/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

public class X10Sequence {
    public static final int FUNCTION_ALL_UNITS_OFF = 0;
    public static final int FUNCTION_ALL_LIGHTS_ON = 1;
    public static final int FUNCTION_ON = 2;
    public static final int FUNCTION_OFF = 3;
    public static final int FUNCTION_DIM = 4;
    public static final int FUNCTION_BRIGHT = 5;
    public static final int FUNCTION_ALL_LIGHTS_OFF = 6;
    public static final int FUNCTION_EXTENDED_CODE = 7;
    public static final int FUNCTION_HAIL_REQUEST = 8;
    public static final int FUNCTION_HAIL_ACKNOWLEDGE = 9;
    public static final int FUNCTION_PRESET_DIM_1 = 10;
    public static final int FUNCTION_PRESET_DIM_2 = 11;
    public static final int FUNCTION_EXTENDED_DATA_TRANSFER = 12;
    public static final int FUNCTION_STATUS_ON = 13;
    public static final int FUNCTION_STATUS_OFF = 14;
    public static final int FUNCTION_STATUS_REQUEST = 15;
    public static final int EXTCMD_DIM = 49;
    private static final int MAXINDEX = 32;
    int index = 0;
    Command[] cmds = new Command[32];
    static String[] functionNames = new String[]{"All Off", "All Lights On", "On", "Off", "Dim", "Bright", "All Lights Off", "Extended Code", "Hail Request", "Hail Ack", "Preset Dim 1", "Preset Dim 2", "Ext Data Trnsfr", "Status On", "Status Off", "Status Req"};
    static final int[] encoder;
    static final int[] decoder;
    static String[] houseValueDecoder;

    static {
        int[] nArray = new int[17];
        nArray[0] = -1;
        nArray[1] = 6;
        nArray[2] = 14;
        nArray[3] = 2;
        nArray[4] = 10;
        nArray[5] = 1;
        nArray[6] = 9;
        nArray[7] = 5;
        nArray[8] = 13;
        nArray[9] = 7;
        nArray[10] = 15;
        nArray[11] = 3;
        nArray[12] = 11;
        nArray[14] = 8;
        nArray[15] = 4;
        nArray[16] = 12;
        encoder = nArray;
        decoder = new int[]{13, 5, 3, 11, 15, 7, 1, 9, 14, 6, 4, 12, 16, 8, 2, 10};
        houseValueDecoder = new String[]{"??", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P"};
    }

    public void addFunction(int house, int function, int dimcount) {
        if (this.index >= 32) {
            throw new IllegalArgumentException("Sequence too long");
        }
        this.cmds[this.index] = new Function(house, function, dimcount);
        ++this.index;
    }

    public void addAddress(int house, int device) {
        if (this.index >= 32) {
            throw new IllegalArgumentException("Sequence too long");
        }
        this.cmds[this.index] = new Address(house, device);
        ++this.index;
    }

    public void addExtData(int house, int device, int cmd, int data) {
        if (this.index >= 32) {
            throw new IllegalArgumentException("Sequence too long");
        }
        this.cmds[this.index] = new ExtData(house, device, cmd, data);
        ++this.index;
    }

    public void reset() {
        this.index = 0;
    }

    public Command getCommand() {
        return this.cmds[this.index++];
    }

    public static String functionName(int i) {
        return functionNames[i];
    }

    public static int encode(int i) {
        if (i < 1 || i > 16) {
            throw new IllegalArgumentException("Encode outside 1-16: " + i);
        }
        return encoder[i];
    }

    public static int decode(int i) {
        if (i < 0 || i > 15) {
            throw new IllegalArgumentException("Decode outside 1-16: " + i);
        }
        return decoder[i];
    }

    public static String formatAddressByte(int b) {
        return "House " + X10Sequence.houseValueToText(X10Sequence.decode(b >> 4 & 0xF)) + " address device " + X10Sequence.decode(b & 0xF);
    }

    public static String formatCommandByte(int b) {
        return "House " + X10Sequence.houseValueToText(X10Sequence.decode(b >> 4 & 0xF)) + " function: " + X10Sequence.functionName(b & 0xF);
    }

    public static String houseValueToText(int hV) {
        if (hV >= 1 && hV <= 16) {
            return houseValueDecoder[hV];
        }
        return "??";
    }

    public static String houseCodeToText(int hC) {
        String hCode = "";
        switch (hC) {
            case 6: {
                hCode = "A";
                break;
            }
            case 14: {
                hCode = "B";
                break;
            }
            case 2: {
                hCode = "C";
                break;
            }
            case 10: {
                hCode = "D";
                break;
            }
            case 1: {
                hCode = "E";
                break;
            }
            case 9: {
                hCode = "F";
                break;
            }
            case 5: {
                hCode = "G";
                break;
            }
            case 13: {
                hCode = "H";
                break;
            }
            case 7: {
                hCode = "I";
                break;
            }
            case 15: {
                hCode = "J";
                break;
            }
            case 3: {
                hCode = "K";
                break;
            }
            case 11: {
                hCode = "L";
                break;
            }
            case 0: {
                hCode = "M";
                break;
            }
            case 8: {
                hCode = "N";
                break;
            }
            case 4: {
                hCode = "O";
                break;
            }
            case 12: {
                hCode = "P";
                break;
            }
            default: {
                hCode = "Unk hC:" + hC;
            }
        }
        return hCode;
    }

    public static class Address
    implements Command {
        int house;
        int device;

        public Address(int house, int device) {
            this.house = house;
            this.device = device;
        }

        @Override
        public int getHouseCode() {
            return this.house;
        }

        public int getAddress() {
            return this.device;
        }

        @Override
        public boolean isAddress() {
            return true;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    public static interface Command {
        public boolean isAddress();

        public boolean isFunction();

        public int getHouseCode();
    }

    public static class ExtData
    implements Command {
        int house;
        int device;
        int cmd;
        int data;

        public ExtData(int house, int device, int cmd, int data) {
            this.house = house;
            this.device = device;
            this.cmd = cmd;
            this.data = data;
        }

        public int getExtData() {
            return this.data;
        }

        public int getExtCmd() {
            return this.cmd;
        }

        @Override
        public int getHouseCode() {
            return this.house;
        }

        public int getAddress() {
            return this.device;
        }

        @Override
        public boolean isAddress() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    public static class Function
    implements Command {
        int house;
        int function;
        int dimcount;

        public Function(int house, int function, int dimcount) {
            this.house = house;
            this.function = function;
            this.dimcount = dimcount;
        }

        @Override
        public int getHouseCode() {
            return this.house;
        }

        public int getFunction() {
            return this.function;
        }

        public int getDimCount() {
            return this.dimcount;
        }

        @Override
        public boolean isAddress() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return true;
        }
    }
}

