/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    private SerialTrafficController tc = null;
    int housecode = -1;
    int devicecode = -1;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, userName);
        this.tc = tc;
        this.housecode = tc.getAdapterMemo().getSerialAddress().houseCodeAsValueFromSystemName(this.getSystemName());
        this.devicecode = tc.getAdapterMemo().getSerialAddress().deviceCodeAsValueFromSystemName(this.getSystemName());
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton", (Object)(_pushButtonLockout ? "Lock" : "Unlock"));
    }

    protected void sendMessage(boolean closed) {
        if (log.isDebugEnabled()) {
            log.debug("set closed {} house {} device {}", new Object[]{closed, X10Sequence.houseCodeToText(this.housecode), this.devicecode});
        }
        X10Sequence out = new X10Sequence();
        out.addAddress(this.housecode, this.devicecode);
        out.addFunction(this.housecode, closed ? 3 : 2, 0);
        this.tc.sendX10Sequence(out, null);
    }
}

