/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.powerline.Bundle;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSensor;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerialSensorManager
extends AbstractSensorManager
implements SerialListener {
    private SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SerialSensorManager.class);

    public SerialSensorManager(SerialTrafficController tc) {
        super(tc.getAdapterMemo());
        this.tc = tc;
        tc.addSerialListener(this);
    }

    @Override
    @Nonnull
    public SerialSystemConnectionMemo getMemo() {
        return (SerialSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = this.tc.getAdapterMemo().getSerialAddress().normalizeSystemName(systemName);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Powerline Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("Powerline Sensor with this name already exists - " + systemName);
        }
        s = userName == null ? new SerialSensor(sName, this.tc) : new SerialSensor(sName, this.tc, userName);
        return s;
    }

    @Override
    public void message(SerialMessage r) {
    }

    @Override
    public abstract void reply(SerialReply var1);

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        log.warn("getNextValidAddress called but system does not yet support multiple additions");
        Sensor s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + curAddress);
        if (s == null && !ignoreInitialExisting) {
            return curAddress;
        }
        int iName = 0;
        String houseCode = curAddress.substring(0, 1);
        try {
            iName = Integer.parseInt(curAddress.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JmriException("Unable to convert " + curAddress + " to a number after the house code");
        }
        s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + curAddress);
        if (s != null) {
            int x = 1;
            while (x < 10) {
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + houseCode + ++iName);
                if (s == null) {
                    return String.valueOf(houseCode) + iName;
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, String.valueOf(houseCode) + iName));
        }
        return String.valueOf(houseCode) + iName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.tc.getAdapterMemo().getSerialAddress().validateSystemNameFormat(name, this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.tc.getAdapterMemo().getSerialAddress().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

