/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.powerline.Bundle;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerialLightManager
extends AbstractLightManager {
    SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SerialLightManager.class);

    public SerialLightManager(SerialTrafficController tc) {
        super(tc.getAdapterMemo());
        this.tc = tc;
    }

    @Override
    @Nonnull
    public SerialSystemConnectionMemo getMemo() {
        return (SerialSystemConnectionMemo)this.memo;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        if (this.tc.getAdapterMemo().getSerialAddress().validSystemNameFormat(systemName, 'L') == Manager.NameValidity.VALID) {
            Light lgt = this.createNewSpecificLight(systemName, userName);
            if (!this.tc.getAdapterMemo().getSerialAddress().validSystemNameConfig(systemName, 'L')) {
                log.warn("Light system Name does not refer to configured hardware: {}", (Object)systemName);
            }
            return lgt;
        }
        log.error("Invalid Light system Name format: {}", (Object)systemName);
        throw new IllegalArgumentException("Invalid Light system Name format: " + systemName);
    }

    protected abstract Light createNewSpecificLight(String var1, String var2);

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.tc.getAdapterMemo().getSerialAddress().validateSystemNameFormat(name, this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.tc.getAdapterMemo().getSerialAddress().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return this.tc.getAdapterMemo().getSerialAddress().validSystemNameConfig(systemName, 'L');
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }

    @Override
    public boolean supportsVariableLights(@Nonnull String systemName) {
        return true;
    }
}

