/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import jmri.implementation.AbstractVariableLight;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerialLight
extends AbstractVariableLight {
    SerialTrafficController tc = null;
    protected int housecode = -1;
    protected int devicecode = -1;
    protected int idhighbyte = -1;
    protected int idmiddlebyte = -1;
    protected int idlowbyte = -1;
    private static final Logger log = LoggerFactory.getLogger(SerialLight.class);

    public SerialLight(String systemName, SerialTrafficController tc) {
        super(systemName);
        this.tc = tc;
        this.initializeLight();
    }

    public SerialLight(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, userName);
        this.tc = tc;
        this.initializeLight();
    }

    protected void initializeLight() {
        this.housecode = this.tc.getAdapterMemo().getSerialAddress().houseCodeAsValueFromSystemName(this.getSystemName());
        this.devicecode = this.tc.getAdapterMemo().getSerialAddress().deviceCodeAsValueFromSystemName(this.getSystemName());
        if (this.housecode == -1) {
            this.idhighbyte = this.tc.getAdapterMemo().getSerialAddress().idHighCodeAsValueFromSystemName(this.getSystemName());
            this.idmiddlebyte = this.tc.getAdapterMemo().getSerialAddress().idMiddleCodeAsValueFromSystemName(this.getSystemName());
            this.idlowbyte = this.tc.getAdapterMemo().getSerialAddress().idLowCodeAsValueFromSystemName(this.getSystemName());
        }
    }

    protected void initIntensity(double intensity) {
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        double newDim;
        int function;
        if (log.isDebugEnabled()) {
            log.debug("sendOnOff({}) Current: {}", (Object)newState, (Object)this.mState);
        }
        if (newState == 2) {
            function = 2;
            newDim = 1.0;
        } else if (newState == 4) {
            function = 3;
            newDim = 0.0;
        } else {
            log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("set state {} house {} device {}", new Object[]{newState, X10Sequence.houseCodeToText(this.housecode), this.devicecode});
        }
        X10Sequence out = new X10Sequence();
        out.addAddress(this.housecode, this.devicecode);
        out.addFunction(this.housecode, function, 0);
        this.tc.sendX10Sequence(out, null);
        if (log.isDebugEnabled()) {
            log.debug("sendOnOff({})  house {} device {} funct: {}", new Object[]{newDim, X10Sequence.houseValueToText(this.housecode), this.devicecode, function});
        }
    }
}

