/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pi.configurexml;

import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import jmri.jmrix.pi.RaspberryPiAdapter;
import jmri.jmrix.pi.RaspberryPiConnectionConfig;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaspberryPiConnectionConfigXml
extends AbstractConnectionConfigXml {
    private RaspberryPiAdapter adapter = null;
    private static final Logger log = LoggerFactory.getLogger(RaspberryPiConnectionConfigXml.class);

    @Override
    protected void getInstance() {
        log.debug("getInstance without Parameter called");
        if (this.adapter == null) {
            this.adapter = new RaspberryPiAdapter();
            if (this.adapter.getGPIOController() == null) {
                this.handleException("Not running on Raspberry PI.", null, this.adapter.getSystemPrefix(), this.adapter.getUserName(), null);
            }
        }
    }

    protected void getInstance(Object object) {
        log.debug("getInstance with Parameter called");
        this.adapter = ((RaspberryPiConnectionConfig)object).getAdapter();
    }

    @Override
    protected void register() {
        this.register(new RaspberryPiConnectionConfig(this.adapter));
    }

    @Override
    public Element store(Object o) {
        this.getInstance(o);
        Element e = new Element("connection");
        this.storeCommon(e, this.adapter);
        e.setAttribute("class", this.getClass().getName());
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        this.getInstance();
        this.loadCommon(shared, perNode, this.adapter);
        this.register();
        this.adapter.configure();
        return true;
    }
}

