/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pi;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.exception.GpioPinNotProvisionedException;
import java.io.Serializable;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.pi.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaspberryPiTurnout
extends AbstractTurnout
implements Serializable {
    private GpioController gpio = null;
    private GpioPinDigitalOutput pin = null;
    private static final Logger log = LoggerFactory.getLogger(RaspberryPiTurnout.class);

    public RaspberryPiTurnout(String systemName) {
        this(systemName, GpioFactory.getInstance());
    }

    public RaspberryPiTurnout(String systemName, String userName) {
        this(systemName, userName, GpioFactory.getInstance());
    }

    public RaspberryPiTurnout(String systemName, GpioController _gpio) {
        super(systemName);
        log.trace("Provisioning turnout '{}'", (Object)systemName);
        this.init(systemName, _gpio);
    }

    public RaspberryPiTurnout(String systemName, String userName, GpioController _gpio) {
        super(systemName, userName);
        log.trace("Provisioning turnout '{}' with username '{}'", (Object)systemName, (Object)userName);
        this.init(systemName, _gpio);
    }

    private void init(String systemName, GpioController _gpio) {
        int address;
        String pinName;
        Pin p;
        log.debug("Provisioning turnout {}", (Object)systemName);
        if (this.gpio == null) {
            this.gpio = _gpio;
        }
        if ((p = RaspiPin.getPinByName((String)(pinName = "GPIO " + (address = Integer.parseInt(this.getSystemName().substring(this.getSystemName().lastIndexOf("T") + 1)))))) != null) {
            try {
                this.pin = this.gpio.provisionDigitalOutputPin(p, this.getSystemName());
            }
            catch (RuntimeException re) {
                log.error("Provisioning sensor {} failed with: {}", (Object)systemName, (Object)re.getMessage());
                throw new IllegalArgumentException(re.getMessage());
            }
            if (this.pin == null) {
                String msg = Bundle.getMessage("ProvisioningFailed", pinName, this.getSystemName());
                log.error(msg);
                throw new IllegalArgumentException(msg);
            }
        } else {
            String msg = Bundle.getMessage("PinNameNotValid", pinName, systemName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.pin.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, PinPullResistance.OFF);
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if (newState == 2) {
            log.debug("Setting turnout '{}' to CLOSED", (Object)this.getSystemName());
            if (!this.getInverted()) {
                this.pin.high();
            } else {
                this.pin.low();
            }
        } else if (newState == 4) {
            log.debug("Setting turnout '{}' to THROWN", (Object)this.getSystemName());
            if (!this.getInverted()) {
                this.pin.low();
            } else {
                this.pin.high();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            this.gpio.unprovisionPin(new GpioPin[]{this.pin});
        }
        catch (GpioPinNotProvisionedException gpioPinNotProvisionedException) {
            log.trace("Pin not provisioned, was this turnout already disposed?");
        }
        super.dispose();
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean locked) {
    }
}

