/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pi;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.pi.RaspberryPiSensorManager;
import jmri.jmrix.pi.RaspberryPiTurnoutManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaspberryPiSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private static final Logger log = LoggerFactory.getLogger(RaspberryPiSystemConnectionMemo.class);

    public RaspberryPiSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        InstanceManager.store(this, RaspberryPiSystemConnectionMemo.class);
        log.debug("Created RaspberryPiSystemConnectionMemo");
    }

    public RaspberryPiSystemConnectionMemo() {
        this("P", "RaspberryPi");
    }

    public SensorManager getSensorManager() {
        return (SensorManager)this.get(SensorManager.class);
    }

    public void setSensorManager(SensorManager s) {
        InstanceManager.setSensorManager(s);
        this.store(s, SensorManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        return (TurnoutManager)this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(TurnoutManager t) {
        InstanceManager.setTurnoutManager(t);
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        return (LightManager)this.get(LightManager.class);
    }

    public void setLightManager(LightManager l) {
        InstanceManager.setLightManager(l);
        this.store(l, LightManager.class);
    }

    @Override
    public void configureManagers() {
        this.setTurnoutManager(new RaspberryPiTurnoutManager(this));
        this.setSensorManager(new RaspberryPiSensorManager(this));
        this.register();
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.pi.RaspberryPiActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, RaspberryPiSystemConnectionMemo.class);
        super.dispose();
    }
}

