/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pi;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.exception.GpioPinNotProvisionedException;
import jmri.Sensor;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.pi.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaspberryPiSensor
extends AbstractSensor
implements GpioPinListenerDigital {
    private static GpioController gpio = null;
    private GpioPinDigitalInput pin = null;
    private PinPullResistance pull = PinPullResistance.PULL_DOWN;
    private static final Logger log = LoggerFactory.getLogger(RaspberryPiSensor.class);

    public RaspberryPiSensor(String systemName, String userName) {
        this(systemName, userName, GpioFactory.getInstance(), PinPullResistance.PULL_DOWN);
    }

    public RaspberryPiSensor(String systemName, String userName, PinPullResistance p) {
        this(systemName, userName, GpioFactory.getInstance(), p);
    }

    public RaspberryPiSensor(String systemName) {
        this(systemName, GpioFactory.getInstance(), PinPullResistance.PULL_DOWN);
    }

    public RaspberryPiSensor(String systemName, PinPullResistance p) {
        this(systemName, GpioFactory.getInstance(), p);
    }

    public RaspberryPiSensor(String systemName, String userName, GpioController _gpio) {
        super(systemName, userName);
        this.init(systemName, _gpio, PinPullResistance.PULL_DOWN);
    }

    public RaspberryPiSensor(String systemName, String userName, GpioController _gpio, PinPullResistance p) {
        super(systemName, userName);
        this.init(systemName, _gpio, p);
    }

    public RaspberryPiSensor(String systemName, GpioController _gpio) {
        super(systemName);
        this.init(systemName, _gpio, PinPullResistance.PULL_DOWN);
    }

    public RaspberryPiSensor(String systemName, GpioController _gpio, PinPullResistance p) {
        super(systemName);
        this.init(systemName, _gpio, p);
    }

    private void init(String systemName, GpioController _gpio, PinPullResistance pRes) {
        log.debug("Provisioning sensor {}", (Object)systemName);
        if (gpio == null) {
            gpio = _gpio;
        }
        this.pull = pRes;
        int address = Integer.parseInt(systemName.substring(systemName.lastIndexOf("S") + 1));
        String pinName = "GPIO " + address;
        Pin p = RaspiPin.getPinByName((String)pinName);
        if (p != null) {
            try {
                this.pin = gpio.provisionDigitalInputPin(p, this.getSystemName(), this.pull);
            }
            catch (RuntimeException re) {
                log.error("Provisioning sensor {} failed with: {}", (Object)systemName, (Object)re.getMessage());
                throw new IllegalArgumentException(re.getMessage());
            }
            if (this.pin == null) {
                String msg = Bundle.getMessage("ProvisioningFailed", pinName, this.getSystemName());
                log.error(msg);
                throw new IllegalArgumentException(msg);
            }
        } else {
            String msg = Bundle.getMessage("PinNameNotValid", pinName, systemName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.pin.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, PinPullResistance.OFF);
        this.pin.addListener(new GpioPinListener[]{this});
        this.requestUpdateFromLayout();
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.pin.isHigh()) {
            this.setOwnState(2);
        } else {
            this.setOwnState(4);
        }
    }

    @Override
    public void dispose() {
        try {
            gpio.unprovisionPin(new GpioPin[]{this.pin});
        }
        catch (GpioPinNotProvisionedException gpioPinNotProvisionedException) {
            log.trace("Pin not provisioned, was this sensor already disposed?");
        }
        super.dispose();
    }

    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
        log.debug("GPIO PIN STATE CHANGE: {} = {}", (Object)event.getPin(), (Object)event.getState());
        if (event.getPin() == this.pin) {
            if (event.getState().isHigh()) {
                this.setOwnState(!this.getInverted() ? 2 : 4);
            } else {
                this.setOwnState(!this.getInverted() ? 4 : 2);
            }
        }
    }

    private void setPullState(PinPullResistance pr) {
        this.pull = pr;
        this.pin.setPullResistance(this.pull);
    }

    @Override
    public void setPullResistance(Sensor.PullResistance r) {
        if (r == Sensor.PullResistance.PULL_DOWN) {
            this.setPullState(PinPullResistance.PULL_DOWN);
        } else if (r == Sensor.PullResistance.PULL_UP) {
            this.setPullState(PinPullResistance.PULL_UP);
        } else {
            this.setPullState(PinPullResistance.OFF);
        }
    }

    @Override
    public Sensor.PullResistance getPullResistance() {
        if (this.pull == PinPullResistance.PULL_DOWN) {
            return Sensor.PullResistance.PULL_DOWN;
        }
        if (this.pull == PinPullResistance.PULL_UP) {
            return Sensor.PullResistance.PULL_UP;
        }
        return Sensor.PullResistance.PULL_OFF;
    }
}

