/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pi;

import java.awt.GraphicsEnvironment;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.pi.Bundle;
import jmri.jmrix.pi.RaspberryPiAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaspberryPiConnectionConfig
extends AbstractConnectionConfig {
    private boolean disabled = false;
    private RaspberryPiAdapter adapter = null;
    private Date GPIOMessageShown = null;
    protected boolean init = false;
    String manuf = "Raspberry Pi Foundation";
    private static final Logger log = LoggerFactory.getLogger(RaspberryPiConnectionConfig.class);

    public RaspberryPiConnectionConfig(RaspberryPiAdapter p) {
        this.adapter = p;
    }

    public RaspberryPiConnectionConfig() {
        this.adapter = new RaspberryPiAdapter();
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (this.init) {
            return;
        }
        this.addNameEntryCheckers(this.adapter);
        this.init = true;
    }

    @Override
    public void updateAdapter() {
        if (this.adapter.getSystemConnectionMemo() != null && !this.adapter.getSystemConnectionMemo().setSystemPrefix(this.systemPrefixField.getText())) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
        }
    }

    @Override
    protected void showAdvancedItems() {
    }

    @Override
    public void loadDetails(JPanel details) {
        this._details = details;
        this.setInstance();
        if (!this.init) {
            if (this.adapter.getSystemConnectionMemo() != null) {
                this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
                this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
                this.NUMOPTIONS += 2;
            }
            this.addStandardDetails(this.adapter, false, this.NUMOPTIONS);
            this.init = false;
            this.checkInitDone();
        }
    }

    @Override
    protected void setInstance() {
        if (this.adapter == null) {
            this.adapter = new RaspberryPiAdapter();
        }
        if (!(this.adapter.getGPIOController() != null || GraphicsEnvironment.isHeadless() || this.GPIOMessageShown != null && (new Date().getTime() - this.GPIOMessageShown.getTime()) / 1000L % 60L <= 30L)) {
            JOptionPane.showMessageDialog(this._details, Bundle.getMessage("NoGpioControllerMessage"), Bundle.getMessage("NoGpioControllerTitle"), 0);
            this.GPIOMessageShown = new Date();
        }
    }

    @Override
    public RaspberryPiAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public String getInfo() {
        return "GPIO";
    }

    @Override
    public String getManufacturer() {
        return this.manuf;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manuf = manufacturer;
    }

    @Override
    public String name() {
        return this.getConnectionName();
    }

    @Override
    public String getConnectionName() {
        return "Raspberry Pi GPIO";
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }
}

