/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pi;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.annotation.CheckForNull;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.pi.RaspberryPiSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaspberryPiAdapter
extends AbstractPortController {
    private GpioController gpio = null;
    private static final Logger log = LoggerFactory.getLogger(RaspberryPiAdapter.class);

    public RaspberryPiAdapter() {
        super(new RaspberryPiSystemConnectionMemo());
        log.debug("RaspberryPi GPIO Adapter Constructor called");
        this.manufacturerName = "Raspberry Pi Foundation";
        try {
            this.gpio = GpioFactory.getInstance();
            this.opened = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            log.error("Expected to run on Raspberry PI, but does not appear to be.");
        }
    }

    @Override
    public String getCurrentPortName() {
        return "GPIO";
    }

    @Override
    public void dispose() {
        super.dispose();
        this.gpio.shutdown();
    }

    @Override
    public void connect() {
    }

    @Override
    public void configure() {
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public DataInputStream getInputStream() {
        return null;
    }

    @Override
    public DataOutputStream getOutputStream() {
        return null;
    }

    @Override
    public RaspberryPiSystemConnectionMemo getSystemConnectionMemo() {
        return (RaspberryPiSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    @Override
    public void recover() {
    }

    @CheckForNull
    public GpioController getGPIOController() {
        return this.gpio;
    }
}

