/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.tie;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerTableModel
extends AbstractTableModel {
    static ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.openlcb.swing.tie.TieBundle");
    public static final int USERNAME_COLUMN = 0;
    public static final int NODE_COLUMN = 1;
    public static final int NUMBER_COLUMN = 2;
    final String[] columnName = new String[]{"User Name", "Node", "Event"};
    final String[][] dummy = new String[][]{{"East Lower Yard Button 1", "12", "1"}, {"East Lower Yard Button 2", "12", "2"}, {"East Lower Yard Button 3", "12", "3"}, {"East Lower Yard Button 4", "12", "4"}, {"East Lower Yard Button 5", "12", "5"}, {"West Lower Yard Button 1", "14", "5"}, {"West Lower Yard Button 2", "14", "4"}, {"West Lower Yard Button 3", "14", "3"}, {"West Lower Yard Button 4", "14", "2"}, {"West Lower Yard Button 5", "14", "1"}};
    private static final Logger log = LoggerFactory.getLogger(ProducerTableModel.class);

    @Override
    public String getColumnName(int c) {
        return this.columnName[c];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnName.length;
    }

    @Override
    public int getRowCount() {
        return this.dummy.length;
    }

    @Override
    public Object getValueAt(int r, int c) {
        return this.dummy[r][c];
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
    }

    public void printTable(HardcopyWriter w, int[] colWidth) {
        int[] columnSize = new int[4];
        int charPerLine = w.getCharactersPerLine();
        int tableLineWidth = 0;
        int totalColWidth = 0;
        int j = 0;
        while (j < 4) {
            totalColWidth += colWidth[j];
            ++j;
        }
        float ratio = (float)charPerLine / (float)totalColWidth;
        int j2 = 0;
        while (j2 < 4) {
            columnSize[j2] = (int)Math.round((double)((float)colWidth[j2] * ratio) - 1.0);
            tableLineWidth += columnSize[j2] + 1;
            ++j2;
        }
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
        String[] columnStrings = new String[4];
        int i = 0;
        while (i < 4) {
            columnStrings[i] = this.getColumnName(i);
            ++i;
        }
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnSize);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
        String[] spaces = new String[4];
        int k = 0;
        while (k < 4) {
            spaces[k] = "";
            int i2 = 0;
            while (i2 < columnSize[k]) {
                spaces[k] = String.valueOf(spaces[k]) + " ";
                ++i2;
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < this.getRowCount()) {
            int j3 = 0;
            while (j3 < 4) {
                columnStrings[j3] = this.getValueAt(i3, j3) == null ? spaces[j3] : (String)this.getValueAt(i3, j3);
                ++j3;
            }
            this.printColumns(w, columnStrings, columnSize);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            ++i3;
        }
        w.close();
    }

    protected void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnSize) {
        StringBuilder columnString = new StringBuilder();
        StringBuilder lineString = new StringBuilder();
        String[] spaces = new String[4];
        int k = 0;
        while (k < 4) {
            spaces[k] = "";
            int i = 0;
            while (i < columnSize[k]) {
                spaces[k] = String.valueOf(spaces[k]) + " ";
                ++i;
            }
            ++k;
        }
        boolean complete = false;
        while (!complete) {
            int k2;
            complete = true;
            int i = 0;
            while (i < 4) {
                if (columnStrings[i].length() > columnSize[i]) {
                    boolean noWord = true;
                    k2 = columnSize[i];
                    while (k2 >= 1) {
                        if (columnStrings[i].startsWith(" ", k2 - 1) || columnStrings[i].startsWith("-", k2 - 1) || columnStrings[i].startsWith("_", k2 - 1)) {
                            columnString = new StringBuilder(columnStrings[i].substring(0, k2));
                            columnString.append(spaces[i].substring(columnStrings[i].substring(0, k2).length()));
                            columnStrings[i] = columnStrings[i].substring(k2);
                            noWord = false;
                            complete = false;
                            break;
                        }
                        --k2;
                    }
                    if (noWord) {
                        columnString = new StringBuilder(columnStrings[i].substring(0, columnSize[i]));
                        columnStrings[i] = columnStrings[i].substring(columnSize[i]);
                        complete = false;
                    }
                } else {
                    columnString = new StringBuilder(columnStrings[i]);
                    columnString.append(spaces[i].substring(columnStrings[i].length()));
                    columnStrings[i] = "";
                }
                lineString.append((CharSequence)columnString);
                lineString.append(" ");
                ++i;
            }
            try {
                w.write(lineString.toString());
                int iLine = w.getCurrentLineNumber();
                int i2 = 0;
                k2 = 0;
                while (i2 < w.getCharactersPerLine()) {
                    w.write(iLine, i2, iLine + 1, i2);
                    i2 = k2 < 4 ? i2 + columnSize[k2] + 1 : w.getCharactersPerLine();
                    ++k2;
                }
                w.write("\n");
                lineString = new StringBuilder();
            }
            catch (IOException e) {
                log.warn("error during printing: {}", (Throwable)e);
            }
        }
    }
}

