/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.send;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.swing.CanPanel;
import jmri.jmrix.openlcb.swing.ClientActions;
import jmri.util.StringUtil;
import jmri.util.javaworld.GridLayout2;
import org.openlcb.Connection;
import org.openlcb.DatagramAcknowledgedMessage;
import org.openlcb.DatagramMessage;
import org.openlcb.EventID;
import org.openlcb.IdentifyConsumersMessage;
import org.openlcb.IdentifyEventsAddressedMessage;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.Message;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.VerifyNodeIDNumberMessage;
import org.openlcb.can.AliasMap;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLcbCanSendPane
extends CanPanel
implements CanListener {
    final JLabel jLabel1 = new JLabel();
    final JButton sendButton = new JButton();
    final JTextField packetTextField = new JTextField(12);
    static final int MAXSEQUENCE = 4;
    final JTextField[] mPacketField = new JTextField[4];
    final JCheckBox[] mUseField = new JCheckBox[4];
    final JTextField[] mDelayField = new JTextField[4];
    final JToggleButton mRunButton = new JToggleButton("Go");
    final JTextField srcAliasField = new JTextField(4);
    NodeSelector nodeSelector;
    final JTextField sendEventField = new JTextField("02 03 04 05 06 07 00 01 ");
    final JTextField datagramContentsField = new JTextField("20 61 00 00 00 00 08");
    final JTextField configNumberField = new JTextField("40");
    final JTextField configAddressField = new JTextField("000000");
    final JTextField readDataField = new JTextField(80);
    final JTextField writeDataField = new JTextField(80);
    final JComboBox<String> addrSpace = new JComboBox<String>(new String[]{"CDI", "All", "Config", "None"});
    Connection connection;
    AliasMap aliasMap;
    NodeID srcNodeID;
    MemoryConfigurationService mcs;
    MimicNodeStore store;
    OlcbInterface iface;
    ClientActions actions;
    int mNextSequenceElement = 0;
    Timer timer = null;
    private TrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(OpenLcbCanSendPane.class);

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.iface = (OlcbInterface)memo.get(OlcbInterface.class);
        this.actions = new ClientActions(this.iface, memo);
        this.tc = memo.getTrafficController();
        this.tc.addCanListener(this);
        this.connection = (Connection)memo.get(Connection.class);
        this.srcNodeID = (NodeID)memo.get(NodeID.class);
        this.aliasMap = (AliasMap)memo.get(AliasMap.class);
        Connection.ConnectionListener cl = new Connection.ConnectionListener(){

            public void connectionActive(Connection c) {
                log.debug("connection active");
                OpenLcbCanSendPane.this.srcAliasField.setText(Integer.toHexString(OpenLcbCanSendPane.this.aliasMap.getAlias(OpenLcbCanSendPane.this.srcNodeID)));
            }
        };
        this.connection.registerStartNotification(cl);
        this.mcs = (MemoryConfigurationService)memo.get(MemoryConfigurationService.class);
        this.store = (MimicNodeStore)memo.get(MimicNodeStore.class);
        this.nodeSelector = new NodeSelector(this.store);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getSendSinglePacketJPanel());
        this.add(new JSeparator());
        this.add(new JLabel("Send sequence of frames:"));
        JPanel pane2 = new JPanel();
        pane2.setLayout(new GridLayout2(6, 4));
        pane2.add(new JLabel(""));
        pane2.add(new JLabel("Send"));
        pane2.add(new JLabel("packet"));
        pane2.add(new JLabel("wait (msec)"));
        int i = 0;
        while (i < 4) {
            pane2.add(new JLabel(Integer.toString(i + 1)));
            this.mUseField[i] = new JCheckBox();
            this.mPacketField[i] = new JTextField(10);
            this.mDelayField[i] = new JTextField(10);
            pane2.add(this.mUseField[i]);
            pane2.add(this.mPacketField[i]);
            pane2.add(this.mDelayField[i]);
            ++i;
        }
        pane2.add(this.mRunButton);
        this.add(pane2);
        this.mRunButton.addActionListener(this::runButtonActionPerformed);
        this.add(new JSeparator());
        this.add(new JLabel("Send special frame:"));
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        pane2.add(new JLabel("Src Node alias:"));
        pane2.add(this.srcAliasField);
        this.add(pane2);
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        JButton b = new JButton("Send CIM");
        b.addActionListener(this::sendCimPerformed);
        pane2.add(b);
        this.add(new JSeparator());
        this.add(this.addLineLabel("Send OpenLCB global message:"));
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        b = new JButton("Send Verify Nodes Global");
        b.addActionListener(this::sendVerifyNodeGlobal);
        pane2.add(b);
        b = new JButton("Send Verify Node Global with NodeID");
        b.addActionListener(this::sendVerifyNodeGlobalID);
        pane2.add(b);
        this.add(new JSeparator());
        this.add(this.addLineLabel("Send OpenLCB event message:"));
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        b = new JButton("Send Request Consumers");
        b.addActionListener(this::sendReqConsumers);
        pane2.add(b);
        b = new JButton("Send Request Producers");
        b.addActionListener(this::sendReqProducers);
        pane2.add(b);
        b = new JButton("Send Event Produced");
        b.addActionListener(this::sendEventPerformed);
        pane2.add(b);
        pane2.add(new JLabel("Event ID (8 bytes):"));
        pane2.add(this.sendEventField);
        this.add(new JSeparator());
        this.add(this.addLineLabel("Send OpenLCB addressed message to:", (JComponent)this.nodeSelector));
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        b = new JButton("Send Request Events");
        b.addActionListener(this::sendRequestEvents);
        pane2.add(b);
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        b = new JButton("Send Datagram");
        b.addActionListener(this::sendDatagramPerformed);
        pane2.add(b);
        pane2.add(new JLabel("Contents: "));
        pane2.add(this.datagramContentsField);
        b = new JButton("Send Datagram Reply");
        b.addActionListener(this::sendDatagramReply);
        pane2.add(b);
        this.add(new JSeparator());
        this.add(this.addLineLabel("Send OpenLCB Configuration Command:"));
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        pane2.add(new JLabel("Memory Address: "));
        pane2.add(this.configAddressField);
        pane2.add(new JLabel("Address Space: "));
        pane2.add(this.addrSpace);
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        pane2.add(new JLabel("Byte Count: "));
        pane2.add(this.configNumberField);
        b = new JButton("Read");
        b.addActionListener(this::readPerformed);
        pane2.add(b);
        pane2.add(new JLabel("Data: "));
        pane2.add(this.readDataField);
        pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        this.add(pane2);
        b = new JButton("Write");
        b.addActionListener(this::writePerformed);
        pane2.add(b);
        pane2.add(new JLabel("Data: "));
        this.writeDataField.setText("00 00");
        pane2.add(this.writeDataField);
        b = new JButton("Open CDI Config Tool");
        this.add(b);
        b.addActionListener(e -> this.openCdiPane());
    }

    private JPanel getSendSinglePacketJPanel() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 1));
        this.jLabel1.setText("Single Frame:  (Raw input format is [123] 12 34 56) ");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send frame");
        this.packetTextField.setToolTipText("Frame as hex pairs, e.g. 82 7D; standard header in (), extended in []");
        pane1.add(this.jLabel1);
        pane1.add(this.packetTextField);
        pane1.add(this.sendButton);
        pane1.add(Box.createVerticalGlue());
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
        return pane1;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.send.OpenLcbCanSendFrame";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return String.valueOf(this.memo.getUserName()) + " Send Can Frame";
        }
        return "Send CAN Frames and OpenLCB Messages";
    }

    JComponent addLineLabel(String text) {
        return this.addLineLabel(text, null);
    }

    JComponent addLineLabel(String text, JComponent c) {
        JLabel lab = new JLabel(text);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (c != null) {
            p.add(lab);
            p.add(c);
        } else {
            p.add(lab);
        }
        p.add(Box.createHorizontalGlue());
        return p;
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        CanMessage m = this.createPacket(input);
        log.debug("sendButtonActionPerformed: {}", (Object)m);
        this.tc.sendCanMessage(m, this);
    }

    public void sendCimPerformed(ActionEvent e) {
        String data = "[10700" + this.srcAliasField.getText() + "]";
        log.debug("|{}|", (Object)data);
        CanMessage m = this.createPacket(data);
        log.debug("sendCimPerformed");
        this.tc.sendCanMessage(m, this);
    }

    NodeID destNodeID() {
        return this.nodeSelector.getSelectedItem();
    }

    EventID eventID() {
        return new EventID(StringUtil.bytesFromHexString(this.sendEventField.getText().replace(".", " ")));
    }

    public void sendVerifyNodeGlobal(ActionEvent e) {
        VerifyNodeIDNumberMessage m = new VerifyNodeIDNumberMessage(this.srcNodeID);
        this.connection.put((Message)m, null);
    }

    public void sendVerifyNodeGlobalID(ActionEvent e) {
        VerifyNodeIDNumberMessage m = new VerifyNodeIDNumberMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void sendRequestEvents(ActionEvent e) {
        IdentifyEventsAddressedMessage m = new IdentifyEventsAddressedMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void sendEventPerformed(ActionEvent e) {
        ProducerConsumerEventReportMessage m = new ProducerConsumerEventReportMessage(this.srcNodeID, this.eventID());
        this.connection.put((Message)m, null);
    }

    public void sendReqConsumers(ActionEvent e) {
        IdentifyConsumersMessage m = new IdentifyConsumersMessage(this.srcNodeID, this.eventID());
        this.connection.put((Message)m, null);
    }

    public void sendReqProducers(ActionEvent e) {
        IdentifyProducersMessage m = new IdentifyProducersMessage(this.srcNodeID, this.eventID());
        this.connection.put((Message)m, null);
    }

    public void sendDatagramPerformed(ActionEvent e) {
        DatagramMessage m = new DatagramMessage(this.srcNodeID, this.destNodeID(), StringUtil.bytesFromHexString(this.datagramContentsField.getText()));
        this.connection.put((Message)m, null);
    }

    public void sendDatagramReply(ActionEvent e) {
        DatagramAcknowledgedMessage m = new DatagramAcknowledgedMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void readPerformed(ActionEvent e) {
        int space = 255 - this.addrSpace.getSelectedIndex();
        long addr = Integer.parseInt(this.configAddressField.getText(), 16);
        int length = Integer.parseInt(this.configNumberField.getText());
        this.mcs.requestRead(this.destNodeID(), space, addr, length, new MemoryConfigurationService.McsReadHandler(){

            public void handleReadData(NodeID dest, int space, long address, byte[] data) {
                log.debug("Read data received {} bytes", (Object)data.length);
                OpenLcbCanSendPane.this.readDataField.setText(StringUtil.hexStringFromBytes(data));
            }

            public void handleFailure(int errorCode) {
                log.warn("OpenLCB read failed: 0x{}", (Object)Integer.toHexString(errorCode));
            }
        });
    }

    public void writePerformed(ActionEvent e) {
        int space = 255 - this.addrSpace.getSelectedIndex();
        long addr = Integer.parseInt(this.configAddressField.getText(), 16);
        byte[] content = StringUtil.bytesFromHexString(this.writeDataField.getText());
        this.mcs.requestWrite(this.destNodeID(), space, addr, content, new MemoryConfigurationService.McsWriteHandler(){

            public void handleSuccess() {
            }

            public void handleFailure(int errorCode) {
                log.warn("OpenLCB write failed:  0x{}", (Object)Integer.toHexString(errorCode));
            }
        });
    }

    public void openCdiPane() {
        this.actions.openCdiWindow(this.destNodeID(), this.destNodeID().toString());
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.sendNextItem());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    protected synchronized void timeout() {
        this.sendNextItem();
    }

    public void runButtonActionPerformed(ActionEvent e) {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        boolean ok = false;
        int i = 0;
        while (i < 4) {
            if (this.mUseField[i].isSelected()) {
                ok = true;
            }
            ++i;
        }
        if (!ok) {
            this.mRunButton.setSelected(false);
            return;
        }
        this.mNextSequenceElement = 0;
        this.sendNextItem();
    }

    void startSequenceDelay() {
        int delay = Integer.parseInt(this.mDelayField[this.mNextSequenceElement].getText());
        ++this.mNextSequenceElement;
        this.restartTimer(delay);
    }

    void sendNextItem() {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        if (this.mNextSequenceElement >= 4) {
            this.mNextSequenceElement = 0;
        }
        if (this.mUseField[this.mNextSequenceElement].isSelected()) {
            CanMessage m = this.createPacket(this.mPacketField[this.mNextSequenceElement].getText());
            this.tc.sendCanMessage(m, this);
            this.startSequenceDelay();
        } else {
            ++this.mNextSequenceElement;
            this.sendNextItem();
        }
    }

    CanMessage createPacket(String s) {
        CanMessage m;
        CbusAddress a = new CbusAddress(s);
        if (a.check()) {
            m = a.makeMessage(this.tc.getCanid());
        } else {
            String h;
            int i;
            m = new CanMessage(this.tc.getCanid());
            if (s.charAt(0) == '[') {
                m.setExtended(true);
                i = s.indexOf(93);
                h = s.substring(1, i);
                m.setHeader(Integer.parseInt(h, 16));
                s = s.substring(i + 1);
            } else if (s.charAt(0) == '(') {
                i = s.indexOf(41);
                h = s.substring(1, i);
                m.setHeader(Integer.parseInt(h, 16));
                s = s.substring(i + 1);
            }
            byte[] b = StringUtil.bytesFromHexString(s);
            m.setNumDataElements(b.length);
            int i2 = 0;
            while (i2 < b.length) {
                m.setElement(i2, b[i2] & 0xFF);
                ++i2;
            }
        }
        return m;
    }

    @Override
    public void message(CanMessage m) {
    }

    @Override
    public void reply(CanReply m) {
    }

    @Override
    public void dispose() {
        this.mRunButton.setSelected(false);
        super.dispose();
    }
}

