/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.protocoloptions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.swing.protocoloptions.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolOptionsFrame
extends JmriJFrame {
    final CanSystemConnectionMemo scm;
    private final Map<String, JPanel> protocolPanels = new HashMap<String, JPanel>();
    private JTabbedPane protocolTabs;
    private final List<Runnable> saveCallbacks = new ArrayList<Runnable>();
    boolean anyChanged = false;
    private static final Logger log = LoggerFactory.getLogger(ProtocolOptionsFrame.class);

    public ProtocolOptionsFrame(CanSystemConnectionMemo scm) {
        this.scm = scm;
    }

    private JPanel getProtocolTab(String protocolKey) {
        JPanel p = this.protocolPanels.get(protocolKey);
        if (p != null) {
            return p;
        }
        p = new JPanel(new GridBagLayout());
        p.setName(Bundle.getMessage("TabTitle" + protocolKey));
        this.protocolTabs.add(p);
        this.protocolPanels.put(protocolKey, p);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        p.add((Component)new JPanel(), c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 1;
        c2.gridy = 0;
        p.add((Component)new JPanel(), c2);
        return p;
    }

    private void addTextSetting(String protocolKey, String optionKey) {
        String pastValue = this.scm.getProtocolOption(protocolKey, optionKey);
        if (pastValue == null) {
            pastValue = "";
        }
        JPanel tab = this.getProtocolTab(protocolKey);
        this.addOptionLabel(protocolKey, optionKey, tab);
        JTextField valueField = new JTextField(pastValue, 20);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridy = -1;
        c2.gridx = 1;
        c2.anchor = 23;
        c2.insets = new Insets(0, 0, 0, 3);
        tab.add((Component)valueField, c2);
        try {
            String tip = Bundle.getMessage("ToolTip" + protocolKey + optionKey);
            valueField.setToolTipText(tip);
        }
        catch (MissingResourceException missingResourceException) {}
        this.saveCallbacks.add(() -> {
            String v = this.scm.getProtocolOption(protocolKey, optionKey);
            String newV = valueField.getText();
            if (newV.equals(v)) {
                return;
            }
            this.scm.setProtocolOption(protocolKey, optionKey, newV);
            this.anyChanged = true;
        });
        valueField.addActionListener(actionEvent -> log.warn("Entry changed: {} {} = {}", new Object[]{protocolKey, optionKey, valueField.getText()}));
    }

    private void addOptionLabel(String protocolKey, String optionKey, JPanel tab) {
        String labelText = Bundle.getMessage("Label" + protocolKey + optionKey);
        JLabel label = new JLabel(labelText);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridy = -1;
        c1.gridx = 0;
        c1.anchor = 24;
        c1.insets = new Insets(0, 0, 0, 3);
        tab.add((Component)label, c1);
    }

    private void addComboBoxSetting(String protocolKey, String optionKey, String[] choices, String defaultChoice) {
        JPanel tab = this.getProtocolTab(protocolKey);
        String pastValue = this.scm.getProtocolOption(protocolKey, optionKey);
        this.addOptionLabel(protocolKey, optionKey, tab);
        JComboBox<ComboSelectionEntry> valueField = new JComboBox<ComboSelectionEntry>();
        int defaultNum = -1;
        int pastNum = -1;
        int i = 0;
        while (i < choices.length) {
            String displayKey;
            if (choices[i].equals(pastValue)) {
                pastNum = i;
            }
            if (choices[i].equals(defaultChoice)) {
                defaultNum = i;
            }
            try {
                displayKey = Bundle.getMessage("Selection" + protocolKey + optionKey + choices[i]);
            }
            catch (MissingResourceException missingResourceException) {
                displayKey = choices[i];
            }
            valueField.addItem(new ComboSelectionEntry(displayKey, choices[i]));
            ++i;
        }
        if (pastNum >= 0) {
            valueField.setSelectedIndex(pastNum);
        } else if (pastValue == null) {
            valueField.setSelectedIndex(defaultNum);
        }
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridy = -1;
        c2.gridx = 1;
        c2.anchor = 23;
        c2.insets = new Insets(0, 0, 0, 3);
        tab.add(valueField, c2);
        try {
            String tip = Bundle.getMessage("ToolTip" + protocolKey + optionKey);
            valueField.setToolTipText(tip);
        }
        catch (MissingResourceException missingResourceException) {}
        this.saveCallbacks.add(() -> {
            String v = this.scm.getProtocolOption(protocolKey, optionKey);
            ComboSelectionEntry newO = (ComboSelectionEntry)valueField.getSelectedItem();
            if (newO == null) {
                return;
            }
            String newV = newO.selectionKey;
            if (newV.equals(v)) {
                return;
            }
            this.scm.setProtocolOption(protocolKey, optionKey, newV);
            this.anyChanged = true;
        });
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitle", this.scm.getUserName()));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.protocolTabs = new JTabbedPane();
        contentPane.add(this.protocolTabs);
        this.getProtocolTab("Ident");
        this.addTextSetting("Ident", "NodeId");
        this.addTextSetting("Ident", "UserName");
        this.addTextSetting("Ident", "UserDescription");
        this.getProtocolTab("FastClock");
        this.addComboBoxSetting("FastClock", "EnableMode", new String[]{"disabled", "generator", "consumer"}, "disabled");
        this.addComboBoxSetting("FastClock", "ClockId", new String[]{"default", "realtime", "alt1", "alt2", "custom"}, "default");
        this.addTextSetting("FastClock", "ClockCustomId");
        JPanel helpHintPanel = new JPanel();
        BoxLayout helpLayout = new BoxLayout(helpHintPanel, 0);
        helpHintPanel.setLayout(helpLayout);
        contentPane.add(helpHintPanel);
        JLabel hintOnHelpLabel = new JLabel(Bundle.getMessage("HintOnHelp"));
        helpHintPanel.add(hintOnHelpLabel);
        JPanel bottomPanel = new JPanel();
        BoxLayout bottomLayout = new BoxLayout(bottomPanel, 0);
        bottomPanel.setLayout(bottomLayout);
        contentPane.add(bottomPanel);
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"), new ImageIcon(FileUtil.findURL("program:resources/icons/misc/gui3/SaveIcon.png", FileUtil.Location.INSTALLED)));
        bottomPanel.add(saveButton);
        saveButton.addActionListener(actionEvent -> this.saveButtonClicked());
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        bottomPanel.add(cancelButton);
        cancelButton.addActionListener(actionEvent -> this.dispatchEvent(new WindowEvent(this, 201)));
        this.pack();
    }

    private void saveButtonClicked() {
        for (Runnable r : this.saveCallbacks) {
            r.run();
        }
        this.setVisible(false);
        this.dispose();
    }

    private static class ComboSelectionEntry {
        final String displayKey;
        final String selectionKey;

        private ComboSelectionEntry(String displayKey, String selectionKey) {
            this.displayKey = displayKey;
            this.selectionKey = selectionKey;
        }

        public String toString() {
            return this.displayKey;
        }
    }
}

