/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.networktree;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.ClientActions;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriPanel;
import org.openlcb.Connection;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.memconfig.MemConfigDescriptionPane;
import org.openlcb.swing.memconfig.MemConfigReadWritePane;
import org.openlcb.swing.networktree.NodeTreeRep;
import org.openlcb.swing.networktree.TreePane;

public class NetworkTreePane
extends JmriPanel
implements CanListener,
CanPanelInterface {
    private transient CanSystemConnectionMemo memo;
    TreePane treePane;

    @Override
    public void initContext(Object context) {
        if (context instanceof CanSystemConnectionMemo) {
            this.initComponents((CanSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addCanListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.treePane = new TreePane();
        this.treePane.setPreferredSize(new Dimension(300, 300));
        this.treePane.initComponents((MimicNodeStore)memo.get(MimicNodeStore.class), (Connection)memo.get(Connection.class), (NodeID)memo.get(NodeID.class), (NodeTreeRep.SelectionKeyLoader)new ActionLoader(memo));
        this.add((Component)this.treePane);
        this.treePane.addTreeSelectionListener(e -> {
            JTree tree = (JTree)e.getSource();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (node.getUserObject() instanceof NodeTreeRep.SelectionKey) {
                ((NodeTreeRep.SelectionKey)node.getUserObject()).select(node);
            }
        });
    }

    @Override
    public String getTitle() {
        return "OpenLCB Network Tree";
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removeCanListener(this);
    }

    @Override
    public synchronized void message(CanMessage l) {
    }

    @Override
    public synchronized void reply(CanReply l) {
    }

    private static class ActionLoader
    extends NodeTreeRep.SelectionKeyLoader {
        private final ClientActions actions;
        final MimicNodeStore store;
        final MemoryConfigurationService mcs;

        ActionLoader(CanSystemConnectionMemo memo) {
            OlcbInterface iface = (OlcbInterface)memo.get(OlcbInterface.class);
            this.actions = new ClientActions(iface, memo);
            this.store = iface.getNodeStore();
            this.mcs = iface.getMemoryConfigurationService();
        }

        public NodeTreeRep.SelectionKey cdiKey(String name, NodeID node) {
            return new NodeTreeRep.SelectionKey(name, node){

                public void select(DefaultMutableTreeNode rep) {
                    MimicNodeStore.NodeMemo memo = store.findNode(this.node);
                    SimpleNodeIdent ident = memo.getSimpleNodeIdent();
                    StringBuilder description = new StringBuilder();
                    if (ident.getUserName() != null) {
                        description.append(ident.getUserName());
                    }
                    if (ident.getUserDesc() != null && ident.getUserDesc().length() > 0) {
                        if (description.length() > 0) {
                            description.append(" - ");
                        }
                        description.append(ident.getUserDesc());
                    }
                    if (description.length() == 0) {
                        if (ident.getMfgName() != null && ident.getMfgName().length() > 0) {
                            description.append(ident.getMfgName());
                        }
                        if (ident.getModelName() != null && ident.getModelName().length() > 0) {
                            if (description.length() > 0) {
                                description.append(" - ");
                            }
                            description.append(ident.getModelName());
                        }
                    }
                    if (description.length() == 0) {
                        description.append(this.node.toString());
                    } else {
                        description.append(" (");
                        description.append(this.node.toString());
                        description.append(")");
                    }
                    this.openCdiPane(this.node, description.toString());
                }
            };
        }

        public NodeTreeRep.SelectionKey configurationKey(String name, NodeID node) {
            return new NodeTreeRep.SelectionKey(name, node){

                public void select(DefaultMutableTreeNode rep) {
                    this.openConfigurePane(this.node);
                }
            };
        }

        void openConfigurePane(NodeID node) {
            JmriJFrame f = new JmriJFrame();
            f.setTitle("Configuration Capabilities " + node);
            MemConfigDescriptionPane mc = new MemConfigDescriptionPane(node, this.store, this.mcs);
            f.add((Component)mc);
            mc.initComponents();
            f.pack();
            f.setVisible(true);
            f = new JmriJFrame();
            f.setTitle("Configuration R/W Tool " + node);
            mc = new MemConfigReadWritePane(node, this.store, this.mcs);
            f.add((Component)mc);
            mc.initComponents();
            f.pack();
            f.setVisible(true);
        }

        public void openCdiPane(NodeID destNode, String description) {
            this.actions.openCdiWindow(destNode, description);
        }
    }
}

