/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.monitor;

import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.monitor.Bundle;
import jmri.util.StringUtil;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.Message;
import org.openlcb.OlcbInterface;
import org.openlcb.Utilities;
import org.openlcb.can.AliasMap;
import org.openlcb.can.CanFrame;
import org.openlcb.can.MessageBuilder;
import org.openlcb.can.OpenLcbCanFrame;
import org.openlcb.implementations.EventTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorPane
extends AbstractMonPane
implements CanListener,
CanPanelInterface {
    CanSystemConnectionMemo memo;
    AliasMap aliasMap;
    MessageBuilder messageBuilder;
    OlcbInterface olcbInterface;
    final JCheckBox nodeNameCheckBox = new JCheckBox();
    final JCheckBox eventCheckBox = new JCheckBox();
    final JCheckBox eventAllCheckBox = new JCheckBox();
    final String nodeNameCheck = String.valueOf(this.getClass().getName()) + ".NodeName";
    final String eventCheck = String.valueOf(this.getClass().getName()) + ".Event";
    final String eventAllCheck = String.valueOf(this.getClass().getName()) + ".EventAll";
    private final UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
    private static final Logger log = LoggerFactory.getLogger(MonitorPane.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof CanSystemConnectionMemo) {
            this.initComponents((CanSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addCanListener(this);
        this.aliasMap = (AliasMap)memo.get(AliasMap.class);
        this.messageBuilder = new MessageBuilder(this.aliasMap);
        this.olcbInterface = (OlcbInterface)memo.get(OlcbInterface.class);
        this.setFixedWidthFont();
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("MonitorTitle");
    }

    @Override
    protected void init() {
    }

    @Override
    public void dispose() {
        try {
            this.memo.getTrafficController().removeCanListener(this);
        }
        catch (NullPointerException npe) {
            log.debug("Null Pointer Exception while attempting to remove Can Listener", (Throwable)npe);
        }
        this.pm.setSimplePreferenceState(this.nodeNameCheck, this.nodeNameCheckBox.isSelected());
        this.pm.setSimplePreferenceState(this.eventCheck, this.eventCheckBox.isSelected());
        this.pm.setSimplePreferenceState(this.eventAllCheck, this.eventAllCheckBox.isSelected());
        super.dispose();
    }

    @Override
    protected void addCustomControlPanes(JPanel parent) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.nodeNameCheckBox.setText(Bundle.getMessage("CheckBoxShowNodeName"));
        this.nodeNameCheckBox.setVisible(true);
        this.nodeNameCheckBox.setSelected(this.pm.getSimplePreferenceState(this.nodeNameCheck));
        p.add(this.nodeNameCheckBox);
        this.eventCheckBox.setText(Bundle.getMessage("CheckBoxShowEvent"));
        this.eventCheckBox.setVisible(true);
        this.eventCheckBox.setSelected(this.pm.getSimplePreferenceState(this.eventCheck));
        p.add(this.eventCheckBox);
        this.eventAllCheckBox.setText(Bundle.getMessage("CheckBoxShowEventAll"));
        this.eventAllCheckBox.setVisible(true);
        this.eventAllCheckBox.setSelected(this.pm.getSimplePreferenceState(this.eventAllCheck));
        p.add(this.eventAllCheckBox);
        parent.add(p);
        super.addCustomControlPanes(parent);
    }

    String formatFrame(boolean extended, int header, int len, int[] content) {
        StringBuilder formatted = new StringBuilder();
        formatted.append(extended ? "[" : "(");
        formatted.append(Integer.toHexString(header));
        formatted.append(extended ? "]" : ")");
        int i = 0;
        while (i < len) {
            formatted.append(" ");
            formatted.append(StringUtil.twoHexFromInt(content[i]));
            ++i;
        }
        i = len;
        while (i < 8) {
            formatted.append("   ");
            ++i;
        }
        return new String(formatted);
    }

    List<Message> frameToMessages(int header, int len, int[] content) {
        OpenLcbCanFrame frame = new OpenLcbCanFrame(header & 0xFFF);
        frame.setHeader(header);
        if (len != 0) {
            byte[] data = new byte[len];
            int i = 0;
            while (i < data.length) {
                data[i] = (byte)content[i];
                ++i;
            }
            frame.setData(data);
        }
        this.aliasMap.processFrame(frame);
        return this.messageBuilder.processFrame((CanFrame)frame);
    }

    void format(String prefix, boolean extended, int header, int len, int[] content) {
        String formatted;
        String raw = this.formatFrame(extended, header, len, content);
        if (extended && (header & 0x8000000) != 0) {
            List<Message> list = this.frameToMessages(header, len, content);
            if (list == null || list.isEmpty()) {
                if ((header & 0xF000000) == 0xB000000) {
                    formatted = String.valueOf(prefix) + ": (Start of Datagram)";
                } else if ((header & 0xF000000) == 0xC000000) {
                    formatted = String.valueOf(prefix) + ": (Middle of Datagram)";
                } else if ((header & 0xFFFF000) == 161513472 && content.length > 0) {
                    switch (content[0] & 0xF0) {
                        case 16: {
                            formatted = String.valueOf(prefix) + ": SNIP Reply 1st frame";
                            break;
                        }
                        case 32: {
                            formatted = String.valueOf(prefix) + ": SNIP Reply last frame";
                            break;
                        }
                        case 48: {
                            formatted = String.valueOf(prefix) + ": SNIP Reply middle frame";
                            break;
                        }
                        default: {
                            formatted = String.valueOf(prefix) + ": SNIP Reply unknown";
                            break;
                        }
                    }
                } else {
                    formatted = String.valueOf(prefix) + ": Unknown message " + raw;
                }
            } else {
                String name;
                Message msg = list.get(0);
                StringBuilder sb = new StringBuilder();
                sb.append(prefix);
                sb.append(": ");
                sb.append(list.get(0).toString());
                if (this.nodeNameCheckBox.isSelected() && this.olcbInterface != null && (name = this.olcbInterface.getNodeStore().findNode(list.get(0).getSourceNodeID()).getSimpleNodeIdent().getUserName()) != null && !name.equals("")) {
                    sb.append("\n  Src: ");
                    sb.append(name);
                }
                if ((this.eventCheckBox.isSelected() || this.eventAllCheckBox.isSelected()) && this.olcbInterface != null && msg instanceof EventMessage) {
                    EventID ev = ((EventMessage)msg).getEventID();
                    EventTable.EventTableEntry[] descr = this.olcbInterface.getEventTable().getEventInfo(ev).getAllEntries();
                    if (descr.length > 0) {
                        sb.append("\n  Event: ");
                        sb.append(descr[0].getDescription());
                    }
                    if (this.eventAllCheckBox.isSelected()) {
                        int i = 1;
                        while (i < descr.length) {
                            sb.append("\n  Event: ");
                            sb.append(descr[i].getDescription());
                            ++i;
                        }
                    }
                }
                formatted = sb.toString();
            }
        } else {
            String alias = "0x" + Integer.toHexString(header & 0xFFF).toUpperCase();
            if ((header & 0x7000000) == 0) {
                int[] data = new int[len];
                System.arraycopy(content, 0, data, 0, len);
                switch (header & 0xFFF000) {
                    case 0x700000: {
                        formatted = String.valueOf(prefix) + ": Alias " + alias + " RID frame";
                        break;
                    }
                    case 0x701000: {
                        formatted = String.valueOf(prefix) + ": Alias " + alias + " AMD frame for node " + Utilities.toHexDotsString((int[])data);
                        break;
                    }
                    case 0x702000: {
                        formatted = String.valueOf(prefix) + ": Alias " + alias + " AME frame for node " + Utilities.toHexDotsString((int[])data);
                        break;
                    }
                    case 0x703000: {
                        formatted = String.valueOf(prefix) + ": Alias " + alias + " AMR frame for node " + Utilities.toHexDotsString((int[])data);
                        break;
                    }
                    default: {
                        formatted = String.valueOf(prefix) + ": Unknown CAN control frame: " + raw;
                        break;
                    }
                }
            } else {
                formatted = String.valueOf(prefix) + ": Alias " + alias + " CID " + (header & 0x7000000) / 0x1000000 + " frame";
            }
        }
        this.nextLine(String.valueOf(formatted) + "\n", raw);
    }

    @Override
    public synchronized void message(CanMessage l) {
        log.debug("Message: {}", (Object)l);
        this.format("S", l.isExtended(), l.getHeader(), l.getNumDataElements(), l.getData());
    }

    @Override
    public synchronized void reply(CanReply l) {
        log.debug("Reply: {}", (Object)l);
        this.format("R", l.isExtended(), l.getHeader(), l.getNumDataElements(), l.getData());
    }
}

