/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.hub;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.adapters.gridconnect.GridConnectMessage;
import jmri.jmrix.can.adapters.gridconnect.GridConnectReply;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriPanel;
import jmri.util.zeroconf.ZeroConfService;
import org.openlcb.hub.Hub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubPane
extends JmriPanel
implements CanListener,
CanPanelInterface {
    String nextLine;
    CanSystemConnectionMemo memo;
    final transient Hub hub;
    final JLabel label = new JLabel("                                                 ");
    Thread t;
    CanReply workingReply;
    private static final Logger log = LoggerFactory.getLogger(HubPane.class);

    public HubPane() {
        this.hub = new Hub(){

            public void notifyOwner(String line) {
                HubPane.this.nextLine = line;
                SwingUtilities.invokeLater(() -> HubPane.this.label.setText(HubPane.this.nextLine));
            }
        };
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof CanSystemConnectionMemo) {
            this.initComponents((CanSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addCanListener(this);
        this.setLayout(new BoxLayout(this, 1));
        try {
            this.add(new JLabel("Hub IP address " + InetAddress.getLocalHost().getHostAddress() + ":" + this.hub.getPort()));
        }
        catch (UnknownHostException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        this.add(this.label);
        this.startHubThread(this.hub.getPort());
    }

    void startHubThread(int port) {
        this.t = ThreadingUtil.newThread(() -> ((Hub)this.hub).start(), "OpenLCB Hub Thread");
        this.t.setDaemon(true);
        this.hub.addForwarder(m -> {
            if (m.source == null) {
                return;
            }
            GridConnectReply msg = new GridConnectReply();
            byte[] bytes = m.line.getBytes(StandardCharsets.US_ASCII);
            int i = 0;
            while (i < m.line.length()) {
                msg.setElement(i, bytes[i]);
                ++i;
            }
            this.workingReply = msg.createReply();
            CanMessage result = new CanMessage(this.workingReply.getNumDataElements(), this.workingReply.getHeader());
            int i2 = 0;
            while (i2 < this.workingReply.getNumDataElements()) {
                result.setElement(i2, this.workingReply.getElement(i2));
                ++i2;
            }
            result.setExtended(this.workingReply.isExtended());
            this.memo.getTrafficController().sendCanMessage(result, this);
            this.memo.getTrafficController().distributeOneReply(this.workingReply, this);
        });
        this.t.start();
        this.advertise(port);
    }

    void stopHubThread() {
        if (this.t != null) {
            this.t.stop();
            this.t = null;
        }
    }

    void advertise(int port) {
        ZeroConfService.create("_openlcb-can._tcp.local.", port).publish();
    }

    @Override
    public String getTitle() {
        return "OpenLCB Hub Control";
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removeCanListener(this);
    }

    @Override
    public synchronized void message(CanMessage l) {
        GridConnectMessage gm = new GridConnectMessage(l);
        if (log.isDebugEnabled()) {
            log.debug("message {}", (Object)gm);
        }
        this.hub.putLine(gm.toString());
    }

    @Override
    public synchronized void reply(CanReply reply) {
        if (reply != this.workingReply) {
            GridConnectMessage gm = new GridConnectMessage(new CanMessage(reply));
            log.debug("reply {}", (Object)gm.toString());
            this.hub.putLine(gm.toString());
        }
    }
}

