/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.downloader;

import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.MemoryContents;
import jmri.jmrix.AbstractLoaderPane;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.downloader.Bundle;
import jmri.jmrix.openlcb.swing.downloader.LoaderAction;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.openlcb.Connection;
import org.openlcb.LoaderClient;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderPane
extends AbstractLoaderPane
implements CanPanelInterface {
    protected CanSystemConnectionMemo memo;
    Connection connection;
    MemoryConfigurationService mcs;
    DatagramService dcs;
    MimicNodeStore store;
    NodeSelector nodeSelector;
    JPanel selectorPane;
    JTextField spaceField;
    JCheckBox lockNode;
    LoaderClient loaderClient;
    NodeID nid;
    byte[] fdata;
    private static final Logger log = LoggerFactory.getLogger(LoaderPane.class);

    public String getTitle(String menuTitle) {
        return Bundle.getMessage("TitleLoader");
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        this.connection = (Connection)memo.get(Connection.class);
        this.mcs = (MemoryConfigurationService)memo.get(MemoryConfigurationService.class);
        this.dcs = (DatagramService)memo.get(DatagramService.class);
        this.store = (MimicNodeStore)memo.get(MimicNodeStore.class);
        this.nodeSelector = new NodeSelector(this.store);
        this.loaderClient = (LoaderClient)memo.get(LoaderClient.class);
        this.nid = (NodeID)memo.get(NodeID.class);
        this.loadButton.setText("Load");
        this.loadButton.setToolTipText("Start Load Process");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Target Node ID: "));
        p.add((Component)this.nodeSelector);
        this.selectorPane.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Address Space: "));
        this.spaceField = new JTextField("239");
        p.add(this.spaceField);
        this.selectorPane.add(p);
        this.spaceField.setToolTipText("The decimal number of the address space, e.g. 239");
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.lockNode = new JCheckBox("Lock Node");
        p.add(this.lockNode);
        this.selectorPane.add(p);
        this.verifyButton.setVisible(false);
    }

    @Override
    protected void addChooserFilters(JFileChooser chooser) {
    }

    @Override
    public void doRead(JFileChooser chooser) {
        String fn = chooser.getSelectedFile().getPath();
        this.readFile(fn);
        this.bar.setValue(0);
        this.loadButton.setEnabled(true);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.downloader.LoaderFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("TitleLoader"));
    }

    @Override
    protected void addOptionsPanel() {
        this.selectorPane = new JPanel();
        this.selectorPane.setLayout(new BoxLayout(this.selectorPane, 1));
        this.add(this.selectorPane);
    }

    @Override
    protected void handleOptionsInFileContent(MemoryContents inputContent) {
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        this.setOperationAborted(false);
        this.abortButton.setEnabled(false);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortDisabled"));
        int ispace = Integer.parseInt(this.spaceField.getText());
        long addr = 0L;
        this.loaderClient.doLoad(this.nid, this.destNodeID(), ispace, addr, this.fdata, new LoaderClient.LoaderStatusReporter(){

            public void onProgress(float percent) {
                LoaderPane.this.updateGUI(Math.round(percent));
            }

            public void onDone(int errorCode, String errorString) {
                if (errorCode == 0) {
                    LoaderPane.this.updateGUI(100);
                    if (errorString.isEmpty()) {
                        LoaderPane.this.status.setText(Bundle.getMessage("StatusDownloadOk"));
                    } else {
                        LoaderPane.this.status.setText(Bundle.getMessage("StatusDownloadOkWithMessage", errorString));
                    }
                    LoaderPane.this.setOperationAborted(false);
                } else {
                    String msg = Bundle.getMessage("StatusDownloadFailed", Integer.toHexString(errorCode), errorString);
                    LoaderPane.this.status.setText(msg);
                    LoaderPane.this.setOperationAborted(true);
                    log.info(msg);
                }
                LoaderPane.this.enableDownloadVerifyButtons();
            }
        });
    }

    void updateGUI(int value) {
        SwingUtilities.invokeLater(() -> {
            log.debug("updateGUI with {}", (Object)value);
            this.bar.setValue(value);
        });
    }

    NodeID destNodeID() {
        return this.nodeSelector.getSelectedItem();
    }

    @Override
    protected void setDefaultFieldValues() {
        log.debug("setDefaultFieldValues leaves fields unchanged");
    }

    public void readFile(String filename) {
        File file = new File(filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                int content;
                log.info("Total file size to read (in bytes) : {}", (Object)fis.available());
                this.fdata = new byte[fis.available()];
                int i = 0;
                while ((content = fis.read()) != -1) {
                    this.fdata[i++] = (byte)content;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Unable to read {}", (Object)filename, (Object)e);
        }
    }

    @Override
    protected boolean parametersAreValid() {
        return true;
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super("Openlcb Firmware Download", new JmriJFrameInterface(), LoaderAction.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

