/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.SystemConnectionMemo;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbSignalMast;
import jmri.jmrix.openlcb.swing.Bundle;
import org.openlcb.swing.EventIdTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbSignalMastAddPane
extends SignalMastAddPane {
    final JCheckBox allowUnLit = new JCheckBox();
    LinkedHashMap<String, JCheckBox> disabledAspects = new LinkedHashMap(12);
    final LinkedHashMap<String, EventIdTextField> aspectEventIDs = new LinkedHashMap(12);
    final JPanel disabledAspectsPanel = new JPanel();
    final EventIdTextField litEventID = new EventIdTextField();
    final EventIdTextField notLitEventID = new EventIdTextField();
    final EventIdTextField heldEventID = new EventIdTextField();
    final EventIdTextField notHeldEventID = new EventIdTextField();
    OlcbSignalMast currentMast = null;
    final DecimalFormat paddedNumber = new DecimalFormat("0000");
    private static final Logger log = LoggerFactory.getLogger(OlcbSignalMastAddPane.class);

    public OlcbSignalMastAddPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.litEventID.setText("00.00.00.00.00.00.00.00");
        this.notLitEventID.setText("00.00.00.00.00.00.00.00");
        this.heldEventID.setText("00.00.00.00.00.00.00.00");
        this.notHeldEventID.setText("00.00.00.00.00.00.00.00");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(String.valueOf(Bundle.getMessage("AllowUnLitLabel")) + ": "));
        p.add(this.allowUnLit);
        p.setAlignmentX(0.0f);
        this.add(p);
        TitledBorder disableborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        disableborder.setTitle(Bundle.getMessage("EnterAspectsLabel"));
        JScrollPane disabledAspectsScroll = new JScrollPane(this.disabledAspectsPanel);
        disabledAspectsScroll.setBorder(disableborder);
        this.add(disabledAspectsScroll);
        TitledBorder litborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        litborder.setTitle(Bundle.getMessage("LitUnLit"));
        JPanel pLit = new JPanel();
        pLit.setBorder(litborder);
        pLit.setLayout(new BoxLayout(pLit, 1));
        JPanel p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("LitLabel")));
        p5.add(Box.createHorizontalGlue());
        pLit.add(p5);
        pLit.add((Component)this.litEventID);
        p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("NotLitLabel")));
        p5.add(Box.createHorizontalGlue());
        pLit.add(p5);
        pLit.add((Component)this.notLitEventID);
        this.add(pLit);
        TitledBorder heldborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        heldborder.setTitle(Bundle.getMessage("HeldUnHeld"));
        JPanel pHeld = new JPanel();
        pHeld.setBorder(heldborder);
        pHeld.setLayout(new BoxLayout(pHeld, 1));
        p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("HeldLabel")));
        p5.add(Box.createHorizontalGlue());
        pHeld.add(p5);
        pHeld.add((Component)this.heldEventID);
        p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("NotHeldLabel")));
        p5.add(Box.createHorizontalGlue());
        pHeld.add(p5);
        pHeld.add((Component)this.notHeldEventID);
        this.add(pHeld);
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("OlcbSignalMastPane");
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap map, @Nonnull SignalSystem sigSystem) {
        Enumeration<String> aspects = map.getAspects();
        this.disabledAspects = new LinkedHashMap(12);
        this.disabledAspectsPanel.removeAll();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            JCheckBox disabled = new JCheckBox(aspect);
            this.disabledAspects.put(aspect, disabled);
            EventIdTextField eventID = new EventIdTextField();
            eventID.setText("00.00.00.00.00.00.00.00");
            this.aspectEventIDs.put(aspect, eventID);
        }
        this.disabledAspectsPanel.setLayout(new BoxLayout(this.disabledAspectsPanel, 1));
        for (Map.Entry<String, JCheckBox> entry : this.disabledAspects.entrySet()) {
            JPanel p1 = new JPanel();
            TitledBorder p1border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
            p1border.setTitle(entry.getKey());
            p1.setBorder(p1border);
            p1.setLayout(new BoxLayout(p1, 1));
            p1.add((Component)this.aspectEventIDs.get(entry.getKey()));
            p1.add(entry.getValue());
            entry.getValue().setName(entry.getKey());
            entry.getValue().setText(Bundle.getMessage("DisableAspect"));
            this.disabledAspectsPanel.add(p1);
        }
        this.litEventID.setText("00.00.00.00.00.00.00.00");
        this.notLitEventID.setText("00.00.00.00.00.00.00.00");
        this.heldEventID.setText("00.00.00.00.00.00.00.00");
        this.notHeldEventID.setText("00.00.00.00.00.00.00.00");
        this.disabledAspectsPanel.revalidate();
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast instanceof OlcbSignalMast;
    }

    @Override
    public void setMast(SignalMast mast) {
        if (mast == null) {
            this.currentMast = null;
            return;
        }
        if (!(mast instanceof OlcbSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            return;
        }
        this.currentMast = (OlcbSignalMast)mast;
        List<String> disabled = this.currentMast.getDisabledAspects();
        if (disabled != null) {
            for (String aspect : disabled) {
                if (!this.disabledAspects.containsKey(aspect)) continue;
                this.disabledAspects.get(aspect).setSelected(true);
            }
        }
        for (String aspect : this.currentMast.getAllKnownAspects()) {
            if (this.aspectEventIDs.get(aspect) == null) {
                EventIdTextField eventID = new EventIdTextField();
                eventID.setText("00.00.00.00.00.00.00.00");
                this.aspectEventIDs.put(aspect, eventID);
            }
            if (this.currentMast.isOutputConfigured(aspect)) {
                this.aspectEventIDs.get(aspect).setText(this.currentMast.getOutputForAppearance(aspect));
                continue;
            }
            this.aspectEventIDs.get(aspect).setText("00.00.00.00.00.00.00.00");
        }
        this.litEventID.setText(this.currentMast.getLitEventId());
        this.notLitEventID.setText(this.currentMast.getNotLitEventId());
        this.heldEventID.setText(this.currentMast.getHeldEventId());
        this.notHeldEventID.setText(this.currentMast.getNotHeldEventId());
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        log.debug("setMast({})", (Object)mast);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        if (this.currentMast == null) {
            String type = mastname.substring(11, mastname.length() - 4);
            String name = "MF$olm:" + sigsysname + ":" + type;
            name = String.valueOf(name) + "($" + this.paddedNumber.format(OlcbSignalMast.getLastRef() + 1) + ")";
            this.currentMast = new OlcbSignalMast(name);
            if (!username.equals("")) {
                this.currentMast.setUserName(username);
            }
            this.currentMast.setMastType(type);
            InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
        }
        for (Map.Entry<String, JCheckBox> entry : this.disabledAspects.entrySet()) {
            if (entry.getValue().isSelected()) {
                this.currentMast.setAspectDisabled(entry.getKey());
            } else {
                this.currentMast.setAspectEnabled(entry.getKey());
            }
            this.currentMast.setOutputForAppearance(entry.getKey(), this.aspectEventIDs.get(entry.getKey()).getText());
        }
        this.currentMast.setLitEventId(this.litEventID.getText());
        this.currentMast.setNotLitEventId(this.notLitEventID.getText());
        this.currentMast.setHeldEventId(this.heldEventID.getText());
        this.currentMast.setNotHeldEventId(this.notHeldEventID.getText());
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        return true;
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        public boolean isAvailable() {
            for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
                if (!(memo instanceof CanSystemConnectionMemo)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("OlcbSignalMastPane");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new OlcbSignalMastAddPane();
        }
    }
}

