/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.swing.Bundle;
import jmri.util.JmriJFrame;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.cdi.swing.CdiPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientActions {
    private static final Logger log = LoggerFactory.getLogger(ClientActions.class);
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;

    public ClientActions(OlcbInterface iface, CanSystemConnectionMemo memo) {
        this.iface = iface;
        this.memo = memo;
    }

    public void openCdiWindow(NodeID destNode, String description) {
        final ArrayList sensorButtonList = new ArrayList();
        final ArrayList turnoutButtonList = new ArrayList();
        JmriJFrame f = new JmriJFrame();
        f.setTitle(Bundle.getMessage("CdiPanelConfigure", description));
        f.setLayout(new BoxLayout(f.getContentPane(), 1));
        final CdiPanel m = new CdiPanel();
        f.add((Component)m);
        m.setEventTable(this.iface.getNodeStore().getSimpleNodeIdent(destNode).getUserName(), this.iface.getEventTable());
        CdiPanel.GuiItemFactory factory = new CdiPanel.GuiItemFactory(){
            private boolean haveButtons = false;
            JPanel gpane = null;
            JTextField desc = null;
            JFormattedTextField evt1 = null;
            JFormattedTextField evt2 = null;

            public JButton handleReadButton(JButton button) {
                return button;
            }

            public JButton handleWriteButton(JButton button) {
                return button;
            }

            public void handleGroupPaneStart(JPanel pane) {
                this.gpane = pane;
                this.evt1 = null;
                this.evt2 = null;
                this.desc = null;
            }

            public void handleGroupPaneEnd(JPanel pane) {
                if (this.gpane != null && this.evt1 != null && this.evt2 != null && this.desc != null) {
                    JPanel p = new JPanel();
                    p.setLayout(new FlowLayout());
                    p.setAlignmentX(-1.0f);
                    pane.add(p);
                    JButton button = new JButton(Bundle.getMessage("CdiPanelMakeSensor"));
                    p.add(button);
                    sensorButtonList.add(button);
                    button.addActionListener(new ActionListener(){
                        final JTextField mdesc;
                        final JFormattedTextField mevt1;
                        final JFormattedTextField mevt2;
                        {
                            this.mdesc = desc;
                            this.mevt1 = evt1;
                            this.mevt2 = evt2;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(String.valueOf(ClientActions.this.memo.getSystemPrefix()) + "S" + this.mevt1.getText() + ";" + this.mevt2.getText());
                            if (this.mdesc.getText().length() > 0) {
                                sensor.setUserName(this.mdesc.getText());
                            }
                            log.info("make sensor MS{};{} [{}]", new Object[]{this.mevt1.getText(), this.mevt2.getText(), this.mdesc.getText()});
                        }
                    });
                    button = new JButton(Bundle.getMessage("CdiPanelMakeTurnout"));
                    p.add(button);
                    turnoutButtonList.add(button);
                    button.addActionListener(new ActionListener(){
                        final JTextField mdesc;
                        final JFormattedTextField mevt1;
                        final JFormattedTextField mevt2;
                        {
                            this.mdesc = desc;
                            this.mevt1 = evt1;
                            this.mevt2 = evt2;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Turnout turnout = InstanceManager.turnoutManagerInstance().provideTurnout(String.valueOf(ClientActions.this.memo.getSystemPrefix()) + "T" + this.mevt1.getText() + ";" + this.mevt2.getText());
                            if (this.mdesc.getText().length() > 0) {
                                turnout.setUserName(this.mdesc.getText());
                            }
                            log.info("make turnout MT{};{} [{}]", new Object[]{this.mevt1.getText(), this.mevt2.getText(), this.mdesc.getText()});
                        }
                    });
                    if (!this.haveButtons) {
                        this.haveButtons = true;
                        m.addButtonToFooter((JComponent)ClientActions.this.buttonForList(sensorButtonList, Bundle.getMessage("CdiPanelMakeAllSensors")));
                        m.addButtonToFooter((JComponent)ClientActions.this.buttonForList(turnoutButtonList, Bundle.getMessage("CdiPanelMakeAllTurnouts")));
                    }
                    this.gpane = null;
                    this.evt1 = null;
                    this.evt2 = null;
                    this.desc = null;
                }
            }

            public JFormattedTextField handleEventIdTextField(JFormattedTextField field) {
                if (this.evt1 == null) {
                    this.evt1 = field;
                } else if (this.evt2 == null) {
                    this.evt2 = field;
                } else {
                    this.gpane = null;
                }
                return field;
            }

            public JTextField handleStringValue(JTextField value) {
                this.desc = value;
                return value;
            }
        };
        ConfigRepresentation rep = this.iface.getConfigForNode(destNode);
        m.initComponents(rep, factory);
        f.pack();
        f.setVisible(true);
    }

    JButton buttonForList(ArrayList<JButton> list, String label) {
        JButton b = new JButton(label);
        b.addActionListener(e -> {
            int delay = 0;
            for (JButton b1 : list) {
                ActionListener taskPerformer = new ActionListener(b1){
                    final JButton target;
                    {
                        this.target = jButton;
                    }

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        this.target.doClick();
                    }
                };
                Timer t = new Timer(delay, taskPerformer);
                t.setRepeats(false);
                t.start();
                delay += 150;
            }
        });
        return b;
    }
}

