/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.BooleanPropertyDescriptor;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.Turnout;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbTurnout;
import jmri.jmrix.openlcb.OlcbUtils;
import jmri.managers.AbstractTurnoutManager;
import org.openlcb.OlcbInterface;

public class OlcbTurnoutManager
extends AbstractTurnoutManager {
    private boolean isLoading = false;
    private final ArrayList<OlcbTurnout> pendingTurnouts = new ArrayList();

    public OlcbTurnoutManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        ArrayList l = new ArrayList();
        l.add(new BooleanPropertyDescriptor("IsAuthoritative", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateAuthHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        l.add(new BooleanPropertyDescriptor("ListenStateMessages", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateListenHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String addr = systemName.substring(this.getSystemPrefix().length() + 1);
        OlcbTurnout t = new OlcbTurnout(this.getSystemPrefix(), addr, (OlcbInterface)this.memo.get(OlcbInterface.class));
        t.setUserName(userName);
        ArrayList<OlcbTurnout> arrayList = this.pendingTurnouts;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingTurnouts.add(t);
            } else {
                t.finishLoad();
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        ArrayList<OlcbTurnout> arrayList = this.pendingTurnouts;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        ArrayList<OlcbTurnout> arrayList = this.pendingTurnouts;
        synchronized (arrayList) {
            this.pendingTurnouts.forEach(OlcbTurnout::finishLoad);
            this.pendingTurnouts.clear();
            this.isLoading = false;
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpPrefix = String.valueOf(prefix) + this.typeLetter();
        String tmpSName = String.valueOf(tmpPrefix) + curAddress;
        try {
            OlcbAddress.validateSystemNameFormat(tmpSName, Locale.getDefault(), tmpPrefix);
        }
        catch (NamedBean.BadSystemNameException e) {
            throw new JmriException(e.getMessage());
        }
        return String.valueOf(prefix) + this.typeLetter() + curAddress;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        this.createSystemName(curAddress, prefix);
        return curAddress;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        name = super.validateSystemNameFormat(name, locale);
        return OlcbAddress.validateSystemNameFormat(name, locale, this.getSystemNamePrefix());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddTurnoutEntryToolTip");
    }
}

