/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SystemConnectionMemo;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.openlcb.OlcbThrottle;
import jmri.jmrix.openlcb.OpenLcbLocoAddress;
import org.openlcb.NodeID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbThrottleManager
extends AbstractThrottleManager {
    private static final Logger log = LoggerFactory.getLogger(OlcbThrottleManager.class);

    public OlcbThrottleManager() {
    }

    public OlcbThrottleManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (!(a instanceof DccLocoAddress)) {
            this.failedThrottleRequest(a, "Not a DccLocoAddress");
            return;
        }
        DccLocoAddress address = (DccLocoAddress)a;
        log.debug("new debug throttle for {}", (Object)address);
        this.notifyThrottleKnown(new OlcbThrottle(address, this.adapterMemo), a);
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 1;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public LocoAddress getAddress(String value, LocoAddress.Protocol protocol) {
        if (protocol == LocoAddress.Protocol.OPENLCB) {
            NodeID node = new NodeID(value);
            return new OpenLcbLocoAddress(node);
        }
        return super.getAddress(value, protocol);
    }

    @Override
    public String[] getAddressTypes() {
        return new String[]{LocoAddress.Protocol.DCC_SHORT.getPeopleName(), LocoAddress.Protocol.DCC_LONG.getPeopleName(), LocoAddress.Protocol.OPENLCB.getPeopleName()};
    }

    @Override
    public LocoAddress.Protocol[] getAddressProtocolTypes() {
        return new LocoAddress.Protocol[]{LocoAddress.Protocol.DCC_SHORT, LocoAddress.Protocol.DCC_LONG, LocoAddress.Protocol.OPENLCB};
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("disposeThrottle called for {}", (Object)t);
        if (super.disposeThrottle(t, l) && t instanceof OlcbThrottle) {
            OlcbThrottle lnt = (OlcbThrottle)t;
            lnt.throttleDispose();
            return true;
        }
        return false;
    }
}

