/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.openlcb.OpenLcbLocoAddress;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.throttle.ThrottleImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbThrottle
extends AbstractThrottle {
    final ThrottleImplementation oti;
    final DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(OlcbThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlcbThrottle(DccLocoAddress address, SystemConnectionMemo memo) {
        super(memo);
        OlcbInterface iface = (OlcbInterface)memo.get(OlcbInterface.class);
        OlcbThrottle olcbThrottle = this;
        synchronized (olcbThrottle) {
            this.speedSetting = 0.0f;
        }
        this.isForward = true;
        this.address = address;
        if (iface.getNodeStore() == null) {
            log.error("Failed to access Mimic Node Store");
        }
        if (iface.getDatagramService() == null) {
            log.error("Failed to access Datagram Service");
        }
        this.oti = address instanceof OpenLcbLocoAddress ? new ThrottleImplementation(((OpenLcbLocoAddress)address).getNode(), iface.getNodeStore(), iface.getDatagramService()) : new ThrottleImplementation(this.address.getNumber(), this.address.isLongAddress(), iface.getNodeStore(), iface.getDatagramService());
        this.oti.start();
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        if ((double)speed > 1.0) {
            log.warn("Speed was set too high: {}", (Object)Float.valueOf(speed));
        }
        this.speedSetting = speed;
        if ((double)speed >= 0.0) {
            this.oti.setSpeed((double)speed * 100.0, this.isForward);
        } else {
            this.oti.doEmergencyStop();
        }
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        OlcbThrottle olcbThrottle = this;
        synchronized (olcbThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void setFunction(int functionNum, boolean newState) {
        this.updateFunction(functionNum, newState);
        this.oti.setFunction(functionNum, newState ? 1 : 0);
    }

    @Override
    public void throttleDispose() {
        log.debug("throttleDispose() called");
        this.finishRecord();
    }
}

