/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.ResourceBundle;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbProgrammer;
import jmri.jmrix.openlcb.OlcbProgrammerManager;
import jmri.jmrix.openlcb.OlcbSensorManager;
import jmri.jmrix.openlcb.OlcbThrottleManager;
import jmri.jmrix.openlcb.OlcbTurnoutManager;
import jmri.jmrix.swing.ComponentFactory;
import org.openlcb.OlcbInterface;

public class OlcbSystemConnectionMemo
extends CanSystemConnectionMemo {
    final ComponentFactory cf = null;
    protected OlcbProgrammerManager programmerManager;
    protected OlcbTurnoutManager turnoutManager;
    protected OlcbThrottleManager throttleManager;
    protected OlcbSensorManager sensorManager;
    protected OlcbInterface olcbInterface;

    public OlcbSystemConnectionMemo() {
        this.register();
        InstanceManager.store(this, OlcbSystemConnectionMemo.class);
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.getDisabled()) {
            return false;
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            return this.getProgrammerManager().isGlobalProgrammerAvailable();
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            return this.getProgrammerManager().isAddressedModePossible();
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (type.equals(TurnoutManager.class)) {
            return true;
        }
        if (type.equals(ThrottleManager.class)) {
            return true;
        }
        return super.provides(type);
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.getDisabled()) {
            return null;
        }
        if (T.equals(GlobalProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(AddressedProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(SensorManager.class)) {
            return (T)this.getSensorManager();
        }
        if (T.equals(TurnoutManager.class)) {
            return (T)this.getTurnoutManager();
        }
        if (T.equals(ThrottleManager.class)) {
            return (T)this.getThrottleManager();
        }
        if (T.equals(OlcbInterface.class)) {
            return (T)this.getInterface();
        }
        return super.get(T);
    }

    @Override
    public void configureManagers() {
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        if (this.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        InstanceManager.store(this.getThrottleManager(), ThrottleManager.class);
    }

    public OlcbProgrammerManager getProgrammerManager() {
        if (this.programmerManager == null) {
            this.programmerManager = new OlcbProgrammerManager(new OlcbProgrammer());
        }
        return this.programmerManager;
    }

    public void setProgrammerManager(OlcbProgrammerManager p) {
        this.programmerManager = p;
    }

    public OlcbTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.turnoutManager == null) {
            this.turnoutManager = new OlcbTurnoutManager(this);
        }
        return this.turnoutManager;
    }

    public OlcbThrottleManager getThrottleManager() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.throttleManager == null) {
            this.throttleManager = new OlcbThrottleManager();
        }
        return this.throttleManager;
    }

    public OlcbSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.sensorManager == null) {
            this.sensorManager = new OlcbSensorManager(this);
        }
        return this.sensorManager;
    }

    public OlcbInterface getInterface() {
        return this.olcbInterface;
    }

    public void setInterface(OlcbInterface iface) {
        this.olcbInterface = iface;
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.openlcb.OlcbActionListBundle");
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, OlcbSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        if (this.turnoutManager != null) {
            InstanceManager.deregister(this.turnoutManager, OlcbTurnoutManager.class);
        }
        if (this.sensorManager != null) {
            InstanceManager.deregister(this.sensorManager, OlcbSensorManager.class);
        }
        if (this.throttleManager != null) {
            InstanceManager.deregister(this.throttleManager, OlcbThrottleManager.class);
        }
        super.dispose();
    }

    @CheckReturnValue
    public static int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2) {
        OlcbAddress[] array1 = new OlcbAddress(suffix1).split();
        OlcbAddress[] array2 = new OlcbAddress(suffix2).split();
        int i = 0;
        while (i < Math.min(array1.length, array2.length)) {
            int c = array1[i].compare(array2[i]);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return Integer.signum(array1.length - array2.length);
    }
}

