/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.implementation.AbstractSignalMast;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbAddress;
import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.EventID;
import org.openlcb.EventState;
import org.openlcb.IdentifyConsumersMessage;
import org.openlcb.IdentifyEventsAddressedMessage;
import org.openlcb.IdentifyEventsGlobalMessage;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbSignalMast
extends AbstractSignalMast {
    protected String mastType = "F$olm";
    StateMachine<Boolean> litMachine;
    StateMachine<Boolean> heldMachine;
    StateMachine<String> aspectMachine;
    NodeID node;
    Connection connection;
    CanSystemConnectionMemo systemMemo;
    int mastNumber;
    protected static volatile int lastRef = 0;
    private static final Logger log = LoggerFactory.getLogger(OlcbSignalMast.class);

    public OlcbSignalMast(String sys, String user) {
        super(sys, user);
        this.configureFromName(sys);
    }

    public OlcbSignalMast(String sys) {
        super(sys);
        this.configureFromName(sys);
    }

    public OlcbSignalMast(String sys, String user, String mastSubType) {
        super(sys, user);
        this.mastType = mastSubType;
        this.configureFromName(sys);
    }

    protected void configureFromName(String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].endsWith(this.mastType)) {
            log.warn("First part of SignalMast system name is incorrect {} : {}", (Object)systemName, (Object)this.mastType);
        } else {
            String systemPrefix = parts[0].substring(0, parts[0].indexOf(36) - 1);
            List<SystemConnectionMemo> memoList = InstanceManager.getList(SystemConnectionMemo.class);
            for (SystemConnectionMemo memo : memoList) {
                if (!memo.getSystemPrefix().equals(systemPrefix)) continue;
                if (memo instanceof CanSystemConnectionMemo) {
                    this.systemMemo = (CanSystemConnectionMemo)memo;
                    break;
                }
                log.error("Can't create mast \"{}\" because system \"{}\" is not CanSystemConnectionMemo but rather {}", new Object[]{systemName, systemPrefix, memo.getClass()});
                break;
            }
            if (this.systemMemo == null) {
                log.error("No OpenLCB connection found for system prefix \"{}\", so mast \"{}\" will not function", (Object)systemPrefix, (Object)systemName);
            }
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf(40));
        this.setMastType(mast);
        String tmp = parts[2].substring(parts[2].indexOf("($") + 2, parts[2].indexOf(41));
        try {
            this.mastNumber = Integer.parseInt(tmp);
            if (this.mastNumber > lastRef) {
                OlcbSignalMast.setLastRef(this.mastNumber);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Mast number of SystemName {} is not in the correct format: {} is not an integer", (Object)systemName, (Object)tmp);
        }
        this.configureSignalSystemDefinition(system);
        this.configureAspectTable(system, mast);
        if (this.systemMemo != null) {
            this.node = ((OlcbInterface)this.systemMemo.get(OlcbInterface.class)).getNodeId();
            this.connection = ((OlcbInterface)this.systemMemo.get(OlcbInterface.class)).getOutputConnection();
            this.litMachine = new StateMachine<Boolean>(this.connection, this.node, Boolean.TRUE);
            this.heldMachine = new StateMachine<Boolean>(this.connection, this.node, Boolean.FALSE);
            this.aspectMachine = new StateMachine<String>(this.connection, this.node, this.getAspect());
            ((OlcbInterface)this.systemMemo.get(OlcbInterface.class)).registerMessageListener((Connection)new MessageDecoder(){

                public void put(Message msg, Connection sender) {
                    OlcbSignalMast.this.handleMessage(msg);
                }
            });
        }
    }

    public void setOutputForAppearance(String appearance, String event) {
        this.aspectMachine.setEventForState(appearance, event);
    }

    public boolean isOutputConfigured(String appearance) {
        return this.aspectMachine.getEventStringForState(appearance) != null;
    }

    public String getOutputForAppearance(String appearance) {
        String retval = this.aspectMachine.getEventStringForState(appearance);
        if (retval == null) {
            log.error("Trying to get appearance {} but it has not been configured", (Object)appearance);
            return "";
        }
        return retval;
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        this.aspectMachine.setState(aspect);
    }

    public void handleMessage(Message msg) {
        Boolean litBefore = this.litMachine.getState();
        Boolean heldBefore = this.heldMachine.getState();
        String aspectBefore = this.aspectMachine.getState();
        msg.applyTo(this.litMachine, null);
        msg.applyTo(this.heldMachine, null);
        msg.applyTo(this.aspectMachine, null);
        if (!litBefore.equals(this.litMachine.getState())) {
            this.firePropertyChange("Lit", litBefore, this.litMachine.getState());
        }
        if (!heldBefore.equals(this.heldMachine.getState())) {
            this.firePropertyChange("Held", heldBefore, this.heldMachine.getState());
        }
        this.aspect = this.aspectMachine.getState();
        this.speed = (String)this.getSignalSystem().getProperty(this.aspect, "speed");
        if (this.aspect == null || !this.aspect.equals(aspectBefore)) {
            this.firePropertyChange("Aspect", aspectBefore, this.aspect);
        }
    }

    @Override
    public void setLit(boolean newLit) {
        this.litMachine.setState(newLit);
    }

    @Override
    public boolean getLit() {
        return this.litMachine.getState();
    }

    @Override
    public void setHeld(boolean newHeld) {
        this.heldMachine.setState(newHeld);
    }

    @Override
    public boolean getHeld() {
        return this.heldMachine.getState();
    }

    protected static void setLastRef(int newVal) {
        lastRef = newVal;
    }

    public static int getLastRef() {
        return lastRef;
    }

    public void setLitEventId(String event) {
        this.litMachine.setEventForState(Boolean.TRUE, event);
    }

    public String getLitEventId() {
        return this.litMachine.getEventStringForState(Boolean.TRUE);
    }

    public void setNotLitEventId(String event) {
        this.litMachine.setEventForState(Boolean.FALSE, event);
    }

    public String getNotLitEventId() {
        return this.litMachine.getEventStringForState(Boolean.FALSE);
    }

    public void setHeldEventId(String event) {
        this.heldMachine.setEventForState(Boolean.TRUE, event);
    }

    public String getHeldEventId() {
        return this.heldMachine.getEventStringForState(Boolean.TRUE);
    }

    public void setNotHeldEventId(String event) {
        this.heldMachine.setEventForState(Boolean.FALSE, event);
    }

    public String getNotHeldEventId() {
        return this.heldMachine.getEventStringForState(Boolean.FALSE);
    }

    static class StateMachine<T>
    extends MessageDecoder {
        final Connection connection;
        final NodeID node;
        T state;
        boolean initizalized = false;
        protected final HashMap<T, String> stateToEventString = new HashMap();
        protected final HashMap<T, EventID> stateToEventID = new HashMap();
        protected final HashMap<EventID, T> eventToState = new HashMap();
        private static final EventID nullEvent = new EventID(new byte[8]);

        public StateMachine(@Nonnull Connection connection, @Nonnull NodeID node, @Nonnull T start) {
            this.connection = connection;
            this.node = node;
            this.state = start;
        }

        public void setState(@Nonnull T newState) {
            log.debug("sending PCER to {}", (Object)this.getEventStringForState(newState));
            this.connection.put((Message)new ProducerConsumerEventReportMessage(this.node, this.getEventIDForState(newState)), null);
        }

        @Nonnull
        public T getState() {
            return this.state;
        }

        public void setEventForState(@Nonnull T key, @Nonnull String value) {
            this.stateToEventString.put(key, value);
            EventID eid = new OlcbAddress(value).toEventID();
            this.stateToEventID.put(key, eid);
            if (this.eventToState.get(eid) == null) {
                this.eventToState.put(eid, key);
                if (!nullEvent.equals((Object)eid)) {
                    this.connection.put((Message)new ProducerIdentifiedMessage(this.node, eid, EventState.Unknown), null);
                    this.connection.put((Message)new ConsumerIdentifiedMessage(this.node, eid, EventState.Unknown), null);
                    this.connection.put((Message)new IdentifyProducersMessage(this.node, eid), null);
                    this.connection.put((Message)new IdentifyConsumersMessage(this.node, eid), null);
                }
            }
        }

        @CheckForNull
        public EventID getEventIDForState(@Nonnull T key) {
            EventID retval = this.stateToEventID.get(key);
            if (retval == null) {
                retval = new EventID("00.00.00.00.00.00.00.00");
            }
            return retval;
        }

        @CheckForNull
        public String getEventStringForState(@Nonnull T key) {
            String retval = this.stateToEventString.get(key);
            if (retval == null) {
                retval = "00.00.00.00.00.00.00.00";
            }
            return retval;
        }

        EventState getEventIDState(EventID event) {
            T value = this.eventToState.get(event);
            if (this.initizalized) {
                if (value.equals(this.state)) {
                    return EventState.Valid;
                }
                return EventState.Invalid;
            }
            return EventState.Unknown;
        }

        public void handleProducerConsumerEventReport(@Nonnull ProducerConsumerEventReportMessage msg, Connection sender) {
            if (this.eventToState.containsKey(msg.getEventID())) {
                this.initizalized = true;
                this.state = this.eventToState.get(msg.getEventID());
            }
        }

        public void handleProducerIdentified(@Nonnull ProducerIdentifiedMessage msg, Connection sender) {
            if (this.eventToState.containsKey(msg.getEventID()) && msg.getEventState() == EventState.Valid) {
                this.initizalized = true;
                this.state = this.eventToState.get(msg.getEventID());
            }
        }

        public void handleConsumerIdentified(@Nonnull ConsumerIdentifiedMessage msg, Connection sender) {
            if (this.eventToState.containsKey(msg.getEventID()) && msg.getEventState() == EventState.Valid) {
                this.initizalized = true;
                this.state = this.eventToState.get(msg.getEventID());
            }
        }

        public void handleIdentifyEventsAddressed(@Nonnull IdentifyEventsAddressedMessage msg, Connection sender) {
            if (!this.node.equals((Object)msg.getDestNodeID())) {
                return;
            }
            this.sendAllIdentifiedMessages();
        }

        public void handleIdentifyEventsGlobal(@Nonnull IdentifyEventsGlobalMessage msg, Connection sender) {
            this.sendAllIdentifiedMessages();
        }

        public void sendAllIdentifiedMessages() {
            Set<Map.Entry<EventID, T>> set = this.eventToState.entrySet();
            for (Map.Entry<EventID, T> entry : set) {
                EventID event = entry.getKey();
                this.connection.put((Message)new ConsumerIdentifiedMessage(this.node, event, this.getEventIDState(event)), null);
                this.connection.put((Message)new ProducerIdentifiedMessage(this.node, event, this.getEventIDState(event)), null);
            }
        }

        public void handleIdentifyProducers(@Nonnull IdentifyProducersMessage msg, Connection sender) {
            EventID event = msg.getEventID();
            if (this.eventToState.containsKey(event)) {
                this.connection.put((Message)new ProducerIdentifiedMessage(this.node, event, this.getEventIDState(event)), null);
            }
        }

        public void handleIdentifyConsumers(@Nonnull IdentifyConsumersMessage msg, Connection sender) {
            EventID event = msg.getEventID();
            if (this.eventToState.containsKey(event)) {
                this.connection.put((Message)new ConsumerIdentifiedMessage(this.node, event, this.getEventIDState(event)), null);
            }
        }
    }
}

