/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.BooleanPropertyDescriptor;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.Sensor;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbSensor;
import jmri.jmrix.openlcb.OlcbUtils;
import jmri.managers.AbstractSensorManager;
import org.openlcb.OlcbInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbSensorManager
extends AbstractSensorManager
implements CanListener {
    private boolean isLoading = false;
    private final ArrayList<OlcbSensor> pendingSensors = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(OlcbSensorManager.class);

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        ArrayList l = new ArrayList();
        l.add(new BooleanPropertyDescriptor("IsAuthoritative", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateAuthHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        l.add(new BooleanPropertyDescriptor("ListenStateMessages", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateListenHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        return l;
    }

    @Override
    public void dispose() {
        this.getMemo().getTrafficController().removeCanListener(this);
        super.dispose();
    }

    public OlcbSensorManager(CanSystemConnectionMemo memo) {
        super(memo);
        memo.getTrafficController().addCanListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String addr = systemName.substring(this.getSystemNamePrefix().length());
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (NamedBean.BadSystemNameException e) {
            log.error(e.getMessage());
            throw e;
        }
        OlcbSensor s = new OlcbSensor(this.getSystemPrefix(), addr, (OlcbInterface)this.memo.get(OlcbInterface.class));
        s.setUserName(userName);
        ArrayList<OlcbSensor> arrayList = this.pendingSensors;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingSensors.add(s);
            } else {
                s.finishLoad();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        log.debug("Sensor manager : start load");
        ArrayList<OlcbSensor> arrayList = this.pendingSensors;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        log.debug("Sensor manager : finish load");
        ArrayList<OlcbSensor> arrayList = this.pendingSensors;
        synchronized (arrayList) {
            this.pendingSensors.forEach(OlcbSensor::finishLoad);
            this.pendingSensors.clear();
            this.isLoading = false;
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpPrefix = String.valueOf(prefix) + this.typeLetter();
        String tmpSName = String.valueOf(tmpPrefix) + curAddress;
        try {
            OlcbAddress.validateSystemNameFormat(tmpSName, Locale.getDefault(), tmpPrefix);
        }
        catch (NamedBean.BadSystemNameException ex) {
            throw new JmriException(ex.getMessage());
        }
        return String.valueOf(prefix) + this.typeLetter() + curAddress;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        this.createSystemName(curAddress, prefix);
        return curAddress;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddSensorEntryToolTip");
    }

    @Override
    public void reply(CanReply l) {
    }

    @Override
    public void message(CanMessage l) {
    }

    @Override
    public void updateAll() {
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        name = super.validateSystemNameFormat(name, locale);
        name = OlcbAddress.validateSystemNameFormat(name, locale, this.getSystemNamePrefix());
        return name;
    }
}

