/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.BooleanPropertyDescriptor;
import jmri.Light;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbLight;
import jmri.jmrix.openlcb.OlcbUtils;
import jmri.managers.AbstractLightManager;
import org.openlcb.OlcbInterface;

public class OlcbLightManager
extends AbstractLightManager {
    private boolean isLoading = false;
    private final ArrayList<OlcbLight> pendingLights = new ArrayList();

    public OlcbLightManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        ArrayList l = new ArrayList();
        l.add(new BooleanPropertyDescriptor("IsAuthoritative", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateAuthHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        l.add(new BooleanPropertyDescriptor("ListenStateMessages", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateListenHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String addr = systemName.substring(this.getSystemPrefix().length() + 1);
        OlcbLight l = new OlcbLight(this.getSystemPrefix(), addr, (OlcbInterface)this.memo.get(OlcbInterface.class));
        l.setUserName(userName);
        ArrayList<OlcbLight> arrayList = this.pendingLights;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingLights.add(l);
            } else {
                l.finishLoad();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        ArrayList<OlcbLight> arrayList = this.pendingLights;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        ArrayList<OlcbLight> arrayList = this.pendingLights;
        synchronized (arrayList) {
            for (OlcbLight l : this.pendingLights) {
                l.finishLoad();
            }
            this.pendingLights.clear();
            this.isLoading = false;
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String address) throws IllegalArgumentException {
        if (address.startsWith("+") || address.startsWith("-")) {
            return false;
        }
        try {
            OlcbAddress.validateSystemNameFormat(address, Locale.getDefault(), this.getSystemNamePrefix());
        }
        catch (NamedBean.BadSystemNameException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        super.validateSystemNameFormat(name, locale);
        name = OlcbAddress.validateSystemNameFormat(name, locale, this.getSystemNamePrefix());
        return name;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddLightEntryToolTip");
    }
}

