/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import javax.annotation.Nonnull;
import jmri.LightControl;
import jmri.implementation.AbstractLight;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbUtils;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.VersionedValueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbLight
extends AbstractLight {
    private static final int PC_DEFAULT_FLAGS = 30;
    static final boolean DEFAULT_IS_AUTHORITATIVE = true;
    static final boolean DEFAULT_LISTEN = true;
    private boolean _finishedLoad = false;
    OlcbAddress addrOn;
    OlcbAddress addrOff;
    OlcbInterface iface;
    VersionedValueListener<Boolean> lightListener;
    BitProducerConsumer pc;
    private static final Logger log = LoggerFactory.getLogger(OlcbLight.class);

    private void init(String address) {
        OlcbAddress a = new OlcbAddress(address);
        OlcbAddress[] v = a.split();
        if (v == null) {
            log.error("Did not find usable system name: {}", (Object)address);
            return;
        }
        if (v.length == 2) {
            this.addrOn = v[0];
            this.addrOff = v[1];
        } else {
            log.error("Can't parse OpenLCB Light system name: {}", (Object)address);
        }
    }

    void finishLoad() {
        int flags = 30;
        flags = OlcbUtils.overridePCFlagsFromProperties(this, flags);
        this.pc = new BitProducerConsumer(this.iface, this.addrOn.toEventID(), this.addrOff.toEventID(), flags);
        this.lightListener = new VersionedValueListener<Boolean>(this.pc.getValue()){

            public void update(Boolean value) {
                OlcbLight.this.setState(value != false ? 2 : 4);
            }
        };
        this.activateLight();
    }

    @Override
    public void activateLight() {
        if (this.lightListener == null) {
            return;
        }
        this.lightControlList.stream().forEach(LightControl::activateLightControl);
        this.mActive = true;
        this._finishedLoad = true;
    }

    @Override
    public void setState(int newState) {
        if (this._finishedLoad) {
            super.setState(newState);
        } else {
            log.debug("Light {} status being set while still Activating", (Object)this);
        }
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        switch (newState) {
            case 2: {
                this.lightListener.setFromOwnerWithForceNotify((Object)true);
                break;
            }
            case 4: {
                this.lightListener.setFromOwnerWithForceNotify((Object)false);
                break;
            }
            case 1: {
                if (this.pc == null) break;
                this.pc.resetToDefault();
                break;
            }
        }
    }

    @Override
    public void setProperty(@Nonnull String key, Object value) {
        Object old = this.getProperty(key);
        super.setProperty(key, value);
        if (value.equals(old)) {
            return;
        }
        if (this.pc == null) {
            return;
        }
        this.finishLoad();
    }

    @Override
    public void dispose() {
        if (this.lightListener != null) {
            this.lightListener.release();
        }
        if (this.pc != null) {
            this.pc.release();
        }
        super.dispose();
    }

    public OlcbLight(String systemName) {
        super(systemName);
    }

    public OlcbLight(String prefix, String address, OlcbInterface iface) {
        super(String.valueOf(prefix) + "L" + address);
        this.iface = iface;
        this.init(address);
    }
}

