/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.awt.event.ActionEvent;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import jmri.AddressedProgrammerManager;
import jmri.ClockControl;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.Version;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.openlcb.OlcbClockControl;
import jmri.jmrix.openlcb.OlcbLightManager;
import jmri.jmrix.openlcb.OlcbProgrammer;
import jmri.jmrix.openlcb.OlcbProgrammerManager;
import jmri.jmrix.openlcb.OlcbSensorManager;
import jmri.jmrix.openlcb.OlcbThrottleManager;
import jmri.jmrix.openlcb.OlcbTurnoutManager;
import jmri.jmrix.openlcb.swing.OpenLcbComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.profile.ProfileManager;
import jmri.util.ThreadingUtil;
import org.openlcb.Connection;
import org.openlcb.LoaderClient;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.SimpleNodeIdentInfoReplyMessage;
import org.openlcb.SimpleNodeIdentInfoRequestMessage;
import org.openlcb.can.AliasMap;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanInterface;
import org.openlcb.can.MessageBuilder;
import org.openlcb.can.OpenLcbCanFrame;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.protocols.TimeProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbConfigurationManager
extends ConfigurationManager {
    public static final String OPT_PROTOCOL_IDENT = "Ident";
    public static final String OPT_IDENT_NODEID = "NodeId";
    public static final String OPT_IDENT_USERNAME = "UserName";
    public static final String OPT_IDENT_DESCRIPTION = "UserDescription";
    public static final String OPT_PROTOCOL_FASTCLOCK = "FastClock";
    public static final String OPT_FASTCLOCK_ENABLE = "EnableMode";
    public static final String OPT_FASTCLOCK_ENABLE_OFF = "disabled";
    public static final String OPT_FASTCLOCK_ENABLE_GENERATOR = "generator";
    public static final String OPT_FASTCLOCK_ENABLE_CONSUMER = "consumer";
    public static final String OPT_FASTCLOCK_ID = "ClockId";
    public static final String OPT_FASTCLOCK_ID_DEFAULT = "default";
    public static final String OPT_FASTCLOCK_ID_DEFAULT_RT = "realtime";
    public static final String OPT_FASTCLOCK_ID_ALT_1 = "alt1";
    public static final String OPT_FASTCLOCK_ID_ALT_2 = "alt2";
    public static final String OPT_FASTCLOCK_ID_CUSTOM = "custom";
    public static final String OPT_FASTCLOCK_CUSTOM_ID = "ClockCustomId";
    final ComponentFactory cf;
    CanInterface olcbCanInterface;
    TrafficController tc;
    NodeID nodeID;
    LoaderClient loaderClient;
    OlcbClockControl clockControl;
    @Deprecated
    AliasMap aliasMap;
    @Deprecated
    MessageBuilder messageBuilder;
    protected OlcbProgrammerManager programmerManager;
    protected OlcbThrottleManager throttleManager;
    protected OlcbTurnoutManager turnoutManager;
    protected OlcbSensorManager sensorManager;
    protected OlcbLightManager lightManager;
    private static final Logger log = LoggerFactory.getLogger(OlcbConfigurationManager.class);

    public OlcbConfigurationManager(CanSystemConnectionMemo memo) {
        super(memo);
        this.cf = new OpenLcbComponentFactory(this.adapterMemo);
        InstanceManager.store(this.cf, ComponentFactory.class);
        InstanceManager.store(this, OlcbConfigurationManager.class);
    }

    private void initializeFastClock() {
        boolean isMaster;
        String enableOption = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_FASTCLOCK, OPT_FASTCLOCK_ENABLE);
        if (OPT_FASTCLOCK_ENABLE_GENERATOR.equals(enableOption)) {
            isMaster = true;
        } else if (OPT_FASTCLOCK_ENABLE_CONSUMER.equals(enableOption)) {
            isMaster = false;
        } else {
            return;
        }
        NodeID clockId = null;
        String clockIdSetting = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_FASTCLOCK, OPT_FASTCLOCK_ID);
        if (OPT_FASTCLOCK_ID_DEFAULT.equals(clockIdSetting)) {
            clockId = TimeProtocol.DEFAULT_CLOCK;
        } else if (OPT_FASTCLOCK_ID_DEFAULT_RT.equals(clockIdSetting)) {
            clockId = TimeProtocol.DEFAULT_RT_CLOCK;
        } else if (OPT_FASTCLOCK_ID_ALT_1.equals(clockIdSetting)) {
            clockId = TimeProtocol.ALT_CLOCK_1;
        } else if (OPT_FASTCLOCK_ID_ALT_2.equals(clockIdSetting)) {
            clockId = TimeProtocol.ALT_CLOCK_2;
        } else if (OPT_FASTCLOCK_ID_CUSTOM.equals(clockIdSetting)) {
            String customId = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_FASTCLOCK, OPT_FASTCLOCK_CUSTOM_ID);
            if (customId == null || customId.isEmpty()) {
                log.error("OpenLCB clock initialize: User selected custom clock, but did not provide a Custom Clock ID. Using default clock.");
            } else {
                try {
                    clockId = new NodeID(customId);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error("OpenLCB clock initialize: Custom Clock ID '{}' is in illegal format. Use dotted hex notation like 05.01.01.01.DD.EE", (Object)customId);
                }
            }
        }
        if (clockId == null) {
            clockId = TimeProtocol.DEFAULT_CLOCK;
        }
        log.debug("Creating olcb clock with id {} is_master {}", (Object)clockId, (Object)isMaster);
        this.clockControl = new OlcbClockControl(this.getInterface(), clockId, isMaster);
        InstanceManager.setDefault(ClockControl.class, this.clockControl);
    }

    @Override
    public void configureManagers() {
        this.getOurNodeID();
        this.tc = this.adapterMemo.getTrafficController();
        this.olcbCanInterface = OlcbConfigurationManager.createOlcbCanInterface(this.nodeID, this.tc);
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setThrottleManager(this.getThrottleManager());
        InstanceManager.setLightManager(this.getLightManager());
        if (this.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        new StartUpHandler().start();
        OlcbInterface iface = this.getInterface();
        this.loaderClient = new LoaderClient(iface.getOutputConnection(), iface.getMemoryConfigurationService(), iface.getDatagramService());
        iface.registerMessageListener((Connection)this.loaderClient);
        iface.registerMessageListener((Connection)new SimpleNodeIdentInfoHandler());
        this.initializeFastClock();
        this.aliasMap = new AliasMap();
        this.tc.addCanListener(new CanListener(){

            @Override
            public void message(CanMessage m) {
                if (!m.isExtended() || m.isRtr()) {
                    return;
                }
                OlcbConfigurationManager.this.aliasMap.processFrame(OlcbConfigurationManager.convertFromCan(m));
            }

            @Override
            public void reply(CanReply m) {
                if (!m.isExtended() || m.isRtr()) {
                    return;
                }
                OlcbConfigurationManager.this.aliasMap.processFrame(OlcbConfigurationManager.convertFromCan(m));
            }
        });
        this.messageBuilder = new MessageBuilder(this.aliasMap);
    }

    OlcbInterface getInterface() {
        return this.olcbCanInterface.getInterface();
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.adapterMemo.getDisabled()) {
            return false;
        }
        if (type.equals(ThrottleManager.class)) {
            return true;
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (type.equals(TurnoutManager.class)) {
            return true;
        }
        if (type.equals(LightManager.class)) {
            return true;
        }
        if (type.equals(AliasMap.class)) {
            return true;
        }
        if (type.equals(MessageBuilder.class)) {
            return true;
        }
        if (type.equals(MimicNodeStore.class)) {
            return true;
        }
        if (type.equals(Connection.class)) {
            return true;
        }
        if (type.equals(MemoryConfigurationService.class)) {
            return true;
        }
        if (type.equals(DatagramService.class)) {
            return true;
        }
        if (type.equals(NodeID.class)) {
            return true;
        }
        if (type.equals(OlcbInterface.class)) {
            return true;
        }
        if (type.equals(CanInterface.class)) {
            return true;
        }
        if (type.equals(ClockControl.class)) {
            return this.clockControl != null;
        }
        return false;
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (T.equals(ThrottleManager.class)) {
            return (T)this.getThrottleManager();
        }
        if (T.equals(SensorManager.class)) {
            return (T)this.getSensorManager();
        }
        if (T.equals(TurnoutManager.class)) {
            return (T)this.getTurnoutManager();
        }
        if (T.equals(LightManager.class)) {
            return (T)this.getLightManager();
        }
        if (T.equals(AliasMap.class)) {
            return (T)this.aliasMap;
        }
        if (T.equals(MessageBuilder.class)) {
            return (T)this.messageBuilder;
        }
        if (T.equals(MimicNodeStore.class)) {
            return (T)this.getInterface().getNodeStore();
        }
        if (T.equals(Connection.class)) {
            return (T)this.getInterface().getOutputConnection();
        }
        if (T.equals(MemoryConfigurationService.class)) {
            return (T)this.getInterface().getMemoryConfigurationService();
        }
        if (T.equals(DatagramService.class)) {
            return (T)this.getInterface().getDatagramService();
        }
        if (T.equals(LoaderClient.class)) {
            return (T)this.loaderClient;
        }
        if (T.equals(NodeID.class)) {
            return (T)this.nodeID;
        }
        if (T.equals(OlcbInterface.class)) {
            return (T)this.getInterface();
        }
        if (T.equals(CanInterface.class)) {
            return (T)this.olcbCanInterface;
        }
        if (T.equals(ClockControl.class)) {
            return (T)this.clockControl;
        }
        return null;
    }

    public OlcbProgrammerManager getProgrammerManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.programmerManager == null) {
            this.programmerManager = new OlcbProgrammerManager(new OlcbProgrammer());
        }
        return this.programmerManager;
    }

    public OlcbThrottleManager getThrottleManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.throttleManager == null) {
            this.throttleManager = new OlcbThrottleManager(this.adapterMemo);
        }
        return this.throttleManager;
    }

    public OlcbTurnoutManager getTurnoutManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.turnoutManager == null) {
            this.turnoutManager = new OlcbTurnoutManager(this.adapterMemo);
        }
        return this.turnoutManager;
    }

    public OlcbSensorManager getSensorManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.sensorManager == null) {
            this.sensorManager = new OlcbSensorManager(this.adapterMemo);
        }
        return this.sensorManager;
    }

    @Override
    public void dispose() {
        if (this.turnoutManager != null) {
            InstanceManager.deregister(this.turnoutManager, OlcbTurnoutManager.class);
        }
        if (this.sensorManager != null) {
            InstanceManager.deregister(this.sensorManager, OlcbSensorManager.class);
        }
        if (this.lightManager != null) {
            InstanceManager.deregister(this.lightManager, OlcbLightManager.class);
        }
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        InstanceManager.deregister(this, OlcbConfigurationManager.class);
        if (this.clockControl != null) {
            this.clockControl.dispose();
            InstanceManager.deregister(this.clockControl, ClockControl.class);
        }
    }

    public OlcbLightManager getLightManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.lightManager == null) {
            this.lightManager = new OlcbLightManager(this.adapterMemo);
        }
        return this.lightManager;
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.openlcb.OlcbActionListBundle");
    }

    protected void getOurNodeID() {
        List<NodeID> previous;
        String userOption = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_IDENT, OPT_IDENT_NODEID);
        if (userOption != null && !userOption.isEmpty()) {
            try {
                this.nodeID = new NodeID(userOption);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("User set node ID protocol option which is in invalid format ({}). Expected dotted hex notation like 02.01.12.FF.EE.DD", (Object)userOption);
            }
        }
        if (!(previous = InstanceManager.getList(NodeID.class)).isEmpty()) {
            this.nodeID = previous.get(0);
            return;
        }
        long pid = this.getProcessId(1L);
        log.debug("Process ID: {}", (Object)pid);
        InetAddress address = null;
        try {
            NetworkInterface n = NetworkInterface.getNetworkInterfaces().nextElement();
            if (n != null) {
                address = n.getInetAddresses().nextElement();
            }
        }
        catch (SocketException e) {
            log.warn("Can't get IP address to make NodeID", (Throwable)e);
        }
        log.debug("InetAddress: {}", address);
        byte b1 = 0;
        if (address != null) {
            b1 = address.getAddress()[0];
        }
        this.nodeID = new NodeID(new byte[]{2, 1, 18, (byte)(b1 & 0xFF), (byte)(pid >> 8 & 0xFFL), (byte)(pid & 0xFFL)});
        log.debug("Node ID: {}", (Object)this.nodeID);
    }

    protected long getProcessId(long fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static CanInterface createOlcbCanInterface(NodeID nodeID, TrafficController tc) {
        final CanInterface olcbIf = new CanInterface(nodeID, frame -> tc.sendCanMessage(OlcbConfigurationManager.convertToCan(frame), null));
        tc.addCanListener(new CanListener(){

            @Override
            public void message(CanMessage m) {
            }

            @Override
            public void reply(CanReply m) {
                if (!m.isExtended() || m.isRtr()) {
                    return;
                }
                olcbIf.frameInput().send((CanFrame)OlcbConfigurationManager.convertFromCan(m));
            }
        });
        olcbIf.getInterface().setLoopbackThread(r -> ThreadingUtil.runOnLayout(r::run));
        return olcbIf;
    }

    static CanMessage convertToCan(CanFrame f) {
        CanMessage fout = new CanMessage(f.getData(), f.getHeader());
        fout.setExtended(true);
        return fout;
    }

    static OpenLcbCanFrame convertFromCan(jmri.jmrix.can.CanFrame message) {
        OpenLcbCanFrame fin = new OpenLcbCanFrame(0);
        fin.setHeader(message.getHeader());
        if (message.getNumDataElements() == 0) {
            return fin;
        }
        byte[] data = new byte[message.getNumDataElements()];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(message.getElement(i) & 0xFF);
            ++i;
        }
        fin.setData(data);
        return fin;
    }

    class SimpleNodeIdentInfoHandler
    extends MessageDecoder {
        private final byte[] content;

        private void addStringPart(String value, List<Byte> contents) {
            if (value != null && !value.isEmpty()) {
                byte[] bb;
                byte[] byArray = bb = value.getBytes(StandardCharsets.UTF_8);
                int n = bb.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    contents.add(b);
                    ++n2;
                }
            }
            contents.add((byte)0);
        }

        SimpleNodeIdentInfoHandler() {
            ArrayList<Byte> l = new ArrayList<Byte>(256);
            l.add((byte)4);
            this.addStringPart("JMRI", l);
            this.addStringPart("PanelPro", l);
            String name = ProfileManager.getDefault().getActiveProfileName();
            if (name != null) {
                this.addStringPart("Profile " + name, l);
            } else {
                this.addStringPart("", l);
            }
            this.addStringPart(Version.name(), l);
            l.add((byte)2);
            this.addStringPart(OlcbConfigurationManager.this.adapterMemo.getProtocolOption(OlcbConfigurationManager.OPT_PROTOCOL_IDENT, OlcbConfigurationManager.OPT_IDENT_USERNAME), l);
            this.addStringPart(OlcbConfigurationManager.this.adapterMemo.getProtocolOption(OlcbConfigurationManager.OPT_PROTOCOL_IDENT, OlcbConfigurationManager.OPT_IDENT_DESCRIPTION), l);
            this.content = new byte[l.size()];
            int i = 0;
            while (i < l.size()) {
                this.content[i] = (Byte)l.get(i);
                ++i;
            }
        }

        public void handleSimpleNodeIdentInfoRequest(SimpleNodeIdentInfoRequestMessage msg, Connection sender) {
            if (msg.getDestNodeID().equals((Object)OlcbConfigurationManager.this.nodeID) && (msg.getSourceNodeID().equals((Object)OlcbConfigurationManager.this.nodeID) || org.openlcb.Version.libVersionAtLeast((int)0, (int)7, (int)8))) {
                OlcbConfigurationManager.this.getInterface().getOutputConnection().put((Message)new SimpleNodeIdentInfoReplyMessage(OlcbConfigurationManager.this.nodeID, msg.getSourceNodeID(), this.content), (Connection)this);
            }
        }
    }

    class StartUpHandler {
        Timer timer;
        static final int START_DELAY = 2500;

        StartUpHandler() {
        }

        void start() {
            log.debug("StartUpHandler starts up");
            this.timer = new Timer(2500, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = ThreadingUtil.newThread(() -> ((StartUpHandler)StartUpHandler.this).OlcbConfigurationManager.this.olcbCanInterface.initialize(), "olcbCanInterface.initialize");
                    t.start();
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
    }
}

