/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.beans.PropertyChangeListener;
import java.util.Date;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.openlcb.Bundle;
import jmri.util.ThreadingUtil;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.protocols.TimeBroadcastConsumer;
import org.openlcb.protocols.TimeBroadcastGenerator;
import org.openlcb.protocols.TimeProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbClockControl
extends DefaultClockControl {
    private final Timebase jmriClock;
    private TimeProtocol hardwareClock;
    private final NodeID clockId;
    private TimeBroadcastConsumer consumer;
    private TimeBroadcastGenerator generator;
    private final PropertyChangeListener listener;
    private static final Logger log = LoggerFactory.getLogger(OlcbClockControl.class);

    public OlcbClockControl(OlcbInterface iface, NodeID clockID, boolean isMaster) {
        this.clockId = clockID;
        if (isMaster) {
            this.generator = new TimeBroadcastGenerator(iface, clockID);
            this.hardwareClock = this.generator;
        } else {
            this.consumer = new TimeBroadcastConsumer(iface, clockID);
            this.hardwareClock = this.consumer;
        }
        this.jmriClock = InstanceManager.getDefault(Timebase.class);
        this.listener = propertyChangeEvent -> this.clockUpdate(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
        this.hardwareClock.addPropertyChangeListener(this.listener);
    }

    public void dispose() {
        this.hardwareClock.removePropertyChangeListener(this.listener);
        if (this.consumer != null) {
            this.consumer.dispose();
            this.consumer = null;
            this.hardwareClock = null;
        }
    }

    private void clockUpdate(String property, Object newValue) {
        switch (property) {
            case "RunUpdated": {
                this.jmriClock.setRun(this.hardwareClock.isRunning());
                break;
            }
            case "RateUpdated": {
                try {
                    this.jmriClock.userSetRate(this.hardwareClock.getRate());
                }
                catch (TimebaseRateException timebaseRateException) {
                    log.warn("Failed to set OpenLCB rate to internal clock.");
                }
                break;
            }
            case "TimeUpdated": {
                this.jmriClock.setTime(new Date(this.hardwareClock.getTimeInMsec()));
            }
        }
    }

    @Override
    public String getHardwareClockName() {
        String clockName = this.clockId.equals((Object)TimeProtocol.DEFAULT_CLOCK) ? Bundle.getMessage("OlcbClockDefault") : (this.clockId.equals((Object)TimeProtocol.DEFAULT_RT_CLOCK) ? Bundle.getMessage("OlcbClockDefaultRT") : (this.clockId.equals((Object)TimeProtocol.ALT_CLOCK_1) ? Bundle.getMessage("OlcbClockAlt1") : (this.clockId.equals((Object)TimeProtocol.ALT_CLOCK_2) ? Bundle.getMessage("OlcbClockAlt2") : Bundle.getMessage("OlcbClockCustom", this.clockId.toString()))));
        if (this.consumer != null) {
            return Bundle.getMessage("OlcbClockListenerFor", clockName);
        }
        return Bundle.getMessage("OlcbClockGeneratorFor", clockName);
    }

    @Override
    public boolean canCorrectHardwareClock() {
        return false;
    }

    @Override
    public boolean canSet12Or24HourClock() {
        return false;
    }

    @Override
    public boolean requiresIntegerRate() {
        return false;
    }

    @Override
    public double getRate() {
        return this.hardwareClock.getRate();
    }

    @Override
    public Date getTime() {
        return new Date(this.hardwareClock.getTimeInMsec());
    }

    @Override
    public void stopHardwareClock() {
        this.hardwareClock.requestStop();
    }

    @Override
    public void startHardwareClock(Date now) {
        this.hardwareClock.requestSetTime(now.getTime());
        this.hardwareClock.requestStart();
    }

    @Override
    public void setRate(double newRate) {
        if (Math.abs(this.hardwareClock.getRate() - newRate) > 0.12) {
            this.hardwareClock.requestSetRate(newRate);
        } else if (Math.abs(this.hardwareClock.getRate() - newRate) > 1.0E-4) {
            ThreadingUtil.runOnLayoutDelayed(() -> this.clockUpdate("RateUpdated", null), 50);
        }
    }

    @Override
    public void setTime(Date now) {
        this.hardwareClock.requestSetTime(now.getTime());
    }

    @Override
    public void initializeHardwareClock(double rate, Date now, boolean getTime) {
        if (!getTime) {
            this.hardwareClock.requestSetTime(now.getTime());
            if (rate == 0.0) {
                this.hardwareClock.requestStop();
            } else {
                this.hardwareClock.requestSetRate(rate);
                this.hardwareClock.requestStart();
            }
        } else {
            this.hardwareClock.requestQuery();
        }
    }
}

