/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.util.StringUtil;
import org.openlcb.EventID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbAddress {
    static final int GROUP_FULL_HEX = 1;
    static final int GROUP_DOT_HEX = 3;
    static final String singleAddressPattern = "([xX](\\p{XDigit}\\p{XDigit}){1,8})|((\\p{XDigit}?\\p{XDigit}.){7}\\p{XDigit}?\\p{XDigit})";
    private Matcher hCode = null;
    String aString;
    int[] aFrame = null;
    boolean match = false;
    static final int NODEFACTOR = 100000;
    private static final Logger log = LoggerFactory.getLogger(OlcbAddress.class);

    private Matcher getMatcher() {
        if (this.hCode == null) {
            this.hCode = Pattern.compile("^([xX](\\p{XDigit}\\p{XDigit}){1,8})|((\\p{XDigit}?\\p{XDigit}.){7}\\p{XDigit}?\\p{XDigit})$").matcher("");
        }
        return this.hCode;
    }

    public OlcbAddress(EventID e) {
        byte[] contents = e.getContents();
        this.aFrame = new int[contents.length];
        int i = 0;
        byte[] byArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            this.aFrame[i++] = b;
            ++n2;
        }
        this.aString = this.toCanonicalString();
    }

    public OlcbAddress(String s) {
        this.aString = s;
        if (!this.aString.contains(";")) {
            if (this.aString.contains(".")) {
                String[] terms = s.split("\\.");
                if (terms.length != 8) {
                    log.error("unexpected number of terms: {}", (Object)terms.length);
                }
                int[] tFrame = new int[terms.length];
                try {
                    int i = 0;
                    while (i < terms.length) {
                        tFrame[i] = Integer.parseInt(terms[i], 16);
                        ++i;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this.aFrame = tFrame;
                this.match = true;
            } else {
                if (this.aString.startsWith("x")) {
                    this.aString = this.aString.substring(1);
                }
                if (this.aString.startsWith("X")) {
                    this.aString = this.aString.substring(1);
                }
                int len = this.aString.length() / 2;
                int[] tFrame = new int[len];
                try {
                    int i = 0;
                    while (i < len) {
                        String two = this.aString.substring(2 * i, 2 * i + 2);
                        tFrame[i] = Integer.parseInt(two, 16);
                        ++i;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this.aFrame = tFrame;
                this.match = true;
            }
        }
    }

    public boolean equals(Object r) {
        if (r == null) {
            return false;
        }
        if (!r.getClass().equals(this.getClass())) {
            return false;
        }
        OlcbAddress opp = (OlcbAddress)r;
        if (opp.aFrame.length != this.aFrame.length) {
            return false;
        }
        int i = 0;
        while (i < this.aFrame.length) {
            if (this.aFrame[i] != opp.aFrame[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        int[] nArray = this.aFrame;
        int n = this.aFrame.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            ret += value;
            ++n2;
        }
        return ret;
    }

    public int compare(@Nonnull OlcbAddress opp) {
        if (!this.match && !opp.match) {
            return this.aString.compareTo(opp.aString);
        }
        if (this.match && !opp.match) {
            return -1;
        }
        if (!this.match && opp.match) {
            return 1;
        }
        int i = 0;
        while (i < Math.min(this.aFrame.length, opp.aFrame.length)) {
            if (this.aFrame[i] != opp.aFrame[i]) {
                return Integer.signum(this.aFrame[i] - opp.aFrame[i]);
            }
            ++i;
        }
        return Integer.signum(this.aFrame.length - opp.aFrame.length);
    }

    public CanMessage makeMessage() {
        CanMessage c = new CanMessage(this.aFrame, 425410560);
        c.setExtended(true);
        return c;
    }

    public boolean check() {
        return this.getMatcher().reset(this.aString).matches();
    }

    boolean match(CanReply r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        int i = 0;
        while (i < this.aFrame.length) {
            if (this.aFrame[i] != r.getElement(i)) {
                return false;
            }
            ++i;
        }
        if (!r.isExtended()) {
            return false;
        }
        return (r.getHeader() & 0x1FFFF000) == 425410560;
    }

    boolean match(CanMessage r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        int i = 0;
        while (i < this.aFrame.length) {
            if (this.aFrame[i] != r.getElement(i)) {
                return false;
            }
            ++i;
        }
        if (!r.isExtended()) {
            return false;
        }
        return (r.getHeader() & 0x1FFFF000) == 425410560;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Documented API, no resources to improve")
    public OlcbAddress[] split() {
        if (this.aString.endsWith(";")) {
            return null;
        }
        String[] pStrings = this.aString.split(";");
        OlcbAddress[] retval = new OlcbAddress[pStrings.length];
        int i = 0;
        while (i < pStrings.length) {
            if (pStrings[i].equals("")) {
                return null;
            }
            retval[i] = new OlcbAddress(pStrings[i]);
            if (!retval[i].match) {
                return null;
            }
            ++i;
        }
        return retval;
    }

    public boolean checkSplit() {
        return this.split() != null;
    }

    int[] elements() {
        return this.aFrame;
    }

    public String toString() {
        return this.aString;
    }

    public String toCanonicalString() {
        String retval = "x";
        int[] nArray = this.aFrame;
        int n = this.aFrame.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            retval = StringUtil.appendTwoHexFromInt(value, retval);
            ++n2;
        }
        return retval;
    }

    public String toDottedString() {
        String retval = "";
        int[] nArray = this.aFrame;
        int n = this.aFrame.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (!retval.isEmpty()) {
                retval = String.valueOf(retval) + ".";
            }
            retval = StringUtil.appendTwoHexFromInt(value, retval);
            ++n2;
        }
        return retval;
    }

    public EventID toEventID() {
        byte[] b = new byte[8];
        int i = 0;
        while (i < 8) {
            b[i] = (byte)this.aFrame[i];
            ++i;
        }
        return new EventID(b);
    }

    @Nonnull
    public static String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale, @Nonnull String prefix) throws NamedBean.BadSystemNameException {
        String oAddr = name.substring(prefix.length());
        OlcbAddress a = new OlcbAddress(oAddr);
        OlcbAddress[] v = a.split();
        if (v == null) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", "Did not find usable system name: " + name + " to a valid Olcb sensor address");
        }
        switch (v.length) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", "Wrong number of events in address: " + name);
            }
        }
        return name;
    }
}

