/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialLightManager;
import jmri.jmrix.oaktree.SerialSensorManager;
import jmri.jmrix.oaktree.SerialTrafficController;
import jmri.jmrix.oaktree.SerialTurnoutManager;
import jmri.jmrix.oaktree.swing.OakTreeComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakTreeSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(OakTreeSystemConnectionMemo.class);

    public OakTreeSystemConnectionMemo(@Nonnull String prefix, @Nonnull String userName) {
        super(prefix, userName);
        InstanceManager.store(this, OakTreeSystemConnectionMemo.class);
        InstanceManager.store(new OakTreeComponentFactory(this), ComponentFactory.class);
        log.debug("Created OakTreeSystemConnectionMemo");
    }

    public OakTreeSystemConnectionMemo() {
        this("O", "Oak Tree Systems");
        log.debug("Created nameless OakTreeSystemConnectionMemo");
    }

    public void setTrafficController(SerialTrafficController s) {
        this.tc = s;
    }

    public SerialTrafficController getTrafficController() {
        if (this.tc == null) {
            this.setTrafficController(new SerialTrafficController(this));
            log.debug("Auto create of OakTree SerialTrafficController for initial configuration");
        }
        return this.tc;
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void configureManagers() {
        this.setTurnoutManager(new SerialTurnoutManager(this));
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        this.setLightManager(new SerialLightManager(this));
        InstanceManager.setLightManager(this.getLightManager());
        this.setSensorManager(new SerialSensorManager(this));
        InstanceManager.setSensorManager(this.getSensorManager());
        this.register();
    }

    public SensorManager getSensorManager() {
        return (SensorManager)this.get(SensorManager.class);
    }

    public void setSensorManager(SerialSensorManager s) {
        this.store(s, SensorManager.class);
        this.getTrafficController().setSensorManager(s);
    }

    public TurnoutManager getTurnoutManager() {
        return (TurnoutManager)this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(SerialTurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        return (LightManager)this.get(LightManager.class);
    }

    public void setLightManager(SerialLightManager l) {
        this.store(l, LightManager.class);
    }
}

