/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ncemonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanelInterface;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="serialStream is access from separate thread, and this class isn't used much")
public class NcePacketMonitorPanel
extends AbstractMonPane
implements NcePanelInterface {
    ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.ncemonitor.NcePacketMonitorBundle");
    Vector<String> portNameVector = null;
    SerialPort activeSerialPort = null;
    NceSystemConnectionMemo memo = null;
    JToggleButton checkButton = new JToggleButton("Info");
    JRadioButton locoSpeedButton = new JRadioButton("Hide loco packets");
    JCheckBox truncateCheckBox = new JCheckBox("+ on");
    Thread readerThread;
    protected JComboBox<String> portBox = new JComboBox();
    protected JButton openPortButton = new JButton();
    DataInputStream serialStream = null;
    OutputStream ostream = null;
    private static final Logger log = LoggerFactory.getLogger(NcePacketMonitorPanel.class);

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.analyzer.NcePacketMonitorFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(this.rb.getString("Title"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.portBox.setToolTipText("Select the port to use");
        this.portBox.setAlignmentX(0.0f);
        Vector<String> v = this.getPortNames();
        int i = 0;
        while (i < v.size()) {
            this.portBox.addItem(v.elementAt(i));
            ++i;
        }
        this.openPortButton.setText("Open");
        this.openPortButton.setToolTipText("Configure program to use selected port");
        this.openPortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    NcePacketMonitorPanel.this.openPortButtonActionPerformed(evt);
                }
                catch (UnsatisfiedLinkError ex) {
                    log.error("Error while opening port.  Did you select the right one?\n{}", (Throwable)ex);
                }
            }
        });
        JSeparator js = new JSeparator();
        js.setMaximumSize(new Dimension(10000, 10));
        this.add(js);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel("Serial port: "));
        p1.add(this.portBox);
        p1.add(this.openPortButton);
        p1.setMaximumSize(p1.getPreferredSize());
        this.add(p1);
        JSeparator js2 = new JSeparator();
        js2.setMaximumSize(new Dimension(10000, 10));
        this.add(js2);
        JPanel p2 = new JPanel();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.checkButton.setToolTipText("?");
        this.checkButton.setEnabled(false);
        p.add(this.checkButton);
        this.checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NcePacketMonitorPanel.this.checkButton.isSelected()) {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{63});
                    NcePacketMonitorPanel.this.checkButton.setText("Res.");
                    NcePacketMonitorPanel.this.checkButton.setToolTipText("Resume packet monitoring");
                } else {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{32});
                    NcePacketMonitorPanel.this.checkButton.setText("Info");
                    NcePacketMonitorPanel.this.checkButton.setToolTipText("?");
                }
            }
        });
        this.truncateCheckBox.setToolTipText("Check this box to suppress identical packets");
        p.add(this.truncateCheckBox);
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        ButtonGroup g = new ButtonGroup();
        JRadioButton b = new JRadioButton("Verbose");
        b.setToolTipText("V");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{86});
            }
        });
        b = new JRadioButton("Hex with preamble symbol");
        b.setToolTipText("H0");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 48});
            }
        });
        p2.add(p);
        b = new JRadioButton("(as above with spaces)");
        b.setToolTipText("H1");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 49});
            }
        });
        p2.add(p);
        b = new JRadioButton("Hex without preamble symbol");
        b.setToolTipText("H2");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 50});
            }
        });
        p2.add(p);
        b = new JRadioButton("(as above with spaces)");
        b.setToolTipText("H3");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 51});
            }
        });
        p2.add(p);
        b = new JRadioButton("Hex with preamble count in hex");
        b.setToolTipText("H4");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 52});
            }
        });
        p2.add(p);
        b = new JRadioButton("(as above with spaces)");
        b.setToolTipText("H5");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 53});
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        g = new ButtonGroup();
        b = new JRadioButton("Hide acc packets");
        b.setToolTipText("A-");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 45});
            }
        });
        b = new JRadioButton("Show acc packets");
        b.setToolTipText("A+");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 43});
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        g = new ButtonGroup();
        b = new JRadioButton("Hide idle packets");
        b.setToolTipText("I-");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{73, 45});
            }
        });
        b = new JRadioButton("Show idle packets");
        b.setToolTipText("I+");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{73, 43});
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        g = new ButtonGroup();
        this.locoSpeedButton.setToolTipText("L-");
        g.add(this.locoSpeedButton);
        p.add(this.locoSpeedButton);
        this.locoSpeedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{76, 45});
            }
        });
        b = new JRadioButton("Show loco packets");
        b.setToolTipText("L+");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{76, 43});
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        g = new ButtonGroup();
        b = new JRadioButton("Hide reset packets");
        b.setToolTipText("R-");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{82, 45});
            }
        });
        b = new JRadioButton("Show reset packets");
        b.setToolTipText("R+");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{82, 43});
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        g = new ButtonGroup();
        b = new JRadioButton("Hide signal packets");
        b.setToolTipText("S-");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{83, 45});
            }
        });
        b = new JRadioButton("Show signal packets");
        b.setToolTipText("S+");
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{83, 43});
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JLabel t = new JLabel("Monitor Command");
        p.add(t);
        ButtonGroup g2 = new ButtonGroup();
        JRadioButton b2 = new JRadioButton("Acc addresses single");
        b2.setToolTipText("AS");
        g2.add(b2);
        p.add(b2);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 83});
            }
        });
        b2 = new JRadioButton("Acc addresses paired");
        b2.setToolTipText("AP");
        g2.add(b2);
        p.add(b2);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 80});
            }
        });
        p2.add(p);
        p2.setMaximumSize(p2.getPreferredSize());
        JScrollPane ps = new JScrollPane(p2);
        ps.setMaximumSize(ps.getPreferredSize());
        ps.setVisible(true);
        this.add(ps);
    }

    synchronized void sendBytes(byte[] bytes) {
        try {
            if (this.ostream == null) {
                throw new IOException("Unable to send data to command station: output stream is null");
            }
            int i = 0;
            while (i < bytes.length) {
                this.ostream.write(bytes[i]);
                this.wait(3L);
                ++i;
            }
            this.ostream.write(13);
        }
        catch (IOException e) {
            log.error("Exception on output: {}", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Interrupted output: {}", (Throwable)e);
        }
    }

    void openPortButtonActionPerformed(ActionEvent e) {
        log.info("Open button pushed");
        this.openPortButton.setEnabled(false);
        this.portBox.setEnabled(false);
        this.openPort((String)this.portBox.getSelectedItem(), "JMRI");
        this.readerThread = new Thread(new Reader());
        this.readerThread.start();
        this.checkButton.setEnabled(true);
        log.info("Open button processing complete");
    }

    void stopThread(Thread t) {
        t.stop();
    }

    @Override
    public synchronized void dispose() {
        if (this.readerThread != null) {
            this.stopThread(this.readerThread);
        }
        if (this.activeSerialPort != null) {
            this.activeSerialPort.close();
        }
        this.serialStream = null;
        this.ostream = null;
        this.activeSerialPort = null;
        this.portNameVector = null;
        super.dispose();
    }

    public Vector<String> getPortNames() {
        this.portNameVector = new Vector();
        Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
        while (portIDs.hasMoreElements()) {
            CommPortIdentifier id = portIDs.nextElement();
            if (id.getPortType() == 2) continue;
            this.portNameVector.addElement(id.getName());
        }
        return this.portNameVector;
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"}, justification="this is for skip-chars while loop: no matter how many, we're skipping")
    public synchronized String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                this.handlePortBusy(p, portName);
                return "Port " + p + " in use already";
            }
            try {
                this.activeSerialPort.setSerialPortParams(38400, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.activeSerialPort.setRTS(true);
            this.activeSerialPort.setDTR(true);
            this.activeSerialPort.setFlowControlMode(0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = new DataInputStream(this.activeSerialPort.getInputStream());
            this.ostream = this.activeSerialPort.getOutputStream();
            this.sendBytes(new byte[]{76, 45, 10, 13});
            int count = this.serialStream.available();
            log.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                this.serialStream.skip(count);
                count = this.serialStream.available();
            }
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
        }
        catch (IOException ex) {
            log.error("IO error while opening port {}", (Object)portName, (Object)ex);
            return "IO error while opening port " + portName + ": " + ex;
        }
        catch (UnsupportedCommOperationException ex) {
            log.error("Unsupported communications operation while opening port {}", (Object)portName, (Object)ex);
            return "Unsupported communications operation while opening port " + portName + ": " + ex;
        }
        catch (NoSuchPortException ex) {
            log.error("No such port: {}", (Object)portName, (Object)ex);
            return "No such port: " + portName + ": " + ex;
        }
        return null;
    }

    void handlePortBusy(PortInUseException p, String port) {
        log.error("Port {} in use, cannot open", (Throwable)p);
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE DCC Packet Analyzer", (WindowInterface)new JmriJFrameInterface(), NcePacketMonitorPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }

    class Reader
    implements Runnable {
        static final int maxMsg = 80;
        StringBuffer msg;
        StringBuffer duplicates = new StringBuffer(80);
        String msgString;
        String matchString = "";

        Reader() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.handleIncomingData();
                    }
                }
                catch (IOException e) {
                    log.warn("run: Exception: {}", (Object)e.toString());
                    continue;
                }
                break;
            }
        }

        void handleIncomingData() throws IOException {
            this.msg = new StringBuffer(80);
            int i = 0;
            while (i < 80) {
                char char1 = (char)NcePacketMonitorPanel.this.serialStream.readByte();
                if (char1 == '\r') break;
                this.msg.append(char1);
                ++i;
            }
            this.msgString = this.msg.toString();
            if (this.msgString.equals(this.matchString) && NcePacketMonitorPanel.this.truncateCheckBox.isSelected()) {
                this.duplicates.append('+');
            } else {
                this.matchString = this.msgString;
                if (this.duplicates.length() != 0) {
                    this.duplicates.append('\n');
                    this.msgString = " " + new String(this.duplicates) + this.msgString;
                } else {
                    this.msgString = "\n" + this.msgString;
                }
                this.duplicates.setLength(0);
                Runnable r = new Runnable(){
                    String msgForLater;
                    {
                        this.msgForLater = Reader.this.msgString;
                    }

                    @Override
                    public void run() {
                        NcePacketMonitorPanel.this.nextLine(this.msgForLater, "");
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

