/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.usbinterface;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.jmrix.nce.usbinterface.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbInterfacePanel
extends NcePanel
implements NceListener {
    private int replyLen = 0;
    private int waiting = 0;
    private int minCabNum = -1;
    private int maxCabNum = -1;
    private int minCabSetNum = -1;
    private int maxCabSetNum = -1;
    private static final int CAB_MIN_USB = 2;
    private static final int CAB_MIN_PRO = 2;
    private static final int CAB_MAX_USB_128 = 4;
    private static final int CAB_MAX_USB_165 = 10;
    private static final int CAB_MAX_PRO = 63;
    private static final int CAB_MAX_SB3 = 5;
    private static final int REPLY_1 = 1;
    private static final int REPLY_2 = 2;
    private static final int REPLY_4 = 4;
    Thread nceCabUpdateThread;
    private boolean setRequested = false;
    private int setCabId = -1;
    private NceTrafficController tc = null;
    JTextField newCabId = new JTextField(5);
    JLabel oldCabId = new JLabel("     ");
    JButton setButton = new JButton(Bundle.getMessage("ButtonSet"));
    JLabel space1 = new JLabel(" ");
    JLabel space2 = new JLabel("  ");
    JLabel space3 = new JLabel("   ");
    JLabel space4 = new JLabel("    ");
    JLabel space5 = new JLabel("     ");
    JLabel statusText = new JLabel();
    private boolean firstTime = true;
    int recChar = 0;
    int[] recChars = new int[16];
    private static final Logger log = LoggerFactory.getLogger(UsbInterfacePanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.usbinterface.UsbInterfacePanel";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("TitleUsbInterface"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getNceTrafficController();
        this.minCabNum = 2;
        this.maxCabNum = 63;
        this.minCabSetNum = 3;
        this.maxCabSetNum = 63;
        if (this.tc.getUsbSystem() != 0 && (this.tc.getCmdGroups() & 8L) != 0L) {
            this.minCabNum = 2;
            this.maxCabNum = 10;
        } else if (this.tc.getUsbSystem() == 3) {
            this.minCabNum = 2;
            this.maxCabNum = 63;
        } else if (this.tc.getUsbSystem() == 2) {
            this.minCabNum = 2;
            this.maxCabNum = 5;
        } else {
            this.maxCabSetNum = this.tc.getCommandOptions() >= 40 ? 10 : 4;
        }
        this.setLayout(new BoxLayout(this, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        p1.setPreferredSize(new Dimension(400, 75));
        this.addItem(p1, new JLabel(Bundle.getMessage("LabelSetCabId")), 1, 2);
        this.newCabId.setText(" ");
        this.addItem(p1, this.newCabId, 2, 2);
        this.addItem(p1, this.setButton, 3, 2);
        this.add(p1);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridBagLayout());
        this.addItem(p2, new JLabel(Bundle.getMessage("LabelStatus")), 1, 1);
        this.statusText.setText(" ");
        this.addItem(p2, this.statusText, 2, 1);
        this.add(p2);
        JPanel p3 = new JPanel();
        this.add(p3);
        this.addButtonAction(this.setButton);
    }

    public boolean validateCabId(int id) {
        if (id < this.minCabNum || id > this.maxCabNum) {
            return false;
        }
        return this.tc.getUsbSystem() != 1 || (this.tc.getCmdGroups() & 8L) == 0L || id != 6 && id != 7;
    }

    public void buttonActionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.setButton) {
            this.changeCabId();
        } else {
            log.error("unknown action performed: {}", src);
        }
    }

    private void changeCabId() {
        int i = -1;
        try {
            i = Integer.parseInt(this.newCabId.getText().trim());
            if (this.validateCabId(i)) {
                this.processMemory(true, i);
            } else {
                this.statusText.setText(MessageFormat.format(Bundle.getMessage("StatusInvalidCabIdEntered"), i));
            }
        }
        catch (RuntimeException runtimeException) {
            log.debug("failed to convert {}", (Object)i);
        }
    }

    private void processMemory(boolean doSet, int cabId) {
        if (doSet) {
            this.setRequested = true;
            this.setCabId = cabId;
        }
        if (this.nceCabUpdateThread != null && this.nceCabUpdateThread.isAlive()) {
            return;
        }
        this.nceCabUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (UsbInterfacePanel.this.tc.getUsbSystem() != 0 && UsbInterfacePanel.this.setRequested) {
                    UsbInterfacePanel.this.cabSetIdUsb();
                }
            }
        });
        this.nceCabUpdateThread.setName(Bundle.getMessage("ThreadTitle"));
        this.nceCabUpdateThread.setPriority(1);
        this.nceCabUpdateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cabSetIdUsb() {
        if (this.firstTime) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted.", (Throwable)e);
            }
        }
        this.firstTime = false;
        this.recChar = -1;
        this.setRequested = false;
        if (this.validateCabId(this.setCabId)) {
            this.statusText.setText(MessageFormat.format(Bundle.getMessage("StatusSetIdStart"), this.setCabId));
            this.writeUsbCabId(this.setCabId);
            if (!this.waitNce()) {
                return;
            }
            if (this.recChar != NceMessage.NCE_OKAY) {
                this.statusText.setText(MessageFormat.format(Bundle.getMessage("StatusUsbErrorCode"), this.recChars[0]));
            } else {
                this.statusText.setText(MessageFormat.format(Bundle.getMessage("StatusSetIdFinished"), this.setCabId));
            }
            UsbInterfacePanel usbInterfacePanel = this;
            synchronized (usbInterfacePanel) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.statusText.setText(MessageFormat.format(Bundle.getMessage("StatusInvalidCabId"), this.setCabId, this.minCabSetNum, this.maxCabSetNum));
        this.setVisible(true);
        this.repaint();
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Thread wait from main transfer loop")
    public void reply(NceReply r) {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("Receive character");
        }
        if (this.waiting <= 0) {
            log.error("unexpected response. Len: {} code: {}", (Object)r.getNumDataElements(), (Object)r.getElement(0));
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            this.statusText.setText(Bundle.getMessage("StatusError"));
            return;
        }
        if (this.replyLen == 1) {
            this.recChar = r.getElement(0);
        }
        if (this.replyLen == 2) {
            i = 0;
            while (i < 2) {
                this.recChars[i] = r.getElement(i);
                ++i;
            }
        }
        if (this.replyLen == 4) {
            i = 0;
            while (i < 4) {
                this.recChars[i] = r.getElement(i);
                ++i;
            }
        }
        UsbInterfacePanel usbInterfacePanel = this;
        synchronized (usbInterfacePanel) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitNce() {
        int count = 100;
        if (log.isDebugEnabled()) {
            log.debug("Going to sleep");
        }
        while (this.waiting > 0) {
            UsbInterfacePanel usbInterfacePanel = this;
            synchronized (usbInterfacePanel) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (--count >= 0) continue;
            this.statusText.setText(Bundle.getMessage("StatusReplyTimeout"));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("awake!");
        }
        return true;
    }

    private void writeUsbCabId(int value) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbSetCabId(value);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    protected void addItem(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        p.add((Component)c, gc);
    }

    private void addButtonAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsbInterfacePanel.this.buttonActionPerformed(e);
            }
        });
    }
}

