/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.usbdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.nce.NcePortController;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.usbdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class UsbDriverAdapter
extends NcePortController {
    Vector<String> portNameVector = null;
    SerialPort activeSerialPort = null;
    String[] option1Values = new String[]{"PowerCab", "SB3/SB3a", "Power Pro", "Twin", "SB5"};
    String[] option2Values = new String[]{"V6.x.x", "V7.x.x"};
    private String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200")};
    private int[] validSpeedValues = new int[]{9600, 19200};
    private boolean opened = false;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(UsbDriverAdapter.class);

    public UsbDriverAdapter() {
        super(new NceSystemConnectionMemo());
        this.option1Name = "System";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("SystemLabel"), this.option1Values, false));
        this.option2Name = "USB Version";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("UsbVersionLabel"), this.option2Values, false));
        this.setOptionState(this.option2Name, this.getOptionChoices(this.option2Name)[1]);
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                int baud = this.currentBaudNumber(this.mBaudRate);
                this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            this.activeSerialPort.enableReceiveTimeout(50);
            log.debug("Serial timeout was observed as: {}", (Object)(String.valueOf(this.activeSerialPort.getReceiveTimeout()) + " " + this.activeSerialPort.isReceiveTimeoutEnabled()));
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("NCE USB {}  port opened at {} baud", (Object)portName, (Object)this.activeSerialPort.getBaudRate());
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException | UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        log.trace("configure with {}", (Object)this.getSystemConnectionMemo());
        NceTrafficController tc = new NceTrafficController();
        this.getSystemConnectionMemo().setNceTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        if (this.getOptionState(this.option2Name).equals(this.getOptionChoices(this.option2Name)[1])) {
            if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[4])) {
                tc.setUsbSystem(5);
                tc.setCmdGroups(348L);
                this.getSystemConnectionMemo().configureCommandStation(40);
            } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[3])) {
                tc.setUsbSystem(4);
                tc.setCmdGroups(350L);
                this.getSystemConnectionMemo().configureCommandStation(40);
            } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[2])) {
                tc.setUsbSystem(3);
                tc.setCmdGroups(340L);
                this.getSystemConnectionMemo().configureCommandStation(20);
            } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[1])) {
                tc.setUsbSystem(2);
                tc.setCmdGroups(336L);
                this.getSystemConnectionMemo().configureCommandStation(30);
            } else {
                tc.setUsbSystem(1);
                tc.setCmdGroups(350L);
                this.getSystemConnectionMemo().configureCommandStation(40);
            }
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[4])) {
            tc.setUsbSystem(5);
            tc.setCmdGroups(336L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[3])) {
            tc.setUsbSystem(4);
            tc.setCmdGroups(336L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[2])) {
            tc.setUsbSystem(3);
            tc.setCmdGroups(320L);
            this.getSystemConnectionMemo().configureCommandStation(20);
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[1])) {
            tc.setUsbSystem(2);
            tc.setCmdGroups(337L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        } else {
            tc.setUsbSystem(1);
            tc.setCmdGroups(338L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        }
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

