/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NcePortController;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends NcePortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    char NCE_OKAY = (char)33;
    char NCE_ERROR = (char)48;
    char NCE_LOCO_OUT_OF_RANGE = (char)49;
    char NCE_CAB_OUT_OF_RANGE = (char)50;
    char NCE_DATA_OUT_OF_RANGE = (char)51;
    char NCE_BYTE_OUT_OF_RANGE = (char)52;
    String[] option1Values = new String[]{"2006 to Mar 1 2007", "Mar 3 2007 to Jan 24 2008", "Feb 2 2008 to Jan 30 2021", "Feb 22 2021 on"};
    int epromRevision = -1;
    private final byte[] turnoutMemory = new byte[256];
    private final byte[] macroMemory = new byte[5136];
    private final byte[] consistMemory = new byte[1552];
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new NceSystemConnectionMemo());
        this.option1Name = "Eprom";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("EpromLabel"), this.option1Values, false));
        this.setOptionState(this.option1Name, this.option1Values[1]);
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: ", (Throwable)e);
        }
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        NceTrafficController tc = new NceTrafficController();
        this.getSystemConnectionMemo().setNceTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        tc.connectPort(this);
        tc.setSimulatorRunning(true);
        this.getSystemConnectionMemo().configureCommandStation(20);
        tc.setCmdGroups(510L);
        tc.setUsbSystem(0);
        this.epromRevision = Arrays.asList(this.option1Values).indexOf(this.getOptionState(this.option1Name));
        if (this.epromRevision == -1) {
            this.epromRevision = 1;
        }
        this.getSystemConnectionMemo().configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Nce Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    @Override
    public void run() {
        log.info("NCE Simulator Started");
        while (true) {
            NceMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Nce simulator received message: ");
                int i = 0;
                while (i < m.getNumDataElements()) {
                    buf.append(Integer.toHexString(0xFF & m.getElement(i)).toUpperCase()).append(" ");
                    ++i;
                }
                log.debug(buf.toString());
            }
            if (m == null) continue;
            NceReply r = this.generateReply(m);
            this.writeReply(r);
            if (!log.isDebugEnabled() || r == null) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("Nce simulator sent reply: ");
            int i = 0;
            while (i < r.getNumDataElements()) {
                buf.append(Integer.toHexString(0xFF & r.getElement(i)).toUpperCase()).append(" ");
                ++i;
            }
            log.debug(buf.toString());
        }
    }

    private NceMessage readMessage() {
        NceMessage msg = null;
        try {
            msg = this.loadChars();
        }
        catch (IOException iOException) {}
        return msg;
    }

    private NceMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        NceMessage msg = new NceMessage(nchars);
        int i = 0;
        while (i < nchars) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
            ++i;
        }
        return msg;
    }

    private NceReply generateReply(NceMessage m) {
        NceReply reply = new NceReply(this.getSystemConnectionMemo().getNceTrafficController());
        int command = m.getElement(0);
        if (command < 128) {
            return null;
        }
        if (command > 191) {
            reply.setElement(0, this.NCE_ERROR);
            return reply;
        }
        switch (command) {
            case 170: {
                reply.setElement(0, 6);
                reply.setElement(1, 2);
                reply.setElement(2, this.epromRevision);
                break;
            }
            case 130: {
                reply.setElement(0, 18);
                reply.setElement(1, 48);
                break;
            }
            case 138: {
                reply.setElement(0, 255);
                reply.setElement(1, 255);
                reply.setElement(2, 0);
                reply.setElement(3, 0);
                break;
            }
            case 140: {
                reply.setElement(0, this.NCE_OKAY);
                reply.setElement(1, 13);
                reply.setElement(2, 10);
                break;
            }
            case 143: {
                this.readMemory(m, reply, 16);
                break;
            }
            case 155: {
                reply.setElement(0, 0);
                reply.setElement(1, 0);
                break;
            }
            case 157: {
                this.readMemory(m, reply, 1);
                break;
            }
            case 151: {
                this.writeMemory(m, reply, 1, false);
                break;
            }
            case 152: {
                this.writeMemory(m, reply, 2, false);
                break;
            }
            case 153: {
                this.writeMemory(m, reply, 4, false);
                break;
            }
            case 154: {
                this.writeMemory(m, reply, 8, false);
                break;
            }
            case 142: {
                this.writeMemory(m, reply, m.getElement(3), true);
                break;
            }
            case 173: {
                this.accessoryCommand(m, reply);
                break;
            }
            case 161: 
            case 167: 
            case 169: {
                reply.setElement(0, 123);
                reply.setElement(1, this.NCE_OKAY);
                break;
            }
            default: {
                reply.setElement(0, this.NCE_OKAY);
            }
        }
        return reply;
    }

    private void writeReply(NceReply r) {
        if (r == null) {
            return;
        }
        int i = 0;
        while (i < r.getNumDataElements()) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private NceReply readMemory(NceMessage m, NceReply reply, int num) {
        if (num > 16) {
            log.error("Nce read memory command was greater than 16");
            return null;
        }
        int nceMemoryAddress = this.getNceAddress(m);
        if (nceMemoryAddress >= 60416 && nceMemoryAddress < 60672) {
            log.debug("Reading turnout memory: {}", (Object)Integer.toHexString(nceMemoryAddress));
            int offset = m.getElement(2);
            int i = 0;
            while (i < num) {
                reply.setElement(i, this.turnoutMemory[offset + i]);
                ++i;
            }
            return reply;
        }
        if (nceMemoryAddress >= 62720 && nceMemoryAddress < 64256) {
            log.debug("Reading consist memory: {}", (Object)Integer.toHexString(nceMemoryAddress));
            int offset = nceMemoryAddress - 62720;
            int i = 0;
            while (i < num) {
                reply.setElement(i, this.consistMemory[offset + i]);
                ++i;
            }
            return reply;
        }
        if (nceMemoryAddress >= 51200 && nceMemoryAddress < 56320) {
            log.debug("Reading macro memory: {}", (Object)Integer.toHexString(nceMemoryAddress));
            int offset = nceMemoryAddress - 51200;
            log.debug("offset: {}", (Object)offset);
            int i = 0;
            while (i < num) {
                reply.setElement(i, this.macroMemory[offset + i]);
                ++i;
            }
            return reply;
        }
        int i = 0;
        while (i < num) {
            reply.setElement(i, 0);
            ++i;
        }
        return reply;
    }

    private NceReply writeMemory(NceMessage m, NceReply reply, int num, boolean skipbyte) {
        int i;
        int offset;
        if (num > 16) {
            log.error("Nce write memory command was greater than 16");
            return null;
        }
        int nceMemoryAddress = this.getNceAddress(m);
        int byteDataBegins = 3;
        if (skipbyte) {
            ++byteDataBegins;
        }
        if (nceMemoryAddress >= 60416 && nceMemoryAddress < 60672) {
            log.debug("Writing turnout memory: {}", (Object)Integer.toHexString(nceMemoryAddress));
            offset = m.getElement(2);
            i = 0;
            while (i < num) {
                this.turnoutMemory[offset + i] = (byte)m.getElement(i + byteDataBegins);
                ++i;
            }
        }
        if (nceMemoryAddress >= 62720 && nceMemoryAddress < 64256) {
            log.debug("Writing consist memory: {}", (Object)Integer.toHexString(nceMemoryAddress));
            offset = nceMemoryAddress - 62720;
            i = 0;
            while (i < num) {
                this.consistMemory[offset + i] = (byte)m.getElement(i + byteDataBegins);
                ++i;
            }
        }
        if (nceMemoryAddress >= 51200 && nceMemoryAddress < 56320) {
            log.debug("Writing macro memory: {}", (Object)Integer.toHexString(nceMemoryAddress));
            offset = nceMemoryAddress - 51200;
            log.debug("offset: {}", (Object)offset);
            i = 0;
            while (i < num) {
                this.macroMemory[offset + i] = (byte)m.getElement(i + byteDataBegins);
                ++i;
            }
        }
        reply.setElement(0, this.NCE_OKAY);
        return reply;
    }

    private int getNceAddress(NceMessage m) {
        int addr = m.getElement(1);
        addr *= 256;
        return addr += m.getElement(2);
    }

    private NceReply accessoryCommand(NceMessage m, NceReply reply) {
        if (m.getElement(3) == 3 || m.getElement(3) == 4) {
            String operation = "close";
            if (m.getElement(3) == 4) {
                operation = "throw";
            }
            int nceAccessoryAddress = this.getNceAddress(m);
            log.debug("Accessory command {} NT {}", (Object)operation, (Object)nceAccessoryAddress);
            if (nceAccessoryAddress > 2044) {
                log.error("Turnout address greater than 2044, address: {}", (Object)nceAccessoryAddress);
                return null;
            }
            int bit = nceAccessoryAddress - 1 & 7;
            int setMask = 1;
            int i = 0;
            while (i < bit) {
                setMask <<= 1;
                ++i;
            }
            int clearMask = 4095 - setMask;
            int offset = nceAccessoryAddress - 1 >> 3;
            byte read = this.turnoutMemory[offset];
            byte write = (byte)(read & clearMask & 0xFF);
            if (operation.equals("close")) {
                write = (byte)(write + setMask);
            }
            this.turnoutMemory[offset] = write;
        }
        reply.setElement(0, this.NCE_OKAY);
        return reply;
    }
}

