/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.packetgen.Bundle;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.StringUtil;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class NcePacketGenPanel
extends NcePanel
implements NceListener {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    JCheckBox checkBoxBinCmd = new JCheckBox();
    JTextField replyLenTextField = new JTextField(2);
    private NceTrafficController tc = null;

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.packetgen.NcePacketGenFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getNceTrafficController();
        this.jLabel1.setText("Command: ");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send packet");
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText("Enter command");
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.checkBoxBinCmd.setText("Binary");
        this.checkBoxBinCmd.setVisible(true);
        this.checkBoxBinCmd.setToolTipText("Check to enable binary commands");
        this.checkBoxBinCmd.setSelected(true);
        this.replyLenTextField.setVisible(true);
        this.replyLenTextField.setMaximumSize(new Dimension(50, this.replyLenTextField.getPreferredSize().height));
        this.replyLenTextField.setToolTipText("Enter number of expected bytes, will override internal defaults");
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(300, 150));
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.sendButton);
        this.add(this.checkBoxBinCmd);
        this.add(this.replyLenTextField);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NcePacketGenPanel.this.sendButtonActionPerformed(e);
            }
        });
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        if (this.checkBoxBinCmd.isSelected()) {
            NceMessage m = this.createPacket(input);
            if (m == null) {
                JOptionPane.showMessageDialog(this, "Enter hexadecimal numbers only", "NCE Binary Command", 0);
                return;
            }
            m.setBinary(true);
            int replyLen = this.getReplyLen(this.replyLenTextField.getText());
            if (replyLen > 0) {
                m.setReplyLen(replyLen);
            } else {
                m.setReplyLen(this.getMessageLength(m.getOpCode()));
            }
            this.tc.sendNceMessage(m, this);
        } else {
            NceMessage m = new NceMessage(input.length());
            int i = 0;
            while (i < input.length()) {
                m.setElement(i, input.charAt(i));
                ++i;
            }
            this.tc.sendNceMessage(m, this);
        }
    }

    @Override
    public void message(NceMessage m) {
    }

    @Override
    public void reply(NceReply r) {
    }

    NceMessage createPacket(String s) {
        byte[] b;
        try {
            b = StringUtil.bytesFromHexString(s);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (b.length == 0) {
            return null;
        }
        NceMessage m = new NceMessage(b.length);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    private int getReplyLen(String s) {
        int b;
        try {
            b = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return b;
    }

    private int getMessageLength(int opcode) {
        int replyLen = 1;
        switch (opcode & 0xFF) {
            case 171: 
            case 172: {
                replyLen = 0;
                break;
            }
            case 130: 
            case 155: 
            case 161: 
            case 167: 
            case 169: {
                replyLen = 2;
                break;
            }
            case 140: 
            case 170: {
                replyLen = 3;
                break;
            }
            case 138: {
                replyLen = 4;
                break;
            }
            case 143: {
                replyLen = 16;
                break;
            }
            default: {
                replyLen = 1;
            }
        }
        return replyLen;
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Send Binary Command", (WindowInterface)new JmriJFrameInterface(), NcePacketGenPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

