/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.ncemon;

import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanelInterface;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMonPanel
extends AbstractMonPane
implements NceListener,
NcePanelInterface {
    NceSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(NceMonPanel.class);

    @Override
    public String getHelpTarget() {
        return null;
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append("Command Monitor");
        return x.toString();
    }

    @Override
    public void dispose() {
        try {
            this.memo.getNceTrafficController().removeNceListener(this);
        }
        catch (NullPointerException e) {
            log.error("Error on dispose {}", (Object)e.toString());
        }
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(NceSystemConnectionMemo memo) {
        this.memo = memo;
        try {
            memo.getNceTrafficController().addNceListener(this);
        }
        catch (NullPointerException nullPointerException) {
            log.error("Unable to start the NCE Command monitor");
            JOptionPane.showMessageDialog(null, "An Error has occurred that prevents the NCE Command Monitor from being loaded.\nPlease check the System Console for more information", "No Connection", 2);
        }
    }

    @Override
    public synchronized void message(NceMessage m) {
        if (m.isBinary()) {
            this.logMessage(m);
        } else {
            this.logMessage("cmd: ", m);
        }
    }

    @Override
    public synchronized void reply(NceReply r) {
        if (r.isUnsolicited()) {
            this.logMessage("msg: ", r);
        } else {
            this.logMessage(r);
        }
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Nce Command Monitor", (WindowInterface)new JmriJFrameInterface(), NceMonPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

