/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.macro;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMacroRestore
extends Thread
implements NceListener {
    private static final int CS_MACRO_MEM = 51200;
    private static final int MACRO_LNTH = 20;
    private static final int REPLY_1 = 1;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean fileValid = false;
    JLabel textMacro = new JLabel();
    JLabel macroNumber = new JLabel();
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(NceMacroRestore.class);

    public NceMacroRestore(NceTrafficController t) {
        this.tc = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(f));){
                JmriJFrame fstatus;
                block28: {
                    JPanel ps = new JPanel();
                    fstatus = new JmriJFrame("Macro Restore");
                    fstatus.setLocationRelativeTo(null);
                    fstatus.setSize(200, 100);
                    fstatus.getContentPane().add(ps);
                    ps.add(this.textMacro);
                    ps.add(this.macroNumber);
                    this.textMacro.setText("Macro number:");
                    this.textMacro.setVisible(true);
                    this.macroNumber.setVisible(true);
                    this.waiting = 0;
                    this.fileValid = false;
                    int macroNum = 0;
                    int curMacro = 51200;
                    byte[] macroAccy = new byte[20];
                    do {
                        String line;
                        try {
                            line = in.readLine();
                        }
                        catch (IOException iOException) {
                            break block28;
                        }
                        this.macroNumber.setText(Integer.toString(macroNum++));
                        if (line == null) {
                            log.error("NCE macro file terminator :0000 not found");
                            break block28;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("macro {}", (Object)line);
                        }
                        String macroAddr = ":" + Integer.toHexString(curMacro);
                        String[] macroLine = line.split(" ");
                        if (macroLine[0].equalsIgnoreCase(":0000")) {
                            this.fileValid = true;
                            break block28;
                        }
                        if (!macroAddr.equalsIgnoreCase(macroLine[0])) {
                            log.error("Restore file selected is not a vaild backup file");
                            log.error("Macro addr in restore file should be {} Macro addr read {}", (Object)macroAddr, (Object)macroLine[0]);
                            break block28;
                        }
                        if (curMacro == 51200 && JOptionPane.showConfirmDialog(null, "Restore file found!  Restore can take over a minute, continue?", "NCE Macro Restore", 0) != 0) break block28;
                        fstatus.setVisible(true);
                        int i = 0;
                        while (i < 10) {
                            int j = i << 1;
                            byte[] b = StringUtil.bytesFromHexString(macroLine[i + 1]);
                            macroAccy[j] = b[0];
                            macroAccy[j + 1] = b[1];
                            ++i;
                        }
                        NceMessage m = this.writeNceMacroMemory(curMacro, macroAccy, false);
                        this.tc.sendNceMessage(m, this);
                        m = this.writeNceMacroMemory(curMacro, macroAccy, true);
                        this.tc.sendNceMessage(m, this);
                        curMacro += 20;
                        if (this.waiting <= 0) continue;
                        NceMacroRestore nceMacroRestore = this;
                        synchronized (nceMacroRestore) {
                            try {
                                this.wait(20000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    } while (this.waiting <= 0);
                    log.error("timeout waiting for reply");
                }
                in.close();
                fstatus.dispose();
                if (this.fileValid) {
                    JOptionPane.showMessageDialog(null, "Successful Restore!", "NCE Macro", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Restore failed. Check console for error messages. \r\nIf operating at 19,200 baud, try 9600 baud.", "NCE Macro", 0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private NceMessage writeNceMacroMemory(int curMacro, byte[] b, boolean second) {
        byte[] bl;
        byte[] data;
        this.replyLen = 1;
        ++this.waiting;
        if (second) {
            curMacro += 16;
            data = new byte[4];
            int i = 0;
            while (i < 4) {
                data[i] = b[i + 16];
                ++i;
            }
            bl = NceBinaryCommand.accMemoryWrite4(curMacro, data);
        } else {
            data = new byte[16];
            int i = 0;
            while (i < 16) {
                data[i] = b[i];
                ++i;
            }
            bl = NceBinaryCommand.accMemoryWriteN(curMacro, data);
        }
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        if (log.isDebugEnabled()) {
            log.debug("waiting for {} responses ", (Object)this.waiting);
        }
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        if (this.replyLen == 1 && r.getElement(0) != NceMessage.NCE_OKAY) {
            log.error("reply incorrect");
        }
        if (this.waiting == 0) {
            NceMacroRestore nceMacroRestore = this;
            synchronized (nceMacroRestore) {
                this.notify();
            }
        }
    }
}

