/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.macro;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.macro.Bundle;
import jmri.jmrix.nce.macro.NceMacroBackup;
import jmri.jmrix.nce.macro.NceMacroRestore;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMacroEditPanel
extends NcePanel
implements NceListener {
    private NceTrafficController tc = null;
    private int maxNumMacros = 255;
    private int macroSize = 20;
    private int memBase = 51200;
    private boolean isUsb = false;
    private int macroNum = 0;
    private int replyLen = 0;
    private int waiting = 0;
    private static final String QUESTION = Bundle.getMessage("Add");
    private static final String CLOSED = InstanceManager.turnoutManagerInstance().getClosedText();
    private static final String THROWN = InstanceManager.turnoutManagerInstance().getThrownText();
    private static final String CLOSED_NCE = Bundle.getMessage("Normal");
    private static final String THROWN_NCE = Bundle.getMessage("Reverse");
    private static final String DELETE = Bundle.getMessage("Delete");
    private static final String EMPTY = Bundle.getMessage("empty");
    private static final String ACCESSORY = Bundle.getMessage("accessory");
    private static final String LINK = Bundle.getMessage("LinkMacro");
    Thread nceMemoryThread;
    private boolean readRequested = false;
    private boolean writeRequested = false;
    private boolean macroSearchInc = false;
    private boolean macroSearchDec = false;
    private boolean macroValid = false;
    private boolean macroModified = false;
    JLabel textMacro = new JLabel(Bundle.getMessage("Macro"));
    JLabel textReply = new JLabel(Bundle.getMessage("Reply"));
    JLabel macroReply = new JLabel();
    JButton previousButton = new JButton(Bundle.getMessage("Previous"));
    JButton nextButton = new JButton(Bundle.getMessage("Next"));
    JButton getButton = new JButton(Bundle.getMessage("Get"));
    JButton saveButton = new JButton(Bundle.getMessage("Save"));
    JButton backUpButton = new JButton(Bundle.getMessage("Backup"));
    JButton restoreButton = new JButton(Bundle.getMessage("Restore"));
    JCheckBox checkBoxEmpty = new JCheckBox(Bundle.getMessage("EmptyMacro"));
    JCheckBox checkBoxNce = new JCheckBox(Bundle.getMessage("NCETurnout"));
    JTextField macroTextField = new JTextField(4);
    JLabel space2 = new JLabel("                          ");
    JLabel space3 = new JLabel("                          ");
    JLabel space4 = new JLabel("                          ");
    JLabel space15 = new JLabel(" ");
    JLabel num1 = new JLabel();
    JLabel textAccy1 = new JLabel();
    JTextField accyTextField1 = new JTextField(4);
    JButton cmdButton1 = new JButton();
    JButton deleteButton1 = new JButton();
    JLabel num2 = new JLabel();
    JLabel textAccy2 = new JLabel();
    JTextField accyTextField2 = new JTextField(4);
    JButton cmdButton2 = new JButton();
    JButton deleteButton2 = new JButton();
    JLabel num3 = new JLabel();
    JLabel textAccy3 = new JLabel();
    JTextField accyTextField3 = new JTextField(4);
    JButton cmdButton3 = new JButton();
    JButton deleteButton3 = new JButton();
    JLabel num4 = new JLabel();
    JLabel textAccy4 = new JLabel();
    JTextField accyTextField4 = new JTextField(4);
    JButton cmdButton4 = new JButton();
    JButton deleteButton4 = new JButton();
    JLabel num5 = new JLabel();
    JLabel textAccy5 = new JLabel();
    JTextField accyTextField5 = new JTextField(4);
    JButton cmdButton5 = new JButton();
    JButton deleteButton5 = new JButton();
    JLabel num6 = new JLabel();
    JLabel textAccy6 = new JLabel();
    JTextField accyTextField6 = new JTextField(4);
    JButton cmdButton6 = new JButton();
    JButton deleteButton6 = new JButton();
    JLabel num7 = new JLabel();
    JLabel textAccy7 = new JLabel();
    JTextField accyTextField7 = new JTextField(4);
    JButton cmdButton7 = new JButton();
    JButton deleteButton7 = new JButton();
    JLabel num8 = new JLabel();
    JLabel textAccy8 = new JLabel();
    JTextField accyTextField8 = new JTextField(4);
    JButton cmdButton8 = new JButton();
    JButton deleteButton8 = new JButton();
    JLabel num9 = new JLabel();
    JLabel textAccy9 = new JLabel();
    JTextField accyTextField9 = new JTextField(4);
    JButton cmdButton9 = new JButton();
    JButton deleteButton9 = new JButton();
    JLabel num10 = new JLabel();
    JLabel textAccy10 = new JLabel();
    JTextField accyTextField10 = new JTextField(4);
    JButton cmdButton10 = new JButton();
    JButton deleteButton10 = new JButton();
    int recChar = 0;
    int[] recChars = new int[16];
    private static final Logger log = LoggerFactory.getLogger(NceMacroEditPanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.macro.NceMacroEditFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("TitleEditNCEMacro"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo memo) {
        this.memo = memo;
        this.tc = memo.getNceTrafficController();
        if (this.tc.getUsbSystem() != 0 && (this.tc.getCmdGroups() & 8L) != 0L) {
            this.maxNumMacros = 16;
            this.isUsb = true;
            this.macroSize = 16;
            this.memBase = -1;
        }
        this.macroReply.setText(Bundle.getMessage("unknown"));
        this.macroTextField.setText("");
        this.saveButton.setEnabled(false);
        this.previousButton.setToolTipText(Bundle.getMessage("toolTipSearchDecrementing"));
        this.nextButton.setToolTipText(Bundle.getMessage("toolTipSearchIncrementing"));
        this.getButton.setToolTipText(Bundle.getMessage("toolTipReadMacro"));
        if (this.isUsb) {
            this.macroTextField.setToolTipText(Bundle.getMessage("toolTipEnterMacroUsb"));
        } else {
            this.macroTextField.setToolTipText(Bundle.getMessage("toolTipEnterMacroSerial"));
        }
        this.saveButton.setToolTipText(Bundle.getMessage("toolTipUpdateMacro"));
        this.backUpButton.setToolTipText(Bundle.getMessage("toolTipBackUp"));
        this.restoreButton.setToolTipText(Bundle.getMessage("toolTipRestore"));
        this.checkBoxEmpty.setToolTipText(Bundle.getMessage("toolTipSearchEmpty"));
        this.checkBoxNce.setToolTipText(Bundle.getMessage("toolTipUseNce"));
        this.initAccyFields();
        this.setLayout(new GridBagLayout());
        this.addItem(this.textMacro, 2, 0);
        this.addItem(this.previousButton, 1, 1);
        this.addItem(this.macroTextField, 2, 1);
        this.addItem(this.nextButton, 3, 1);
        this.addItem(this.checkBoxEmpty, 4, 1);
        this.addItem(this.textReply, 0, 2);
        this.addItem(this.macroReply, 1, 2);
        this.addItem(this.getButton, 2, 2);
        this.addItem(this.checkBoxNce, 4, 2);
        this.addItem(this.space2, 1, 3);
        this.addItem(this.space3, 2, 3);
        this.addItem(this.space4, 3, 3);
        int rNum = 5;
        this.addAccyRow(this.num1, this.textAccy1, this.accyTextField1, this.cmdButton1, this.deleteButton1, rNum++);
        this.addAccyRow(this.num2, this.textAccy2, this.accyTextField2, this.cmdButton2, this.deleteButton2, rNum++);
        this.addAccyRow(this.num3, this.textAccy3, this.accyTextField3, this.cmdButton3, this.deleteButton3, rNum++);
        this.addAccyRow(this.num4, this.textAccy4, this.accyTextField4, this.cmdButton4, this.deleteButton4, rNum++);
        this.addAccyRow(this.num5, this.textAccy5, this.accyTextField5, this.cmdButton5, this.deleteButton5, rNum++);
        this.addAccyRow(this.num6, this.textAccy6, this.accyTextField6, this.cmdButton6, this.deleteButton6, rNum++);
        this.addAccyRow(this.num7, this.textAccy7, this.accyTextField7, this.cmdButton7, this.deleteButton7, rNum++);
        if (!this.isUsb) {
            this.addAccyRow(this.num8, this.textAccy8, this.accyTextField8, this.cmdButton8, this.deleteButton8, rNum++);
            this.addAccyRow(this.num9, this.textAccy9, this.accyTextField9, this.cmdButton9, this.deleteButton9, rNum++);
        }
        this.addAccyRow(this.num10, this.textAccy10, this.accyTextField10, this.cmdButton10, this.deleteButton10, rNum++);
        this.addItem(this.space15, 2, rNum++);
        this.addItem(this.saveButton, 2, rNum);
        if (this.isUsb) {
            this.backUpButton.setEnabled(false);
            this.restoreButton.setEnabled(false);
        }
        this.addItem(this.backUpButton, 3, rNum);
        this.addItem(this.restoreButton, 4, rNum);
        this.addButtonAction(this.previousButton);
        this.addButtonAction(this.nextButton);
        this.addButtonAction(this.getButton);
        this.addButtonAction(this.saveButton);
        this.addButtonAction(this.backUpButton);
        this.addButtonAction(this.restoreButton);
        this.addButtonCmdAction(this.cmdButton1);
        this.addButtonCmdAction(this.cmdButton2);
        this.addButtonCmdAction(this.cmdButton3);
        this.addButtonCmdAction(this.cmdButton4);
        this.addButtonCmdAction(this.cmdButton5);
        this.addButtonCmdAction(this.cmdButton6);
        this.addButtonCmdAction(this.cmdButton7);
        this.addButtonCmdAction(this.cmdButton8);
        this.addButtonCmdAction(this.cmdButton9);
        this.addButtonCmdAction(this.cmdButton10);
        this.addButtonDelAction(this.deleteButton1);
        this.addButtonDelAction(this.deleteButton2);
        this.addButtonDelAction(this.deleteButton3);
        this.addButtonDelAction(this.deleteButton4);
        this.addButtonDelAction(this.deleteButton5);
        this.addButtonDelAction(this.deleteButton6);
        this.addButtonDelAction(this.deleteButton7);
        this.addButtonDelAction(this.deleteButton8);
        this.addButtonDelAction(this.deleteButton9);
        this.addButtonDelAction(this.deleteButton10);
        this.addCheckBoxAction(this.checkBoxNce);
    }

    public void buttonActionPerformed(ActionEvent ae) {
        if (this.macroSearchInc || this.macroSearchDec) {
            return;
        }
        if (ae.getSource() == this.saveButton) {
            boolean status = this.saveMacro();
            if (status) {
                this.setSaveButton(false);
            }
            return;
        }
        if (this.macroModified) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MacroModified"), Bundle.getMessage("NceMacro"), 2);
            this.macroModified = false;
        } else {
            this.setSaveButton(false);
            if (ae.getSource() == this.previousButton) {
                this.macroSearchDec = true;
                this.macroNum = this.getMacro();
                if (this.macroNum < 0) {
                    this.macroSearchDec = false;
                } else {
                    this.processMemory(true, false, this.macroNum, null);
                }
            }
            if (ae.getSource() == this.nextButton) {
                this.macroSearchInc = true;
                this.macroNum = this.getMacro();
                if (this.macroNum < 0) {
                    this.macroSearchInc = false;
                } else {
                    this.processMemory(true, false, this.macroNum, null);
                }
            }
            if (ae.getSource() == this.getButton) {
                this.macroNum = this.getMacro();
                if (this.macroNum >= 0) {
                    this.processMemory(true, false, this.macroNum, null);
                }
            }
            if (!this.isUsb && ae.getSource() == this.backUpButton) {
                NceMacroBackup mb = new NceMacroBackup(this.tc);
                mb.setName("Macro Backup");
                mb.start();
            }
            if (!this.isUsb && ae.getSource() == this.restoreButton) {
                NceMacroRestore mr = new NceMacroRestore(this.tc);
                mr.setName("Macro Restore");
                mr.start();
            }
        }
    }

    public void buttonActionCmdPerformed(ActionEvent ae) {
        if (this.macroSearchInc || this.macroSearchDec) {
            return;
        }
        if (ae.getSource() == this.cmdButton1) {
            this.updateAccyCmdPerformed(this.accyTextField1, this.cmdButton1, this.textAccy1, this.deleteButton1);
        }
        if (ae.getSource() == this.cmdButton2) {
            this.updateAccyCmdPerformed(this.accyTextField2, this.cmdButton2, this.textAccy2, this.deleteButton2);
        }
        if (ae.getSource() == this.cmdButton3) {
            this.updateAccyCmdPerformed(this.accyTextField3, this.cmdButton3, this.textAccy3, this.deleteButton3);
        }
        if (ae.getSource() == this.cmdButton4) {
            this.updateAccyCmdPerformed(this.accyTextField4, this.cmdButton4, this.textAccy4, this.deleteButton4);
        }
        if (ae.getSource() == this.cmdButton5) {
            this.updateAccyCmdPerformed(this.accyTextField5, this.cmdButton5, this.textAccy5, this.deleteButton5);
        }
        if (ae.getSource() == this.cmdButton6) {
            this.updateAccyCmdPerformed(this.accyTextField6, this.cmdButton6, this.textAccy6, this.deleteButton6);
        }
        if (ae.getSource() == this.cmdButton7) {
            this.updateAccyCmdPerformed(this.accyTextField7, this.cmdButton7, this.textAccy7, this.deleteButton7);
        }
        if (ae.getSource() == this.cmdButton8) {
            this.updateAccyCmdPerformed(this.accyTextField8, this.cmdButton8, this.textAccy8, this.deleteButton8);
        }
        if (ae.getSource() == this.cmdButton9) {
            this.updateAccyCmdPerformed(this.accyTextField9, this.cmdButton9, this.textAccy9, this.deleteButton9);
        }
        if (ae.getSource() == this.cmdButton10) {
            this.updateAccyCmdPerformed(this.accyTextField10, this.cmdButton10, this.textAccy10, this.deleteButton10);
        }
    }

    public void buttonActionDeletePerformed(ActionEvent ae) {
        if (this.macroSearchInc || this.macroSearchDec) {
            return;
        }
        if (ae.getSource() == this.deleteButton1) {
            this.updateAccyDelPerformed(this.accyTextField1, this.cmdButton1, this.textAccy1, this.deleteButton1);
        }
        if (ae.getSource() == this.deleteButton2) {
            this.updateAccyDelPerformed(this.accyTextField2, this.cmdButton2, this.textAccy2, this.deleteButton2);
        }
        if (ae.getSource() == this.deleteButton3) {
            this.updateAccyDelPerformed(this.accyTextField3, this.cmdButton3, this.textAccy3, this.deleteButton3);
        }
        if (ae.getSource() == this.deleteButton4) {
            this.updateAccyDelPerformed(this.accyTextField4, this.cmdButton4, this.textAccy4, this.deleteButton4);
        }
        if (ae.getSource() == this.deleteButton5) {
            this.updateAccyDelPerformed(this.accyTextField5, this.cmdButton5, this.textAccy5, this.deleteButton5);
        }
        if (ae.getSource() == this.deleteButton6) {
            this.updateAccyDelPerformed(this.accyTextField6, this.cmdButton6, this.textAccy6, this.deleteButton6);
        }
        if (ae.getSource() == this.deleteButton7) {
            this.updateAccyDelPerformed(this.accyTextField7, this.cmdButton7, this.textAccy7, this.deleteButton7);
        }
        if (ae.getSource() == this.deleteButton8) {
            this.updateAccyDelPerformed(this.accyTextField8, this.cmdButton8, this.textAccy8, this.deleteButton8);
        }
        if (ae.getSource() == this.deleteButton9) {
            this.updateAccyDelPerformed(this.accyTextField9, this.cmdButton9, this.textAccy9, this.deleteButton9);
        }
        if (ae.getSource() == this.deleteButton10) {
            if (this.deleteButton10.getText().equals(LINK)) {
                if (!this.macroValid) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("GetMacroNumber"), Bundle.getMessage("NceMacro"), 0);
                    return;
                }
                int linkMacro = this.validMacro(this.accyTextField10.getText());
                if (linkMacro == -1) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("EnterMacroNumberLine10"), Bundle.getMessage("NceMacro"), 0);
                    return;
                }
                this.setSaveButton(true);
                this.textAccy10.setText(LINK);
                this.cmdButton10.setVisible(false);
                this.deleteButton10.setText(DELETE);
                this.deleteButton10.setToolTipText(Bundle.getMessage("toolTipRemoveMacroLink"));
            } else {
                this.updateAccyDelPerformed(this.accyTextField10, this.cmdButton10, this.textAccy10, this.deleteButton10);
                this.initAccyRow10();
            }
        }
    }

    public void checkBoxActionPerformed(ActionEvent ae) {
        this.processMemory(true, false, this.macroNum, null);
    }

    private int getMacro() {
        int mN;
        this.initAccyFields();
        String m = this.macroTextField.getText();
        if (m.isEmpty()) {
            m = "0";
        }
        if ((mN = this.validMacro(m)) < 0) {
            this.macroReply.setText(Bundle.getMessage("error"));
            JOptionPane.showMessageDialog(this, Bundle.getMessage("EnterMacroNumber"), Bundle.getMessage("NceMacro"), 0);
            this.macroValid = false;
            return mN;
        }
        if (this.macroSearchInc || this.macroSearchDec) {
            this.macroReply.setText(Bundle.getMessage("searching"));
            if (this.macroSearchInc && ++mN >= this.maxNumMacros + 1) {
                mN = 0;
            }
            if (this.macroSearchDec && --mN <= -1) {
                mN = this.maxNumMacros;
            }
        } else {
            this.macroReply.setText(Bundle.getMessage("waiting"));
        }
        return mN;
    }

    private boolean saveMacro() {
        byte[] macroAccy = new byte[this.macroSize];
        int index = 0;
        int accyNum = 0;
        accyNum = this.getAccyRow(macroAccy, index, this.textAccy1, this.accyTextField1, this.cmdButton1);
        if (accyNum < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy2, this.accyTextField2, this.cmdButton2)) < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy3, this.accyTextField3, this.cmdButton3)) < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy4, this.accyTextField4, this.cmdButton4)) < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy5, this.accyTextField5, this.cmdButton5)) < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy6, this.accyTextField6, this.cmdButton6)) < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy7, this.accyTextField7, this.cmdButton7)) < 0) {
            return false;
        }
        if (accyNum > 0) {
            index += 2;
        }
        if (!this.isUsb) {
            accyNum = this.getAccyRow(macroAccy, index, this.textAccy8, this.accyTextField8, this.cmdButton8);
            if (accyNum < 0) {
                return false;
            }
            if (accyNum > 0) {
                index += 2;
            }
            if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy9, this.accyTextField9, this.cmdButton9)) < 0) {
                return false;
            }
            if (accyNum > 0) {
                index += 2;
            }
        }
        if ((accyNum = this.getAccyRow(macroAccy, index, this.textAccy10, this.accyTextField10, this.cmdButton10)) < 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("EnterMacroNumberLine10"), Bundle.getMessage("NceMacro"), 0);
            return false;
        }
        this.processMemory(false, true, this.macroNum, macroAccy);
        return true;
    }

    private void processMemory(boolean doRead, boolean doWrite, final int macroId, byte[] macroArray) {
        final byte[] macroData = new byte[this.macroSize];
        this.macroValid = false;
        this.readRequested = false;
        this.writeRequested = false;
        if (doRead) {
            this.readRequested = true;
        }
        if (doWrite) {
            this.writeRequested = true;
            int i = 0;
            while (i < this.macroSize) {
                macroData[i] = macroArray[i];
                ++i;
            }
        }
        if (this.nceMemoryThread != null && this.nceMemoryThread.isAlive()) {
            return;
        }
        this.nceMemoryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block9: {
                    if (NceMacroEditPanel.this.readRequested) {
                        NceMacroEditPanel.this.macroNum = macroId;
                        int macroCount = 0;
                        do {
                            int entriesRead = NceMacroEditPanel.this.readMacroMemory(NceMacroEditPanel.this.macroNum);
                            NceMacroEditPanel.this.macroTextField.setText(Integer.toString(NceMacroEditPanel.this.macroNum));
                            if (entriesRead == 0) {
                                NceMacroEditPanel.this.initAccyFields();
                                NceMacroEditPanel.this.macroReply.setText(Bundle.getMessage("macroEmpty"));
                                if (NceMacroEditPanel.this.checkBoxEmpty.isSelected()) {
                                    NceMacroEditPanel.this.macroValid = true;
                                    NceMacroEditPanel.this.macroSearchInc = false;
                                    NceMacroEditPanel.this.macroSearchDec = false;
                                    break block9;
                                }
                            } else {
                                if (entriesRead < 0) {
                                    NceMacroEditPanel.this.macroReply.setText(Bundle.getMessage("error"));
                                    NceMacroEditPanel.this.macroValid = false;
                                    NceMacroEditPanel.this.macroSearchInc = false;
                                    NceMacroEditPanel.this.macroSearchDec = false;
                                    break block9;
                                }
                                NceMacroEditPanel.this.macroReply.setText(Bundle.getMessage("macroFound"));
                                if (!NceMacroEditPanel.this.checkBoxEmpty.isSelected()) {
                                    NceMacroEditPanel.this.macroSearchInc = false;
                                    NceMacroEditPanel.this.macroSearchDec = false;
                                    NceMacroEditPanel.this.macroValid = true;
                                    break block9;
                                }
                            }
                            if (!NceMacroEditPanel.this.macroSearchInc && !NceMacroEditPanel.this.macroSearchDec || NceMacroEditPanel.this.macroValid) continue;
                            if (++macroCount > NceMacroEditPanel.this.maxNumMacros) {
                                NceMacroEditPanel.this.macroSearchInc = false;
                                NceMacroEditPanel.this.macroSearchDec = false;
                                break block9;
                            }
                            NceMacroEditPanel.this.macroNum = NceMacroEditPanel.this.getMacro();
                        } while (NceMacroEditPanel.this.macroSearchInc || NceMacroEditPanel.this.macroSearchDec);
                        NceMacroEditPanel.this.macroValid = true;
                    }
                }
                if (NceMacroEditPanel.this.writeRequested) {
                    NceMacroEditPanel.this.writeMacroMemory(macroId, macroData);
                }
            }
        });
        this.nceMemoryThread.setName(Bundle.getMessage("ThreadTitle"));
        this.nceMemoryThread.setPriority(1);
        this.nceMemoryThread.start();
    }

    private int readMacroMemory(int mN) {
        int entriesRead = 0;
        if (this.isUsb) {
            this.setUsbCabMemoryPointer(14, mN * this.macroSize);
            if (!this.waitNce()) {
                return -1;
            }
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            int accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy1, this.accyTextField1, this.cmdButton1, this.deleteButton1);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy2, this.accyTextField2, this.cmdButton2, this.deleteButton2);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy3, this.accyTextField3, this.cmdButton3, this.deleteButton3);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy4, this.accyTextField4, this.cmdButton4, this.deleteButton4);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy5, this.accyTextField5, this.cmdButton5, this.deleteButton5);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy6, this.accyTextField6, this.cmdButton6, this.deleteButton6);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            ++entriesRead;
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy7, this.accyTextField7, this.cmdButton7, this.deleteButton7);
            this.readUsbMemoryN(2);
            if (!this.waitNce()) {
                return -1;
            }
            accyAddr = this.getMacroAccyAdr(this.recChars);
            if (accyAddr <= 0) {
                return entriesRead;
            }
            this.setAccy(accyAddr, this.getAccyCmd(this.recChars), this.textAccy8, this.accyTextField8, this.cmdButton8, this.deleteButton8);
            return ++entriesRead;
        }
        int memPtr = 51200 + mN * this.macroSize;
        int readPtr = 0;
        int[] workBuf = new int[2];
        this.readSerialMemory16(memPtr);
        if (!this.waitNce()) {
            return -1;
        }
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        int accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy1, this.accyTextField1, this.cmdButton1, this.deleteButton1);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy2, this.accyTextField2, this.cmdButton2, this.deleteButton2);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy3, this.accyTextField3, this.cmdButton3, this.deleteButton3);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy4, this.accyTextField4, this.cmdButton4, this.deleteButton4);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy5, this.accyTextField5, this.cmdButton5, this.deleteButton5);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy6, this.accyTextField6, this.cmdButton6, this.deleteButton6);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy7, this.accyTextField7, this.cmdButton7, this.deleteButton7);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy8, this.accyTextField8, this.cmdButton8, this.deleteButton8);
        readPtr = 0;
        this.readSerialMemory16(memPtr += 16);
        if (!this.waitNce()) {
            return -1;
        }
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        ++entriesRead;
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy9, this.accyTextField9, this.cmdButton9, this.deleteButton9);
        workBuf[0] = this.recChars[readPtr++];
        workBuf[1] = this.recChars[readPtr++];
        accyAddr = this.getMacroAccyAdr(workBuf);
        if (accyAddr <= 0) {
            return entriesRead;
        }
        this.setAccy(accyAddr, this.getAccyCmd(workBuf), this.textAccy10, this.accyTextField10, this.cmdButton10, this.deleteButton10);
        return ++entriesRead;
    }

    private void updateAccyCmdPerformed(JTextField accyTextField, JButton cmdButton, JLabel textAccy, JButton deleteButton) {
        if (!this.macroValid) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("GetMacroNumber"), Bundle.getMessage("NceMacro"), 0);
        } else {
            String accyText = accyTextField.getText();
            int accyNum = 0;
            try {
                accyNum = Integer.parseInt(accyText);
            }
            catch (NumberFormatException numberFormatException) {
                accyNum = -1;
            }
            if (accyNum < 1 || accyNum > 2044) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("EnterAccessoryNumber"), Bundle.getMessage("NceMacroAddress"), 0);
                return;
            }
            String accyCmd = cmdButton.getText();
            if (this.checkBoxNce.isSelected()) {
                if (!accyCmd.equals(THROWN_NCE)) {
                    cmdButton.setText(THROWN_NCE);
                }
                if (!accyCmd.equals(CLOSED_NCE)) {
                    cmdButton.setText(CLOSED_NCE);
                }
            } else {
                if (!accyCmd.equals(THROWN)) {
                    cmdButton.setText(THROWN);
                }
                if (!accyCmd.equals(CLOSED)) {
                    cmdButton.setText(CLOSED);
                }
            }
            this.setSaveButton(true);
            textAccy.setText(ACCESSORY);
            deleteButton.setText(DELETE);
            deleteButton.setToolTipText(Bundle.getMessage("toolTipRemoveAcessory"));
            deleteButton.setEnabled(true);
        }
    }

    private void updateAccyDelPerformed(JTextField accyTextField, JButton cmdButton, JLabel textAccy, JButton deleteButton) {
        this.setSaveButton(true);
        textAccy.setText(EMPTY);
        accyTextField.setText("");
        cmdButton.setText(QUESTION);
        deleteButton.setEnabled(false);
    }

    private int getAccyRow(byte[] b, int i, JLabel textAccy, JTextField accyTextField, JButton cmdButton) {
        int accyNum = 0;
        if (textAccy.getText().equals(ACCESSORY)) {
            accyNum = this.getAccyNum(accyTextField.getText());
            if (accyNum < 0) {
                return accyNum;
            }
            int upperByte = (accyNum += 3) & 0xFF;
            upperByte = (upperByte >> 2) + 128;
            b[i] = (byte)upperByte;
            int lowerByteH = ((accyNum ^ 0x700) & 0x700) >> 4;
            int lowerByteL = (accyNum & 3) << 1;
            int lowerByte = lowerByteH + lowerByteL + 136;
            if (cmdButton.getText().equals(CLOSED) || cmdButton.getText().equals(CLOSED_NCE)) {
                ++lowerByte;
            }
            b[i + 1] = (byte)lowerByte;
        }
        if (textAccy.getText().equals(LINK)) {
            int macroLink = this.validMacro(accyTextField.getText());
            if (macroLink < 0) {
                return macroLink;
            }
            b[i] = -1;
            b[i + 1] = (byte)macroLink;
        }
        return accyNum;
    }

    private int getAccyNum(String accyText) {
        int accyNum = 0;
        try {
            accyNum = Integer.parseInt(accyText);
        }
        catch (NumberFormatException numberFormatException) {
            accyNum = -1;
        }
        if (accyNum < 1 || accyNum > 2044) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("EnterAccessoryNumber"), Bundle.getMessage("NceMacroAddress"), 0);
            accyNum = -1;
        }
        return accyNum;
    }

    private void setSaveButton(boolean display) {
        this.macroModified = display;
        this.saveButton.setEnabled(display);
        if (!this.isUsb) {
            this.backUpButton.setEnabled(!display);
            this.restoreButton.setEnabled(!display);
        }
    }

    private int getMacroAccyAdr(int[] b) {
        int accyAddrL = b[0];
        int accyAddr = 0;
        if (accyAddrL == 0 && b[1] == 0) {
            return accyAddr;
        }
        if ((accyAddrL & 0xFF) == 255) {
            accyAddr = b[1];
            this.linkAccessory10(accyAddr & 0xFF);
            accyAddr = -accyAddr;
        } else {
            accyAddrL = accyAddrL << 2 & 0xFC;
            int accyLSB = b[1];
            accyLSB = (accyLSB & 6) >> 1;
            int accyAddrH = b[1];
            accyAddrH = 112 - (accyAddrH & 0x70) << 4;
            accyAddr = accyAddrH + accyAddrL + accyLSB - 3;
        }
        return accyAddr;
    }

    private void linkAccessory10(int accyAddr) {
        this.textAccy10.setText(LINK);
        this.accyTextField10.setText(Integer.toString(accyAddr));
        this.cmdButton10.setVisible(false);
        this.deleteButton10.setText(DELETE);
        this.deleteButton10.setToolTipText(Bundle.getMessage("toolTipRemoveMacroLink"));
    }

    private void setAccy(int accyAddr, String accyCmd, JLabel textAccy, JTextField accyTextField, JButton cmdButton, JButton deleteButton) {
        textAccy.setText(ACCESSORY);
        accyTextField.setText(Integer.toString(accyAddr));
        deleteButton.setEnabled(true);
        cmdButton.setText(accyCmd);
    }

    private String getAccyCmd(int[] b) {
        int accyCmd = b[1];
        String s = THROWN;
        if (this.checkBoxNce.isSelected()) {
            s = THROWN_NCE;
        }
        if ((accyCmd &= 1) == 0) {
            return s;
        }
        s = CLOSED;
        if (this.checkBoxNce.isSelected()) {
            s = CLOSED_NCE;
        }
        return s;
    }

    private int validMacro(String s) {
        int mN;
        try {
            mN = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (mN < 0 || mN > this.maxNumMacros) {
            return -1;
        }
        return mN;
    }

    private boolean writeMacroMemory(int macroNum, byte[] b) {
        if (this.isUsb) {
            this.setUsbCabMemoryPointer(14, macroNum * this.macroSize);
            if (!this.waitNce()) {
                return false;
            }
            int i = 0;
            while (i < this.macroSize) {
                this.writeUsbMemory1(b[i]);
                if (!this.waitNce()) {
                    return false;
                }
                ++i;
            }
        } else {
            int nceMemoryAddr = macroNum * this.macroSize + this.memBase;
            byte[] buf = new byte[16];
            int i = 0;
            while (i < 16) {
                buf[i] = b[i];
                ++i;
            }
            this.writeSerialMemoryN(nceMemoryAddr, buf);
            if (!this.waitNce()) {
                return false;
            }
            buf = new byte[4];
            i = 0;
            while (i < 4) {
                buf[i] = b[i + 16];
                ++i;
            }
            this.writeSerialMemory4(nceMemoryAddr + 16, buf);
            if (!this.waitNce()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitNce() {
        int count = 100;
        if (log.isDebugEnabled()) {
            log.debug("Going to sleep");
        }
        while (this.waiting > 0) {
            NceMacroEditPanel nceMacroEditPanel = this;
            synchronized (nceMacroEditPanel) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (--count >= 0) continue;
            this.macroReply.setText("Error");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("awake!");
        }
        return true;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Thread wait from main transfer loop")
    public void reply(NceReply r) {
        if (log.isDebugEnabled()) {
            log.debug("Receive character");
        }
        if (this.waiting <= 0) {
            log.error("unexpected response. Len: {} code: {}", (Object)r.getNumDataElements(), (Object)r.getElement(0));
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            this.macroReply.setText("error");
            return;
        }
        int i = 0;
        while (i < this.replyLen) {
            this.recChars[i] = r.getElement(i);
            ++i;
        }
        NceMacroEditPanel nceMacroEditPanel = this;
        synchronized (nceMacroEditPanel) {
            this.notify();
        }
    }

    private void setUsbCabMemoryPointer(int cab, int offset) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbMemoryPointer(cab, offset);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void readUsbMemoryN(int num) {
        switch (num) {
            case 1: {
                this.replyLen = 1;
                break;
            }
            case 2: {
                this.replyLen = 2;
                break;
            }
            case 4: {
                this.replyLen = 4;
                break;
            }
            default: {
                log.error("Invalid usb read byte count");
                return;
            }
        }
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbMemoryRead((byte)num);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, this.replyLen);
        this.tc.sendNceMessage(m, this);
    }

    private void writeUsbMemory1(int value) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbMemoryWrite1((byte)value);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void readSerialMemory16(int nceCabAddr) {
        this.replyLen = 16;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceCabAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        this.tc.sendNceMessage(m, this);
    }

    private void writeSerialMemoryN(int nceMacroAddr, byte[] b) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryWriteN(nceMacroAddr, b);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void writeSerialMemory4(int nceMacroAddr, byte[] b) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryWrite4(nceMacroAddr, b);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void addAccyRow(JComponent col1, JComponent col2, JComponent col3, JComponent col4, JComponent col5, int row) {
        this.addItem(col1, 0, row);
        this.addItem(col2, 1, row);
        this.addItem(col3, 2, row);
        this.addItem(col4, 3, row);
        this.addItem(col5, 4, row);
    }

    private void addItem(JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        this.add((Component)c, gc);
    }

    private void addButtonAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceMacroEditPanel.this.buttonActionPerformed(e);
            }
        });
    }

    private void addButtonCmdAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceMacroEditPanel.this.buttonActionCmdPerformed(e);
            }
        });
    }

    private void addButtonDelAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceMacroEditPanel.this.buttonActionDeletePerformed(e);
            }
        });
    }

    private void addCheckBoxAction(JCheckBox cb) {
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceMacroEditPanel.this.checkBoxActionPerformed(e);
            }
        });
    }

    private void initAccyFields() {
        this.initAccyRow(1, this.num1, this.textAccy1, this.accyTextField1, this.cmdButton1, this.deleteButton1);
        this.initAccyRow(2, this.num2, this.textAccy2, this.accyTextField2, this.cmdButton2, this.deleteButton2);
        this.initAccyRow(3, this.num3, this.textAccy3, this.accyTextField3, this.cmdButton3, this.deleteButton3);
        this.initAccyRow(4, this.num4, this.textAccy4, this.accyTextField4, this.cmdButton4, this.deleteButton4);
        this.initAccyRow(5, this.num5, this.textAccy5, this.accyTextField5, this.cmdButton5, this.deleteButton5);
        this.initAccyRow(6, this.num6, this.textAccy6, this.accyTextField6, this.cmdButton6, this.deleteButton6);
        this.initAccyRow(7, this.num7, this.textAccy7, this.accyTextField7, this.cmdButton7, this.deleteButton7);
        this.initAccyRow(8, this.num8, this.textAccy8, this.accyTextField8, this.cmdButton8, this.deleteButton8);
        this.initAccyRow(9, this.num9, this.textAccy9, this.accyTextField9, this.cmdButton9, this.deleteButton9);
        this.initAccyRow(10, this.num10, this.textAccy10, this.accyTextField10, this.cmdButton10, this.deleteButton10);
    }

    private void initAccyRow(int row, JLabel num, JLabel textAccy, JTextField accyTextField, JButton cmdButton, JButton deleteButton) {
        num.setText(Integer.toString(row));
        num.setVisible(true);
        textAccy.setText(EMPTY);
        textAccy.setVisible(true);
        cmdButton.setText(QUESTION);
        cmdButton.setVisible(true);
        cmdButton.setToolTipText(Bundle.getMessage("toolTipSetCommand"));
        deleteButton.setText(DELETE);
        deleteButton.setVisible(true);
        deleteButton.setEnabled(false);
        deleteButton.setToolTipText(Bundle.getMessage("toolTipRemoveAcessory"));
        accyTextField.setText("");
        accyTextField.setToolTipText(Bundle.getMessage("EnterAccessoryNumber"));
        accyTextField.setMaximumSize(new Dimension(accyTextField.getMaximumSize().width, accyTextField.getPreferredSize().height));
        if (row == 10) {
            this.initAccyRow10();
        }
    }

    private void initAccyRow10() {
        this.cmdButton10.setVisible(true);
        this.deleteButton10.setText(LINK);
        this.deleteButton10.setEnabled(true);
        this.deleteButton10.setToolTipText(Bundle.getMessage("toolTipLink"));
        this.accyTextField10.setToolTipText(Bundle.getMessage("toolTip10"));
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Macro Editor", (WindowInterface)new JmriJFrameInterface(), NceMacroEditPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

