/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.macro;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMacroBackup
extends Thread
implements NceListener {
    private static final int CS_MACRO_MEM = 51200;
    private static final int NUM_MACRO = 256;
    private static final int MACRO_LNTH = 20;
    private static final int REPLY_16 = 16;
    private static int replyLen = 0;
    private int waiting = 0;
    private boolean secondRead = false;
    private boolean fileValid = false;
    private static final byte[] NCE_MACRO_DATA = new byte[20];
    JLabel textMacro = new JLabel();
    JLabel macroNumber = new JLabel();
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(NceMacroBackup.class);

    public NceMacroBackup(NceTrafficController t) {
        this.tc = t;
    }

    @Override
    public void run() {
        String fileName;
        String fileNameLC;
        JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        File fs = new File("NCE macro backup.txt");
        fc.setSelectedFile(fs);
        int retVal = fc.showSaveDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        if (fc.getFileFilter() != fc.getAcceptAllFileFilter() && !(fileNameLC = (fileName = f.getAbsolutePath()).toLowerCase()).endsWith(".txt")) {
            fileName = String.valueOf(fileName) + ".txt";
            f = new File(fileName);
        }
        if (f.exists() && JOptionPane.showConfirmDialog(null, "File " + f.getName() + " already exists, overwrite it?", "Overwrite file?", 2) != 0) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PrintWriter fileOut = new PrintWriter((Writer)new BufferedWriter(new FileWriter(f)), true);){
                if (JOptionPane.showConfirmDialog(null, "Backup can take over a minute, continue?", "NCE Macro Backup", 0) != 0) {
                    fileOut.close();
                    return;
                }
                JPanel ps = new JPanel();
                JmriJFrame fstatus = new JmriJFrame("Macro Backup");
                fstatus.setLocationRelativeTo(null);
                fstatus.setSize(200, 100);
                fstatus.getContentPane().add(ps);
                ps.add(this.textMacro);
                ps.add(this.macroNumber);
                this.textMacro.setText("Macro number:");
                this.textMacro.setVisible(true);
                this.macroNumber.setVisible(true);
                this.waiting = 0;
                this.fileValid = true;
                int macroNum = 0;
                while (macroNum < 256) {
                    this.macroNumber.setText(Integer.toString(macroNum));
                    fstatus.setVisible(true);
                    this.getNceMacro(macroNum);
                    if (!this.fileValid) {
                        macroNum = 256;
                    }
                    if (this.fileValid) {
                        StringBuilder buf = new StringBuilder();
                        buf.append(":").append(Integer.toHexString(51200 + macroNum * 20));
                        int i = 0;
                        while (i < 20) {
                            buf.append(" ").append(StringUtil.twoHexFromInt(NCE_MACRO_DATA[i++]));
                            buf.append(StringUtil.twoHexFromInt(NCE_MACRO_DATA[i]));
                            ++i;
                        }
                        log.debug("macro {}", (Object)buf);
                        fileOut.println(buf.toString());
                    }
                    ++macroNum;
                }
                if (this.fileValid) {
                    String line = ":0000";
                    fileOut.println(line);
                }
                fileOut.flush();
                fileOut.close();
                fstatus.dispose();
                if (this.fileValid) {
                    JOptionPane.showMessageDialog(null, "Successful Backup!", "NCE Macro", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Backup failed", "NCE Macro", 0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void getNceMacro(int mN) {
        NceMessage m = this.readMacroMemory(mN, false);
        this.tc.sendNceMessage(m, this);
        if (!this.readWait()) {
            return;
        }
        NceMessage m2 = this.readMacroMemory(mN, true);
        this.tc.sendNceMessage(m2, this);
        this.readWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readWait() {
        int waitcount = 30;
        while (this.waiting > 0) {
            NceMacroBackup nceMacroBackup = this;
            synchronized (nceMacroBackup) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (waitcount-- >= 0) continue;
            log.error("read timeout");
            this.fileValid = false;
            return false;
        }
        return true;
    }

    private NceMessage readMacroMemory(int macroNum, boolean second) {
        this.secondRead = second;
        int nceMacroAddr = macroNum * 20 + 51200;
        if (second) {
            nceMacroAddr += 16;
        }
        replyLen = 16;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceMacroAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        if (r.getNumDataElements() != replyLen) {
            log.error("reply length incorrect");
            return;
        }
        int offset = 0;
        int numBytes = 16;
        if (this.secondRead) {
            offset = 16;
            numBytes = 4;
        }
        int i = 0;
        while (i < numBytes) {
            NceMacroBackup.NCE_MACRO_DATA[i + offset] = (byte)r.getElement(i);
            ++i;
        }
        --this.waiting;
        NceMacroBackup nceMacroBackup = this;
        synchronized (nceMacroBackup) {
            this.notify();
        }
    }
}

