/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.jmrix.nce.consist.Bundle;
import jmri.jmrix.nce.consist.NceConsistRoster;
import jmri.jmrix.nce.consist.NceConsistRosterEntry;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintNceConsistRosterAction
extends AbstractAction {
    Frame mFrame;
    boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintNceConsistRosterAction.class);

    public PrintNceConsistRosterAction(String actionName, Frame frame, boolean preview) {
        super(actionName);
        this.mFrame = frame;
        this.isPreview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(this.mFrame, Bundle.getMessage("NcePrintRosterTitle"), 10, 0.5, 0.5, 0.5, 0.5, this.isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
        writer.write(icon.getImage(), new JLabel(icon));
        NceConsistRoster r = InstanceManager.getDefault(NceConsistRoster.class);
        List<NceConsistRosterEntry> list = r.matchingList(null, null, null, null, null, null, null, null, null, null);
        log.debug("Roster list size: {}", (Object)list.size());
        for (NceConsistRosterEntry entry : list) {
            entry.printEntry(writer);
        }
        writer.close();
    }
}

