/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.consist.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistRestore
extends Thread
implements NceListener {
    private static final int CS_CONSIST_MEM = 62720;
    private static final int CONSIST_LNTH = 16;
    private static final int REPLY_1 = 1;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean fileValid = false;
    JLabel textConsist = new JLabel();
    JLabel consistNumber = new JLabel();
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(NceConsistRestore.class);

    public NceConsistRestore(NceTrafficController t) {
        this.tc = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(f));){
                JmriJFrame fstatus;
                block25: {
                    JPanel ps = new JPanel();
                    fstatus = new JmriJFrame(Bundle.getMessage("NceConsistRestore"));
                    fstatus.setLocationRelativeTo(null);
                    fstatus.setSize(300, 100);
                    fstatus.getContentPane().add(ps);
                    ps.add(this.textConsist);
                    ps.add(this.consistNumber);
                    this.textConsist.setText(Bundle.getMessage("ConsistLineNumber"));
                    this.textConsist.setVisible(true);
                    this.consistNumber.setVisible(true);
                    this.waiting = 0;
                    this.fileValid = false;
                    int consistNum = 0;
                    int curConsist = 62720;
                    byte[] consistData = new byte[16];
                    do {
                        String line = in.readLine();
                        this.consistNumber.setText(Integer.toString(consistNum++));
                        if (line == null) {
                            log.error("NCE consist file terminator :0000 not found");
                            break block25;
                        }
                        log.debug("consist {}", (Object)line);
                        String consistAddr = ":" + Integer.toHexString(curConsist);
                        String[] consistLine = line.split(" ");
                        if (consistLine[0].equalsIgnoreCase(":0000")) {
                            this.fileValid = true;
                            break block25;
                        }
                        if (!consistAddr.equalsIgnoreCase(consistLine[0])) {
                            log.error("Restore file selected is not a vaild backup file");
                            log.error("Consist memory address in restore file should be {} read {}", (Object)consistAddr, (Object)consistLine[0]);
                            break block25;
                        }
                        if (curConsist == 62720 && JOptionPane.showConfirmDialog(null, Bundle.getMessage("RestoreTakesAwhile"), Bundle.getMessage("NceConsistRestore"), 0) != 0) break block25;
                        fstatus.setVisible(true);
                        int i = 0;
                        while (i < 8) {
                            int j = i << 1;
                            byte[] b = StringUtil.bytesFromHexString(consistLine[i + 1]);
                            consistData[j] = b[0];
                            consistData[j + 1] = b[1];
                            ++i;
                        }
                        NceMessage m = this.writeNceConsistMemory(curConsist, consistData);
                        this.tc.sendNceMessage(m, this);
                        curConsist += 16;
                        if (this.waiting <= 0) continue;
                        NceConsistRestore nceConsistRestore = this;
                        synchronized (nceConsistRestore) {
                            try {
                                this.wait(20000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    } while (this.waiting <= 0);
                    log.error("timeout waiting for reply");
                }
                in.close();
                fstatus.dispose();
                if (this.fileValid) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("SuccessfulRestore"), Bundle.getMessage("NceConsistRestore"), 1);
                } else {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("RestoreFailed"), Bundle.getMessage("NceConsistRestore"), 0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private NceMessage writeNceConsistMemory(int curConsist, byte[] b) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryWriteN(curConsist, b);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        log.debug("waiting for {} responses", (Object)this.waiting);
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        if (this.replyLen == 1 && r.getElement(0) != NceMessage.NCE_OKAY) {
            log.error("reply incorrect");
        }
        if (this.waiting == 0) {
            NceConsistRestore nceConsistRestore = this;
            synchronized (nceConsistRestore) {
                this.notify();
            }
        }
    }
}

