/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.consist.Bundle;
import jmri.jmrix.nce.consist.NceConsistBackup;
import jmri.jmrix.nce.consist.NceConsistRestore;
import jmri.jmrix.nce.consist.NceConsistRoster;
import jmri.jmrix.nce.consist.NceConsistRosterEntry;
import jmri.jmrix.nce.consist.NceConsistRosterMenu;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistEditPanel
extends NcePanel
implements NceListener {
    NceConsistRoster nceConsistRoster = InstanceManager.getDefault(NceConsistRoster.class);
    private static final int CONSIST_MIN = 1;
    private static final int CONSIST_MAX = 127;
    private static final int LOC_ADR_MIN = 0;
    private static final int LOC_ADR_MAX = 9999;
    private static final int LOC_ADR_REPLACE = 16383;
    private int consistNum = 0;
    private boolean newConsist = true;
    private int locoPosition = 0;
    private static final int LEAD = 0;
    private static final int REAR = 1;
    private static final int MID = 2;
    private int consistNumVerify;
    private final int[] locoVerifyList = new int[6];
    private int verifyType;
    private static final int VERIFY_DONE = 0;
    private static final int VERIFY_LEAD_REAR = 1;
    private static final int VERIFY_MID_FWD = 2;
    private static final int VERIFY_MID_REV = 4;
    private static final int VERIFY_ALL = 8;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean consistSearchNext = false;
    private boolean consistSearchPrevious = false;
    private boolean locoSearch = false;
    private boolean emptyConsistSearch = false;
    private boolean verifyRosterMatch = false;
    private static final int CONSIST_ERROR = -1;
    private static final int ADDRESS_ERROR = -1;
    private int consistCount = 0;
    private boolean refresh = false;
    JLabel textConsist = new JLabel();
    JLabel textStatus = new JLabel();
    JLabel consistStatus = new JLabel();
    JButton previousButton = new JButton();
    JButton nextButton = new JButton();
    JButton getButton = new JButton();
    JButton throttleButton = new JButton();
    JButton clearCancelButton = new JButton();
    JButton saveLoadButton = new JButton();
    JButton deleteButton = new JButton();
    JButton backUpButton = new JButton();
    JButton restoreButton = new JButton();
    JCheckBox checkBoxEmpty = new JCheckBox();
    JCheckBox checkBoxVerify = new JCheckBox();
    JCheckBox checkBoxConsist = new JCheckBox();
    JTextField consistTextField = new JTextField(4);
    JLabel textLocomotive = new JLabel();
    JLabel textRoster = new JLabel();
    JLabel textAddress = new JLabel();
    JLabel textAddrType = new JLabel();
    JLabel textDirection = new JLabel();
    JLabel textConRoster = new JLabel();
    JLabel textConRoadName = new JLabel();
    JLabel textConRoadNumber = new JLabel();
    JLabel textConModel = new JLabel();
    JComboBox<String> conRosterBox = this.nceConsistRoster.fullRosterComboBox();
    JLabel space1 = new JLabel("            ");
    JLabel space2 = new JLabel(" ");
    JLabel space3a = new JLabel("                            ");
    JLabel space3b = new JLabel("                            ");
    JLabel space3c = new JLabel("                            ");
    JLabel space3d = new JLabel("                            ");
    JLabel space15 = new JLabel(" ");
    JLabel textLoco1 = new JLabel();
    JTextField locoTextField1 = new JTextField(4);
    JComboBox<Object> locoRosterBox1 = new RosterEntryComboBox();
    JButton adrButton1 = new JButton();
    JButton cmdButton1 = new JButton();
    JButton dirButton1 = new JButton();
    JLabel textLoco2 = new JLabel();
    JTextField locoTextField2 = new JTextField(4);
    JComboBox<Object> locoRosterBox2 = new RosterEntryComboBox();
    JButton adrButton2 = new JButton();
    JButton cmdButton2 = new JButton();
    JButton dirButton2 = new JButton();
    JLabel textLoco3 = new JLabel();
    JTextField locoTextField3 = new JTextField(4);
    JComboBox<Object> locoRosterBox3 = new RosterEntryComboBox();
    JButton adrButton3 = new JButton();
    JButton cmdButton3 = new JButton();
    JButton dirButton3 = new JButton();
    JLabel textLoco4 = new JLabel();
    JTextField locoTextField4 = new JTextField(4);
    JComboBox<Object> locoRosterBox4 = new RosterEntryComboBox();
    JButton adrButton4 = new JButton();
    JButton cmdButton4 = new JButton();
    JButton dirButton4 = new JButton();
    JLabel textLoco5 = new JLabel();
    JTextField locoTextField5 = new JTextField(4);
    JComboBox<Object> locoRosterBox5 = new RosterEntryComboBox();
    JButton adrButton5 = new JButton();
    JButton cmdButton5 = new JButton();
    JButton dirButton5 = new JButton();
    JLabel textLoco6 = new JLabel();
    JTextField locoTextField6 = new JTextField(4);
    JComboBox<Object> locoRosterBox6 = new RosterEntryComboBox();
    JButton adrButton6 = new JButton();
    JButton cmdButton6 = new JButton();
    JButton dirButton6 = new JButton();
    private NceTrafficController tc = null;
    NceConsistRosterEntry nceConsistRosterEntry;
    private final boolean enablePartialMatch = true;
    protected List<NceConsistRosterEntry> consistList = new ArrayList<NceConsistRosterEntry>();
    private boolean exactMatch = false;
    ActionListener consistRosterListener;
    private static final int ERROR_LOCO_IN_USE = 1;
    private static final int ERROR_NO_EMPTY_CONSIST = 2;
    private static final int ERROR_CONSIST_DOESNT_MATCH = 3;
    private static final int WARN_CONSIST_ALREADY_LOADED = 4;
    private int locoNumInUse;
    private int errorCode = 0;
    private static final Logger log = LoggerFactory.getLogger(NceConsistEditPanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            try {
                this.initComponents((NceSystemConnectionMemo)context);
            }
            catch (Exception exception) {
                log.error("NceConsistEdit initContext failed");
            }
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.consist.NceConsistEditFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("NceConsistEditTitle"));
        return x.toString();
    }

    @Override
    public List<JMenu> getMenus() {
        JMenu toolMenu = new JMenu("Tools");
        toolMenu.add(new NceConsistRosterMenu("Roster", 1, this));
        ArrayList<JMenu> l = new ArrayList<JMenu>();
        l.add(toolMenu);
        return l;
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getNceTrafficController();
        this.textConsist.setText(Bundle.getMessage("L_Consist"));
        this.textStatus.setText(Bundle.getMessage("L_Status"));
        this.consistStatus.setText(Bundle.getMessage("EditStateUNKNOWN"));
        this.previousButton.setText(Bundle.getMessage("KeyPREVIOUS"));
        this.previousButton.setToolTipText(Bundle.getMessage("ToolTipPrevious"));
        this.nextButton.setText(Bundle.getMessage("KeyNEXT"));
        this.nextButton.setToolTipText(Bundle.getMessage("ToolTipNext"));
        this.getButton.setText(Bundle.getMessage("KeyGET"));
        this.getButton.setToolTipText(Bundle.getMessage("ToolTipGet"));
        this.consistTextField.setText(Integer.toString(127));
        this.consistTextField.setToolTipText(MessageFormat.format(Bundle.getMessage("ToolTipConsist"), 1, 127));
        this.consistTextField.setMaximumSize(new Dimension(this.consistTextField.getMaximumSize().width, this.consistTextField.getPreferredSize().height));
        this.textLocomotive.setText(Bundle.getMessage("L_Loco"));
        this.textRoster.setText(Bundle.getMessage("L_Roster"));
        this.textAddress.setText(Bundle.getMessage("L_Address"));
        this.textAddrType.setText(Bundle.getMessage("L_Type"));
        this.textDirection.setText(Bundle.getMessage("L_Direction"));
        this.textConRoster.setText(Bundle.getMessage("L_Consist"));
        this.textConRoadName.setText("");
        this.textConRoadNumber.setText("");
        this.textConModel.setText("");
        this.throttleButton.setText(Bundle.getMessage("L_Throttle"));
        this.throttleButton.setEnabled(true);
        this.throttleButton.setToolTipText(Bundle.getMessage("ToolTipThrottle"));
        this.clearCancelButton.setText(Bundle.getMessage("KeyCLEAR"));
        this.clearCancelButton.setEnabled(false);
        this.clearCancelButton.setToolTipText(Bundle.getMessage("ToolTipClear"));
        this.saveLoadButton.setText(Bundle.getMessage("KeySAVE"));
        this.saveLoadButton.setVisible(false);
        this.saveLoadButton.setEnabled(false);
        this.saveLoadButton.setToolTipText(Bundle.getMessage("ToolTipSave"));
        this.deleteButton.setText(Bundle.getMessage("KeyDELETE"));
        this.deleteButton.setVisible(false);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText(Bundle.getMessage("ToolTipDelete"));
        this.backUpButton.setText(Bundle.getMessage("KeyBACKUP"));
        this.backUpButton.setToolTipText(Bundle.getMessage("ToolTipBackup"));
        this.restoreButton.setText(Bundle.getMessage("KeyRESTORE"));
        this.restoreButton.setToolTipText(Bundle.getMessage("ToolTipRestore"));
        this.checkBoxEmpty.setText(Bundle.getMessage("KeyEMPTY"));
        this.checkBoxEmpty.setToolTipText(Bundle.getMessage("ToolTipEmpty"));
        this.checkBoxVerify.setText(Bundle.getMessage("KeyVERIFY"));
        this.checkBoxVerify.setSelected(true);
        this.checkBoxVerify.setToolTipText(Bundle.getMessage("ToolTipVerify"));
        this.checkBoxConsist.setText(Bundle.getMessage("KeyCONSIST"));
        this.checkBoxConsist.setSelected(true);
        this.checkBoxConsist.setToolTipText(Bundle.getMessage("ToolTipConsistCkBox"));
        this.initLocoFields();
        this.setLayout(new GridBagLayout());
        this.addItem(this.textConsist, 2, 0);
        this.addItem(this.previousButton, 1, 1);
        this.addItem(this.consistTextField, 2, 1);
        this.addItem(this.nextButton, 3, 1);
        this.addItem(this.checkBoxEmpty, 5, 1);
        this.addItem(this.textStatus, 0, 2);
        this.addItem(this.consistStatus, 1, 2);
        this.addItem(this.getButton, 2, 2);
        this.addItem(this.checkBoxVerify, 5, 2);
        this.addItem(this.space3a, 1, 3);
        this.addItem(this.space3b, 2, 3);
        this.addItem(this.space3c, 3, 3);
        this.addItem(this.space3d, 4, 3);
        this.addItem(this.textConRoster, 1, 4);
        this.addItem(this.conRosterBox, 1, 5);
        this.addItem(this.textConRoadName, 2, 5);
        this.addItem(this.textConRoadNumber, 3, 5);
        this.addItem(this.textConModel, 4, 5);
        this.addItem(this.checkBoxConsist, 5, 5);
        this.initConsistRoster(this.conRosterBox);
        this.addItem(this.space1, 1, 6);
        this.addItem(this.textLocomotive, 0, 7);
        this.addItem(this.textRoster, 1, 7);
        this.addItem(this.textAddress, 2, 7);
        this.addItem(this.textAddrType, 3, 7);
        this.addItem(this.textDirection, 4, 7);
        this.addLocoRow(this.textLoco1, this.locoRosterBox1, this.locoTextField1, this.adrButton1, this.dirButton1, this.cmdButton1, 8);
        this.addLocoRow(this.textLoco2, this.locoRosterBox2, this.locoTextField2, this.adrButton2, this.dirButton2, this.cmdButton2, 9);
        this.addLocoRow(this.textLoco3, this.locoRosterBox3, this.locoTextField3, this.adrButton3, this.dirButton3, this.cmdButton3, 10);
        this.addLocoRow(this.textLoco4, this.locoRosterBox4, this.locoTextField4, this.adrButton4, this.dirButton4, this.cmdButton4, 11);
        this.addLocoRow(this.textLoco5, this.locoRosterBox5, this.locoTextField5, this.adrButton5, this.dirButton5, this.cmdButton5, 12);
        this.addLocoRow(this.textLoco6, this.locoRosterBox6, this.locoTextField6, this.adrButton6, this.dirButton6, this.cmdButton6, 13);
        this.addItem(this.space15, 2, 15);
        this.addItem(this.throttleButton, 0, 16);
        this.addItem(this.clearCancelButton, 1, 16);
        this.addItem(this.saveLoadButton, 2, 16);
        this.addItem(this.deleteButton, 3, 16);
        this.addItem(this.backUpButton, 4, 16);
        this.addItem(this.restoreButton, 5, 16);
        this.addButtonAction(this.previousButton);
        this.addButtonAction(this.nextButton);
        this.addButtonAction(this.getButton);
        this.addButtonAction(this.throttleButton);
        this.addButtonAction(this.clearCancelButton);
        this.addButtonAction(this.saveLoadButton);
        this.addButtonAction(this.deleteButton);
        this.addButtonAction(this.backUpButton);
        this.addButtonAction(this.restoreButton);
        this.addCheckBoxAction(this.checkBoxConsist);
        this.checkBoxConsist();
    }

    public void buttonActionPerformed(ActionEvent ae) {
        if (this.consistSearchNext || this.consistSearchPrevious || this.locoSearch) {
            return;
        }
        if (ae.getSource() == this.throttleButton) {
            if (!this.validConsist()) {
                return;
            }
            int locoAddr = this.validLocoAdr(this.locoTextField1.getText());
            boolean isLong = this.adrButton1.getText().equals(Bundle.getMessage("KeyLONG"));
            if (locoAddr < 0) {
                return;
            }
            this.consistNum = this.validConsist(this.consistTextField.getText());
            ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
            tf.getAddressPanel().setAddress(this.consistNum, false);
            if (JOptionPane.showConfirmDialog(null, Bundle.getMessage("DIALOG_Funct2Lead"), Bundle.getMessage("DIALOG_NceThrottle"), 0) == 0) {
                tf.getAddressPanel().setAddress(locoAddr, isLong);
            }
            tf.toFront();
            return;
        }
        if (ae.getSource() == this.clearCancelButton) {
            if (this.clearCancelButton.getText().equals(Bundle.getMessage("KeyCLEAR"))) {
                this.updateRoster(Bundle.getMessage("CLEARED"));
                this.refresh = true;
                this.killConsist();
            } else {
                this.changeButtons(false);
                this.consistNum = this.getConsist();
            }
        }
        if (ae.getSource() == this.saveLoadButton) {
            if (!this.validConsist()) {
                return;
            }
            if (!this.canLoad()) {
                this.consistStatus.setText(Bundle.getMessage("EditStateERROR"));
                this.saveLoadButton.setEnabled(false);
                return;
            }
            this.consistStatus.setText(Bundle.getMessage("EditStateOKAY"));
            this.enableAllLocoRows(false);
            if (this.saveLoadButton.getText().equals(Bundle.getMessage("KeyLOAD"))) {
                this.loadShift();
                this.updateRoster(this.consistTextField.getText());
                this.consistNum = this.validConsist(this.consistTextField.getText());
                if (!this.verifyAllLocoAddr()) {
                    this.fullLoad();
                }
            } else if (this.updateRoster(this.consistTextField.getText())) {
                this.saveLoadButton.setEnabled(false);
                this.consistNum = this.getConsist();
            }
            return;
        }
        if (ae.getSource() == this.deleteButton) {
            if (JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("DIALOG_ConfirmDel1")) + " " + this.conRosterBox.getSelectedItem().toString() + " " + Bundle.getMessage("DIALOG_ConfirmDel2"), Bundle.getMessage("DIALOG_NceDelete"), 2) != 0) {
                return;
            }
            this.deleteRoster();
            this.changeButtons(false);
            return;
        }
        if (ae.getSource() == this.previousButton) {
            this.consistSearchPrevious = true;
            this.consistNum = this.getConsist();
        }
        if (ae.getSource() == this.nextButton) {
            this.consistSearchNext = true;
            this.consistNum = this.getConsist();
        }
        if (ae.getSource() == this.getButton) {
            this.consistNum = this.getConsist();
        }
        if (ae.getSource() == this.backUpButton) {
            NceConsistBackup mb = new NceConsistBackup(this.tc);
            mb.setName("Consist Backup");
            mb.start();
        }
        if (ae.getSource() == this.restoreButton) {
            NceConsistRestore mr = new NceConsistRestore(this.tc);
            mr.setName("Consist Restore");
            mr.start();
        }
    }

    public void buttonActionCmdPerformed(ActionEvent ae) {
        if (this.consistSearchNext || this.consistSearchPrevious || this.locoSearch) {
            return;
        }
        if (this.consistChanged()) {
            return;
        }
        if (ae.getSource() == this.cmdButton1) {
            this.modifyLocoFields(this.locoRosterBox1, this.locoTextField1, this.adrButton1, this.dirButton1, this.cmdButton1);
        }
        if (ae.getSource() == this.cmdButton2) {
            this.modifyLocoFields(this.locoRosterBox2, this.locoTextField2, this.adrButton2, this.dirButton2, this.cmdButton2);
        }
        if (ae.getSource() == this.cmdButton3) {
            this.modifyLocoFields(this.locoRosterBox3, this.locoTextField3, this.adrButton3, this.dirButton3, this.cmdButton3);
        }
        if (ae.getSource() == this.cmdButton4) {
            this.modifyLocoFields(this.locoRosterBox4, this.locoTextField4, this.adrButton4, this.dirButton4, this.cmdButton4);
        }
        if (ae.getSource() == this.cmdButton5) {
            this.modifyLocoFields(this.locoRosterBox5, this.locoTextField5, this.adrButton5, this.dirButton5, this.cmdButton5);
        }
        if (ae.getSource() == this.cmdButton6) {
            this.modifyLocoFields(this.locoRosterBox6, this.locoTextField6, this.adrButton6, this.dirButton6, this.cmdButton6);
        }
        if (this.updateRoster(this.consistTextField.getText())) {
            this.saveLoadButton.setEnabled(false);
        }
    }

    public void buttonActionAdrPerformed(ActionEvent ae) {
        if (this.consistSearchNext || this.consistSearchPrevious || this.locoSearch) {
            return;
        }
        if (this.consistChanged()) {
            return;
        }
        if (ae.getSource() == this.adrButton1) {
            this.toggleAdrButton(this.locoTextField1, this.adrButton1);
        }
        if (ae.getSource() == this.adrButton2) {
            this.toggleAdrButton(this.locoTextField2, this.adrButton2);
        }
        if (ae.getSource() == this.adrButton3) {
            this.toggleAdrButton(this.locoTextField3, this.adrButton3);
        }
        if (ae.getSource() == this.adrButton4) {
            this.toggleAdrButton(this.locoTextField4, this.adrButton4);
        }
        if (ae.getSource() == this.adrButton5) {
            this.toggleAdrButton(this.locoTextField5, this.adrButton5);
        }
        if (ae.getSource() == this.adrButton6) {
            this.toggleAdrButton(this.locoTextField6, this.adrButton6);
        }
    }

    private void toggleAdrButton(JTextField locoTextField, JButton adrButton) {
        if (this.validLocoAdr(locoTextField.getText()) < 0) {
            return;
        }
        if (locoTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_EnterLocoB4AddrChg"), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return;
        }
        if (adrButton.getText().equals(Bundle.getMessage("KeyLONG"))) {
            if (Integer.parseInt(locoTextField.getText()) < 128 && Integer.parseInt(locoTextField.getText()) > 0) {
                adrButton.setText(Bundle.getMessage("KeySHORT"));
            }
        } else {
            adrButton.setText(Bundle.getMessage("KeyLONG"));
        }
    }

    public void buttonActionDirPerformed(ActionEvent ae) {
        if (this.consistSearchNext || this.consistSearchPrevious || this.locoSearch) {
            return;
        }
        if (this.consistChanged()) {
            return;
        }
        if (ae.getSource() == this.dirButton1) {
            this.toggleDirButton(this.locoTextField1, this.dirButton1, this.cmdButton1);
        }
        if (ae.getSource() == this.dirButton2) {
            this.toggleDirButton(this.locoTextField2, this.dirButton2, this.cmdButton2);
        }
        if (ae.getSource() == this.dirButton3) {
            this.toggleDirButton(this.locoTextField3, this.dirButton3, this.cmdButton3);
        }
        if (ae.getSource() == this.dirButton4) {
            this.toggleDirButton(this.locoTextField4, this.dirButton4, this.cmdButton4);
        }
        if (ae.getSource() == this.dirButton5) {
            this.toggleDirButton(this.locoTextField5, this.dirButton5, this.cmdButton5);
        }
        if (ae.getSource() == this.dirButton6) {
            this.toggleDirButton(this.locoTextField6, this.dirButton6, this.cmdButton6);
        }
        this.saveLoadButton.setEnabled(this.canLoad());
    }

    private void toggleDirButton(JTextField locoTextField, JButton dirButton, JButton cmdButton) {
        if (this.validLocoAdr(locoTextField.getText()) < 0) {
            return;
        }
        if (locoTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_EnterLocoB4DirChg"), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return;
        }
        cmdButton.setEnabled(true);
        if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
            dirButton.setText(Bundle.getMessage("KeyREV"));
        } else {
            dirButton.setText(Bundle.getMessage("KeyFWD"));
        }
    }

    public void locoSelected(ActionEvent ae) {
        if (ae.getSource() == this.locoRosterBox1) {
            this.rosterBoxSelect(this.locoRosterBox1, this.locoTextField1, this.adrButton1);
        }
        if (ae.getSource() == this.locoRosterBox2) {
            this.rosterBoxSelect(this.locoRosterBox2, this.locoTextField2, this.adrButton2);
        }
        if (ae.getSource() == this.locoRosterBox3) {
            this.rosterBoxSelect(this.locoRosterBox3, this.locoTextField3, this.adrButton3);
        }
        if (ae.getSource() == this.locoRosterBox4) {
            this.rosterBoxSelect(this.locoRosterBox4, this.locoTextField4, this.adrButton4);
        }
        if (ae.getSource() == this.locoRosterBox5) {
            this.rosterBoxSelect(this.locoRosterBox5, this.locoTextField5, this.adrButton5);
        }
        if (ae.getSource() == this.locoRosterBox6) {
            this.rosterBoxSelect(this.locoRosterBox6, this.locoTextField6, this.adrButton6);
        }
    }

    private void rosterBoxSelect(JComboBox<Object> locoRosterBox, JTextField locoTextField, JButton adrButton) {
        RosterEntry entry = null;
        Object o = locoRosterBox.getSelectedItem();
        if (o.getClass().equals(RosterEntry.class)) {
            entry = (RosterEntry)o;
        }
        if (entry != null) {
            DccLocoAddress a = entry.getDccLocoAddress();
            locoTextField.setText("" + a.getNumber());
            if (a.isLongAddress()) {
                adrButton.setText(Bundle.getMessage("KeyLONG"));
            } else {
                adrButton.setText(Bundle.getMessage("KeySHORT"));
            }
            if (locoRosterBox == this.locoRosterBox1) {
                this.textConRoadName.setText(entry.getRoadName());
                this.textConRoadNumber.setText(entry.getRoadNumber());
                this.textConModel.setText(entry.getModel());
            }
        }
    }

    public void consistRosterSelected(ActionEvent ae) {
        if (this.consistSearchNext || this.consistSearchPrevious || this.locoSearch) {
            return;
        }
        String entry = "";
        entry = this.conRosterBox.getSelectedItem().toString();
        log.debug("load consist {} from roster ", (Object)entry);
        if (entry.equals("")) {
            this.changeButtons(false);
            this.consistNum = this.getConsist();
            return;
        }
        this.changeButtons(true);
        this.loadRosterEntry(entry);
    }

    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.checkBoxConsist) {
            this.checkBoxConsist();
        }
    }

    private void checkBoxConsist() {
        if (this.checkBoxConsist.isSelected()) {
            this.conRosterBox.setEnabled(true);
            this.saveLoadButton.setVisible(true);
            this.saveLoadButton.setEnabled(this.canLoad());
            this.deleteButton.setVisible(true);
        } else {
            this.conRosterBox.setEnabled(false);
            this.conRosterBox.removeActionListener(this.consistRosterListener);
            this.conRosterBox.setSelectedIndex(0);
            this.conRosterBox.addActionListener(this.consistRosterListener);
            this.saveLoadButton.setVisible(false);
            this.saveLoadButton.setEnabled(false);
            this.deleteButton.setVisible(false);
            this.deleteButton.setEnabled(false);
        }
    }

    private int getConsist() {
        this.newConsist = true;
        int consistNumber = this.validConsist(this.consistTextField.getText());
        if (consistNumber == -1) {
            this.consistSearchPrevious = false;
            this.consistSearchNext = false;
            return consistNumber;
        }
        if (this.consistSearchNext || this.consistSearchPrevious) {
            this.consistCount = 0;
            this.consistStatus.setText(Bundle.getMessage("EditStateSEARCH"));
        } else {
            this.consistStatus.setText(Bundle.getMessage("EditStateWAIT"));
            if (consistNumber == this.consistNum) {
                this.newConsist = false;
            }
        }
        if (this.waiting > 0) {
            return consistNumber;
        }
        if (this.consistSearchNext) {
            this.readConsistMemory(consistNumber - 7, 0);
        } else {
            this.readConsistMemory(consistNumber, 0);
        }
        return consistNumber;
    }

    private boolean validConsist() {
        int consistNumber = this.validConsist(this.consistTextField.getText());
        if (consistNumber == -1) {
            this.consistStatus.setText(Bundle.getMessage("EditStateERROR"));
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("ToolTipConsist"), 1, 127), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return false;
        }
        return true;
    }

    private int validConsist(String s) {
        int consistNumber;
        try {
            consistNumber = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (consistNumber < 1 || consistNumber > 127) {
            return -1;
        }
        return consistNumber;
    }

    private int validLocoAdr(String s) {
        int locoAddress;
        try {
            locoAddress = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            locoAddress = -1;
        }
        if (locoAddress < 0 || locoAddress > 9999) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_AddrRange"), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return -1;
        }
        return locoAddress;
    }

    private boolean consistChanged() {
        if (this.consistNum != this.validConsist(this.consistTextField.getText())) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_PressRead"), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return true;
        }
        this.newConsist = false;
        return false;
    }

    private void readConsistMemory(int consistNum, int engPosition) {
        this.locoPosition = engPosition;
        int nceMemAddr = consistNum * 2 + 62720;
        if (this.locoPosition == 1) {
            nceMemAddr = consistNum * 2 + 62976;
        }
        if (this.locoPosition == 2) {
            nceMemAddr = consistNum * 8 + 63232;
        }
        log.debug("Read consist ({}) position ({}) NCE memory address ({})", new Object[]{consistNum, engPosition, Integer.toHexString(nceMemAddr)});
        byte[] bl = NceBinaryCommand.accMemoryRead(nceMemAddr);
        this.sendNceMessage(bl, 16);
    }

    private void loadRosterEntry(String entry) {
        this.nceConsistRosterEntry = this.nceConsistRoster.entryFromTitle(entry);
        this.consistTextField.setText(this.nceConsistRosterEntry.getConsistNumber());
        int cNum = this.validConsist(this.nceConsistRosterEntry.getConsistNumber());
        if (cNum > 0) {
            log.debug("verify consist matches roster selection");
            this.verifyRosterMatch = true;
            this.consistNum = this.getConsist();
        } else if (this.nceConsistRosterEntry.getConsistNumber().equals(Bundle.getMessage("CLEARED")) || this.nceConsistRosterEntry.getConsistNumber().equals("0")) {
            log.debug("search for empty consist");
            this.consistTextField.setText(Integer.toString(127));
            this.emptyConsistSearch = true;
            this.consistSearchNext = true;
            this.consistNum = this.getConsist();
            this.loadFullRoster(this.nceConsistRosterEntry);
            this.saveLoadButton.setEnabled(false);
        } else {
            log.error("roster consist number is out of range: {}", (Object)this.consistNum);
            this.consistStatus.setText(Bundle.getMessage("EditStateERROR"));
        }
    }

    private void loadFullRoster(NceConsistRosterEntry nceConsistRosterEntry) {
        this.textConRoadName.setText(nceConsistRosterEntry.getRoadName());
        this.textConRoadNumber.setText(nceConsistRosterEntry.getRoadNumber());
        this.textConModel.setText(nceConsistRosterEntry.getModel());
        this.locoTextField1.setText(nceConsistRosterEntry.getLoco1DccAddress());
        this.adrButton1.setText(nceConsistRosterEntry.isLoco1LongAddress() ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        this.dirButton1.setText(this.convertDTD(nceConsistRosterEntry.getLoco1Direction()));
        this.locoRosterBox1.setEnabled(true);
        this.locoTextField1.setEnabled(true);
        this.adrButton1.setEnabled(true);
        this.dirButton1.setEnabled(true);
        this.locoTextField2.setText(nceConsistRosterEntry.getLoco2DccAddress());
        this.adrButton2.setText(nceConsistRosterEntry.isLoco2LongAddress() ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        this.dirButton2.setText(this.convertDTD(nceConsistRosterEntry.getLoco2Direction()));
        this.locoRosterBox2.setEnabled(true);
        this.locoTextField2.setEnabled(true);
        this.adrButton2.setEnabled(true);
        this.dirButton2.setEnabled(true);
        this.locoTextField3.setText(nceConsistRosterEntry.getLoco3DccAddress());
        this.adrButton3.setText(nceConsistRosterEntry.isLoco3LongAddress() ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        this.dirButton3.setText(this.convertDTD(nceConsistRosterEntry.getLoco3Direction()));
        this.locoRosterBox3.setEnabled(true);
        this.locoTextField3.setEnabled(true);
        this.adrButton3.setEnabled(true);
        this.dirButton3.setEnabled(true);
        this.locoTextField4.setText(nceConsistRosterEntry.getLoco4DccAddress());
        this.adrButton4.setText(nceConsistRosterEntry.isLoco4LongAddress() ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        this.dirButton4.setText(this.convertDTD(nceConsistRosterEntry.getLoco4Direction()));
        this.locoRosterBox4.setEnabled(true);
        this.locoTextField4.setEnabled(true);
        this.adrButton4.setEnabled(true);
        this.dirButton4.setEnabled(true);
        this.locoTextField5.setText(nceConsistRosterEntry.getLoco5DccAddress());
        this.adrButton5.setText(nceConsistRosterEntry.isLoco5LongAddress() ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        this.dirButton5.setText(this.convertDTD(nceConsistRosterEntry.getLoco5Direction()));
        this.locoRosterBox5.setEnabled(true);
        this.locoTextField5.setEnabled(true);
        this.adrButton5.setEnabled(true);
        this.dirButton5.setEnabled(true);
        this.locoTextField6.setText(nceConsistRosterEntry.getLoco6DccAddress());
        this.adrButton6.setText(nceConsistRosterEntry.isLoco6LongAddress() ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        this.dirButton6.setText(this.convertDTD(nceConsistRosterEntry.getLoco6Direction()));
        this.locoRosterBox6.setEnabled(true);
        this.locoTextField6.setEnabled(true);
        this.adrButton6.setEnabled(true);
        this.dirButton6.setEnabled(true);
    }

    private boolean consistRosterMatch(NceConsistRosterEntry nceConsistRosterEntry) {
        if (this.consistTextField.getText().equals(nceConsistRosterEntry.getConsistNumber()) && this.locoTextField1.getText().equals(nceConsistRosterEntry.getLoco1DccAddress()) && this.locoTextField2.getText().equals(nceConsistRosterEntry.getLoco2DccAddress()) && this.locoTextField3.getText().equals(nceConsistRosterEntry.getLoco3DccAddress()) && this.locoTextField4.getText().equals(nceConsistRosterEntry.getLoco4DccAddress()) && this.locoTextField5.getText().equals(nceConsistRosterEntry.getLoco5DccAddress()) && this.locoTextField6.getText().equals(nceConsistRosterEntry.getLoco6DccAddress())) {
            if (this.newConsist) {
                this.textConRoadName.setText(nceConsistRosterEntry.getRoadName());
                this.textConRoadNumber.setText(nceConsistRosterEntry.getRoadNumber());
                this.textConModel.setText(nceConsistRosterEntry.getModel());
                this.dirButton1.setText(this.convertDTD(nceConsistRosterEntry.getLoco1Direction()));
                this.dirButton2.setText(this.convertDTD(nceConsistRosterEntry.getLoco2Direction()));
                this.dirButton3.setText(this.convertDTD(nceConsistRosterEntry.getLoco3Direction()));
                this.dirButton4.setText(this.convertDTD(nceConsistRosterEntry.getLoco4Direction()));
                this.dirButton5.setText(this.convertDTD(nceConsistRosterEntry.getLoco5Direction()));
                this.dirButton6.setText(this.convertDTD(nceConsistRosterEntry.getLoco6Direction()));
            }
            return true;
        }
        return false;
    }

    private boolean consistRosterPartialMatch(NceConsistRosterEntry cre) {
        if (!this.consistTextField.getText().equals(cre.getConsistNumber()) || !this.locoTextField1.getText().equals(cre.getLoco1DccAddress())) {
            this.consistStatus.setText(Bundle.getMessage("EditStateUNKNOWN"));
            return false;
        }
        this.dirButton1.setText(this.convertDTD(cre.getLoco1Direction()));
        this.textConRoadName.setText(cre.getRoadName());
        this.textConRoadNumber.setText(cre.getRoadNumber());
        this.textConModel.setText(cre.getModel());
        if (this.locoTextField2.getText().equals(cre.getLoco2DccAddress())) {
            this.dirButton2.setText(this.convertDTD(cre.getLoco2Direction()));
        }
        if (this.locoTextField3.getText().equals(cre.getLoco3DccAddress())) {
            this.dirButton3.setText(this.convertDTD(cre.getLoco3Direction()));
        }
        if (this.locoTextField4.getText().equals(cre.getLoco4DccAddress())) {
            this.dirButton4.setText(this.convertDTD(cre.getLoco4Direction()));
        }
        if (this.locoTextField5.getText().equals(cre.getLoco5DccAddress())) {
            this.dirButton5.setText(this.convertDTD(cre.getLoco5Direction()));
        }
        if (this.locoTextField6.getText().equals(cre.getLoco6DccAddress())) {
            this.dirButton6.setText(this.convertDTD(cre.getLoco6Direction()));
        }
        this.consistStatus.setText(Bundle.getMessage("EditStateMODIFIED"));
        return true;
    }

    private boolean updateRoster(String consistNumber) {
        NceConsistRosterEntry nceConsistRosterEntry;
        if (!this.checkBoxConsist.isSelected()) {
            return false;
        }
        String id = this.locoTextField1.getText();
        if (id.equals("")) {
            log.debug("Attempt to modify consist without valid id");
            return false;
        }
        if (this.locoTextField2.getText().equals("")) {
            return false;
        }
        this.consistList = this.nceConsistRoster.matchingList(null, null, null, null, null, null, null, null, null, id);
        if (this.consistList.isEmpty()) {
            if (JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("DIALOG_ConfirmAdd1")) + " " + id + " " + Bundle.getMessage("DIALOG_ConfirmAdd2"), Bundle.getMessage("DIALOG_NceSave"), 0) != 0) {
                return false;
            }
            nceConsistRosterEntry = new NceConsistRosterEntry();
            this.nceConsistRoster.addEntry(nceConsistRosterEntry);
        } else {
            nceConsistRosterEntry = this.nceConsistRoster.entryFromTitle(id);
            this.consistList = this.nceConsistRoster.matchingList(null, null, null, this.locoTextField1.getText(), this.locoTextField2.getText(), this.locoTextField3.getText(), this.locoTextField4.getText(), this.locoTextField5.getText(), this.locoTextField6.getText(), id);
            if (this.consistList.isEmpty() && JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("DIALOG_ConfirmUpd1")) + " " + id + " " + Bundle.getMessage("DIALOG_ConfirmUpd2") + this.getRosterText(nceConsistRosterEntry), Bundle.getMessage("DIALOG_NceUpdate"), 0) == 1) {
                if (consistNumber.equals(Bundle.getMessage("CLEARED"))) {
                    nceConsistRosterEntry.setConsistNumber(consistNumber);
                    this.writeRosterFile();
                }
                return false;
            }
            log.debug("Modify consist {}", (Object)id);
        }
        nceConsistRosterEntry.setId(id);
        nceConsistRosterEntry.setConsistNumber(consistNumber);
        nceConsistRosterEntry.setRoadName(this.textConRoadName.getText());
        nceConsistRosterEntry.setRoadNumber(this.textConRoadNumber.getText());
        nceConsistRosterEntry.setModel(this.textConModel.getText());
        nceConsistRosterEntry.setLoco1DccAddress(this.locoTextField1.getText());
        nceConsistRosterEntry.setLoco1LongAddress(this.adrButton1.getText().equals(Bundle.getMessage("KeyLONG")));
        nceConsistRosterEntry.setLoco1Direction(this.directionDTD(this.dirButton1));
        nceConsistRosterEntry.setLoco2DccAddress(this.locoTextField2.getText());
        nceConsistRosterEntry.setLoco2LongAddress(this.adrButton2.getText().equals(Bundle.getMessage("KeyLONG")));
        nceConsistRosterEntry.setLoco2Direction(this.directionDTD(this.dirButton2));
        nceConsistRosterEntry.setLoco3DccAddress(this.locoTextField3.getText());
        nceConsistRosterEntry.setLoco3LongAddress(this.adrButton3.getText().equals(Bundle.getMessage("KeyLONG")));
        nceConsistRosterEntry.setLoco3Direction(this.directionDTD(this.dirButton3));
        nceConsistRosterEntry.setLoco4DccAddress(this.locoTextField4.getText());
        nceConsistRosterEntry.setLoco4LongAddress(this.adrButton4.getText().equals(Bundle.getMessage("KeyLONG")));
        nceConsistRosterEntry.setLoco4Direction(this.directionDTD(this.dirButton4));
        nceConsistRosterEntry.setLoco5DccAddress(this.locoTextField5.getText());
        nceConsistRosterEntry.setLoco5LongAddress(this.adrButton5.getText().equals(Bundle.getMessage("KeyLONG")));
        nceConsistRosterEntry.setLoco5Direction(this.directionDTD(this.dirButton5));
        nceConsistRosterEntry.setLoco6DccAddress(this.locoTextField6.getText());
        nceConsistRosterEntry.setLoco6LongAddress(this.adrButton6.getText().equals(Bundle.getMessage("KeyLONG")));
        nceConsistRosterEntry.setLoco6Direction(this.directionDTD(this.dirButton6));
        this.writeRosterFile();
        return true;
    }

    private String directionDTD(JButton dirButton) {
        String formatDTD = Bundle.getMessage("DTD_UNKNOWN");
        if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
            formatDTD = Bundle.getMessage("DTD_FORWARD");
        }
        if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
            formatDTD = Bundle.getMessage("DTD_REVERSE");
        }
        return formatDTD;
    }

    private String convertDTD(String formatDTD) {
        String word = Bundle.getMessage("KeyQUESTION");
        if (formatDTD.equals(Bundle.getMessage("DTD_FORWARD"))) {
            word = Bundle.getMessage("KeyFWD");
        }
        if (formatDTD.equals(Bundle.getMessage("DTD_REVERSE"))) {
            word = Bundle.getMessage("KeyREV");
        }
        return word;
    }

    private String shortHandConvertDTD(String formatDTD) {
        String word = "";
        if (formatDTD.equals(Bundle.getMessage("DTD_FORWARD"))) {
            word = Bundle.getMessage("KeyFWD");
        }
        if (formatDTD.equals(Bundle.getMessage("DTD_REVERSE"))) {
            word = Bundle.getMessage("KeyREV");
        }
        return word;
    }

    private void deleteRoster() {
        String entry = this.conRosterBox.getSelectedItem().toString();
        log.debug("remove consist {} from roster ", (Object)entry);
        this.nceConsistRoster.removeEntry(this.nceConsistRoster.entryFromTitle(entry));
        this.writeRosterFile();
    }

    private void writeRosterFile() {
        this.conRosterBox.removeActionListener(this.consistRosterListener);
        this.nceConsistRoster.writeRosterFile();
        this.nceConsistRoster.updateComboBox(this.conRosterBox);
        this.conRosterBox.insertItemAt("", 0);
        this.conRosterBox.setSelectedIndex(0);
        this.conRosterBox.addActionListener(this.consistRosterListener);
    }

    private boolean canLoad() {
        if (this.locoTextField1.getText().equals("")) {
            return false;
        }
        if (this.dirButton1.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            return false;
        }
        if (this.locoTextField2.getText().equals("")) {
            return false;
        }
        if (this.dirButton2.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            return false;
        }
        if (!this.locoTextField3.getText().equals("") && this.dirButton3.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            return false;
        }
        if (!this.locoTextField4.getText().equals("") && this.dirButton4.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            return false;
        }
        if (!this.locoTextField5.getText().equals("") && this.dirButton5.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            return false;
        }
        if (!this.locoTextField6.getText().equals("") && this.dirButton6.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            return false;
        }
        if (this.locoTextField3.getText().equals("")) {
            this.dirButton3.setText(Bundle.getMessage("KeyQUESTION"));
        }
        if (this.locoTextField4.getText().equals("")) {
            this.dirButton4.setText(Bundle.getMessage("KeyQUESTION"));
        }
        if (this.locoTextField5.getText().equals("")) {
            this.dirButton5.setText(Bundle.getMessage("KeyQUESTION"));
        }
        if (this.locoTextField6.getText().equals("")) {
            this.dirButton6.setText(Bundle.getMessage("KeyQUESTION"));
        }
        if (this.saveLoadButton.getText().equals(Bundle.getMessage("KeyLOAD"))) {
            return true;
        }
        return !this.exactMatch;
    }

    private void loadShift() {
        int i = 0;
        while (i < 3) {
            this.shiftOneLine(this.locoTextField5, this.adrButton5, this.dirButton5, this.locoTextField6, this.adrButton6, this.dirButton6);
            this.shiftOneLine(this.locoTextField4, this.adrButton4, this.dirButton4, this.locoTextField5, this.adrButton5, this.dirButton5);
            this.shiftOneLine(this.locoTextField3, this.adrButton3, this.dirButton3, this.locoTextField4, this.adrButton4, this.dirButton4);
            this.shiftOneLine(this.locoTextField2, this.adrButton2, this.dirButton2, this.locoTextField3, this.adrButton3, this.dirButton3);
            ++i;
        }
    }

    private void shiftOneLine(JTextField locoTextFieldLow, JButton adrButtonLow, JButton dirButtonLow, JTextField locoTextFieldHigh, JButton adrButtonHigh, JButton dirButtonHigh) {
        if (!locoTextFieldLow.getText().equals("") || locoTextFieldHigh.getText().equals("")) {
            return;
        }
        locoTextFieldLow.setText(locoTextFieldHigh.getText());
        adrButtonLow.setText(adrButtonHigh.getText());
        dirButtonLow.setText(dirButtonHigh.getText());
        dirButtonHigh.setText(Bundle.getMessage("KeyQUESTION"));
        locoTextFieldHigh.setText("");
    }

    private void changeButtons(boolean rosterDisplay) {
        if (rosterDisplay) {
            this.clearCancelButton.setText(Bundle.getMessage("KeyCANCEL"));
            this.clearCancelButton.setToolTipText(Bundle.getMessage("ToolTipCancel"));
            this.clearCancelButton.setEnabled(true);
            this.saveLoadButton.setText(Bundle.getMessage("KeyLOAD"));
            this.saveLoadButton.setToolTipText(Bundle.getMessage("ToolTipLoad"));
        } else {
            this.clearCancelButton.setText(Bundle.getMessage("KeyCLEAR"));
            this.clearCancelButton.setToolTipText(Bundle.getMessage("ToolTipClear"));
            this.saveLoadButton.setText(Bundle.getMessage("KeySAVE"));
            this.saveLoadButton.setToolTipText(Bundle.getMessage("ToolTipSave"));
            this.clearCancelButton.setEnabled(!this.locoTextField1.getText().equals(""));
        }
        this.deleteButton.setEnabled(rosterDisplay);
        this.previousButton.setEnabled(!rosterDisplay);
        this.nextButton.setEnabled(!rosterDisplay);
        this.getButton.setEnabled(!rosterDisplay);
        this.backUpButton.setEnabled(!rosterDisplay);
        this.restoreButton.setEnabled(!rosterDisplay);
        this.saveLoadButton.setEnabled(!rosterDisplay);
        this.cmdButton1.setVisible(!rosterDisplay);
        this.cmdButton2.setVisible(!rosterDisplay);
        this.cmdButton3.setVisible(!rosterDisplay);
        this.cmdButton4.setVisible(!rosterDisplay);
        this.cmdButton5.setVisible(!rosterDisplay);
        this.cmdButton6.setVisible(!rosterDisplay);
    }

    private void killConsist() {
        if (this.validLocoAdr(this.locoTextField1.getText()) < 0) {
            return;
        }
        int locoAddr = this.getLocoAddr(this.locoTextField1, this.adrButton1);
        this.sendNceBinaryCommand(locoAddr, (byte)17, (byte)0);
    }

    private void sendNceBinaryCommand(int locoAddr, byte nceLocoCmd, byte consistNumber) {
        byte[] bl = NceBinaryCommand.nceLocoCmd(locoAddr, nceLocoCmd, consistNumber);
        this.sendNceMessage(bl, 1);
    }

    @Override
    public void message(NceMessage m) {
    }

    @Override
    public void reply(NceReply nceReply) {
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        --this.waiting;
        if (nceReply.getNumDataElements() != this.replyLen) {
            this.consistStatus.setText(Bundle.getMessage("EditStateERROR"));
            log.error("reply length error, expecting: {} got: {}", (Object)this.replyLen, (Object)nceReply.getNumDataElements());
            return;
        }
        if (this.replyLen == 1) {
            int recChar = nceReply.getElement(0);
            log.debug("command reply: {}", (Object)recChar);
            if (recChar == NceMessage.NCE_OKAY) {
                if (this.locoSearch && this.waiting == 0) {
                    this.readConsistMemory(this.consistNumVerify, 0);
                    this.consistStatus.setText(Bundle.getMessage("EditStateVERIFY"));
                    return;
                }
                if (this.refresh && this.waiting == 0) {
                    this.refresh = false;
                    this.readConsistMemory(this.consistNum, 0);
                    return;
                }
                this.consistStatus.setText(Bundle.getMessage("EditStateOKAY"));
            } else {
                this.consistStatus.setText(Bundle.getMessage("EditStateERROR"));
            }
            return;
        }
        if (this.replyLen == 16) {
            if (this.locoSearch) {
                int i = 0;
                while (i < 16) {
                    int recChar_High = nceReply.getElement(i++);
                    recChar_High = recChar_High << 8 & 0xFF00;
                    int recChar_Low = nceReply.getElement(i++);
                    int locoAddress = recChar_High + (recChar_Low &= 0xFF);
                    int j = 0;
                    while (j < this.locoVerifyList.length) {
                        if (this.locoVerifyList[j] == 0) break;
                        if (locoAddress == this.locoVerifyList[j] && this.consistNumVerify != this.consistNum) {
                            this.locoSearch = false;
                            this.consistStatus.setText(Bundle.getMessage("EditStateERROR"));
                            this.locoNumInUse = locoAddress & 0x3FFF;
                            this.queueError(1);
                            return;
                        }
                        ++j;
                    }
                    ++this.consistNumVerify;
                }
                if (this.consistNumVerify > 127) {
                    if (this.locoPosition == 0) {
                        this.locoPosition = 1;
                        this.consistNumVerify = 0;
                    } else {
                        this.locoSearch = false;
                        this.consistStatus.setText(Bundle.getMessage("EditStateOKAY"));
                        if (this.verifyType == 1) {
                            if (this.refresh && this.waiting == 0) {
                                this.refresh = false;
                                this.readConsistMemory(this.consistNum, 0);
                            }
                        } else if (this.verifyType == 2) {
                            this.sendNceBinaryCommand(this.locoVerifyList[0], (byte)15, (byte)this.consistNum);
                        } else if (this.verifyType == 4) {
                            this.sendNceBinaryCommand(this.locoVerifyList[0], (byte)14, (byte)this.consistNum);
                        } else if (this.verifyType == 8) {
                            this.fullLoad();
                        } else {
                            log.debug("verifyType out of range");
                        }
                        this.verifyType = 0;
                        return;
                    }
                }
                this.readConsistMemory(this.consistNumVerify, this.locoPosition);
                return;
            }
            if (this.consistSearchNext) {
                int i = 15;
                while (i > 0) {
                    int recChar_Low = nceReply.getElement(i--);
                    int recChar_High = nceReply.getElement(i--);
                    recChar_High = recChar_High << 8 & 0xFF00;
                    int locoAddress = recChar_High + (recChar_Low &= 0xFF);
                    if (this.emptyConsistSearch) {
                        if (locoAddress == 0) {
                            this.consistSearchNext = false;
                            this.emptyConsistSearch = false;
                            this.consistStatus.setText(Bundle.getMessage("EditStateOKAY"));
                            this.saveLoadButton.setEnabled(this.canLoad());
                            return;
                        }
                    } else if (this.checkBoxEmpty.isSelected()) {
                        if (locoAddress == 0 && this.consistCount > 0) {
                            log.debug("Empty consist ({})", (Object)this.consistNum);
                            this.consistSearchNext = false;
                            this.readConsistMemory(this.consistNum, 0);
                            return;
                        }
                    } else if (locoAddress != 0 && this.consistCount > 0) {
                        this.consistSearchNext = false;
                        this.readConsistMemory(this.consistNum, 0);
                        return;
                    }
                    if (++this.consistCount > 127) {
                        this.consistSearchNext = false;
                        this.consistStatus.setText(Bundle.getMessage("EditStateNONE"));
                        if (this.emptyConsistSearch) {
                            this.emptyConsistSearch = false;
                            this.queueError(2);
                        }
                        return;
                    }
                    --this.consistNum;
                    if (this.consistNum < 1) {
                        this.consistNum = 127;
                    }
                    this.consistTextField.setText(Integer.toString(this.consistNum));
                    if (this.consistNum == 127) break;
                }
                this.readConsistMemory(this.consistNum - 7, 0);
                return;
            }
            if (this.consistSearchPrevious) {
                int i = 0;
                while (i < 16) {
                    int recChar_High = nceReply.getElement(i++);
                    recChar_High = recChar_High << 8 & 0xFF00;
                    int recChar_Low = nceReply.getElement(i++);
                    int locoAddress = recChar_High + (recChar_Low &= 0xFF);
                    if (this.checkBoxEmpty.isSelected()) {
                        if (locoAddress == 0 && this.consistCount > 0) {
                            this.consistSearchPrevious = false;
                            break;
                        }
                    } else if (locoAddress != 0 && this.consistCount > 0) {
                        this.consistSearchPrevious = false;
                        break;
                    }
                    if (++this.consistCount > 127) {
                        this.consistStatus.setText(Bundle.getMessage("EditStateNONE"));
                        this.consistSearchPrevious = false;
                        return;
                    }
                    ++this.consistNum;
                    if (this.consistNum > 127) {
                        this.consistNum = 1;
                    }
                    this.consistTextField.setText(Integer.toString(this.consistNum));
                    if (this.consistNum == 1) break;
                }
                this.readConsistMemory(this.consistNum, 0);
                return;
            }
            if (this.locoPosition == 0) {
                boolean loco1exists = this.updateLocoFields(nceReply, 0, this.locoRosterBox1, this.locoTextField1, this.adrButton1, this.dirButton1, this.cmdButton1);
                if (this.clearCancelButton.getText().equals(Bundle.getMessage("KeyCLEAR"))) {
                    this.clearCancelButton.setEnabled(loco1exists);
                }
            } else if (this.locoPosition == 1) {
                this.updateLocoFields(nceReply, 0, this.locoRosterBox2, this.locoTextField2, this.adrButton2, this.dirButton2, this.cmdButton2);
            } else {
                this.updateLocoFields(nceReply, 0, this.locoRosterBox3, this.locoTextField3, this.adrButton3, this.dirButton3, this.cmdButton3);
                this.updateLocoFields(nceReply, 2, this.locoRosterBox4, this.locoTextField4, this.adrButton4, this.dirButton4, this.cmdButton4);
                this.updateLocoFields(nceReply, 4, this.locoRosterBox5, this.locoTextField5, this.adrButton5, this.dirButton5, this.cmdButton5);
                this.updateLocoFields(nceReply, 6, this.locoRosterBox6, this.locoTextField6, this.adrButton6, this.dirButton6, this.cmdButton6);
                this.consistStatus.setText(Bundle.getMessage("EditStateOKAY"));
                this.checkForRosterMatch();
                this.saveLoadButton.setEnabled(this.canLoad());
            }
            if (this.locoPosition == 0 || this.locoPosition == 1) {
                ++this.locoPosition;
                this.readConsistMemory(this.consistNum, this.locoPosition);
            }
        }
    }

    private void checkForRosterMatch() {
        this.exactMatch = false;
        if (!this.verifyRosterMatch) {
            this.nceConsistRosterEntry = this.nceConsistRoster.entryFromTitle(this.locoTextField1.getText());
        }
        if (this.nceConsistRosterEntry == null) {
            if (this.checkBoxConsist.isSelected() && !this.locoTextField1.getText().equals("")) {
                this.consistStatus.setText(Bundle.getMessage("EditStateUNKNOWN"));
            } else {
                this.textConRoadName.setText("");
            }
            this.textConRoadNumber.setText("");
            this.textConModel.setText("");
            return;
        }
        if (this.consistRosterMatch(this.nceConsistRosterEntry)) {
            this.exactMatch = true;
            if (this.verifyRosterMatch) {
                this.queueError(4);
            }
            this.verifyRosterMatch = false;
        } else {
            if (this.verifyRosterMatch) {
                this.queueError(3);
            }
            this.verifyRosterMatch = false;
            if (!this.consistRosterPartialMatch(this.nceConsistRosterEntry)) {
                this.textConRoadName.setText("");
                this.textConRoadNumber.setText("");
                this.textConModel.setText("");
            }
        }
    }

    private boolean updateLocoFields(NceReply r, int index, JComboBox<Object> locoRosterBox, JTextField locoTextField, JButton adrButton, JButton dirButton, JButton cmdButton) {
        String locoAddrText = this.getLocoAddrText(r, index);
        boolean locoType = this.getLocoAddressType(r, index);
        String locoDirection = this.getLocoDirection(dirButton);
        locoTextField.setText(locoAddrText);
        locoRosterBox.setSelectedIndex(0);
        if (locoAddrText.equals("") || locoAddrText.equals(Bundle.getMessage("REPLACE_LOCO"))) {
            locoRosterBox.setEnabled(true);
            locoTextField.setEnabled(true);
            cmdButton.setText(Bundle.getMessage("KeyADD"));
            cmdButton.setVisible(true);
            cmdButton.setEnabled(false);
            cmdButton.setToolTipText(Bundle.getMessage("ToolTipAdd"));
            dirButton.setText(Bundle.getMessage("KeyQUESTION"));
            dirButton.setEnabled(true);
            adrButton.setText(Bundle.getMessage("KeyLONG"));
            adrButton.setEnabled(true);
            return false;
        }
        locoTextField.setText(locoAddrText);
        locoRosterBox.setEnabled(false);
        locoTextField.setEnabled(false);
        cmdButton.setEnabled(true);
        dirButton.setText(locoDirection);
        dirButton.setEnabled(false);
        adrButton.setText(locoType ? Bundle.getMessage("KeyLONG") : Bundle.getMessage("KeySHORT"));
        adrButton.setEnabled(false);
        if (locoTextField == this.locoTextField1 || locoTextField == this.locoTextField2) {
            cmdButton.setText(Bundle.getMessage("KeyREPLACE"));
            cmdButton.setToolTipText("Press to delete and replace this loco");
        } else {
            cmdButton.setText(Bundle.getMessage("KeyDELETE"));
            cmdButton.setToolTipText("Press to delete this loco from consist");
        }
        return true;
    }

    private void modifyLocoFields(JComboBox<Object> locoRosterBox, JTextField locoTextField, JButton adrButton, JButton dirButton, JButton cmdButton) {
        if (this.validLocoAdr(locoTextField.getText()) < 0) {
            return;
        }
        byte consistNumber = (byte)this.validConsist(this.consistTextField.getText());
        if (consistNumber < 0) {
            return;
        }
        if (locoTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_EnterLocoB4Add"), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return;
        }
        this.refresh = true;
        int locoAddr = this.getLocoAddr(locoTextField, adrButton);
        if (cmdButton.getText().equals(Bundle.getMessage("KeyDELETE"))) {
            this.sendNceBinaryCommand(locoAddr, (byte)16, (byte)0);
        } else if (cmdButton.getText().equals(Bundle.getMessage("KeyREPLACE"))) {
            this.refresh = false;
            locoRosterBox.setEnabled(true);
            locoTextField.setText("");
            locoTextField.setEnabled(true);
            adrButton.setText(Bundle.getMessage("KeyLONG"));
            adrButton.setEnabled(true);
            dirButton.setText(Bundle.getMessage("KeyQUESTION"));
            dirButton.setEnabled(true);
            cmdButton.setText(Bundle.getMessage("KeyADD"));
            cmdButton.setToolTipText(Bundle.getMessage("ToolTipAdd"));
            if (locoTextField == this.locoTextField1) {
                this.sendNceBinaryCommand(16383, (byte)11, consistNumber);
                this.clearCancelButton.setEnabled(false);
            } else {
                this.sendNceBinaryCommand(16383, (byte)13, consistNumber);
            }
            this.sendNceBinaryCommand(locoAddr, (byte)16, (byte)0);
        } else {
            if (dirButton.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_SetDirB4Consist"), Bundle.getMessage("DIALOG_NceConsist"), 0);
                this.refresh = false;
                return;
            }
            this.sendNceBinaryCommand(locoAddr, (byte)16, (byte)0);
            this.verifyLocoAddr(locoAddr);
            if (locoTextField == this.locoTextField1) {
                if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
                    this.sendNceBinaryCommand(locoAddr, (byte)11, consistNumber);
                }
                if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
                    this.sendNceBinaryCommand(locoAddr, (byte)10, consistNumber);
                }
            } else if (locoTextField == this.locoTextField2) {
                if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
                    this.sendNceBinaryCommand(locoAddr, (byte)13, consistNumber);
                }
                if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
                    this.sendNceBinaryCommand(locoAddr, (byte)12, consistNumber);
                }
            } else if (this.locoSearch) {
                this.verifyType = dirButton.getText().equals(Bundle.getMessage("KeyFWD")) ? 2 : 4;
            } else {
                if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
                    this.sendNceBinaryCommand(locoAddr, (byte)15, consistNumber);
                }
                if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
                    this.sendNceBinaryCommand(locoAddr, (byte)14, consistNumber);
                }
            }
        }
    }

    private void fullLoad() {
        this.refresh = true;
        this.loadOneLine(this.locoRosterBox1, this.locoTextField1, this.adrButton1, this.dirButton1, this.cmdButton1);
        this.loadOneLine(this.locoRosterBox2, this.locoTextField2, this.adrButton2, this.dirButton2, this.cmdButton2);
        this.loadOneLine(this.locoRosterBox3, this.locoTextField3, this.adrButton3, this.dirButton3, this.cmdButton3);
        this.loadOneLine(this.locoRosterBox4, this.locoTextField4, this.adrButton4, this.dirButton4, this.cmdButton4);
        this.loadOneLine(this.locoRosterBox5, this.locoTextField5, this.adrButton5, this.dirButton5, this.cmdButton5);
        this.loadOneLine(this.locoRosterBox6, this.locoTextField6, this.adrButton6, this.dirButton6, this.cmdButton6);
        this.changeButtons(false);
    }

    private void loadOneLine(JComboBox<Object> locoRosterBox, JTextField locoTextField, JButton adrButton, JButton dirButton, JButton cmdButton) {
        if (locoTextField.getText().equals("")) {
            return;
        }
        if (this.validLocoAdr(locoTextField.getText()) < 0) {
            return;
        }
        byte cN = (byte)this.validConsist(this.consistTextField.getText());
        if (cN < 0) {
            return;
        }
        int locoAddr = this.getLocoAddr(locoTextField, adrButton);
        if (dirButton.getText().equals(Bundle.getMessage("KeyQUESTION"))) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_SetDirB4Consist"), Bundle.getMessage("DIALOG_NceConsist"), 0);
            return;
        }
        this.sendNceBinaryCommand(locoAddr, (byte)16, (byte)0);
        if (locoTextField == this.locoTextField1) {
            this.sendNceBinaryCommand(locoAddr, (byte)11, cN);
            this.sendNceBinaryCommand(locoAddr, (byte)17, (byte)0);
            if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
                this.sendNceBinaryCommand(locoAddr, (byte)11, cN);
            }
            if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
                this.sendNceBinaryCommand(locoAddr, (byte)10, cN);
            }
        } else if (locoTextField == this.locoTextField2) {
            if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
                this.sendNceBinaryCommand(locoAddr, (byte)13, cN);
            }
            if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
                this.sendNceBinaryCommand(locoAddr, (byte)12, cN);
            }
        } else {
            if (dirButton.getText().equals(Bundle.getMessage("KeyFWD"))) {
                this.sendNceBinaryCommand(locoAddr, (byte)15, cN);
            }
            if (dirButton.getText().equals(Bundle.getMessage("KeyREV"))) {
                this.sendNceBinaryCommand(locoAddr, (byte)14, cN);
            }
        }
    }

    private int getLocoAddr(JTextField locoTextField, JButton adrButton) {
        int locoAddr = Integer.parseInt(locoTextField.getText());
        if (locoAddr >= 128) {
            locoAddr += 49152;
        } else if (adrButton.getText().equals(Bundle.getMessage("KeyLONG"))) {
            locoAddr += 49152;
        }
        return locoAddr;
    }

    private void sendNceMessage(byte[] b, int replyLength) {
        NceMessage m = NceMessage.createBinaryMessage(this.tc, b, replyLength);
        ++this.waiting;
        this.replyLen = replyLength;
        this.tc.sendNceMessage(m, this);
    }

    private boolean getLocoAddressType(NceReply r, int i) {
        int rC = r.getElement(i);
        return (rC &= 0xC0) == 192;
    }

    private String getLocoAddrText(NceReply r, int i) {
        int rC_u = r.getElement(i++);
        int rC = rC_u << 8 & 0x3F00;
        int rC_l = r.getElement(i);
        rC += rC_l & 0xFF;
        String locoAddrText = "";
        if (rC_u != 0 || rC_l != 0) {
            locoAddrText = Integer.toString(rC);
        }
        if (rC == 16383) {
            locoAddrText = Bundle.getMessage("REPLACE_LOCO");
        }
        return locoAddrText;
    }

    private String getLocoDirection(JButton dirButton) {
        if (this.newConsist) {
            return Bundle.getMessage("KeyQUESTION");
        }
        return dirButton.getText();
    }

    private void verifyLocoAddr(int locoAddr) {
        this.verifyType = 1;
        if (this.checkBoxVerify.isSelected()) {
            this.locoVerifyList[0] = locoAddr;
            this.locoVerifyList[1] = 0;
            this.locoSearch = true;
            this.consistNumVerify = 0;
        }
    }

    private boolean verifyAllLocoAddr() {
        this.verifyType = 8;
        if (this.checkBoxVerify.isSelected()) {
            int i = 0;
            if (!this.locoTextField1.getText().equals("") && this.validLocoAdr(this.locoTextField1.getText()) > 0) {
                this.locoVerifyList[i++] = this.getLocoAddr(this.locoTextField1, this.adrButton1);
            }
            if (!this.locoTextField2.getText().equals("") && this.validLocoAdr(this.locoTextField2.getText()) > 0) {
                this.locoVerifyList[i++] = this.getLocoAddr(this.locoTextField2, this.adrButton2);
            }
            if (!this.locoTextField3.getText().equals("") && this.validLocoAdr(this.locoTextField3.getText()) > 0) {
                this.locoVerifyList[i++] = this.getLocoAddr(this.locoTextField3, this.adrButton3);
            }
            if (!this.locoTextField4.getText().equals("") && this.validLocoAdr(this.locoTextField4.getText()) > 0) {
                this.locoVerifyList[i++] = this.getLocoAddr(this.locoTextField4, this.adrButton4);
            }
            if (!this.locoTextField5.getText().equals("") && this.validLocoAdr(this.locoTextField5.getText()) > 0) {
                this.locoVerifyList[i++] = this.getLocoAddr(this.locoTextField5, this.adrButton5);
            }
            if (!this.locoTextField6.getText().equals("") && this.validLocoAdr(this.locoTextField6.getText()) > 0) {
                this.locoVerifyList[i++] = this.getLocoAddr(this.locoTextField6, this.adrButton6);
            } else {
                this.locoVerifyList[i] = 0;
            }
            this.locoSearch = true;
            this.consistNumVerify = 0;
            this.consistStatus.setText(Bundle.getMessage("EditStateVERIFY"));
            this.readConsistMemory(this.consistNumVerify, 0);
            return true;
        }
        return false;
    }

    private void addLocoRow(JComponent col1, JComponent col2, JComponent col3, JComponent col4, JComponent col5, JComponent col6, int row) {
        this.addItem(col1, 0, row);
        this.addItem(col2, 1, row);
        this.addItem(col3, 2, row);
        this.addItem(col4, 3, row);
        this.addItem(col5, 4, row);
        this.addItem(col6, 5, row);
    }

    private void addItem(JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        this.add((Component)c, gc);
    }

    private void addButtonAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.buttonActionPerformed(e);
            }
        });
    }

    private void addCheckBoxAction(JCheckBox cb) {
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.checkBoxActionPerformed(e);
            }
        });
    }

    private void enableAllLocoRows(boolean flag) {
        this.enableLocoRow(flag, this.locoTextField1, this.locoRosterBox1, this.adrButton1, this.dirButton1, this.cmdButton1);
        this.enableLocoRow(flag, this.locoTextField2, this.locoRosterBox2, this.adrButton2, this.dirButton2, this.cmdButton2);
        this.enableLocoRow(flag, this.locoTextField3, this.locoRosterBox3, this.adrButton3, this.dirButton3, this.cmdButton3);
        this.enableLocoRow(flag, this.locoTextField4, this.locoRosterBox4, this.adrButton4, this.dirButton4, this.cmdButton4);
        this.enableLocoRow(flag, this.locoTextField5, this.locoRosterBox5, this.adrButton5, this.dirButton5, this.cmdButton5);
        this.enableLocoRow(flag, this.locoTextField6, this.locoRosterBox6, this.adrButton6, this.dirButton6, this.cmdButton6);
    }

    private void enableLocoRow(boolean flag, JTextField locoTextField, JComboBox<Object> locoRosterBox, JButton adrButton, JButton dirButton, JButton cmdButton) {
        locoTextField.setEnabled(flag);
        locoRosterBox.setEnabled(flag);
        adrButton.setEnabled(flag);
        dirButton.setEnabled(flag);
        cmdButton.setEnabled(flag);
    }

    private void initLocoFields() {
        this.initLocoRow(1, "Lead", this.textLoco1, this.locoTextField1, this.locoRosterBox1, this.adrButton1, this.dirButton1, this.cmdButton1);
        this.initLocoRow(2, "Rear", this.textLoco2, this.locoTextField2, this.locoRosterBox2, this.adrButton2, this.dirButton2, this.cmdButton2);
        this.initLocoRow(3, "Mid 1", this.textLoco3, this.locoTextField3, this.locoRosterBox3, this.adrButton3, this.dirButton3, this.cmdButton3);
        this.initLocoRow(4, "Mid 2", this.textLoco4, this.locoTextField4, this.locoRosterBox4, this.adrButton4, this.dirButton4, this.cmdButton4);
        this.initLocoRow(5, "Mid 3", this.textLoco5, this.locoTextField5, this.locoRosterBox5, this.adrButton5, this.dirButton5, this.cmdButton5);
        this.initLocoRow(6, "Mid 4", this.textLoco6, this.locoTextField6, this.locoRosterBox6, this.adrButton6, this.dirButton6, this.cmdButton6);
    }

    private void initLocoRow(int row, String s, JLabel textLoco, JTextField locoTextField, JComboBox<Object> locoRosterBox, JButton adrButton, JButton dirButton, JButton cmdButton) {
        textLoco.setText(s);
        textLoco.setVisible(true);
        adrButton.setText(Bundle.getMessage("KeyLONG"));
        adrButton.setVisible(true);
        adrButton.setEnabled(false);
        adrButton.setToolTipText("Press to change address type");
        adrButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.buttonActionAdrPerformed(e);
            }
        });
        locoRosterBox.setVisible(true);
        locoRosterBox.setEnabled(false);
        locoRosterBox.setToolTipText("Select loco from roster");
        locoRosterBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.locoSelected(e);
            }
        });
        dirButton.setText(Bundle.getMessage("KeyQUESTION"));
        dirButton.setVisible(true);
        dirButton.setEnabled(false);
        dirButton.setToolTipText("Press to change loco direction");
        dirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.buttonActionDirPerformed(e);
            }
        });
        cmdButton.setText(Bundle.getMessage("KeyADD"));
        cmdButton.setVisible(true);
        cmdButton.setEnabled(false);
        cmdButton.setToolTipText(Bundle.getMessage("ToolTipAdd"));
        cmdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.buttonActionCmdPerformed(e);
            }
        });
        locoTextField.setText("");
        locoTextField.setEnabled(false);
        locoTextField.setToolTipText("Enter loco address");
        locoTextField.setMaximumSize(new Dimension(locoTextField.getMaximumSize().width, locoTextField.getPreferredSize().height));
    }

    private void initConsistRoster(JComboBox<String> conRosterBox) {
        conRosterBox.insertItemAt("", 0);
        conRosterBox.setSelectedIndex(0);
        conRosterBox.setVisible(true);
        conRosterBox.setEnabled(false);
        conRosterBox.setToolTipText("Select consist from roster");
        this.consistRosterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceConsistEditPanel.this.consistRosterSelected(e);
            }
        };
        conRosterBox.addActionListener(this.consistRosterListener);
    }

    private void queueError(int errorCode) {
        log.debug("queue warning/error message: {}", (Object)errorCode);
        if (this.errorCode != 0) {
            log.debug("multiple errors reported {}", (Object)this.errorCode);
            return;
        }
        this.errorCode = errorCode;
        Thread errorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                NceConsistEditPanel.this.reportError();
            }
        });
        errorThread.setName("Report Error");
        errorThread.start();
    }

    public void reportError() {
        switch (this.errorCode) {
            case 1: {
                JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("DIALOG_LocoInUse1")) + " " + this.locoNumInUse + " " + Bundle.getMessage("DIALOG_LocoInUse2") + " " + this.consistNumVerify, Bundle.getMessage("DIALOG_NceConsist"), 0);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_NoEmptyConsist"), Bundle.getMessage("DIALOG_NceConsist"), 0);
                break;
            }
            case 3: {
                if (JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("DIALOG_RosterNotMatch")) + " " + this.getRosterText(this.nceConsistRosterEntry), Bundle.getMessage("DIALOG_NceContinue"), 0) != 0) {
                    if (JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("DIALOG_RosterNotMatch1")) + " " + this.nceConsistRosterEntry.getId() + " " + Bundle.getMessage("DIALOG_RosterNotMatch2") + " " + this.nceConsistRosterEntry.getConsistNumber() + "\n " + Bundle.getMessage("DIALOG_RosterNotMatch3"), Bundle.getMessage("DIALOG_NceReset"), 0) == 0) {
                        this.nceConsistRosterEntry.setConsistNumber(Bundle.getMessage("CLEARED"));
                    }
                    this.changeButtons(false);
                    this.saveLoadButton.setEnabled(this.canLoad());
                    break;
                }
                this.changeButtons(true);
                this.loadFullRoster(this.nceConsistRosterEntry);
                this.saveLoadButton.setEnabled(this.canLoad());
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("DIALOG_ConsistWasLoaded"), Bundle.getMessage("DIALOG_NceConsist"), 2);
                break;
            }
            default: {
                log.error("Error code out of range");
            }
        }
        this.errorCode = 0;
    }

    private String getRosterText(NceConsistRosterEntry nceConsistRosterEntry) {
        return "\n\n" + Bundle.getMessage("ROSTER_ConsistNum") + " " + nceConsistRosterEntry.getConsistNumber() + "\n" + Bundle.getMessage("ROSTER_LeadLoco") + " " + nceConsistRosterEntry.getLoco1DccAddress() + " " + this.shortHandConvertDTD(nceConsistRosterEntry.getLoco1Direction()) + "\n" + Bundle.getMessage("ROSTER_RearLoco") + " " + nceConsistRosterEntry.getLoco2DccAddress() + " " + this.shortHandConvertDTD(nceConsistRosterEntry.getLoco2Direction()) + "\n" + Bundle.getMessage("ROSTER_Mid1Loco") + " " + nceConsistRosterEntry.getLoco3DccAddress() + " " + this.shortHandConvertDTD(nceConsistRosterEntry.getLoco3Direction()) + "\n" + Bundle.getMessage("ROSTER_Mid2Loco") + " " + nceConsistRosterEntry.getLoco4DccAddress() + " " + this.shortHandConvertDTD(nceConsistRosterEntry.getLoco4Direction()) + "\n" + Bundle.getMessage("ROSTER_Mid3Loco") + " " + nceConsistRosterEntry.getLoco5DccAddress() + " " + this.shortHandConvertDTD(nceConsistRosterEntry.getLoco5Direction()) + "\n" + Bundle.getMessage("ROSTER_Mid4Loco") + " " + nceConsistRosterEntry.getLoco6DccAddress() + " " + this.shortHandConvertDTD(nceConsistRosterEntry.getLoco6Direction());
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Consist Editor", (WindowInterface)new JmriJFrameInterface(), NceConsistEditPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

