/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.consist.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistBackup
extends Thread
implements NceListener {
    private static final int CONSIST_LNTH = 16;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean fileValid = false;
    private final byte[] nceConsistData = new byte[16];
    JLabel textConsist = new JLabel();
    JLabel consistNumber = new JLabel();
    private NceTrafficController tc = null;
    private int workingNumConsists = -1;
    private static final Logger log = LoggerFactory.getLogger(NceConsistBackup.class);

    public NceConsistBackup(NceTrafficController t) {
        this.tc = t;
        this.workingNumConsists = 96;
        if (this.tc.getUsbSystem() != 0) {
            this.workingNumConsists = 16;
        }
    }

    @Override
    public void run() {
        String fileName;
        String fileNameLC;
        JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        File fs = new File("NCE consist backup.txt");
        fc.setSelectedFile(fs);
        int retVal = fc.showSaveDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        if (fc.getFileFilter() != fc.getAcceptAllFileFilter() && !(fileNameLC = (fileName = f.getAbsolutePath()).toLowerCase()).endsWith(".txt")) {
            fileName = String.valueOf(fileName) + ".txt";
            f = new File(fileName);
        }
        if (f.exists() && JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("FileExists"), f.getName()), Bundle.getMessage("OverwriteFile"), 2) != 0) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PrintWriter fileOut = new PrintWriter((Writer)new BufferedWriter(new FileWriter(f)), true);){
                if (JOptionPane.showConfirmDialog(null, Bundle.getMessage("BackupTakesAwhile"), Bundle.getMessage("NceConsistBackup"), 0) != 0) {
                    fileOut.close();
                    return;
                }
                JPanel ps = new JPanel();
                JmriJFrame fstatus = new JmriJFrame(Bundle.getMessage("NceConsistBackup"));
                fstatus.setLocationRelativeTo(null);
                fstatus.setSize(300, 100);
                fstatus.getContentPane().add(ps);
                ps.add(this.textConsist);
                ps.add(this.consistNumber);
                this.textConsist.setText(Bundle.getMessage("ConsistLineNumber"));
                this.textConsist.setVisible(true);
                this.consistNumber.setVisible(true);
                this.waiting = 0;
                this.fileValid = true;
                int consistNum = 0;
                while (consistNum < this.workingNumConsists) {
                    this.consistNumber.setText(Integer.toString(consistNum));
                    fstatus.setVisible(true);
                    this.getNceConsist(consistNum);
                    if (!this.fileValid) {
                        consistNum = this.workingNumConsists;
                    }
                    if (this.fileValid) {
                        StringBuilder buf = new StringBuilder();
                        buf.append(":").append(Integer.toHexString(62720 + consistNum * 16));
                        int i = 0;
                        while (i < 16) {
                            buf.append(" ").append(StringUtil.twoHexFromInt(this.nceConsistData[i++]));
                            buf.append(StringUtil.twoHexFromInt(this.nceConsistData[i]));
                            ++i;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("consist {}", (Object)buf.toString());
                        }
                        fileOut.println(buf.toString());
                    }
                    ++consistNum;
                }
                if (this.fileValid) {
                    String line = ":0000";
                    fileOut.println(line);
                }
                fileOut.flush();
                fileOut.close();
                fstatus.dispose();
                if (this.fileValid) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("SuccessfulBackup"), Bundle.getMessage("NceConsistBackup"), 1);
                } else {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("BackupFailed"), Bundle.getMessage("NceConsistBackup"), 0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void getNceConsist(int cN) {
        NceMessage m = this.readConsistMemory(cN);
        this.tc.sendNceMessage(m, this);
        this.readWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readWait() {
        int waitcount = 30;
        while (this.waiting > 0) {
            NceConsistBackup nceConsistBackup = this;
            synchronized (nceConsistBackup) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (waitcount-- >= 0) continue;
            log.error("read timeout");
            this.fileValid = false;
            return false;
        }
        return true;
    }

    private NceMessage readConsistMemory(int consistNum) {
        int nceConsistAddr = consistNum * 16 + 62720;
        this.replyLen = 16;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceConsistAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        int i = 0;
        while (i < 16) {
            this.nceConsistData[i] = (byte)r.getElement(i);
            ++i;
        }
        --this.waiting;
        NceConsistBackup nceConsistBackup = this;
        synchronized (nceConsistBackup) {
            this.notify();
        }
    }
}

