/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.clockmon;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.clockmon.Bundle;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockMonPanel
extends NcePanel
implements NceListener {
    public static final int CS_CLOCK_MEM_ADDR = 56320;
    public static final int CS_CLOCK_MEM_SIZE = 16;
    public static final int CS_CLOCK_SCALE = 0;
    public static final int CS_CLOCK_TICK = 1;
    public static final int CS_CLOCK_SECONDS = 2;
    public static final int CS_CLOCK_MINUTES = 3;
    public static final int CS_CLOCK_HOURS = 4;
    public static final int CS_CLOCK_AMPM = 5;
    public static final int CS_CLOCK_1224 = 6;
    public static final int CS_CLOCK_STATUS = 13;
    public static final int CMD_CLOCK_SET_TIME_SIZE = 3;
    public static final int CMD_CLOCK_SET_PARAM_SIZE = 2;
    public static final int CMD_CLOCK_SET_RUN_SIZE = 1;
    public static final int CMD_CLOCK_SET_REPLY_SIZE = 1;
    public static final int CMD_MEM_SET_REPLY_SIZE = 1;
    public static final int MAX_ERROR_ARRAY = 4;
    public static final double MIN_POLLING_INTERVAL = 1.0;
    public static final double MAX_POLLING_INTERVAL = 120.0;
    public static final double DEFAULT_POLLING_INTERVAL = 5.0;
    public static final double TARGET_SYNC_DELAY = 55.0;
    public static final int SYNCMODE_OFF = 0;
    public static final int SYNCMODE_NCE_MASTER = 1;
    public static final int SYNCMODE_INTERNAL_MASTER = 2;
    public static final int WAIT_CMD_EXECUTION = 1000;
    private static final long MAX_SECONDS_IN_DAY = 86400L;
    private static final double ESTIMATED_NCE_RATE_FACTOR = 0.92;
    DecimalFormat fiveDigits = new DecimalFormat("0.00000");
    DecimalFormat fourDigits = new DecimalFormat("0.0000");
    DecimalFormat threeDigits = new DecimalFormat("0.000");
    DecimalFormat twoDigits = new DecimalFormat("0.00");
    private int waiting = 0;
    private int clockMode = 0;
    private boolean waitingForCmdRead = false;
    private boolean waitingForCmdStop = false;
    private boolean waitingForCmdStart = false;
    private boolean waitingForCmdRatio = false;
    private boolean waitingForCmdTime = false;
    private boolean waitingForCmd1224 = false;
    private boolean updateTimeFromRead = false;
    private boolean updateRatioFromRead = false;
    private boolean updateFormatFromRead = false;
    private boolean updateStatusFromRead = false;
    private NceReply lastClockReadPacket = null;
    private int nceLastHour;
    private int nceLastMinute;
    private int nceLastSecond;
    private int nceLastRatio;
    private boolean nceLastAmPm;
    private boolean nceLast1224;
    private boolean nceLastRunning;
    private double internalLastRatio;
    private boolean internalLastRunning;
    private double pollingInterval = 5.0;
    private final ArrayList<Double> priorDiffs = new ArrayList();
    private final ArrayList<Double> priorOffsetErrors = new ArrayList();
    private final ArrayList<Double> priorCorrections = new ArrayList();
    private double syncInterval = 55.0;
    private int internalSyncInitStateCounter = 0;
    private int internalSyncRunStateCounter = 0;
    private double ncePidGainPv = 0.04;
    private double ncePidGainIv = 0.01;
    private double ncePidGainDv = 0.005;
    private final double intPidGainPv = 0.02;
    private final double intPidGainIv = 0.001;
    private final double intPidGainDv = 0.01;
    private final double rateChgMinimum = 0.001;
    private int nceSyncInitStateCounter = 0;
    private int nceSyncRunStateCounter = 0;
    private int alarmDisplayStateCounter = 0;
    Timebase internalClock;
    Timer timerDisplayUpdate = null;
    Timer alarmSyncUpdate = null;
    JTextField hours = new JTextField("  00");
    JTextField minutes = new JTextField("  00");
    JTextField seconds = new JTextField("  00");
    JTextField rateNce = new JTextField("   1");
    JTextField amPm = new JTextField(2);
    JCheckBox twentyFour = new JCheckBox(Bundle.getMessage("CheckBox24HourFormat"));
    JTextField status = new JTextField(10);
    JRadioButton setSyncModeNceMaster = new JRadioButton(Bundle.getMessage("ClockModeNCE"));
    JRadioButton setSyncModeInternalMaster = new JRadioButton(Bundle.getMessage("ClockModeInternal"));
    JRadioButton setSyncModeOff = new JRadioButton(Bundle.getMessage("ClockModeIndependent"));
    JTextField internalDisplayStatus = new JTextField(60);
    JTextField nceDisplayStatus = new JTextField(60);
    JTextField pollingSpeed = new JTextField(5);
    JTextField ncePidGainP = new JTextField(7);
    JTextField ncePidGainI = new JTextField(7);
    JTextField ncePidGainD = new JTextField(7);
    JTextField intPidGainP = new JTextField(7);
    JTextField intPidGainI = new JTextField(7);
    JTextField intPidGainD = new JTextField(7);
    transient PropertyChangeListener minuteChangeListener;
    JButton setSyncButton = new JButton(Bundle.getMessage("SetSyncMode"));
    JButton setClockButton = new JButton(Bundle.getMessage("SetHoursMinutes"));
    JButton setRatioButton = new JButton(Bundle.getMessage("SetRatio"));
    JButton set1224Button = new JButton(Bundle.getMessage("Set12/24Mode"));
    JButton setStopNceButton = new JButton(Bundle.getMessage("StopNceClock"));
    JButton setStartNceButton = new JButton(Bundle.getMessage("StartNceClock"));
    JButton readButton = new JButton(Bundle.getMessage("ReadAll"));
    JButton setPollingSpeedButton = new JButton(Bundle.getMessage("SetInterfaceUpdRate"));
    JButton setPidButton = new JButton(Bundle.getMessage("SetPid"));
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(ClockMonPanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            try {
                this.initComponents((NceSystemConnectionMemo)context);
            }
            catch (Exception exception) {
                log.error("NceClockMon initContext failed");
            }
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.clockmon.ClockMonFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("TitleNceClockMonitor"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getNceTrafficController();
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel pane2 = new JPanel();
        GridBagLayout gLayout = new GridBagLayout();
        GridBagConstraints gConstraints = new GridBagConstraints();
        Border pane2Border = BorderFactory.createEtchedBorder();
        TitledBorder pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("InternalClockStatusBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.add(this.internalDisplayStatus);
        this.internalDisplayStatus.setEditable(false);
        this.internalDisplayStatus.setBorder(BorderFactory.createEmptyBorder());
        this.add(pane2);
        pane2 = new JPanel();
        pane2Border = BorderFactory.createEtchedBorder();
        pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("NceClockStatusBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.add(this.nceDisplayStatus);
        this.nceDisplayStatus.setEditable(false);
        this.nceDisplayStatus.setBorder(BorderFactory.createEmptyBorder());
        this.add(pane2);
        pane2 = new JPanel();
        pane2Border = BorderFactory.createEtchedBorder();
        pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("SetClockValuesBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.add(new JLabel(Bundle.getMessage("LabelTime")));
        pane2.add(this.hours);
        pane2.add(new JLabel(Bundle.getMessage("LabelTimeSep")));
        pane2.add(this.minutes);
        pane2.add(new JLabel(Bundle.getMessage("LabelTimeSep")));
        pane2.add(this.seconds);
        this.seconds.setEditable(false);
        pane2.add(new JLabel(" "));
        pane2.add(this.amPm);
        this.amPm.setEditable(false);
        pane2.add(new JLabel(" "));
        pane2.add(this.setClockButton);
        this.add(pane2);
        pane2 = new JPanel();
        pane2Border = BorderFactory.createEtchedBorder();
        pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("SetClockRatioBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.add(new JLabel(Bundle.getMessage("LabelRatio")));
        pane2.add(this.rateNce);
        pane2.add(new JLabel(Bundle.getMessage("LabelToOne")));
        pane2.add(this.setRatioButton);
        this.add(pane2);
        pane2 = new JPanel();
        pane2Border = BorderFactory.createEtchedBorder();
        pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("SetClock12/24ModeBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.add(this.twentyFour);
        pane2.add(new JLabel(" "));
        pane2.add(this.set1224Button);
        this.add(pane2);
        pane2 = new JPanel();
        pane2Border = BorderFactory.createEtchedBorder();
        pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("InterfaceCommandBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.setLayout(gLayout);
        gConstraints.gridx = 0;
        gConstraints.gridy = 0;
        gConstraints.gridwidth = 1;
        gConstraints.gridheight = 1;
        gConstraints.ipadx = 10;
        gConstraints.ipady = 1;
        gConstraints.insets = new Insets(1, 1, 1, 1);
        pane2.add((Component)this.setStartNceButton, gConstraints);
        ++gConstraints.gridx;
        pane2.add((Component)this.setStopNceButton, gConstraints);
        ++gConstraints.gridx;
        pane2.add((Component)this.readButton, gConstraints);
        ButtonGroup modeGroup = new ButtonGroup();
        modeGroup.add(this.setSyncModeInternalMaster);
        modeGroup.add(this.setSyncModeNceMaster);
        modeGroup.add(this.setSyncModeOff);
        gConstraints.gridx = 0;
        ++gConstraints.gridy;
        gConstraints.gridwidth = 3;
        pane2.add((Component)this.setSyncModeNceMaster, gConstraints);
        ++gConstraints.gridy;
        pane2.add((Component)this.setSyncModeInternalMaster, gConstraints);
        ++gConstraints.gridy;
        pane2.add((Component)this.setSyncModeOff, gConstraints);
        ++gConstraints.gridy;
        pane2.add((Component)this.setSyncButton, gConstraints);
        this.setSyncModeInternalMaster.setEnabled(true);
        this.setSyncModeNceMaster.setEnabled(true);
        if (this.tc.getUsbSystem() != 0) {
            this.setSyncModeInternalMaster.setEnabled(false);
            this.setSyncModeNceMaster.setEnabled(false);
        }
        this.add(pane2);
        pane2 = new JPanel();
        pane2Border = BorderFactory.createEtchedBorder();
        pane2Titled = BorderFactory.createTitledBorder(pane2Border, Bundle.getMessage("InterfaceUpdRateBorderText"));
        pane2.setBorder(pane2Titled);
        pane2.add(new JLabel(Bundle.getMessage("InterfaceUpdRate")));
        pane2.add(new JLabel(" "));
        pane2.add(this.pollingSpeed);
        this.pollingSpeed.setText("" + this.pollingInterval);
        pane2.add(new JLabel(" "));
        pane2.add(new JLabel(Bundle.getMessage("InterfaceUpdRateSufix")));
        pane2.add(new JLabel(" "));
        pane2.add(this.setPollingSpeedButton);
        this.add(pane2);
        this.readButton.addActionListener(a -> this.issueReadAllRequest());
        this.setClockButton.addActionListener(a -> this.issueClockSet(Integer.parseInt(this.hours.getText().trim()), Integer.parseInt(this.minutes.getText().trim()), Integer.parseInt(this.seconds.getText().trim())));
        this.setStopNceButton.addActionListener(a -> this.issueClockStop());
        this.setStartNceButton.addActionListener(a -> this.issueClockStart());
        this.setRatioButton.addActionListener(a -> this.changeNceClockRatio());
        this.set1224Button.addActionListener(a -> this.issueClock1224(this.twentyFour.isSelected()));
        this.setSyncButton.addActionListener(a -> this.changeSyncMode());
        this.setPollingSpeedButton.addActionListener(a -> this.changePollingSpeed(Double.parseDouble(this.pollingSpeed.getText().trim())));
        this.setPidButton.addActionListener(a -> this.changePidValues());
        if (this.clockMode == 0) {
            this.setSyncModeOff.setSelected(true);
        }
        if (this.clockMode == 2) {
            this.setSyncModeInternalMaster.setSelected(true);
        }
        if (this.clockMode == 1) {
            this.setSyncModeNceMaster.setSelected(true);
        }
        this.setSize(400, 300);
        this.internalClock = InstanceManager.getNullableDefault(Timebase.class);
        if (this.internalClock == null) {
            log.error("No Timebase Instance; clock will not run");
            return;
        }
        this.minuteChangeListener = e -> this.newInternalMinute();
        this.internalClock.addMinuteChangeListener(this.minuteChangeListener);
        this.alarmDisplayUpdateHandler();
    }

    @Override
    public void message(NceMessage m) {
        log.error("clockmon message received: {}", (Object)m);
    }

    @Override
    public void reply(NceReply r) {
        log.trace("nceReplyCatcher() waiting: {} watingForRead: {} waitingForCmdTime: {} waitingForCmd1224: {} waitingForCmdRatio: {} waitingForCmdStop: {} waitingForCmdStart: {}", new Object[]{this.waiting, this.waitingForCmdRead, this.waitingForCmdTime, this.waitingForCmd1224, this.waitingForCmdRatio, this.waitingForCmdStop, this.waitingForCmdStart});
        if (this.waiting <= 0) {
            log.debug("unexpected response");
            return;
        }
        --this.waiting;
        if (this.waitingForCmdRead && r.getNumDataElements() == 16) {
            this.readClockPacket(r);
            this.waitingForCmdRead = false;
            this.callStateMachines();
            return;
        }
        if (this.waitingForCmdTime) {
            if (r.getNumDataElements() != 1) {
                log.error("NCE clock command reply, invalid length:{}", (Object)r.getNumDataElements());
                return;
            }
            this.waitingForCmdTime = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("NCE set clock replied: {}", (Object)r.getElement(0));
            }
            this.callStateMachines();
            return;
        }
        if (r.getNumDataElements() != 1) {
            log.error("NCE clock command reply, invalid length:{}", (Object)r.getNumDataElements());
            return;
        }
        if (this.waitingForCmd1224) {
            this.waitingForCmd1224 = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("NCE set clock 12/24 replied:{}", (Object)r.getElement(0));
            }
            this.callStateMachines();
            return;
        }
        if (this.waitingForCmdRatio) {
            this.waitingForCmdRatio = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("NCE clock ratio cmd replied:{}", (Object)r.getElement(0));
            }
            this.callStateMachines();
            return;
        }
        if (this.waitingForCmdStop) {
            this.waitingForCmdStop = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("NCE clock stop cmd replied:{}", (Object)r.getElement(0));
            }
            this.callStateMachines();
            return;
        }
        if (this.waitingForCmdStart) {
            this.waitingForCmdStart = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("NCE clock start cmd replied:{}", (Object)r.getElement(0));
            }
            this.callStateMachines();
            return;
        }
        log.debug("unexpected response");
    }

    private void callStateMachines() {
        if (this.internalSyncInitStateCounter > 0) {
            this.internalSyncInitStates();
        }
        if (this.internalSyncRunStateCounter > 0) {
            this.internalSyncRunStates();
        }
        if (this.nceSyncInitStateCounter > 0) {
            this.nceSyncInitStates();
        }
        if (this.nceSyncRunStateCounter > 0) {
            this.nceSyncRunStates();
        }
        if (this.alarmDisplayStateCounter > 0) {
            this.alarmDisplayStates();
        }
    }

    private void readClockPacket(NceReply r) {
        NceReply priorClockReadPacket = this.lastClockReadPacket;
        int priorNceRatio = this.nceLastRatio;
        boolean priorNceRunning = this.nceLastRunning;
        this.lastClockReadPacket = r;
        this.nceLastHour = r.getElement(4) & 0xFF;
        this.nceLastMinute = r.getElement(3) & 0xFF;
        this.nceLastSecond = r.getElement(2) & 0xFF;
        this.nceLast1224 = r.getElement(6) == 1;
        this.nceLastAmPm = r.getElement(5) == 65;
        int sc = r.getElement(0) & 0xFF;
        if (sc > 0) {
            this.nceLastRatio = 250 / sc;
        }
        if (this.clockMode == 1 && priorClockReadPacket != null && priorNceRatio != this.nceLastRatio) {
            if (log.isDebugEnabled()) {
                log.debug("NCE Change Rate from cab: prior vs last: {} vs {}", (Object)priorNceRatio, (Object)this.nceLastRatio);
            }
            this.rateNce.setText("" + this.nceLastRatio);
            this.nceSyncInitStateCounter = 1;
            this.nceSyncInitStates();
        }
        boolean bl = this.nceLastRunning = r.getElement(13) != 1;
        if (this.clockMode == 1 && priorClockReadPacket != null && priorNceRunning != this.nceLastRunning) {
            if (log.isDebugEnabled()) {
                log.debug("NCE Stop/Start: prior vs last: {} vs {}", (Object)priorNceRunning, (Object)this.nceLastRunning);
            }
            this.nceSyncInitStateCounter = this.nceLastRunning ? 1 : -1;
            this.nceSyncInitStates();
            this.internalClock.setRun(this.nceLastRunning);
        }
        this.updateSettingsFromNce();
    }

    private void alarmDisplayUpdateHandler() {
        if (this.pollingInterval < 1.0 || this.pollingInterval > 120.0) {
            log.error("reseting pollingInterval, invalid value:{}", (Object)this.pollingInterval);
            this.pollingInterval = 5.0;
        }
        this.alarmSetup();
        this.alarmDisplayStates();
        this.updateInternalClockDisplay();
    }

    private void alarmSetup() {
        if (this.timerDisplayUpdate == null) {
            this.timerDisplayUpdate = new Timer((int)(this.pollingInterval * 1000.0), e -> this.alarmDisplayUpdateHandler());
        }
        this.timerDisplayUpdate.setInitialDelay(1000);
        this.timerDisplayUpdate.setRepeats(true);
        this.timerDisplayUpdate.start();
        this.alarmDisplayStateCounter = 1;
    }

    private void alarmSyncInit() {
        int delay = 1000;
        if (this.alarmSyncUpdate == null) {
            this.alarmSyncUpdate = new Timer(delay, e -> this.alarmSyncHandler());
            if (this.clockMode == 2) {
                delay = (int)(this.syncInterval * 1000.0 / (double)this.nceLastRatio);
                this.alarmSyncUpdate.setRepeats(false);
            }
            if (this.clockMode == 1) {
                delay = 10000;
                this.alarmSyncUpdate.setRepeats(true);
            }
            this.alarmSyncUpdate.setInitialDelay(delay);
            this.alarmSyncUpdate.setDelay(delay);
            this.alarmSyncUpdate.stop();
        }
    }

    private void alarmSyncStart() {
        Date now = this.internalClock.getTime();
        if (this.alarmSyncUpdate == null) {
            this.alarmSyncInit();
        }
        int delay = 60000;
        if (this.clockMode == 2) {
            delay = this.syncInterval - 3.0 - (double)now.getSeconds() <= 0.0 ? 10 : (int)((this.syncInterval - (double)now.getSeconds()) * 1000.0 / this.internalClock.getRate());
        }
        if (this.clockMode == 1) {
            delay = 10000;
        }
        this.alarmSyncUpdate.setDelay(delay);
        this.alarmSyncUpdate.setInitialDelay(delay);
        this.alarmSyncUpdate.start();
        log.trace("alarmSyncStart delay: {} @ {}", (Object)delay, (Object)now);
    }

    private void alarmSyncHandler() {
        if (this.clockMode == 2) {
            this.internalSyncRunStateCounter = 1;
            this.internalSyncRunStates();
        }
        if (this.clockMode == 1 && this.nceSyncRunStateCounter == 0) {
            this.nceSyncRunStateCounter = 1;
            this.nceSyncRunStates();
        }
        if (this.clockMode == 0) {
            this.alarmSyncUpdate.stop();
        }
        if (this.alarmDisplayStateCounter == 0) {
            this.alarmDisplayStateCounter = 1;
            this.alarmDisplayStates();
        }
    }

    private void alarmDisplayStates() {
        int priorState;
        do {
            log.trace("alarmDisplayStates: before: {} {}", (Object)this.alarmDisplayStateCounter, (Object)this.internalClock.getTime());
            priorState = this.alarmDisplayStateCounter;
            switch (this.alarmDisplayStateCounter) {
                case 0: {
                    break;
                }
                case 1: {
                    this.internalClockStatusCheck();
                    this.issueReadOnlyRequest();
                    ++this.alarmDisplayStateCounter;
                    break;
                }
                case 2: {
                    if (this.waitingForCmdRead) break;
                    ++this.alarmDisplayStateCounter;
                    break;
                }
                case 3: {
                    this.alarmDisplayStateCounter = 0;
                    this.updateNceClockDisplay();
                    this.updateInternalClockDisplay();
                    break;
                }
                default: {
                    log.warn("Unexpected alarmDisplayStateCounter {} in alarmDisplayStates", (Object)this.alarmDisplayStateCounter);
                }
            }
            log.trace("alarmDisplayStates: after: {} {}", (Object)this.alarmDisplayStateCounter, (Object)this.internalClock.getTime());
        } while (priorState != this.alarmDisplayStateCounter);
    }

    private double getNceTime() {
        double nceTime = 0.0;
        if (this.lastClockReadPacket != null) {
            nceTime = (double)(this.lastClockReadPacket.getElement(4) * 3600 + this.lastClockReadPacket.getElement(3) * 60 + this.lastClockReadPacket.getElement(2)) + (double)this.lastClockReadPacket.getElement(1) * 0.25;
        }
        return nceTime;
    }

    private Date getNceDate() {
        Date now = this.internalClock.getTime();
        if (this.lastClockReadPacket != null) {
            now.setHours(this.lastClockReadPacket.getElement(4));
            now.setMinutes(this.lastClockReadPacket.getElement(3));
            now.setSeconds(this.lastClockReadPacket.getElement(2));
        }
        return now;
    }

    private double getIntTime() {
        Date now = this.internalClock.getTime();
        int ms = (int)(now.getTime() % 1000L);
        int ss = now.getSeconds();
        int mm = now.getMinutes();
        int hh = now.getHours();
        log.trace("getIntTime: {}:{}:{}.{}", new Object[]{hh, mm, ss, ms});
        return hh * 60 * 60 + mm * 60 + ss + ms / 1000;
    }

    private void changeNceClockRatio() {
        try {
            int newRatio = Integer.parseInt(this.rateNce.getText().trim());
            this.issueClockRatio(newRatio);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Invalid value: {}", (Object)this.rateNce.getText().trim());
        }
    }

    private void internalSyncInitStates() {
        int priorState;
        Date now = this.internalClock.getTime();
        block20: do {
            if (this.internalSyncInitStateCounter != 0) {
                log.trace("internalSyncInitStates begin: {} @ {}", (Object)this.internalSyncInitStateCounter, (Object)now);
            }
            priorState = this.internalSyncInitStateCounter;
            switch (this.internalSyncInitStateCounter) {
                case 0: {
                    break;
                }
                case -1: {
                    this.alarmSyncUpdate.stop();
                    this.internalSyncInitStateCounter = 0;
                    this.internalSyncRunStateCounter = 0;
                    this.setClockButton.setEnabled(true);
                    this.setRatioButton.setEnabled(true);
                    this.set1224Button.setEnabled(true);
                    this.setStopNceButton.setEnabled(true);
                    this.setStartNceButton.setEnabled(true);
                    break;
                }
                case -3: {
                    this.internalSyncRunStateCounter = 0;
                    this.alarmSyncUpdate.stop();
                    this.issueClockStop();
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case -2: {
                    if (this.waitingForCmdStop) continue block20;
                    this.internalSyncInitStateCounter = 0;
                    break;
                }
                case 1: {
                    this.priorDiffs.clear();
                    this.priorCorrections.clear();
                    this.priorOffsetErrors.clear();
                    this.syncInterval = 55.0;
                    this.setClockButton.setEnabled(false);
                    this.setRatioButton.setEnabled(false);
                    this.set1224Button.setEnabled(false);
                    this.setStopNceButton.setEnabled(false);
                    this.setStartNceButton.setEnabled(false);
                    this.issueClockStop();
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 2: {
                    if (this.waitingForCmdStop) continue block20;
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 3: {
                    this.issueClockRatio((int)this.internalClock.getRate());
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 4: {
                    if (this.waitingForCmdRatio) continue block20;
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 5: {
                    this.issueClock1224(true);
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 6: {
                    if (this.waitingForCmd1224) continue block20;
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 7: {
                    now = this.internalClock.getTime();
                    this.issueClockSet(now.getHours(), now.getMinutes(), now.getSeconds());
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 8: {
                    if (this.waitingForCmdTime) continue block20;
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 9: {
                    this.issueClockStart();
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 10: {
                    if (this.waitingForCmdStart) continue block20;
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 11: {
                    this.issueReadOnlyRequest();
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 12: {
                    if (this.waitingForCmdRead) continue block20;
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 13: {
                    this.updateNceClockDisplay();
                    this.updateInternalClockDisplay();
                    this.alarmSyncStart();
                    ++this.internalSyncInitStateCounter;
                    break;
                }
                case 14: {
                    this.internalSyncInitStateCounter = 0;
                    this.internalSyncRunStateCounter = 1;
                    log.trace("internalSyncState: init done");
                    break;
                }
                default: {
                    this.internalSyncInitStateCounter = 0;
                    log.error("Uninitialized value: internalSyncInitStateCounter");
                }
            }
        } while (priorState != this.internalSyncInitStateCounter);
    }

    private void internalSyncRunStates() {
        int priorState;
        Date now = this.internalClock.getTime();
        if (this.internalSyncRunStateCounter != 0) {
            log.trace("internalSyncRunStates: {} @ {}", (Object)this.internalSyncRunStateCounter, (Object)now);
        }
        block9: do {
            priorState = this.internalSyncRunStateCounter;
            switch (this.internalSyncRunStateCounter) {
                case -1: {
                    this.internalSyncInitStateCounter = -1;
                    this.internalSyncInitStates();
                    break;
                }
                case 1: {
                    this.internalClockStatusCheck();
                    this.issueReadOnlyRequest();
                    ++this.internalSyncRunStateCounter;
                    break;
                }
                case 2: 
                case 6: {
                    if (this.waitingForCmdRead) continue block9;
                    ++this.internalSyncRunStateCounter;
                    break;
                }
                case 3: {
                    double nceTime = this.getNceTime();
                    double intTime = this.getIntTime();
                    double diffTime = intTime - nceTime;
                    if (log.isTraceEnabled()) {
                        log.trace("syncStates2 begin. NCE: {}{}:{}{}:{}{} Internal: {}{}:{}{}:{}{} diff: {}", new Object[]{this.nceLastHour / 10, this.nceLastHour - this.nceLastHour / 10 * 10, this.nceLastMinute / 10, this.nceLastMinute - this.nceLastMinute / 10 * 10, this.nceLastSecond / 10, this.nceLastSecond - this.nceLastSecond / 10 * 10, now.getHours() / 10, now.getHours() - now.getHours() / 10 * 10, now.getMinutes() / 10, now.getMinutes() - now.getMinutes() / 10 * 10, now.getSeconds() / 10, now.getSeconds() - now.getSeconds() / 10 * 10, diffTime});
                    }
                    while (this.priorDiffs.size() >= 4) {
                        this.priorDiffs.remove(0);
                    }
                    this.priorDiffs.add(diffTime);
                    this.recomputeInternalSync();
                    this.issueClockSet(now.getHours(), now.getMinutes(), (int)this.syncInterval);
                    ++this.internalSyncRunStateCounter;
                    break;
                }
                case 4: {
                    if (this.waitingForCmdTime) continue block9;
                    ++this.internalSyncRunStateCounter;
                    break;
                }
                case 5: {
                    this.issueReadOnlyRequest();
                    ++this.internalSyncRunStateCounter;
                    break;
                }
                case 7: {
                    double intTime = now.getSeconds();
                    double diffTime = 55.0 - intTime;
                    while (this.priorOffsetErrors.size() >= 4) {
                        this.priorOffsetErrors.remove(0);
                    }
                    this.priorOffsetErrors.add(diffTime);
                    this.recomputeOffset();
                    if (log.isTraceEnabled()) {
                        log.trace("syncState compute offset. NCE: {}{}:{}{}:{}{} Internal: {}{}:{}{}:{}{}", new Object[]{this.nceLastHour / 10, this.nceLastHour - this.nceLastHour / 10 * 10, this.nceLastMinute / 10, this.nceLastMinute - this.nceLastMinute / 10 * 10, this.nceLastSecond / 10, this.nceLastSecond - this.nceLastSecond / 10 * 10, now.getHours() / 10, now.getHours() - now.getHours() / 10 * 10, now.getMinutes() / 10, now.getMinutes() - now.getMinutes() / 10 * 10, now.getSeconds() / 10, now.getSeconds() - now.getSeconds() / 10 * 10});
                    }
                    this.internalSyncRunStateCounter = 0;
                    break;
                }
                default: {
                    this.internalSyncRunStateCounter = 0;
                }
            }
        } while (priorState != this.internalSyncRunStateCounter);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="testing for change from stored value")
    private void internalClockStatusCheck() {
        if (this.clockMode == 2) {
            if (this.internalLastRunning != this.internalClock.getRun()) {
                this.internalSyncInitStateCounter = this.internalClock.getRun() ? 1 : -3;
                this.internalSyncInitStates();
            }
            if (this.internalLastRatio != this.internalClock.getRate()) {
                this.internalSyncInitStateCounter = 1;
                this.internalSyncInitStates();
            }
        }
        this.internalLastRunning = this.internalClock.getRun();
        this.internalLastRatio = this.internalClock.getRate();
    }

    private void changePidValues() {
        double p = 0.0;
        double i = 0.0;
        double d = 0.0;
        boolean ok = true;
        try {
            p = Double.parseDouble(this.ncePidGainP.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Invalid value: {}", (Object)this.ncePidGainP.getText().trim());
            ok = false;
        }
        try {
            i = Double.parseDouble(this.ncePidGainI.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Invalid value: {}", (Object)this.ncePidGainP.getText().trim());
            ok = false;
        }
        try {
            d = Double.parseDouble(this.ncePidGainD.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Invalid value: {}", (Object)this.ncePidGainP.getText().trim());
            ok = false;
        }
        if (ok) {
            if (p < 0.0) {
                p = 0.0;
            }
            if (p > 1.0) {
                p = 1.0;
            }
            if (i < 0.0) {
                i = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            this.ncePidGainPv = p;
            this.ncePidGainIv = i;
            this.ncePidGainDv = d;
            this.ncePidGainP.setText(this.fiveDigits.format(p));
            this.ncePidGainI.setText(this.fiveDigits.format(i));
            this.ncePidGainD.setText(this.fiveDigits.format(d));
        }
    }

    private void recomputeOffset() {
        double sumDiff = 0.0;
        if (this.priorOffsetErrors.size() > 1) {
            sumDiff = this.priorOffsetErrors.get(0) + this.priorOffsetErrors.get(1);
        }
        double avgDiff = sumDiff / 2.0;
        this.syncInterval += avgDiff;
        if (this.syncInterval < 30.0) {
            this.syncInterval = 30.0;
        }
        if (this.syncInterval > 58.0) {
            this.syncInterval = 58.0;
        }
        if (log.isTraceEnabled()) {
            Date now = this.internalClock.getTime();
            StringBuilder txt = new StringBuilder("");
            int i = 0;
            while (i < this.priorOffsetErrors.size()) {
                txt.append(" ").append(this.priorOffsetErrors.get(i));
                ++i;
            }
            log.trace("priorOffsetErrors: {}", (Object)txt);
            log.trace("syncOffset: {} avgDiff: {} @ {}", new Object[]{this.syncInterval, avgDiff, now});
        }
    }

    private void recomputeInternalSync() {
        double sumDiff = 0.0;
        double currError = 0.0;
        if (this.priorDiffs.size() > 0) {
            currError = this.priorDiffs.get(this.priorDiffs.size() - 1);
        }
        int i = 0;
        while (i < this.priorDiffs.size()) {
            sumDiff += this.priorDiffs.get(i).doubleValue();
            ++i;
        }
        double corrDiff = 0.0;
        if (this.priorCorrections.size() > 0) {
            corrDiff = this.priorCorrections.get(this.priorCorrections.size() - 1) - this.priorCorrections.get(0);
        }
        double pCorr = currError * 0.02;
        double iCorr = sumDiff * 0.001;
        double dCorr = corrDiff * 0.01;
        double newRateAdj = pCorr + iCorr + dCorr;
        while (this.priorCorrections.size() >= 4) {
            this.priorCorrections.remove(0);
        }
        this.priorCorrections.add(newRateAdj);
        this.syncInterval += newRateAdj;
        if (this.syncInterval > 57.0) {
            this.syncInterval = 57.0;
        }
        if (this.syncInterval < 40.0) {
            this.syncInterval = 40.0;
        }
        if (log.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder("");
            int i2 = 0;
            while (i2 < this.priorDiffs.size()) {
                txt.append(" ").append(this.priorDiffs.get(i2));
                ++i2;
            }
            log.trace("priorDiffs: {}", (Object)txt);
            log.trace("syncInterval: {} pCorr: {} iCorr: {} dCorr: {}", new Object[]{this.syncInterval, this.fiveDigits.format(pCorr), this.fiveDigits.format(iCorr), this.fiveDigits.format(dCorr)});
        }
    }

    private void recomputeNceSync() {
        double sumDiff = 0.0;
        double currError = 0.0;
        double diffError = 0.0;
        if (this.priorDiffs.size() > 0) {
            currError = this.priorDiffs.get(this.priorDiffs.size() - 1);
            diffError = this.priorDiffs.get(this.priorDiffs.size() - 1) - this.priorDiffs.get(0);
        }
        int i = 0;
        while (i < this.priorDiffs.size()) {
            sumDiff += this.priorDiffs.get(i).doubleValue();
            ++i;
        }
        double corrDiff = 0.0;
        if (this.priorCorrections.size() > 0) {
            corrDiff = this.priorCorrections.get(this.priorCorrections.size() - 1) - this.priorCorrections.get(0);
        }
        double pCorr = currError * this.ncePidGainPv;
        double iCorr = diffError * this.ncePidGainIv;
        double dCorr = corrDiff * this.ncePidGainDv;
        double newRateAdj = pCorr + iCorr + dCorr;
        while (this.priorCorrections.size() >= 4) {
            this.priorCorrections.remove(0);
        }
        this.priorCorrections.add(newRateAdj);
        double oldInternalRate = this.internalClock.getRate();
        double newInternalRate = oldInternalRate + newRateAdj;
        if (Math.abs(currError) > 60.0) {
            this.nceSyncInitStateCounter = 1;
            this.nceSyncInitStates();
        } else if (Math.abs(oldInternalRate - newInternalRate) >= 0.001) {
            try {
                this.internalClock.setRate(newInternalRate);
                if (log.isDebugEnabled()) {
                    log.debug("changing internal rate: {}", (Object)newInternalRate);
                }
            }
            catch (TimebaseRateException timebaseRateException) {
                log.error("recomputeNceSync: Failed setting new internal rate: {}", (Object)newInternalRate);
                this.nceSyncInitStateCounter = 1;
                this.nceSyncInitStates();
            }
        }
        if (log.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder("");
            int i2 = this.priorDiffs.size() - 1;
            while (i2 >= 0) {
                txt.append(" ").append(this.threeDigits.format(this.priorDiffs.get(i2)));
                --i2;
            }
            log.trace("priorDiffs: {}", (Object)txt);
            txt = new StringBuilder("");
            i2 = this.priorCorrections.size() - 1;
            while (i2 >= 0) {
                txt.append(" ").append(this.threeDigits.format(this.priorCorrections.get(i2)));
                --i2;
            }
            log.trace("priorCorrections: {}", (Object)txt);
            log.trace("currError: {} pCorr: {} iCorr: {} dCorr: {} newInternalRate: {}", new Object[]{this.fiveDigits.format(currError), this.fiveDigits.format(pCorr), this.fiveDigits.format(iCorr), this.fiveDigits.format(dCorr), this.threeDigits.format(newInternalRate)});
        }
    }

    private void changePollingSpeed(double newInterval) {
        if (newInterval < 1.0 || newInterval > 120.0) {
            log.error("reseting pollingInterval, invalid value:{}", (Object)newInterval);
        } else {
            this.pollingInterval = newInterval;
            this.pollingSpeed.setText("" + this.pollingInterval);
            if (this.timerDisplayUpdate == null) {
                this.alarmSetup();
            }
            this.timerDisplayUpdate.setDelay((int)(this.pollingInterval * 1000.0));
        }
    }

    private void changeSyncMode() {
        int oldMode = this.clockMode;
        int newMode = 0;
        if (this.setSyncModeNceMaster.isSelected()) {
            newMode = 1;
        }
        if (this.setSyncModeInternalMaster.isSelected()) {
            newMode = 2;
        }
        if (this.internalClock != null) {
            log.debug("changeSyncMode(): New Mode: {} Old Mode: {}", (Object)newMode, (Object)oldMode);
            if (oldMode != newMode) {
                this.clockMode = 0;
                if (oldMode == 0) {
                    if (newMode == 2) {
                        log.debug("starting Internal mode");
                        this.internalSyncInitStateCounter = 1;
                        this.internalSyncRunStateCounter = 0;
                        this.internalSyncInitStates();
                        this.clockMode = 2;
                    }
                    if (newMode == 1) {
                        log.debug("starting NCE mode");
                        this.nceSyncInitStateCounter = 1;
                        this.nceSyncRunStateCounter = 0;
                        this.nceSyncInitStates();
                        this.clockMode = 1;
                    }
                } else {
                    if (oldMode == 1) {
                        this.nceSyncInitStateCounter = -1;
                        this.nceSyncInitStates();
                        this.internalSyncInitStateCounter = 1;
                        this.internalSyncInitStates();
                    }
                    if (oldMode == 2) {
                        this.internalSyncInitStateCounter = -1;
                        this.internalSyncInitStates();
                        this.nceSyncInitStateCounter = 1;
                        this.nceSyncInitStates();
                    }
                }
            }
        }
    }

    private void nceSyncInitStates() {
        int priorState;
        do {
            if (log.isTraceEnabled()) {
                log.trace("Before nceSyncInitStateCounter: {} {}", (Object)this.nceSyncInitStateCounter, (Object)this.internalClock.getTime());
            }
            priorState = this.nceSyncInitStateCounter;
            switch (this.nceSyncInitStateCounter) {
                case -1: {
                    if (this.alarmSyncUpdate != null) {
                        this.alarmSyncUpdate.stop();
                    }
                    this.priorDiffs.clear();
                    this.priorCorrections.clear();
                    this.nceSyncInitStateCounter = 0;
                    this.nceSyncRunStateCounter = 0;
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    log.debug("Init/Reset NCE Clock Sync");
                    this.nceSyncRunStateCounter = 0;
                    this.internalClock.setRun(false);
                    if (this.alarmSyncUpdate != null) {
                        this.alarmSyncUpdate.stop();
                    }
                    this.priorDiffs.clear();
                    this.priorCorrections.clear();
                    this.issueReadOnlyRequest();
                    ++this.nceSyncInitStateCounter;
                    break;
                }
                case 2: {
                    if (this.waitingForCmdRead) break;
                    ++this.nceSyncInitStateCounter;
                    break;
                }
                case 3: {
                    try {
                        this.internalClock.setRate((double)this.nceLastRatio * 0.92);
                    }
                    catch (TimebaseRateException timebaseRateException) {
                        log.error("nceSyncInitStates: failed to set internal clock rate: {}", (Object)this.nceLastRatio);
                    }
                    this.setInternalClockFromNce();
                    this.internalClock.setRun(true);
                    this.nceSyncInitStateCounter = 0;
                    this.nceSyncRunStateCounter = 1;
                    this.nceSyncRunStates();
                    this.alarmSyncStart();
                    this.updateNceClockDisplay();
                    this.updateInternalClockDisplay();
                    break;
                }
                default: {
                    log.warn("Unexpected nceSyncInitStateCounter {} in nceSyncInitStates", (Object)this.nceSyncInitStateCounter);
                }
            }
            log.trace("After nceSyncInitStateCounter: {} {}", (Object)this.nceSyncInitStateCounter, (Object)this.internalClock.getTime());
        } while (priorState != this.nceSyncInitStateCounter);
    }

    private void nceSyncRunStates() {
        int priorState;
        if (log.isTraceEnabled()) {
            log.trace("Before nceSyncRunStateCounter: {} {}", (Object)this.nceSyncRunStateCounter, (Object)this.internalClock.getTime());
        }
        block6: do {
            priorState = this.nceSyncRunStateCounter;
            switch (this.nceSyncRunStateCounter) {
                case 1: {
                    this.issueReadOnlyRequest();
                    ++this.nceSyncRunStateCounter;
                    break;
                }
                case 2: {
                    if (this.waitingForCmdRead) continue block6;
                    ++this.nceSyncRunStateCounter;
                    break;
                }
                case 3: {
                    double intTime = this.getIntTime();
                    double nceTime = this.getNceTime();
                    double diffTime = nceTime - intTime;
                    if (diffTime > 43200.0) {
                        diffTime = 86400.0 + nceTime - intTime;
                    } else if (diffTime < -43200.0) {
                        diffTime = nceTime;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("new diffTime: {} = {} - {}", new Object[]{diffTime, nceTime, intTime});
                    }
                    while (this.priorDiffs.size() >= 4) {
                        this.priorDiffs.remove(0);
                    }
                    this.priorDiffs.add(diffTime);
                    this.recomputeNceSync();
                    if (this.alarmSyncUpdate == null) {
                        this.alarmSyncInit();
                    }
                    this.updateNceClockDisplay();
                    this.updateInternalClockDisplay();
                    ++this.nceSyncRunStateCounter;
                    break;
                }
                case 4: {
                    this.nceSyncRunStateCounter = 0;
                    break;
                }
                default: {
                    log.warn("Unexpected state {} in nceSyncRunStates", (Object)this.nceSyncRunStateCounter);
                }
            }
        } while (priorState != this.nceSyncRunStateCounter);
        if (log.isTraceEnabled()) {
            log.trace("After nceSyncRunStateCounter: {} {}", (Object)this.nceSyncRunStateCounter, (Object)this.internalClock.getTime());
        }
    }

    private void setInternalClockFromNce() {
        Date newTime = this.getNceDate();
        this.internalClock.setTime(newTime);
        log.debug("setInternalClockFromNce nceClock: {}", (Object)newTime);
    }

    private void updateSettingsFromNce() {
        if (this.updateTimeFromRead) {
            this.hours.setText("" + this.nceLastHour / 10 + (this.nceLastHour - this.nceLastHour / 10 * 10));
            this.minutes.setText("" + this.nceLastMinute / 10 + (this.nceLastMinute - this.nceLastMinute / 10 * 10));
            this.seconds.setText("" + this.nceLastSecond / 10 + (this.nceLastSecond - this.nceLastSecond / 10 * 10));
            if (this.nceLast1224) {
                this.twentyFour.setSelected(true);
                this.amPm.setText(" ");
            } else {
                this.twentyFour.setSelected(false);
                if (this.nceLastAmPm) {
                    this.amPm.setText(Bundle.getMessage("TagAm"));
                } else {
                    this.amPm.setText(Bundle.getMessage("TagPm"));
                }
            }
            this.updateTimeFromRead = false;
        }
        if (this.updateRatioFromRead) {
            this.rateNce.setText("" + this.nceLastRatio);
            this.updateRatioFromRead = false;
        }
        if (this.updateFormatFromRead) {
            if (this.nceLast1224) {
                this.twentyFour.setSelected(true);
            } else {
                this.twentyFour.setSelected(false);
            }
            this.updateFormatFromRead = false;
        }
        if (this.updateStatusFromRead) {
            if (this.nceLastRunning) {
                this.status.setText(Bundle.getMessage("TagRunning"));
            } else {
                this.status.setText(Bundle.getMessage("TagStopped"));
            }
        }
    }

    private void updateNceClockDisplay() {
        String txt = this.nceLastRunning ? Bundle.getMessage("TagRunning") : Bundle.getMessage("TagStopped");
        txt = String.valueOf(txt) + " " + this.nceLastHour / 10 + (this.nceLastHour - this.nceLastHour / 10 * 10) + Bundle.getMessage("LabelTimeSep") + this.nceLastMinute / 10 + (this.nceLastMinute - this.nceLastMinute / 10 * 10) + Bundle.getMessage("LabelTimeSep") + this.nceLastSecond / 10 + (this.nceLastSecond - this.nceLastSecond / 10 * 10);
        if (!this.nceLast1224) {
            txt = this.nceLastAmPm ? String.valueOf(txt) + " " + Bundle.getMessage("TagAm") : String.valueOf(txt) + " " + Bundle.getMessage("TagPm");
        }
        txt = String.valueOf(txt) + " " + Bundle.getMessage("LabelRatio") + " " + this.nceLastRatio + Bundle.getMessage("LabelToOne");
        if (this.clockMode == 1) {
            txt = String.valueOf(txt) + " " + Bundle.getMessage("TagIsNceMaster");
            double intTime = this.getIntTime();
            double nceTime = this.getNceTime();
            double diffTime = nceTime - intTime;
            txt = String.valueOf(txt) + " " + Bundle.getMessage("ClockError");
            txt = String.valueOf(txt) + " " + this.threeDigits.format(diffTime);
            log.trace("intTime: {} nceTime: {} diffTime: {}", new Object[]{intTime, nceTime, diffTime});
        }
        this.nceDisplayStatus.setText(txt);
    }

    private void updateInternalClockDisplay() {
        String txt = this.internalClock.getRun() ? Bundle.getMessage("TagRunning") : Bundle.getMessage("TagStopped");
        Date now = this.internalClock.getTime();
        txt = String.valueOf(txt) + " " + now.getHours() / 10 + (now.getHours() - now.getHours() / 10 * 10) + Bundle.getMessage("LabelTimeSep") + now.getMinutes() / 10 + (now.getMinutes() - now.getMinutes() / 10 * 10) + Bundle.getMessage("LabelTimeSep") + now.getSeconds() / 10 + (now.getSeconds() - now.getSeconds() / 10 * 10);
        txt = String.valueOf(txt) + " " + Bundle.getMessage("LabelRatio") + " " + this.threeDigits.format(this.internalClock.getRate()) + Bundle.getMessage("LabelToOne");
        if (this.clockMode == 2) {
            txt = String.valueOf(txt) + " " + Bundle.getMessage("TagIsInternalMaster");
            double intTime = this.getIntTime();
            double nceTime = this.getNceTime();
            double diffTime = nceTime - intTime;
            txt = String.valueOf(txt) + " " + Bundle.getMessage("ClockError");
            txt = String.valueOf(txt) + " " + this.threeDigits.format(diffTime);
        }
        this.internalDisplayStatus.setText(txt);
    }

    private void issueReadOnlyRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(56320);
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
    }

    private void issueReadAllRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(56320);
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
        this.updateTimeFromRead = true;
        this.updateRatioFromRead = true;
        this.updateFormatFromRead = true;
        this.updateStatusFromRead = true;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private void issueReadTimeRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(56320);
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
        this.updateTimeFromRead = true;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private void issueReadRatioRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(56320);
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
        this.updateRatioFromRead = true;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private void issueReadFormatRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(56320);
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
        this.updateFormatFromRead = true;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private void issueReadStatusRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(56320);
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
        this.updateStatusFromRead = true;
    }

    private void issueClockSet(int hh, int mm, int ss) {
        this.issueClockSetMem(hh, mm, ss);
    }

    private void issueClockSetMem(int hh, int mm, int ss) {
        byte[] b = new byte[]{(byte)ss, (byte)mm, (byte)hh};
        byte[] cmd = NceBinaryCommand.accMemoryWriteN(56322, b);
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdTime = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueClockRatio(int r) {
        byte[] cmd = NceBinaryCommand.accSetClockRatio(r);
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdRatio = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueClock1224(boolean mode) {
        byte[] cmd = NceBinaryCommand.accSetClock1224(mode);
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmd1224 = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueClockStop() {
        byte[] cmd = NceBinaryCommand.accStopClock();
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdStop = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueClockStart() {
        byte[] cmd = NceBinaryCommand.accStartClock();
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdStart = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    public void newInternalMinute() {
        if (this.lastClockReadPacket != null && this.lastClockReadPacket.getElement(13) == 0 && this.clockMode == 2) {
            this.alarmSyncStart();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        if (this.timerDisplayUpdate != null) {
            this.timerDisplayUpdate.stop();
        }
    }

    @Override
    public void dispose() {
        if (this.timerDisplayUpdate != null) {
            this.timerDisplayUpdate.stop();
            this.timerDisplayUpdate = null;
        }
        InstanceManager.getDefault(Timebase.class).removeMinuteChangeListener(this.minuteChangeListener);
        this.minuteChangeListener = null;
        super.dispose();
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Clock Monitor", (WindowInterface)new JmriJFrameInterface(), ClockMonPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

