/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.cab;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.cab.Bundle;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceShowCabPanel
extends NcePanel
implements NceListener {
    private int replyLen = 0;
    private int waiting = 0;
    private int minCabNum = -1;
    private int maxCabNum = -1;
    private static final int FIRST_TIME_SLEEP = 3000;
    private static final int CAB_MIN_USB = 2;
    private static final int CAB_MIN_PRO = 1;
    private static final int CAB_MAX_USB = 10;
    private static final int CAB_MAX_PRO = 65;
    private static final int CAB_LINE_LEN = 16;
    private static final int CAB_MAX_CABDATA = 66;
    Thread nceCabUpdateThread;
    Thread autoRefreshThread;
    private final int[] cabFlag1Array = new int[66];
    private final Calendar[] cabLastChangeArray = new Calendar[66];
    private final int[] cabSpeedArray = new int[66];
    private final int[] cabFlagsArray = new int[66];
    private final int[] cabLocoArray = new int[66];
    private final boolean[] cabLongShortArray = new boolean[66];
    private final int[] cabConsistArray = new int[66];
    private final int[] cabF0Array = new int[66];
    private final int[] cabF5Array = new int[66];
    private final int[] cabF13Array = new int[66];
    private final int[] cabF21Array = new int[66];
    private final int[][] cabLine1Array = new int[66][16];
    private final int[][] cabLine2Array = new int[66][16];
    private boolean purgeRequested = false;
    private boolean updateRequested = false;
    private int purgeCabId = -1;
    JLabel textNumber = new JLabel(Bundle.getMessage("Number"));
    JLabel textCab = new JLabel(Bundle.getMessage("Type"));
    JLabel textAddrType = new JLabel(Bundle.getMessage("AddrType"));
    JLabel textAddress = new JLabel(Bundle.getMessage("Loco"));
    JLabel textSpeed = new JLabel(Bundle.getMessage("Speed"));
    JLabel textConsist = new JLabel(Bundle.getMessage("Consist"));
    JLabel textConsistPos = new JLabel(Bundle.getMessage("ConsistPos"));
    JLabel textFunctions = new JLabel(Bundle.getMessage("Functions"));
    JLabel textDisplay1 = new JLabel(Bundle.getMessage("Display1"));
    JLabel textDisplay2 = new JLabel(Bundle.getMessage("Display2"));
    JLabel textReply = new JLabel(Bundle.getMessage("Reply"));
    JLabel textStatus = new JLabel("");
    JLabel textLastUsed = new JLabel(Bundle.getMessage("LastUsed"));
    JButton refreshButton = new JButton(Bundle.getMessage("Refresh"));
    JCheckBox checkBoxShowAllCabs = new JCheckBox(Bundle.getMessage("CheckBoxLabelShowAllCabs"));
    JCheckBox checkBoxAutoRefresh = new JCheckBox(Bundle.getMessage("CheckBoxLabelAutoRefresh"));
    DataRow[] cabData = new DataRow[66];
    NceCabTableModel cabModel = new NceCabTableModel(this.cabData);
    JTable cabTable = new JTable(this.cabModel);
    private NceTrafficController tc = null;
    private boolean firstTime = false;
    int recChar = 0;
    int[] recChars = new int[16];
    private static final Logger log = LoggerFactory.getLogger(NceShowCabPanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.cab.NceShowCabFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getNceTrafficController();
        this.minCabNum = 1;
        this.maxCabNum = 65;
        if (this.tc.getUsbSystem() != 0 && (this.tc.getCmdGroups() & 8L) != 0L) {
            this.minCabNum = 2;
            this.maxCabNum = 10;
        }
        int i = this.minCabNum;
        while (i <= this.maxCabNum) {
            this.cabData[i] = new DataRow();
            ++i;
        }
        this.setLayout(new BoxLayout(this, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        p1.setPreferredSize(new Dimension(1000, 40));
        this.refreshButton.setToolTipText(Bundle.getMessage("RefreshToolTip"));
        this.addButtonAction(this.refreshButton);
        this.checkBoxShowAllCabs.setToolTipText(Bundle.getMessage("CheckBoxAllCabsToolTip"));
        this.checkBoxShowAllCabs.setSelected(false);
        this.addCheckBoxAction(this.checkBoxShowAllCabs);
        this.checkBoxAutoRefresh.setToolTipText(Bundle.getMessage("CheckBoxAutoRefreshToolTip"));
        this.checkBoxAutoRefresh.setSelected(false);
        this.addCheckBoxAction(this.checkBoxAutoRefresh);
        this.addItem(p1, this.refreshButton, 2, 1);
        this.addItem(p1, this.checkBoxAutoRefresh, 3, 1);
        this.addItem(p1, this.checkBoxShowAllCabs, 4, 1);
        this.addItem(p1, this.textStatus, 2, 2);
        JScrollPane cabScrollPane = new JScrollPane(this.cabTable);
        this.cabTable.setFillsViewportHeight(true);
        this.cabTable.setAutoResizeMode(0);
        this.cabModel.setShowAllCabs(false);
        this.cabModel.setShowAllFunctions(true);
        this.cabModel.setShowCabDisplay(true);
        int col = 0;
        while (col < this.cabTable.getColumnCount()) {
            int width = this.cabModel.getPreferredWidth(col);
            TableColumn c = this.cabTable.getColumnModel().getColumn(col);
            c.setPreferredWidth(width);
            ++col;
        }
        this.cabTable.setSelectionMode(0);
        cabScrollPane.setHorizontalScrollBarPolicy(32);
        cabScrollPane.setVerticalScrollBarPolicy(22);
        this.setColumnPurgeButton(this.cabTable, 2);
        this.add(p1);
        this.add(cabScrollPane);
        cabScrollPane.setVisible(true);
        this.refreshPanel();
    }

    public void buttonActionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.refreshButton) {
            this.refreshPanel();
        } else {
            log.error("unknown action performed: {}", src);
        }
    }

    public void checkBoxActionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.checkBoxShowAllCabs) {
            this.cabModel.setShowAllCabs(this.checkBoxShowAllCabs.isSelected());
            this.refreshPanel();
        } else if (src == this.checkBoxAutoRefresh) {
            this.autoRefreshPanel();
        } else {
            log.error("unknown checkbox action performed: {}", src);
        }
    }

    public void purgeCab(int cab) {
        if (cab < this.minCabNum || cab > this.maxCabNum) {
            log.error("{}{}", (Object)Bundle.getMessage("ErrorValueRange"), (Object)cab);
            return;
        }
        int act = this.cabFlag1Array[cab] & 2;
        if (act != 2) {
            log.error("{}{}", (Object)Bundle.getMessage("ErrorCabNotActive"), (Object)cab);
        }
        this.cabFlag1Array[cab] = 0;
        this.processMemory(true, true, cab);
    }

    private void autoRefreshPanel() {
        if (this.checkBoxAutoRefresh.isSelected()) {
            this.autoRefreshThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        NceShowCabPanel.this.refreshPanel();
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait(4000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                    }
                }
            });
            this.autoRefreshThread.setName("NCE Show Cabs Auto Refresh");
            this.autoRefreshThread.setPriority(1);
            this.autoRefreshThread.start();
        } else {
            this.autoRefreshThread.interrupt();
        }
    }

    private void refreshPanel() {
        this.processMemory(false, true, -1);
    }

    private void processMemory(boolean doPurge, boolean doUpdate, int cabId) {
        if (doPurge) {
            this.purgeRequested = true;
            this.purgeCabId = cabId;
        }
        if (doUpdate) {
            this.updateRequested = true;
        }
        if (this.nceCabUpdateThread != null && this.nceCabUpdateThread.isAlive()) {
            return;
        }
        this.textStatus.setText(Bundle.getMessage("StatusProcessingMemory"));
        this.nceCabUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (NceShowCabPanel.this.tc.getUsbSystem() == 0) {
                    if (NceShowCabPanel.this.purgeRequested) {
                        NceShowCabPanel.this.cabPurgeSerial();
                    }
                    if (NceShowCabPanel.this.updateRequested) {
                        NceShowCabPanel.this.cabUpdateSerial();
                    }
                } else {
                    if (NceShowCabPanel.this.purgeRequested) {
                        NceShowCabPanel.this.cabPurgeUsb();
                    }
                    if (NceShowCabPanel.this.updateRequested) {
                        NceShowCabPanel.this.cabUpdateUsb();
                    }
                }
            }
        });
        this.nceCabUpdateThread.setName(Bundle.getMessage("ThreadTitle"));
        this.nceCabUpdateThread.setPriority(1);
        this.nceCabUpdateThread.start();
    }

    public void cabPurgeSerial() {
        if (this.purgeCabId <= this.minCabNum || this.purgeCabId >= this.maxCabNum) {
            log.error("purgeCabId out of range: {}", (Object)this.purgeCabId);
        }
        if (this.firstTime) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("Thread unexpectedly interrupted", (Throwable)e);
            }
        }
        this.firstTime = false;
        this.cabFlag1Array[this.purgeCabId] = 0;
        this.writeCabMemory1(this.purgeCabId, 101, 0);
        if (!this.waitNce()) {
            return;
        }
        this.textStatus.setText(MessageFormat.format(Bundle.getMessage("StatusCabPurged"), this.purgeCabId));
    }

    public void cabPurgeUsb() {
        if (this.purgeCabId <= this.minCabNum || this.purgeCabId >= this.maxCabNum) {
            log.error("purgeCabId out of range: {}", (Object)this.purgeCabId);
        }
        if (this.firstTime) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("Thread unexpectedly interrupted", (Throwable)e);
            }
        }
        this.firstTime = false;
        this.cabFlag1Array[this.purgeCabId] = 0;
        this.setUsbCabMemoryPointer(this.purgeCabId, 70);
        if (!this.waitNce()) {
            return;
        }
        this.writeUsbCabMemory1(0);
        if (!this.waitNce()) {
            return;
        }
        this.textStatus.setText(MessageFormat.format(Bundle.getMessage("StatusCabPurged"), this.purgeCabId));
    }

    private void cabUpdateSerial() {
        if (this.firstTime) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("Thread unexpectedly interrupted", (Throwable)e);
            }
        }
        this.firstTime = false;
        int cabsFound = 0;
        int currCabId = this.minCabNum;
        while (currCabId <= this.maxCabNum) {
            this.textStatus.setText(MessageFormat.format(Bundle.getMessage("StatusProcessingCabId"), currCabId));
            this.cabData[currCabId].cabNumber = currCabId;
            int foundChange = 0;
            this.recChar = -1;
            this.readCabMemory1(currCabId, 101);
            if (!this.waitNce()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("ID = {} Read flag1 character {}", (Object)currCabId, (Object)this.recChar);
            }
            if (this.recChar != -1) {
                if (this.recChar != this.cabFlag1Array[currCabId]) {
                    ++foundChange;
                    if (log.isDebugEnabled()) {
                        log.debug("{}: Flag1 {}<->{}", new Object[]{currCabId, this.recChar, this.cabFlag1Array[currCabId]});
                    }
                }
                this.cabFlag1Array[currCabId] = this.recChar;
                if ((this.recChar & 2) == 2) {
                    if (currCabId >= 1 || !this.checkBoxShowAllCabs.isSelected()) {
                        ++cabsFound;
                    }
                    int cabType = this.recChar & 0x81;
                    this.cabData[currCabId].cabType = currCabId == 65 ? Bundle.getMessage("TypeSerial") : (cabType == 0 ? Bundle.getMessage("TypeProCab") : (cabType == 1 ? Bundle.getMessage("TypeCab04") : (cabType == 128 ? Bundle.getMessage("TypeUSB") : (cabType == 129 ? Bundle.getMessage("TypeAIU") : String.valueOf(Bundle.getMessage("TypeUnknownCab")) + ": " + this.recChar))));
                    this.cabData[currCabId].cabNumber = currCabId;
                    if (cabType == 129) {
                        this.readAiuData(currCabId);
                        if (!this.waitNce()) {
                            return;
                        }
                        this.processAiuData(currCabId, this.recChars);
                    } else {
                        boolean aType;
                        this.readCabMemory16(currCabId, 32);
                        if (!this.waitNce()) {
                            return;
                        }
                        int readChar = this.recChars[0];
                        if (this.cabSpeedArray[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Speed {}<->{}", new Object[]{currCabId, readChar, this.cabSpeedArray[currCabId]});
                            }
                        }
                        this.cabSpeedArray[currCabId] = readChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Read speed character {}", (Object)Integer.toString(readChar));
                        }
                        this.cabData[currCabId].locoSpeed = readChar;
                        readChar = this.recChars[3];
                        if (this.cabFlagsArray[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Flags {}<->{}", new Object[]{currCabId, readChar, this.cabFlagsArray[currCabId]});
                            }
                        }
                        this.cabFlagsArray[currCabId] = readChar;
                        int direction = readChar & 4;
                        this.cabData[currCabId].locoDir = direction > 0 ? Bundle.getMessage("DirForward") : Bundle.getMessage("DirReverse");
                        int mode = readChar & 2;
                        this.cabData[currCabId].mode = "";
                        if (cabType != 128) {
                            this.cabData[currCabId].mode = mode > 0 ? "128" : "28";
                        }
                        readChar = this.recChars[1];
                        if (log.isDebugEnabled()) {
                            log.debug("Read address high character {}", (Object)readChar);
                        }
                        int locoAddress = (readChar & 0x3F) * 256;
                        boolean bl = aType = (readChar & 0xC0) == 192;
                        if (this.cabLongShortArray[currCabId] != aType) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Long {}<->{}", new Object[]{currCabId, aType, this.cabLongShortArray[currCabId]});
                            }
                        }
                        this.cabLongShortArray[currCabId] = aType;
                        this.cabData[currCabId].longShort = aType ? Bundle.getMessage("IsLongAddr") : Bundle.getMessage("IsShortAddr");
                        readChar = this.recChars[2];
                        if (log.isDebugEnabled()) {
                            log.debug("Read address low character {}", (Object)readChar);
                        }
                        if (this.cabLocoArray[currCabId] != (locoAddress += readChar & 0xFF)) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Loco {}<->{}", new Object[]{currCabId, locoAddress, this.cabLocoArray[currCabId]});
                            }
                        }
                        this.cabLocoArray[currCabId] = locoAddress;
                        this.cabData[currCabId].locoAddress = locoAddress;
                        readChar = this.recChars[6];
                        if (this.cabConsistArray[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Consist {}<->{}", new Object[]{currCabId, readChar, this.cabConsistArray[currCabId]});
                            }
                        }
                        this.cabConsistArray[currCabId] = readChar;
                        this.cabData[currCabId].consist = readChar;
                        int pos = this.cabFlagsArray[currCabId] & 0x80;
                        this.cabData[currCabId].consistPos = "";
                        if (this.cabConsistArray[currCabId] != 0) {
                            this.cabData[currCabId].consistPos = pos > 0 ? Bundle.getMessage("IsRear") : Bundle.getMessage("IsLead");
                        }
                        if (this.cabF0Array[currCabId] != (readChar = this.recChars[4])) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F0 {}<->{}", new Object[]{currCabId, readChar, this.cabF0Array[currCabId]});
                            }
                        }
                        this.cabF0Array[currCabId] = readChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Function low character {}", (Object)readChar);
                        }
                        this.procFunctions0_4(currCabId, readChar);
                        readChar = this.recChars[5];
                        if (this.cabF5Array[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F5 {}<->{}", new Object[]{currCabId, readChar, this.cabF5Array[currCabId]});
                            }
                        }
                        this.cabF5Array[currCabId] = readChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Function high character {}", (Object)readChar);
                        }
                        this.procFunctions5_12(currCabId, readChar);
                        this.readCabMemory1(currCabId, 82);
                        if (!this.waitNce()) {
                            return;
                        }
                        if (this.cabF13Array[currCabId] != this.recChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F13 {}<->{}", new Object[]{currCabId, this.recChar, this.cabF13Array[currCabId]});
                            }
                        }
                        this.cabF13Array[currCabId] = this.recChar;
                        this.procFunctions13_20(currCabId, this.recChar);
                        this.readCabMemory1(currCabId, 83);
                        if (!this.waitNce()) {
                            return;
                        }
                        if (this.cabF21Array[currCabId] != this.recChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F21 {}<->{}", new Object[]{currCabId, this.recChar, this.cabF21Array[currCabId]});
                            }
                        }
                        this.cabF21Array[currCabId] = this.recChar;
                        this.procFunctions21_28(currCabId, this.recChar);
                        this.readCabMemory16(currCabId, 0);
                        if (!this.waitNce()) {
                            return;
                        }
                        StringBuilder text1 = new StringBuilder();
                        StringBuilder debug1 = new StringBuilder();
                        int i = 0;
                        while (i < 16) {
                            if (this.cabLine1Array[currCabId][i] != this.recChars[i]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine1[{}] {}<->{}", new Object[]{currCabId, i, this.recChars[i], this.cabLine1Array[currCabId][i]});
                                }
                            }
                            this.cabLine1Array[currCabId][i] = this.recChars[i];
                            if (this.recChars[i] >= 32 && this.recChars[i] <= 127) {
                                text1.append((char)this.recChars[i]);
                            } else {
                                text1.append(" ");
                            }
                            debug1.append(" ").append(this.recChars[i]);
                            ++i;
                        }
                        this.cabData[currCabId].text1 = text1.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("TextLine1Debug: {}", (Object)debug1);
                        }
                        this.readCabMemory16(currCabId, 16);
                        if (!this.waitNce()) {
                            return;
                        }
                        StringBuilder text2 = new StringBuilder();
                        StringBuilder debug2 = new StringBuilder();
                        int i2 = 0;
                        while (i2 < 16) {
                            if (this.cabLine2Array[currCabId][i2] != this.recChars[i2]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine2[{}] {}<->{}", new Object[]{currCabId, i2, this.recChars[i2], this.cabLine2Array[currCabId][i2]});
                                }
                            }
                            this.cabLine2Array[currCabId][i2] = this.recChars[i2];
                            if (this.recChars[i2] >= 32 && this.recChars[i2] <= 127) {
                                text2.append((char)this.recChars[i2]);
                            } else {
                                text2.append(" ");
                            }
                            debug2.append(" ").append(this.recChars[i2]);
                            ++i2;
                        }
                        this.cabData[currCabId].text2 = text2.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("TextLine2Debug: {}", (Object)debug2);
                        }
                        Calendar now = Calendar.getInstance();
                        if (foundChange > 0 || this.cabLastChangeArray[currCabId] == null) {
                            this.cabLastChangeArray[currCabId] = now;
                            StringBuilder txt = new StringBuilder();
                            int h = this.cabLastChangeArray[currCabId].get(11);
                            int m = this.cabLastChangeArray[currCabId].get(12);
                            int s = this.cabLastChangeArray[currCabId].get(13);
                            if (h < 10) {
                                txt.append("0");
                            }
                            txt.append(h);
                            txt.append(":");
                            if (m < 10) {
                                txt.append("0");
                            }
                            txt.append(m);
                            txt.append(":");
                            if (s < 10) {
                                txt.append("0");
                            }
                            txt.append(s);
                            this.cabData[currCabId].lastChange = txt.toString();
                        }
                    }
                }
            }
            ++currCabId;
        }
        this.textStatus.setText(String.valueOf(Bundle.getMessage("StatusProcessingDone")) + ". " + MessageFormat.format(Bundle.getMessage("StatusCabsFound"), cabsFound));
        this.cabModel.fireTableDataChanged();
        this.setVisible(true);
        this.repaint();
    }

    private void cabUpdateUsb() {
        if (this.firstTime) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("Thread unexpectedly interrupted", (Throwable)e);
            }
        }
        this.firstTime = false;
        int cabsFound = 0;
        int currCabId = this.minCabNum;
        while (currCabId <= this.maxCabNum) {
            this.textStatus.setText(MessageFormat.format(Bundle.getMessage("StatusProcessingCabId"), currCabId));
            this.cabData[currCabId].cabNumber = currCabId;
            int foundChange = 0;
            this.recChar = -1;
            this.setUsbCabMemoryPointer(currCabId, 70);
            if (!this.waitNce()) {
                return;
            }
            this.readUsbCabMemoryN(1);
            if (!this.waitNce()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("ID = {} Read flag1 character {}", (Object)currCabId, (Object)this.recChar);
            }
            if (this.recChar != -1) {
                if (this.recChar != this.cabFlag1Array[currCabId]) {
                    ++foundChange;
                    if (log.isDebugEnabled()) {
                        log.debug("{}: Flag1 {}<->{}", new Object[]{currCabId, this.recChar, this.cabFlag1Array[currCabId]});
                    }
                }
                this.cabFlag1Array[currCabId] = this.recChar;
                if ((this.recChar & 2) == 2) {
                    if (currCabId >= 1 || !this.checkBoxShowAllCabs.isSelected()) {
                        ++cabsFound;
                    }
                    int cabType = this.recChar & 0x81;
                    switch (cabType) {
                        case 0: {
                            this.cabData[currCabId].cabType = Bundle.getMessage("TypeProCab");
                            break;
                        }
                        case 1: {
                            this.cabData[currCabId].cabType = Bundle.getMessage("TypeCab04");
                            break;
                        }
                        case 128: {
                            this.cabData[currCabId].cabType = Bundle.getMessage("TypeUSB");
                            break;
                        }
                        case 129: {
                            this.cabData[currCabId].cabType = Bundle.getMessage("TypeAIU");
                            break;
                        }
                        default: {
                            this.cabData[currCabId].cabType = String.valueOf(Bundle.getMessage("TypeUnknownCab")) + ": " + this.recChar;
                        }
                    }
                    this.cabData[currCabId].cabNumber = currCabId;
                    if (cabType == 129) {
                        this.readAiuData(currCabId);
                        if (!this.waitNce()) {
                            return;
                        }
                        this.processAiuData(currCabId, this.recChars);
                    } else {
                        boolean aType;
                        this.setUsbCabMemoryPointer(currCabId, 32);
                        if (!this.waitNce()) {
                            return;
                        }
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        int readChar = this.recChar;
                        if (this.cabSpeedArray[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Speed {}<->{}", new Object[]{currCabId, readChar, this.cabSpeedArray[currCabId]});
                            }
                        }
                        this.cabSpeedArray[currCabId] = readChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Read speed character {}", (Object)Integer.toString(readChar));
                        }
                        this.cabData[currCabId].locoSpeed = readChar;
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        readChar = this.recChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Read address high character {}", (Object)readChar);
                        }
                        int locoAddress = (readChar & 0x3F) * 256;
                        boolean bl = aType = (readChar & 0xC0) == 192;
                        if (this.cabLongShortArray[currCabId] != aType) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Long {}<->{}", new Object[]{currCabId, aType, this.cabLongShortArray[currCabId]});
                            }
                        }
                        this.cabLongShortArray[currCabId] = aType;
                        this.cabData[currCabId].longShort = aType ? Bundle.getMessage("IsLongAddr") : Bundle.getMessage("IsShortAddr");
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        readChar = this.recChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Read address low character {}", (Object)readChar);
                        }
                        if (this.cabLocoArray[currCabId] != (locoAddress += readChar & 0xFF)) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Loco {}<->{}", new Object[]{currCabId, locoAddress, this.cabLocoArray[currCabId]});
                            }
                        }
                        this.cabLocoArray[currCabId] = locoAddress;
                        this.cabData[currCabId].locoAddress = locoAddress;
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        readChar = this.recChar;
                        if (this.cabFlagsArray[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Flags {}<->{}", new Object[]{currCabId, readChar, this.cabFlagsArray[currCabId]});
                            }
                        }
                        this.cabFlagsArray[currCabId] = readChar;
                        int direction = readChar & 4;
                        this.cabData[currCabId].locoDir = direction > 0 ? Bundle.getMessage("DirForward") : Bundle.getMessage("DirReverse");
                        int mode = readChar & 2;
                        this.cabData[currCabId].mode = "";
                        if (cabType != 128) {
                            this.cabData[currCabId].mode = mode > 0 ? "128" : "28";
                        }
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        readChar = this.recChar;
                        if (this.cabF0Array[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F0 {}<->{}", new Object[]{currCabId, readChar, this.cabF0Array[currCabId]});
                            }
                        }
                        this.cabF0Array[currCabId] = readChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Function low character {}", (Object)readChar);
                        }
                        this.procFunctions0_4(currCabId, readChar);
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        readChar = this.recChar;
                        if (this.cabF5Array[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F5 {}<->{}", new Object[]{currCabId, readChar, this.cabF5Array[currCabId]});
                            }
                        }
                        this.cabF5Array[currCabId] = readChar;
                        if (log.isDebugEnabled()) {
                            log.debug("Function high character {}", (Object)readChar);
                        }
                        this.procFunctions5_12(currCabId, readChar);
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        readChar = this.recChar;
                        if (this.cabConsistArray[currCabId] != readChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: Consist {}<->{}", new Object[]{currCabId, readChar, this.cabConsistArray[currCabId]});
                            }
                        }
                        this.cabConsistArray[currCabId] = readChar;
                        this.cabData[currCabId].consist = readChar;
                        int pos = this.cabFlagsArray[currCabId] & 0x80;
                        this.cabData[currCabId].consistPos = "";
                        if (this.cabConsistArray[currCabId] != 0) {
                            this.cabData[currCabId].consistPos = pos > 0 ? Bundle.getMessage("IsRear") : Bundle.getMessage("IsLead");
                        }
                        this.setUsbCabMemoryPointer(currCabId, 99);
                        if (!this.waitNce()) {
                            return;
                        }
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        if (this.cabF13Array[currCabId] != this.recChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F13 {}<->{}", new Object[]{currCabId, this.recChar, this.cabF13Array[currCabId]});
                            }
                        }
                        this.cabF13Array[currCabId] = this.recChar;
                        this.procFunctions13_20(currCabId, this.recChar);
                        this.readUsbCabMemoryN(1);
                        if (!this.waitNce()) {
                            return;
                        }
                        if (this.cabF21Array[currCabId] != this.recChar) {
                            ++foundChange;
                            if (log.isDebugEnabled()) {
                                log.debug("{}: F21 {}<->{}", new Object[]{currCabId, this.recChar, this.cabF21Array[currCabId]});
                            }
                        }
                        this.cabF21Array[currCabId] = this.recChar;
                        this.procFunctions21_28(currCabId, this.recChar);
                        this.setUsbCabMemoryPointer(currCabId, 0);
                        if (!this.waitNce()) {
                            return;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        StringBuilder text1 = new StringBuilder();
                        StringBuilder debug1 = new StringBuilder();
                        int ptrData = 0;
                        int ptrCabLine = 0;
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine1Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine1[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine1Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine1Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text1.append((char)this.recChars[ptrData]);
                            } else {
                                text1.append(" ");
                            }
                            debug1.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine1Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine1[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine1Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine1Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text1.append((char)this.recChars[ptrData]);
                            } else {
                                text1.append(" ");
                            }
                            debug1.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine1Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine1[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine1Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine1Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text1.append((char)this.recChars[ptrData]);
                            } else {
                                text1.append(" ");
                            }
                            debug1.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine1Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine1[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine1Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine1Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text1.append((char)this.recChars[ptrData]);
                            } else {
                                text1.append(" ");
                            }
                            debug1.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.cabData[currCabId].text1 = text1.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("TextLine1Debug: {}", (Object)debug1);
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        StringBuilder text2 = new StringBuilder();
                        StringBuilder debug2 = new StringBuilder();
                        ptrCabLine = 0;
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine2Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine2[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine2Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine2Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text2.append((char)this.recChars[ptrData]);
                            } else {
                                text2.append(" ");
                            }
                            debug2.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine2Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine2[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine2Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine2Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text2.append((char)this.recChars[ptrData]);
                            } else {
                                text2.append(" ");
                            }
                            debug2.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine2Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine2[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine2Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine2Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text2.append((char)this.recChars[ptrData]);
                            } else {
                                text2.append(" ");
                            }
                            debug2.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.readUsbCabMemoryN(4);
                        if (!this.waitNce()) {
                            return;
                        }
                        ptrData = 0;
                        while (ptrData < 4) {
                            if (this.cabLine2Array[currCabId][ptrCabLine] != this.recChars[ptrData]) {
                                ++foundChange;
                                if (log.isDebugEnabled()) {
                                    log.debug("{}: CabLine2[{}] {}<->{}", new Object[]{currCabId, ptrCabLine, this.recChars[ptrData], this.cabLine2Array[currCabId][ptrCabLine]});
                                }
                            }
                            this.cabLine2Array[currCabId][ptrCabLine] = this.recChars[ptrData];
                            if (this.recChars[ptrData] >= 32 && this.recChars[ptrData] <= 127) {
                                text2.append((char)this.recChars[ptrData]);
                            } else {
                                text2.append(" ");
                            }
                            debug2.append(" ").append(this.recChars[ptrData]);
                            ++ptrData;
                            ++ptrCabLine;
                        }
                        this.cabData[currCabId].text2 = text2.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("TextLine2Debug: {}", (Object)debug2);
                        }
                        Calendar now = Calendar.getInstance();
                        if (foundChange > 0 || this.cabLastChangeArray[currCabId] == null) {
                            this.cabLastChangeArray[currCabId] = now;
                            StringBuilder txt = new StringBuilder();
                            int h = this.cabLastChangeArray[currCabId].get(11);
                            int m = this.cabLastChangeArray[currCabId].get(12);
                            int s = this.cabLastChangeArray[currCabId].get(13);
                            if (h < 10) {
                                txt.append("0");
                            }
                            txt.append(h);
                            txt.append(":");
                            if (m < 10) {
                                txt.append("0");
                            }
                            txt.append(m);
                            txt.append(":");
                            if (s < 10) {
                                txt.append("0");
                            }
                            txt.append(s);
                            this.cabData[currCabId].lastChange = txt.toString();
                        }
                    }
                }
            }
            ++currCabId;
        }
        this.textStatus.setText(String.valueOf(Bundle.getMessage("StatusProcessingDone")) + ". " + MessageFormat.format(Bundle.getMessage("StatusCabsFound"), cabsFound));
        this.cabModel.fireTableDataChanged();
        this.setVisible(true);
        this.repaint();
    }

    private void procFunctions0_4(int currCabId, int c) {
        this.cabData[currCabId].F0 = (c & 0x10) != 0;
        this.cabData[currCabId].F1 = (c & 1) != 0;
        this.cabData[currCabId].F2 = (c & 2) != 0;
        this.cabData[currCabId].F3 = (c & 4) != 0;
        this.cabData[currCabId].F4 = (c & 8) != 0;
    }

    private void procFunctions5_12(int currCabId, int c) {
        this.cabData[currCabId].F5 = (c & 1) != 0;
        this.cabData[currCabId].F6 = (c & 2) != 0;
        this.cabData[currCabId].F7 = (c & 4) != 0;
        this.cabData[currCabId].F8 = (c & 8) != 0;
        this.cabData[currCabId].F9 = (c & 0x10) != 0;
        this.cabData[currCabId].F10 = (c & 0x20) != 0;
        this.cabData[currCabId].F11 = (c & 0x40) != 0;
        this.cabData[currCabId].F12 = (c & 0x80) != 0;
    }

    private void procFunctions13_20(int currCabId, int c) {
        this.cabData[currCabId].F13 = (c & 1) != 0;
        this.cabData[currCabId].F14 = (c & 2) != 0;
        this.cabData[currCabId].F15 = (c & 4) != 0;
        this.cabData[currCabId].F16 = (c & 8) != 0;
        this.cabData[currCabId].F17 = (c & 0x10) != 0;
        this.cabData[currCabId].F18 = (c & 0x20) != 0;
        this.cabData[currCabId].F19 = (c & 0x40) != 0;
        this.cabData[currCabId].F20 = (c & 0x80) != 0;
    }

    private void procFunctions21_28(int currCabId, int c) {
        this.cabData[currCabId].F21 = (c & 1) != 0;
        this.cabData[currCabId].F22 = (c & 2) != 0;
        this.cabData[currCabId].F23 = (c & 4) != 0;
        this.cabData[currCabId].F24 = (c & 8) != 0;
        this.cabData[currCabId].F25 = (c & 0x10) != 0;
        this.cabData[currCabId].F26 = (c & 0x20) != 0;
        this.cabData[currCabId].F27 = (c & 0x40) != 0;
        this.cabData[currCabId].F28 = (c & 0x80) != 0;
    }

    private void processAiuData(int currCabId, int[] ptr) {
        this.cabData[currCabId].F1 = (ptr[1] & 1) == 0;
        this.cabData[currCabId].F2 = (ptr[1] & 2) == 0;
        this.cabData[currCabId].F3 = (ptr[1] & 4) == 0;
        this.cabData[currCabId].F4 = (ptr[1] & 8) == 0;
        this.cabData[currCabId].F5 = (ptr[1] & 0x10) == 0;
        this.cabData[currCabId].F6 = (ptr[1] & 0x20) == 0;
        this.cabData[currCabId].F7 = (ptr[1] & 0x40) == 0;
        this.cabData[currCabId].F8 = (ptr[1] & 0x80) == 0;
        this.cabData[currCabId].F9 = (ptr[0] & 1) == 0;
        this.cabData[currCabId].F10 = (ptr[0] & 2) == 0;
        this.cabData[currCabId].F11 = (ptr[0] & 4) == 0;
        this.cabData[currCabId].F12 = (ptr[0] & 8) == 0;
        this.cabData[currCabId].F13 = (ptr[0] & 0x10) == 0;
        this.cabData[currCabId].F14 = (ptr[0] & 0x20) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitNce() {
        int count = 100;
        if (log.isDebugEnabled()) {
            log.debug("Going to sleep");
        }
        while (this.waiting > 0) {
            NceShowCabPanel nceShowCabPanel = this;
            synchronized (nceShowCabPanel) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (--count >= 0) continue;
            this.textStatus.setText("Error");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("awake!");
        }
        return true;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Thread wait from main transfer loop")
    public void reply(NceReply r) {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("Receive character");
        }
        if (this.waiting <= 0) {
            log.error("unexpected response. Len: {} code: {}", (Object)r.getNumDataElements(), (Object)r.getElement(0));
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            this.textStatus.setText("error");
            return;
        }
        if (this.replyLen == 1) {
            this.recChar = r.getElement(0);
        }
        if (this.replyLen == 2) {
            i = 0;
            while (i < 2) {
                this.recChars[i] = r.getElement(i);
                ++i;
            }
        }
        if (this.replyLen == 4) {
            i = 0;
            while (i < 4) {
                this.recChars[i] = r.getElement(i);
                ++i;
            }
        }
        if (this.replyLen == 16) {
            i = 0;
            while (i < 16) {
                this.recChars[i] = r.getElement(i);
                ++i;
            }
        }
        NceShowCabPanel nceShowCabPanel = this;
        synchronized (nceShowCabPanel) {
            this.notify();
        }
    }

    private void writeCabMemory1(int cabNum, int offset, int value) {
        int nceCabAddr = this.getNceCabAddr(cabNum, offset);
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryWrite1(nceCabAddr, (byte)value);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void readCabMemory1(int cabNum, int offset) {
        int nceCabAddr = this.getNceCabAddr(cabNum, offset);
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead1(nceCabAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void readCabMemory16(int cabNum, int offset) {
        int nceCabAddr = this.getNceCabAddr(cabNum, offset);
        this.replyLen = 16;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceCabAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        this.tc.sendNceMessage(m, this);
    }

    private int getNceCabAddr(int cabNum, int offset) {
        int nceCabAddr = cabNum < 65 ? cabNum * 256 + 34816 + offset : 60672 + offset;
        return nceCabAddr;
    }

    private void setUsbCabMemoryPointer(int cab, int offset) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbMemoryPointer(cab, offset);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void readUsbCabMemoryN(int num) {
        switch (num) {
            case 1: {
                this.replyLen = 1;
                break;
            }
            case 2: {
                this.replyLen = 2;
                break;
            }
            case 4: {
                this.replyLen = 4;
                break;
            }
            default: {
                log.error("Invalid usb read byte count");
                return;
            }
        }
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbMemoryRead((byte)num);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, this.replyLen);
        this.tc.sendNceMessage(m, this);
    }

    private void writeUsbCabMemory1(int value) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.usbMemoryWrite1((byte)value);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.tc.sendNceMessage(m, this);
    }

    private void readAiuData(int cabId) {
        this.replyLen = 2;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accAiu2Read(cabId);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, this.replyLen);
        this.tc.sendNceMessage(m, this);
    }

    protected void addItem(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        p.add((Component)c, gc);
    }

    protected void addItemLeft(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.anchor = 17;
        p.add((Component)c, gc);
    }

    protected void addItemTop(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.anchor = 11;
        p.add((Component)c, gc);
    }

    private void addButtonAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceShowCabPanel.this.buttonActionPerformed(e);
            }
        });
    }

    private void addCheckBoxAction(JCheckBox b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceShowCabPanel.this.checkBoxActionPerformed(e);
            }
        });
    }

    void setColumnPurgeButton(JTable table, int column) {
        TableColumnModel tcm = table.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton(Bundle.getMessage("ButtonPurgeCab")));
        tcm.getColumn(column).setCellEditor(buttonEditor);
        table.setRowHeight(new JButton((String)new StringBuilder((String)"  ").append((Object)this.cabModel.getValueAt((int)1, (int)column)).toString()).getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)Bundle.getMessage((String)"ButtonPurgeCab")).getPreferredSize().width + 1);
    }

    @Override
    public void dispose() {
        this.cabModel = null;
        this.cabData = null;
        if (this.autoRefreshThread != null) {
            this.autoRefreshThread.interrupt();
        }
        super.dispose();
    }

    static class DataRow {
        int cabNumber;
        String cabType;
        String longShort;
        int locoAddress;
        int locoSpeed;
        String locoDir;
        String mode;
        int consist;
        String consistPos;
        boolean F0;
        boolean F1;
        boolean F2;
        boolean F3;
        boolean F4;
        boolean F5;
        boolean F6;
        boolean F7;
        boolean F8;
        boolean F9;
        boolean F10;
        boolean F11;
        boolean F12;
        boolean F13;
        boolean F14;
        boolean F15;
        boolean F16;
        boolean F17;
        boolean F18;
        boolean F19;
        boolean F20;
        boolean F21;
        boolean F22;
        boolean F23;
        boolean F24;
        boolean F25;
        boolean F26;
        boolean F27;
        boolean F28;
        String text1;
        String text2;
        String lastChange;

        DataRow() {
        }
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Cabs Monitor", (WindowInterface)new JmriJFrameInterface(), NceShowCabPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }

    class NceCabTableModel
    extends AbstractTableModel {
        DataRow[] cabData;
        private final String[] columnNames1LineText = new String[]{Bundle.getMessage("ColHeaderCabId"), Bundle.getMessage("ColHeaderType"), Bundle.getMessage("ColHeaderPurge"), Bundle.getMessage("ColHeaderLongShort"), Bundle.getMessage("ColHeaderLoco"), Bundle.getMessage("ColHeaderSpeed"), Bundle.getMessage("ColHeaderDir"), Bundle.getMessage("ColHeaderMode"), Bundle.getMessage("ColHeaderConsist"), Bundle.getMessage("ColHeaderConsistPos"), Bundle.getMessage("ColHeaderF0"), Bundle.getMessage("ColHeaderF1"), Bundle.getMessage("ColHeaderF2"), Bundle.getMessage("ColHeaderF3"), Bundle.getMessage("ColHeaderF4"), Bundle.getMessage("ColHeaderF5"), Bundle.getMessage("ColHeaderF6"), Bundle.getMessage("ColHeaderF7"), Bundle.getMessage("ColHeaderF8"), Bundle.getMessage("ColHeaderF9"), Bundle.getMessage("ColHeaderF10"), Bundle.getMessage("ColHeaderF11"), Bundle.getMessage("ColHeaderF12"), Bundle.getMessage("ColHeaderF13"), Bundle.getMessage("ColHeaderF14"), Bundle.getMessage("ColHeaderF15"), Bundle.getMessage("ColHeaderF16"), Bundle.getMessage("ColHeaderF17"), Bundle.getMessage("ColHeaderF18"), Bundle.getMessage("ColHeaderF19"), Bundle.getMessage("ColHeaderF20"), Bundle.getMessage("ColHeaderF21"), Bundle.getMessage("ColHeaderF22"), Bundle.getMessage("ColHeaderF23"), Bundle.getMessage("ColHeaderF24"), Bundle.getMessage("ColHeaderF25"), Bundle.getMessage("ColHeaderF26"), Bundle.getMessage("ColHeaderF27"), Bundle.getMessage("ColHeaderF28"), Bundle.getMessage("ColHeaderText1"), Bundle.getMessage("ColHeaderText2"), Bundle.getMessage("ColHeaderLastUsed")};
        private boolean showAllCabs = false;
        private boolean showAllFunctions = false;
        private boolean showCabDisplay = false;

        NceCabTableModel(DataRow[] cabDataPtr) {
            this.cabData = cabDataPtr;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames1LineText.length;
        }

        @Override
        public int getRowCount() {
            int activeRows = 0;
            if (!this.getShowAllCabs()) {
                int i = NceShowCabPanel.this.minCabNum;
                while (i <= NceShowCabPanel.this.maxCabNum) {
                    if ((NceShowCabPanel.this.cabFlag1Array[i] & 2) == 2) {
                        ++activeRows;
                    }
                    ++i;
                }
            } else {
                activeRows = NceShowCabPanel.this.maxCabNum - NceShowCabPanel.this.minCabNum + 1;
            }
            return activeRows;
        }

        protected int getCabIdForRow(int row) {
            int activeRows = -1;
            if (!this.getShowAllCabs()) {
                int i = NceShowCabPanel.this.minCabNum;
                while (i <= NceShowCabPanel.this.maxCabNum) {
                    if ((NceShowCabPanel.this.cabFlag1Array[i] & 2) == 2 && row == ++activeRows) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
            return row + NceShowCabPanel.this.minCabNum;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames1LineText[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            boolean activeCab;
            int cabId = this.getCabIdForRow(row);
            if (cabId == -1 && !this.getShowAllCabs()) {
                return null;
            }
            if (cabId < NceShowCabPanel.this.minCabNum || cabId > NceShowCabPanel.this.maxCabNum) {
                log.error("getCabIdForRow({}) returned {}", (Object)row, (Object)cabId);
                return null;
            }
            DataRow r = this.cabData[cabId];
            boolean bl = activeCab = (NceShowCabPanel.this.cabFlag1Array[cabId] & 2) == 2;
            if (r == null) {
                return null;
            }
            if (!activeCab && col != 0) {
                return null;
            }
            switch (col) {
                case 0: {
                    return r.cabNumber;
                }
                case 1: {
                    return r.cabType;
                }
                case 2: {
                    return Bundle.getMessage("ButtonPurgeCab");
                }
                case 3: {
                    return r.longShort;
                }
                case 4: {
                    return r.locoAddress;
                }
                case 5: {
                    return r.locoSpeed;
                }
                case 6: {
                    return r.locoDir;
                }
                case 7: {
                    return r.mode;
                }
                case 8: {
                    return r.consist;
                }
                case 9: {
                    return r.consistPos;
                }
                case 10: {
                    return r.F0;
                }
                case 11: {
                    return r.F1;
                }
                case 12: {
                    return r.F2;
                }
                case 13: {
                    return r.F3;
                }
                case 14: {
                    return r.F4;
                }
                case 15: {
                    return r.F5;
                }
                case 16: {
                    return r.F6;
                }
                case 17: {
                    return r.F7;
                }
                case 18: {
                    return r.F8;
                }
                case 19: {
                    return r.F9;
                }
                case 20: {
                    return r.F10;
                }
                case 21: {
                    return r.F11;
                }
                case 22: {
                    return r.F12;
                }
                case 23: {
                    return r.F13;
                }
                case 24: {
                    return r.F14;
                }
                case 25: {
                    return r.F15;
                }
                case 26: {
                    return r.F16;
                }
                case 27: {
                    return r.F17;
                }
                case 28: {
                    return r.F18;
                }
                case 29: {
                    return r.F19;
                }
                case 30: {
                    return r.F20;
                }
                case 31: {
                    return r.F21;
                }
                case 32: {
                    return r.F22;
                }
                case 33: {
                    return r.F23;
                }
                case 34: {
                    return r.F24;
                }
                case 35: {
                    return r.F25;
                }
                case 36: {
                    return r.F26;
                }
                case 37: {
                    return r.F27;
                }
                case 38: {
                    return r.F28;
                }
                case 39: {
                    return r.text1;
                }
                case 40: {
                    return r.text2;
                }
                case 41: {
                    return r.lastChange;
                }
            }
            log.error("Unhandled column number: {}", (Object)col);
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int cabId = this.getCabIdForRow(row);
            if (col == 2) {
                NceShowCabPanel.this.purgeCab(cabId);
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 0 || c == 4 || c == 5 || c == 8) {
                return Integer.class;
            }
            if (c == 1 || c == 3 || c == 6 || c == 7 || c == 9 || c >= 39 && c <= 41) {
                return String.class;
            }
            if (c >= 10 && c <= 38) {
                return Boolean.class;
            }
            if (c == 2) {
                return JButton.class;
            }
            return null;
        }

        public int getPreferredWidth(int col) {
            int width = new JLabel((String)this.columnNames1LineText[col]).getPreferredSize().width + 10;
            return width;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public boolean getShowAllCabs() {
            return this.showAllCabs;
        }

        public void setShowAllCabs(boolean b) {
            this.showAllCabs = b;
        }

        public boolean getShowAllFunctions() {
            return this.showAllFunctions;
        }

        public void setShowAllFunctions(boolean b) {
            this.showAllFunctions = b;
        }

        public boolean getShowCabDisplay() {
            return this.showCabDisplay;
        }

        public void setShowCabDisplay(boolean b) {
            this.showCabDisplay = b;
        }
    }
}

