/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.boosterprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.boosterprog.Bundle;
import jmri.jmrix.nce.swing.NcePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterProgPanel
extends NcePanel {
    JTextField start = new JTextField(6);
    JTextField length = new JTextField(12);
    JLabel status = new JLabel();
    private AddressedProgrammer p = null;
    private static final Logger log = LoggerFactory.getLogger(BoosterProgPanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            try {
                this.initComponents((NceSystemConnectionMemo)context);
            }
            catch (Exception e) {
                log.warn("BoosterProg initContext", (Throwable)e);
            }
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.boosterprog.BoosterProgPanel";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("TitleBoosterProg"));
        return x.toString();
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.setLayout(new BoxLayout(this, 1));
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        this.add(new JLabel(Bundle.getMessage("Warn1")));
        this.add(new JLabel(Bundle.getMessage("Warn2")));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton b = new JButton(Bundle.getMessage("ButtonSet"));
        p.add(new JLabel(Bundle.getMessage("LabelStart")));
        this.start.setText("30");
        p.add(this.start);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoosterProgPanel.this.setStartPushed();
            }
        });
        box.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        b = new JButton(Bundle.getMessage("ButtonSet"));
        p.add(new JLabel(Bundle.getMessage("LabelDuration")));
        this.length.setText("420");
        p.add(this.length);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoosterProgPanel.this.setDurationPushed();
            }
        });
        box.add(p);
        this.add(box);
        this.add(this.status);
        this.status.setText(Bundle.getMessage("StatusOK"));
    }

    private void getProgrammer() {
        this.p = this.memo.getProgrammerManager().getAddressedProgrammer(true, 0);
    }

    private void releaseProgrammer() {
        if (this.p != null) {
            this.memo.getProgrammerManager().releaseAddressedProgrammer(this.p);
        }
        this.p = null;
    }

    void setStartPushed() {
        this.getProgrammer();
        this.status.setText(Bundle.getMessage("StatusProgramming"));
        int val = Integer.parseInt(this.start.getText());
        try {
            try {
                this.p.writeCV("255", val, new ProgListener(){

                    @Override
                    public void programmingOpReply(int value, int retval) {
                        BoosterProgPanel.this.status.setText(Bundle.getMessage("StatusOK"));
                    }
                });
            }
            catch (ProgrammerException e) {
                this.status.setText(String.valueOf(Bundle.getMessage("StatusError")) + e);
                this.releaseProgrammer();
            }
        }
        finally {
            this.releaseProgrammer();
        }
    }

    void setStart(int val) {
        this.getProgrammer();
        try {
            try {
                this.p.writeCV("255", val, new ProgListener(){

                    @Override
                    public void programmingOpReply(int value, int retval) {
                    }
                });
            }
            catch (ProgrammerException programmerException) {
                this.releaseProgrammer();
            }
        }
        finally {
            this.releaseProgrammer();
        }
    }

    void setDuration(final int val) {
        this.getProgrammer();
        try {
            this.p.writeCV("253", val / 256, new ProgListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void programmingOpReply(int value, int retval) {
                    5 var3_3 = this;
                    synchronized (var3_3) {
                        try {
                            this.wait(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    try {
                        try {
                            BoosterProgPanel.this.p.writeCV("254", val % 256, new ProgListener(){

                                @Override
                                public void programmingOpReply(int value, int retval) {
                                }
                            });
                        }
                        catch (ProgrammerException programmerException) {
                            BoosterProgPanel.this.releaseProgrammer();
                        }
                    }
                    finally {
                        BoosterProgPanel.this.releaseProgrammer();
                    }
                }
            });
        }
        catch (ProgrammerException programmerException) {
            this.releaseProgrammer();
        }
    }

    void setDurationPushed() {
        this.getProgrammer();
        this.status.setText(Bundle.getMessage("StatusProgramming"));
        int val = Integer.parseInt(this.length.getText()) / 256;
        try {
            this.p.writeCV("253", val, new ProgListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void programmingOpReply(int value, int retval) {
                    6 var3_3 = this;
                    synchronized (var3_3) {
                        try {
                            this.wait(1500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    BoosterProgPanel.this.durationPart2();
                }
            });
        }
        catch (ProgrammerException e) {
            this.status.setText(String.valueOf(Bundle.getMessage("StatusError")) + e);
            this.releaseProgrammer();
        }
    }

    void durationPart2() {
        this.status.setText(Bundle.getMessage("StatusProgramming"));
        int val = Integer.parseInt(this.length.getText()) % 256;
        try {
            try {
                this.p.writeCV("254", val, new ProgListener(){

                    @Override
                    public void programmingOpReply(int value, int retval) {
                        BoosterProgPanel.this.status.setText(Bundle.getMessage("StatusOK"));
                    }
                });
            }
            catch (ProgrammerException e) {
                this.status.setText(String.valueOf(Bundle.getMessage("StatusError")) + e);
                this.releaseProgrammer();
            }
        }
        finally {
            this.releaseProgrammer();
        }
    }
}

