/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import jmri.Turnout;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.NceTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceTurnoutMonitor
implements NceListener,
PropertyChangeListener {
    public static final int CS_ACCY_MEMORY = 60416;
    private static final int NUM_BLOCK = 16;
    private static final int BLOCK_LEN = 16;
    private static final int REPLY_LEN = 16;
    private static final int NCE_ACCY_THROWN = 0;
    private static final int NCE_ACCY_CLOSED = 1;
    static final int POLL_TIME = 200;
    private int currentBlock;
    private int numTurnouts = 0;
    private int numActiveBlocks = 0;
    private boolean feedbackChange = false;
    boolean[] newTurnouts = new boolean[16];
    boolean[] activeBlock = new boolean[16];
    boolean[] validBlock = new boolean[16];
    byte[] csAccMemCopy = new byte[256];
    byte[] dataBuffer = new byte[256];
    private boolean recData = false;
    Thread nceTurnoutMonitorThread;
    boolean turnoutUpdateValid = true;
    private boolean sentWarnMessage = false;
    private NceTrafficController tc = null;
    private long lastPollTime = 0L;
    private static final Logger log = LoggerFactory.getLogger(NceTurnoutMonitor.class);

    public NceTurnoutMonitor(NceTrafficController t) {
        this.tc = t;
    }

    public NceMessage pollMessage() {
        if (this.tc.getCommandOptions() < 20) {
            return null;
        }
        if (this.tc.getUsbSystem() != 0) {
            return null;
        }
        if (NceTurnout.getNumNtTurnouts() == 0) {
            return null;
        }
        long currentTime = Calendar.getInstance().getTimeInMillis();
        if (currentTime - this.lastPollTime < 400L) {
            return null;
        }
        this.lastPollTime = currentTime;
        if (this.feedbackChange || this.numTurnouts != NceTurnout.getNumNtTurnouts()) {
            this.feedbackChange = false;
            this.numTurnouts = NceTurnout.getNumNtTurnouts();
            int block = 0;
            while (block < 16) {
                this.newTurnouts[block] = true;
                if (!this.activeBlock[block]) {
                    int i = 0;
                    while (i < 128) {
                        int NTnum = 1 + i + block * 128;
                        Turnout mControlTurnout = (Turnout)this.tc.getAdapterMemo().getTurnoutManager().getBySystemName(String.valueOf(this.tc.getAdapterMemo().getSystemPrefix()) + "T" + NTnum);
                        if (mControlTurnout != null) {
                            mControlTurnout.removePropertyChangeListener(this);
                            if (mControlTurnout.getFeedbackMode() == 8) {
                                this.activeBlock[block] = true;
                                ++this.numActiveBlocks;
                                break;
                            }
                            mControlTurnout.addPropertyChangeListener(this);
                            log.trace("add turnout to listener NT{} Feed back mode: {}", (Object)NTnum, (Object)mControlTurnout.getFeedbackMode());
                        }
                        ++i;
                    }
                }
                ++block;
            }
        }
        if (this.numActiveBlocks <= 0) {
            return null;
        }
        if (this.nceTurnoutMonitorThread == null) {
            this.nceTurnoutMonitorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    NceTurnoutMonitor.this.turnoutUpdate();
                }
            });
            this.nceTurnoutMonitorThread.setName("NCE Turnout Monitor");
            this.nceTurnoutMonitorThread.setPriority(1);
            this.nceTurnoutMonitorThread.start();
        }
        do {
            ++this.currentBlock;
            if (this.currentBlock < 16) continue;
            this.currentBlock = 0;
        } while (!this.activeBlock[this.currentBlock]);
        log.trace("found turnouts block {}", (Object)this.currentBlock);
        int nceAccAddress = 60416 + this.currentBlock * 16;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceAccAddress);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        return m;
    }

    @Override
    public void message(NceMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("unexpected message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        if (r.getNumDataElements() == 16) {
            log.trace("memory poll reply received for memory block {}: {}", (Object)this.currentBlock, (Object)r);
            int i = 0;
            while (i < 16) {
                this.dataBuffer[i + this.currentBlock * 16] = (byte)r.getElement(i);
                ++i;
            }
            this.validBlock[this.currentBlock] = true;
            this.recData = true;
            NceTurnoutMonitor nceTurnoutMonitor = this;
            synchronized (nceTurnoutMonitor) {
                this.notify();
            }
        } else {
            log.warn("wrong number of read bytes for memory poll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnoutUpdate() {
        while (this.turnoutUpdateValid) {
            if (!this.recData) {
                NceTurnoutMonitor nceTurnoutMonitor = this;
                synchronized (nceTurnoutMonitor) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            this.recData = false;
            int block = 0;
            while (block < 16) {
                if (this.validBlock[block]) {
                    int NTnum;
                    int i;
                    byte recMemByte;
                    int byteIndex32 = 0;
                    while (byteIndex32 < 16) {
                        recMemByte = this.dataBuffer[byteIndex32 + block * 16];
                        if (recMemByte != this.csAccMemCopy[byteIndex32 + block * 16] || this.newTurnouts[block]) {
                            i = 0;
                            while (i < 8) {
                                NTnum = 1 + i + byteIndex32 * 8 + block * 128;
                                if (this.tc.isNceEpromMarch2007() && !this.tc.isSimulatorRunning()) {
                                    if (i == 3) {
                                        this.monitorActionCommanded(NTnum - 3, recMemByte, i);
                                    }
                                    ++NTnum;
                                    if (i == 7) break;
                                }
                                this.monitorActionCommanded(NTnum, recMemByte, i);
                                ++i;
                            }
                        }
                        ++byteIndex32;
                    }
                    NceTurnoutMonitor byteIndex32 = this;
                    synchronized (byteIndex32) {
                        try {
                            this.wait(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    byteIndex32 = 0;
                    while (byteIndex32 < 16) {
                        recMemByte = this.dataBuffer[byteIndex32 + block * 16];
                        if (recMemByte != this.csAccMemCopy[byteIndex32 + block * 16] || this.newTurnouts[block]) {
                            this.csAccMemCopy[byteIndex32 + block * 16] = recMemByte;
                            i = 0;
                            while (i < 8) {
                                NTnum = 1 + i + byteIndex32 * 8 + block * 128;
                                if (this.tc.isNceEpromMarch2007() && !this.tc.isSimulatorRunning()) {
                                    if (!this.sentWarnMessage) {
                                        log.warn("The installed NCE Command Station EPROM has problems when using turnout MONITORING feedback");
                                        this.sentWarnMessage = true;
                                    }
                                    if (i == 3) {
                                        this.monitorActionKnown(NTnum - 3, recMemByte, i);
                                    }
                                    ++NTnum;
                                    if (i == 7) break;
                                }
                                this.monitorActionKnown(NTnum, recMemByte, i);
                                ++i;
                            }
                        }
                        ++byteIndex32;
                    }
                    this.newTurnouts[block] = false;
                }
                ++block;
            }
        }
    }

    private void monitorActionCommanded(int NTnum, int recMemByte, int bit) {
        NceTurnout rControlTurnout = (NceTurnout)this.tc.getAdapterMemo().getTurnoutManager().getBySystemName(String.valueOf(this.tc.getAdapterMemo().getSystemPrefix()) + "T" + NTnum);
        if (rControlTurnout == null) {
            log.debug("Nce turnout number: {} system prefix: {} doesn't exist", (Object)NTnum, (Object)this.tc.getAdapterMemo().getSystemPrefix());
            return;
        }
        int tCommandedState = rControlTurnout.getCommandedState();
        if (rControlTurnout.getLocked(1) && tCommandedState != 1) {
            return;
        }
        int nceAccyThrown = 0;
        int nceAccyClosed = 1;
        if (rControlTurnout.getInverted()) {
            nceAccyThrown = 1;
            nceAccyClosed = 0;
        }
        log.trace("turnout exists NT{} state: {} Feed back mode: {}", new Object[]{NTnum, tCommandedState, rControlTurnout.getFeedbackMode()});
        log.trace("memory byte: {}", (Object)Integer.toHexString(recMemByte & 0xFF));
        int nceAccState = recMemByte >> bit & 1;
        if (nceAccState == nceAccyThrown && tCommandedState != 4) {
            log.debug("turnout discrepancy, NT{} CommandedState is now THROWN", (Object)NTnum);
            rControlTurnout.setCommandedStateFromCS(4);
        }
        if (nceAccState == nceAccyClosed && tCommandedState != 2) {
            log.debug("turnout discrepancy, NT{} CommandedState is now CLOSED", (Object)NTnum);
            rControlTurnout.setCommandedStateFromCS(2);
        }
    }

    private void monitorActionKnown(int NTnum, int recMemByte, int bit) {
        NceTurnout rControlTurnout = (NceTurnout)this.tc.getAdapterMemo().getTurnoutManager().getBySystemName(String.valueOf(this.tc.getAdapterMemo().getSystemPrefix()) + "T" + NTnum);
        if (rControlTurnout == null) {
            return;
        }
        int tKnownState = rControlTurnout.getKnownState();
        int tCommandedState = rControlTurnout.getCommandedState();
        int nceAccyThrown = 0;
        int nceAccyClosed = 1;
        if (rControlTurnout.getInverted()) {
            nceAccyThrown = 1;
            nceAccyClosed = 0;
        }
        log.trace("turnout exists NT{} state: {} Feed back mode: {}", new Object[]{NTnum, tKnownState, rControlTurnout.getFeedbackMode()});
        log.trace("memory byte: {}", (Object)Integer.toHexString(recMemByte & 0xFF));
        int nceAccState = recMemByte >> bit & 1;
        if (nceAccState == nceAccyThrown && tKnownState != 4) {
            if (rControlTurnout.getLocked(1) && tCommandedState == 2) {
                log.debug("Turnout NT{} is locked, will negate THROW turnout command from layout", (Object)NTnum);
                rControlTurnout.forwardCommandChangeToLayout(2);
                if (rControlTurnout.getReportLocked()) {
                    log.info("Turnout NT{} is locked, JMRI has canceled THROW turnout command from cab", (Object)NTnum);
                }
            } else {
                log.debug("turnout discrepancy, NT{} KnownState is now THROWN", (Object)NTnum);
                rControlTurnout.setKnownStateFromCS(4);
            }
        }
        if (nceAccState == nceAccyClosed && tKnownState != 2) {
            if (rControlTurnout.getLocked(1) && tCommandedState == 4) {
                log.debug("Turnout NT{} is locked, will negate CLOSE turnout command from layout", (Object)NTnum);
                rControlTurnout.forwardCommandChangeToLayout(4);
                if (rControlTurnout.getReportLocked()) {
                    log.info("Turnout NT{} is locked, JMRI has canceled CLOSE turnout command from cab", (Object)NTnum);
                }
            } else {
                log.debug("turnout discrepancy, NT{} KnownState is now CLOSED", (Object)NTnum);
                rControlTurnout.setKnownStateFromCS(2);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("feedbackchange") && (Integer)e.getNewValue() == 8) {
            this.feedbackChange = true;
        }
    }
}

