/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.nce.Bundle;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceTurnoutManager
extends AbstractTurnoutManager
implements NceListener {
    private static final Logger log = LoggerFactory.getLogger(NceTurnoutManager.class);

    public NceTurnoutManager(NceSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public NceSystemConnectionMemo getMemo() {
        return (NceSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        NceTurnout t = new NceTurnout(this.getMemo().getNceTrafficController(), this.getSystemPrefix(), addr);
        t.setUserName(userName);
        return t;
    }

    public int getBitFromSystemName(String systemName) {
        if (!systemName.startsWith(this.getSystemPrefix()) || !systemName.startsWith(String.valueOf(this.getSystemPrefix()) + "T")) {
            log.error("illegal character in header field of nce turnout system name: {}", (Object)systemName);
            return 0;
        }
        int num = 0;
        try {
            num = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1, systemName.length()));
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("illegal character in number field of system name: {}", (Object)systemName);
            return 0;
        }
        if (num <= 0) {
            log.error("invalid nce turnout system name: {}", (Object)systemName);
            return 0;
        }
        if (num > 4096) {
            log.warn("bit number out of range in nce turnout system name: {}", (Object)systemName);
            return 0;
        }
        return num;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void reply(NceReply r) {
    }

    @Override
    public void message(NceMessage m) {
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return super.validateNmraAccessorySystemNameFormat(name, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

